/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.entities.GUID;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.information.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class RepositoryDef
implements Cloneable,
ConsumedResourceInterface,
Serializable {
    private static final long serialVersionUID = -9092261495368700679L;
    public static final String ELEMENT_NAME = "ReposDef";
    public static final String ATTRIBUTE_UID = "uid";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_HOST = "host";
    public static final String ATTRIBUTE_PORT = "port";
    public static final String ATTRIBUTE_AUTOCONNECT = "auto";
    public static final String ATTRIBUTE_BASE = "base";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_DOMAIN = "domain";
    public static final String ATTRIBUTE_PROTOCOL = "protocol";
    public static final String ATTRIBUTE_PROXY = "proxy";
    public static final String ATTRIBUTE_ISSECURE = "issecure";
    public static final String ATTRIBUTE_HIBDIALECT = "hibdialect";
    public static final String PROPERTYNAME_PROTOCOL = "protocol";
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_DESCRIPTION = "description";
    public static final String PROPERTYNAME_HOST = "host";
    public static final String PROPERTYNAME_PORT = "port";
    public static final String PROPERTYNAME_BASE = "base";
    public static final String PROPERTYNAME_DOMAIN = "domain";
    public static final String PROPERTYNAME_AUTOCONNECT = "auto-connect";
    public static final String PROPERTYNAME_PROXY = "proxy";
    public static final String PROPERTYNAME_ISSECURE = "isSecure";
    public static final String PROPERTYNAME_HIBDIALECT = "hibdialect";
    private static final int PRIME_NUMBER = 31;
    private static final int STRINGBUFFER_INIT = 64;
    private static final int OPTION_MAP_INIT = 4;
    private String _uid = GUID.newGUID();
    private String _host;
    private String _port;
    private String _domain;
    private String _base;
    private String _protocol;
    private String _description;
    private String _name;
    private boolean _auto;
    private String _proxy;
    private boolean _isSecure;
    private String _hibDialect;
    private Map _advancedOptions = new HashMap(5);
    private List _hibClasses;

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this._protocol);
        buffer.append("://");
        buffer.append(this._host);
        buffer.append(':');
        buffer.append(this._port);
        buffer.append(";domain=");
        buffer.append(this._domain);
        buffer.append('/');
        buffer.append(this._base);
        return buffer.toString();
    }

    public RepositoryDef(String host, String port, String domain) {
        this._host = host;
        this._port = port;
        this._domain = domain;
    }

    public RepositoryDef(String host, String port, String domain, String base) {
        this(host, port, domain);
        this._base = base;
    }

    public RepositoryDef(String host, String port, String domain, String base, String protocol) {
        this(host, port, domain, base);
        this._protocol = protocol.toLowerCase();
    }

    public RepositoryDef(String host, String port, String domain, String base, String protocol, String name) {
        this(host, port, domain, base, protocol);
        this.setName(name);
    }

    public RepositoryDef(String uid, String host, String port, String domain, String base, String protocol, String name) {
        this(host, port, domain, base, protocol, name);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public Map getOptions() {
        HashMap<String, String> result = new HashMap<String, String>(4);
        result.put("host", this._host);
        result.put("port", this._port);
        result.put("domain", this._domain);
        if (this._base != null) {
            result.put("base", this._base);
        }
        if (this._protocol != null) {
            result.put("protocol", this._protocol);
        }
        return result;
    }

    public void setAuto(boolean auto) {
        this._auto = auto;
    }

    public boolean getAuto() {
        return this._auto;
    }

    public String getUrl() {
        try {
            URI uri = new URI(this._protocol, this._host + ':' + this._port, this._base == null ? "" : '/' + this.stripLeadingSlashes(this._base), null, null);
            return uri.toString();
        }
        catch (URISyntaxException use) {
            return this._protocol + "://" + this._host + ':' + this._port + (this._base == null ? "" : '/' + this.stripLeadingSlashes(this._base));
        }
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public String getPort() {
        return this._port;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setBase(String base) {
        this._base = base;
    }

    public String getBase() {
        return this._base;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol.toLowerCase();
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description == null ? "" : this._description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name == null ? "" : this._name;
    }

    public void setProxy(String proxy) {
        this._proxy = proxy;
    }

    public String getProxy() {
        return this._proxy;
    }

    public void setIsSecure(boolean secure) {
        this._isSecure = secure;
    }

    public boolean getIsSecure() {
        return this._isSecure;
    }

    public final boolean equals(Object obj) {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj == null) {
            isEqual = false;
        } else {
            try {
                RepositoryDef repositoryDef = (RepositoryDef)obj;
                isEqual = Strings.equal((String)this.getBase(), (String)repositoryDef.getBase(), (boolean)false, (boolean)false) && Strings.equal((String)this.getDomain(), (String)repositoryDef.getDomain(), (boolean)false, (boolean)false) && Strings.equal((String)this.getHost(), (String)repositoryDef.getHost(), (boolean)false, (boolean)true) && Strings.equal((String)this.getName(), (String)repositoryDef.getName(), (boolean)true, (boolean)true) && Strings.equal((String)this.getProxy(), (String)repositoryDef.getProxy(), (boolean)false, (boolean)false) && Strings.equal((String)this.getProtocol(), (String)repositoryDef.getProtocol(), (boolean)false, (boolean)false) && Strings.equal((String)this.getPort(), (String)repositoryDef.getPort(), (boolean)false, (boolean)false) && this.getAuto() == repositoryDef.getAuto() && this.getIsSecure() == repositoryDef.getIsSecure() && Strings.equal((String)this.getDescription(), (String)repositoryDef.getDescription(), (boolean)true, (boolean)false);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public final int hashCode() {
        int hashCode = 31;
        if (this._base != null) {
            hashCode ^= this._base.hashCode();
        }
        if (this._description != null) {
            hashCode ^= this._description.hashCode();
        }
        if (this._domain != null) {
            hashCode ^= this._domain.hashCode();
        }
        if (this._host != null) {
            hashCode ^= this._host.hashCode();
        }
        if (this._name != null) {
            hashCode ^= this._name.hashCode();
        }
        if (this._proxy != null) {
            hashCode ^= this._proxy.hashCode();
        }
        if (this._protocol != null) {
            hashCode ^= this._protocol.hashCode();
        }
        if (this._port != null) {
            hashCode ^= this._port.hashCode();
        }
        hashCode ^= Boolean.toString(this._isSecure).hashCode();
        return hashCode ^= Boolean.toString(this._auto).hashCode();
    }

    private String stripLeadingSlashes(String buffer) {
        StringBuffer _buffer = new StringBuffer(buffer.trim());
        while (_buffer.length() > 0 && _buffer.charAt(0) == '/') {
            _buffer.deleteCharAt(0);
        }
        return _buffer.toString();
    }

    public void setAdvancedOptions(Map options) {
        this._advancedOptions.clear();
        if (options != null) {
            this._advancedOptions.putAll(options);
        }
    }

    public void addAdvancedOptions(String key, String value) {
        this._advancedOptions.put(key, value);
    }

    public Map getAdvancedOptions() {
        return this._advancedOptions;
    }

    public final String getHibDialect() {
        return this._hibDialect;
    }

    public final void setHibDialect(String dialect) {
        this._hibDialect = dialect;
    }

    public List getHibClasses() {
        if (this._hibClasses == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this._hibClasses);
    }

    public void addHibClass(String className) {
        if (className == null) {
            return;
        }
        if (this._hibClasses == null) {
            this._hibClasses = new ArrayList(10);
        }
        this._hibClasses.add(className);
    }

    public void removeHibClass(String className) {
        if (className == null) {
            return;
        }
        if (this._hibClasses == null) {
            return;
        }
        this._hibClasses.remove(className);
    }

    public void setHibClasses(List classnames) {
        if (classnames == null || classnames.size() == 0) {
            this._hibClasses = null;
        }
        this._hibClasses = new ArrayList(classnames == null ? 0 : classnames.size());
        if (classnames != null) {
            this._hibClasses.addAll(classnames);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RepositoryDef clone = (RepositoryDef)super.clone();
        clone._advancedOptions = new HashMap(this._advancedOptions);
        if (this._hibClasses != null) {
            clone._hibClasses = new ArrayList(this._hibClasses);
        }
        return clone;
    }

    public RepositoryDef cloneConfig() {
        RepositoryDef repositoryDef = null;
        try {
            repositoryDef = (RepositoryDef)this.clone();
        }
        catch (CloneNotSupportedException e) {
            repositoryDef = null;
        }
        return repositoryDef;
    }

    final boolean hasConflict(RepositoryDef other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else if (other != null) {
            String otherBase = other.getBase();
            String otherDesc = other.getDescription();
            String otherDomain = other.getDomain();
            String otherHIBDialect = other.getHibDialect();
            String otherHost = other.getHost();
            String otherName = other.getName();
            String otherPort = other.getPort();
            String otherProtocol = other.getProtocol();
            String otherProxy = other.getProxy();
            String thisBase = this.getBase();
            String thisDesc = this.getDescription();
            String thisDomain = this.getDomain();
            String thisHIBDialect = this.getHibDialect();
            String thisHost = this.getHost();
            String thisName = this.getName();
            String thisPort = this.getPort();
            String thisProtocol = this.getProtocol();
            String thisProxy = this.getProxy();
            isEqual = !(otherBase != null && !"".equals(otherBase) && thisBase != null && !Strings.equal((String)otherBase, (String)thisBase, (boolean)false, (boolean)false) || otherDomain != null && !"".equals(otherDomain) && thisDomain != null && !Strings.equal((String)otherDomain, (String)thisDomain, (boolean)false, (boolean)false) || otherHIBDialect != null && !"".equals(otherHIBDialect) && thisHIBDialect != null && !Strings.equal((String)otherHIBDialect, (String)thisHIBDialect, (boolean)false, (boolean)false) || otherHost != null && !"".equals(otherHost) && thisHost != null && !Strings.equal((String)otherHost, (String)thisHost, (boolean)false, (boolean)true) || otherName != null && !"".equals(otherName) && thisName != null && !Strings.equal((String)otherName, (String)thisName, (boolean)false, (boolean)true) || otherPort != null && !"".equals(otherPort) && thisPort != null && !Strings.equal((String)otherPort, (String)thisPort, (boolean)false, (boolean)false) || otherProtocol != null && !"".equals(otherProtocol) && thisProtocol != null && !Strings.equal((String)otherProtocol, (String)thisProtocol, (boolean)false, (boolean)false) || otherProxy != null && !"".equals(otherProxy) && thisProxy != null && !Strings.equal((String)otherProxy, (String)thisProxy, (boolean)false, (boolean)false) || otherDesc != null && !"".equals(otherDesc) && thisDesc != null && !Strings.equal((String)otherDesc, (String)thisDesc, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(RepositoryDef newObject) {
        if (newObject != null) {
            String value = newObject.getBase();
            if (value != null) {
                this.setBase(value);
            }
            if ((value = newObject.getDescription()) != null) {
                this.setDescription(value);
            }
            if ((value = newObject.getDomain()) != null) {
                this.setDomain(value);
            }
            if ((value = newObject.getHibDialect()) != null) {
                this.setHibDialect(value);
            }
            if ((value = newObject.getName()) != null) {
                this.setName(value);
            }
            if ((value = newObject.getPort()) != null) {
                this.setPort(value);
            }
            if ((value = newObject.getProtocol()) != null) {
                this.setProtocol(value);
            }
            if ((value = newObject.getProxy()) != null) {
                this.setProxy(value);
            }
            Map.Entry mapEntry2 = null;
            String newOption = null;
            String newOptionValue = null;
            for (Map.Entry mapEntry2 : newObject._advancedOptions.entrySet()) {
                newOption = (String)mapEntry2.getKey();
                newOptionValue = (String)mapEntry2.getValue();
                if (this._advancedOptions.get(newOption) != null) continue;
                this._advancedOptions.put(newOption, newOptionValue);
            }
        }
    }

    void replace(RepositoryDef newObject) {
        if (newObject != null) {
            this.setBase(newObject.getBase());
            this.setDescription(newObject.getDescription());
            this.setDomain(newObject.getDomain());
            this.setHibDialect(newObject.getHibDialect());
            this.setName(newObject.getName());
            this.setPort(newObject.getPort());
            this.setProtocol(newObject.getProtocol());
            this.setProxy(newObject.getProxy());
            Map.Entry mapEntry2 = null;
            for (Map.Entry mapEntry2 : newObject._advancedOptions.entrySet()) {
                this._advancedOptions.put(mapEntry2.getKey(), mapEntry2.getValue());
            }
        }
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._name;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("RepositoryDef.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.repository.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "Repository";
    }

    @Override
    public int getResourceTypeCode() {
        return 3;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

