/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.PluginClassLoader;
import com.sas.text.Message;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class PluginLoader {
    public static final String OBJECT_TYPES_LOADER = "sas.services.information.types";
    private static Map _pluginLoaders = null;
    private String _name;
    private File _pluginRoot;
    private int _policy;
    private ClassLoader _parentClassLoader;
    private Map _classLoaders;
    private Map _loadedClasses;
    private Logger _logger;
    private List _failedPlugins;
    private List _alternateClassLoaders;

    public static PluginLoader getInstance(String name) throws SecurityException, ServiceException {
        PluginLoader loader = null;
        if (_pluginLoaders == null) {
            _pluginLoaders = new HashMap();
        } else if (_pluginLoaders.containsKey(name)) {
            loader = (PluginLoader)_pluginLoaders.get(name);
        }
        if (loader == null) {
            loader = new PluginLoader(name);
            _pluginLoaders.put(name, loader);
        }
        return loader;
    }

    private PluginLoader(String name) throws SecurityException, ServiceException {
        this._name = name;
        this._parentClassLoader = this.getClass().getClassLoader();
        this._classLoaders = new HashMap();
        this._loadedClasses = new HashMap();
        this.setupLogging();
        String path = System.getProperty(name + ".path");
        if (path != null) {
            this._pluginRoot = new File(path);
            if (!this._pluginRoot.exists()) {
                this._logger.warn(Message.format((String)"No plugins loaded by {0} plugin loader.", (Object)name));
                this._logger.warn(Message.format((String)"  Plugin directory {0} does not exist.", (Object)this._pluginRoot.getPath()));
                return;
            }
            if (!this._pluginRoot.isDirectory()) {
                String msg = "PluginLoader failed: configured plugin path " + this._pluginRoot.getPath() + " is not a directory.";
                this._logger.debug(msg);
                throw new ServiceException(msg);
            }
            String policy = System.getProperty(name + ".policy");
            if (policy != null) {
                try {
                    this._policy = PluginClassLoader.parsePolicy(policy);
                }
                catch (IllegalArgumentException e) {
                    String msg = "PluginLoader failed: policy " + policy + " is not valid.";
                    this._logger.debug(msg);
                    throw new ServiceException(msg);
                }
            } else {
                this._policy = 2;
            }
            File[] pluginDirs = this._pluginRoot.listFiles(new DirectoryFilter());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((String)"{0} plugin loader initialized.", (Object)this._name));
                this._logger.debug(Message.format((String)"  Plugins root: {0}", (Object)this._pluginRoot.getAbsolutePath()));
                this._logger.debug(Message.format((String)"  Plugins policy: {0}", (Object)PluginClassLoader.toStringPolicy(this._policy)));
            }
            for (int i = 0; i < pluginDirs.length; ++i) {
                try {
                    PluginClassLoader cl = new PluginClassLoader(pluginDirs[i], this._policy, this._logger);
                    this._classLoaders.put(pluginDirs[i].getName(), cl);
                    continue;
                }
                catch (ServiceException e) {
                    this._logger.warn(Message.format((String)"{0} plugin failed to load.", (Object)pluginDirs[i].getName()));
                    this._logger.warn("  " + e.getMessage());
                    if (this._failedPlugins == null) {
                        this._failedPlugins = new ArrayList();
                    }
                    this._failedPlugins.add(pluginDirs[i]);
                }
            }
            if (this._logger.isDebugEnabled()) {
                int loaded = pluginDirs.length;
                int failed = 0;
                if (this._failedPlugins != null) {
                    failed = this._failedPlugins.size();
                    loaded -= failed;
                }
                this._logger.debug(Message.format((String)"{0,number,integer} plugins loaded by {1} plugin loader.", (Object)loaded, (Object)this._name));
                this._logger.debug(Message.format((String)"  {0,number,integer} plugins failed to load.", (Object)failed));
            }
        } else {
            this._logger.debug(Message.format((String)"No plugins loaded by {0} plugin loader.", (Object)name));
            this._logger.debug(Message.format((String)"  System property {0}.path not set.", (Object)name));
        }
    }

    public void destroy() {
        this._pluginRoot = null;
        this._classLoaders = null;
        this._alternateClassLoaders = null;
        this._loadedClasses = null;
        this._logger = null;
        this._failedPlugins = null;
        _pluginLoaders.remove(this._name);
    }

    public String getName() {
        return this._name;
    }

    public File getPluginRoot() {
        return this._pluginRoot;
    }

    public int getPolicy() {
        return this._policy;
    }

    public void addAlternateClassLoader(ClassLoader classLoader) {
        if (this._alternateClassLoaders == null) {
            this._alternateClassLoaders = new ArrayList();
        }
        if (!this._alternateClassLoaders.contains(classLoader)) {
            this._alternateClassLoaders.add(classLoader);
            this._logger.debug(Message.format((String)"{0} added to alternate class loader list for {1} plugin loader.", (Object)classLoader.toString(), (Object)this._name));
        } else {
            this._logger.debug(Message.format((String)"{0} already added to alternate class loader list for {1} plugin loader.", (Object)classLoader.toString(), (Object)this._name));
        }
    }

    public void removeAlternateClassLoader(ClassLoader classLoader) {
        if (this._alternateClassLoaders == null) {
            return;
        }
        if (this._alternateClassLoaders.contains(classLoader)) {
            this._alternateClassLoaders.remove(classLoader);
            this._logger.debug(Message.format((String)"{0} removed from alternate class loader list for {1} plugin loader.", (Object)classLoader.toString(), (Object)this._name));
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this._loadedClasses.containsKey(className)) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((String)"Class {0} loaded from {1} plugin loader cache.", (Object)className, (Object)this._name));
            }
            return (Class)this._loadedClasses.get(className);
        }
        try {
            Class<?> foundClass = this._parentClassLoader.loadClass(className);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((String)"Class {0} loaded from parent class loader {1} plugin loader.", (Object)className, (Object)this._name));
            }
            this._loadedClasses.put(className, foundClass);
            return foundClass;
        }
        catch (ClassNotFoundException foundClass) {
            if (this._alternateClassLoaders != null) {
                for (ClassLoader cl : this._alternateClassLoaders) {
                    try {
                        Class<?> foundClass2 = cl.loadClass(className);
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug(Message.format((String)"Class {0} loaded from a alternate class loader for {1} plugin loader.", (Object)className, (Object)this._name));
                        }
                        this._loadedClasses.put(className, foundClass2);
                        return foundClass2;
                    }
                    catch (ClassNotFoundException foundClass2) {
                    }
                }
            }
            Iterator<Object> iter = this._classLoaders.entrySet().iterator();
            while (iter.hasNext()) {
                ClassLoader cl;
                cl = (PluginClassLoader)((Map.Entry)iter.next()).getValue();
                try {
                    Class<?> foundClass3 = cl.loadClass(className);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug(Message.format((String)"Class {0} loaded from {1} plugin.", (Object)className, (Object)((PluginClassLoader)cl).getName()));
                    }
                    this._loadedClasses.put(className, foundClass3);
                    return foundClass3;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            String msg = Message.format((String)"Class {0} not found in {1} plugin loader.", (Object)className, (Object)this._name);
            this._logger.debug(msg);
            throw new ClassNotFoundException(msg);
        }
    }

    public Class loadClass(String plugin, String className) throws ClassNotFoundException, ServiceException {
        if (this._loadedClasses.containsKey(className)) {
            this._logger.debug(Message.format((String)"Class {0} loaded from cache.", (Object)className));
            return (Class)this._loadedClasses.get(className);
        }
        ClassLoader cl = (ClassLoader)this._classLoaders.get(plugin);
        if (cl == null) {
            String msg = Message.format((String)"{0} plugin not found in {1} plugin loader.", (Object)plugin, (Object)this._name);
            this._logger.debug(msg);
            throw new ClassNotFoundException(msg);
        }
        Class<?> foundClass = cl.loadClass(className);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((String)"Class {0} loaded from {1} plugin.", (Object)className, (Object)plugin));
        }
        this._loadedClasses.put(className, foundClass);
        return foundClass;
    }

    public PluginClassLoader getPluginClassLoader(String pluginName) {
        return (PluginClassLoader)this._classLoaders.get(pluginName);
    }

    public void clearClassCache() {
        if (this._logger.isDebugEnabled() && this._loadedClasses != null) {
            this._logger.debug(Message.format((String)"Class cache cleared for {0} plugin loader.  {1} entries removed.", (Object)this._name, (Object)this._loadedClasses.size()));
        }
        this._loadedClasses = new HashMap();
    }

    private void setupLogging() throws ServiceException {
        this._logger = LogManager.getLogger((String)"com.sas.services.information.PluginLoader");
        if (this._logger == null) {
            throw new InitializationException();
        }
    }

    @SASScope
    private class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    @SASScope
    public class InitializationException
    extends ServiceException {
        static final long serialVersionUID = 92000001L;
        static final String DEFAULT_MESSAGE = "PluginLoader failed: unable to initialize logger.";

        public InitializationException() {
            super(DEFAULT_MESSAGE);
        }

        public InitializationException(Throwable t) {
            super(t, DEFAULT_MESSAGE);
        }
    }
}

