/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.impl.BaseCacheFactory;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.OMIServerChildRepository;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryInfo;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerDef;
import com.sas.services.information.cache.RepositoryCache;
import com.sas.services.information.metadata.MetadataInterface;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OMIChildServer
extends OMIServer
implements ChildServerInterface {
    private static final long serialVersionUID = 3464328132631795648L;
    MetadataServerInterface _parent = null;
    private static final String LOGCONTEXT = "com.sas.services.information.OMIChildServer";

    public OMIChildServer() throws RemoteException {
        super(OMIChildServer.class);
    }

    public OMIChildServer(MdFactory mdfactory, MdObjectStore mdstore, MetadataServerInterface parent, int childnum) throws RemoteException {
        this(mdfactory, mdstore, parent, childnum, OMIChildServer.class);
    }

    public OMIChildServer(MdFactory mdfactory, MdObjectStore mdstore, MetadataServerInterface parent, int childnum, Class theClass) throws RemoteException {
        super(theClass);
        this._mdfactory = (MdFactoryImpl)mdfactory;
        this._mdstore = mdstore;
        if (parent == null) {
            throw new IllegalArgumentException(RB.getStringResource("ChildRepository.nullparent.ex.txt"));
        }
        this._parent = parent;
        this._name = parent.getName();
        try {
            String host = parent.getHost();
            int port = parent.getPort();
            String domain = parent.getDomain();
            ServerDef def = new ServerDef(this._name, "omi", host, String.valueOf(port));
            def.setDomain(domain);
            this._def = def;
            this._user = this._parent.getUserContext();
            this._logger = LogManager.getLogger((String)"com.sas.services.information.OMIServer");
            this._typeMap = this._parent.getTypeDictionaryMap();
            List infoList = this._parent.getRepositoryInfo();
            this._repositories = new HashMap(infoList.size() * 2);
            this._id2NameMap = new HashMap(infoList.size() * 2);
            this.setIdentity(parent.getIdentity());
            for (RepositoryInfo ri : infoList) {
                OMIServer.RepositoryEntry entry = new OMIServer.RepositoryEntry(this, ri.getName(), ri.getFqid(), ri.getType(), ri.getDescription(), ri.getPath(), ri.getEngine(), ri.getOptions(), ri.getAccess(), ri.getEffectiveAccess(), ri.getFormat(), ri.getState(), ri.getMetadataCreated(), ri.getMetadataUpdated(), null);
                this._repositories.put(ri.getName().toUpperCase(), entry);
                this._id2NameMap.put(ri.getFqid(), ri.getName());
                this._url = "omi://" + this._def.getHost() + ":" + this._def.getPort();
            }
        }
        catch (ServiceException host) {
            // empty catch block
        }
        this._subNum = ((OMIServer)this._parent).getSubNum() + '.' + childnum;
        String subNumPath = this._subNum.replace('.', '/');
        try {
            this._cache = (RepositoryCache)BaseCacheFactory.getCache((String)this.getClass().getName(), (String)(((OMIServer)this._parent).cachePath() + '.' + subNumPath), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (CacheException ex) {
            throw new RuntimeException(ex);
        }
        this.initializeRepositories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRepositories() throws RemoteException {
        StringHolder outXml = new StringHolder();
        int flags = 0x4000001;
        try {
            Object object = this._cnxnSync;
            synchronized (object) {
                this._mdfactory.getConnection().getCMRHandle().GetRepositories(outXml, flags, "");
                String xmlOut = outXml.value;
                this.buildReposDatafromXML(xmlOut);
            }
        }
        catch (RemoteException rex) {
            return;
        }
        catch (GenericError ex) {
            return;
        }
        catch (SystemException ex) {
            return;
        }
        catch (MdException e) {
            return;
        }
    }

    private void buildReposDatafromXML(String xmlOut) throws RemoteException, MdException {
        Document mainDoc = this._mdfactory.getOMIUtil().parseXML(xmlOut);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            String strType = null;
            String strEngine = null;
            String strOptions = null;
            Date metadataCreated = null;
            Date metadataUpdated = null;
            NodeList nodeList = firstNode.getChildNodes();
            int reposCnt = nodeList.getLength();
            for (int index = 0; index < reposCnt; ++index) {
                NamedNodeMap childNodeMap = nodeList.item(index).getAttributes();
                String strFQID = childNodeMap.getNamedItem("Id").getNodeValue();
                if (strFQID.equals("A0000001.A0000001")) continue;
                String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                String strDesc = childNodeMap.getNamedItem("Desc").getNodeValue();
                Node typeNode = childNodeMap.getNamedItem("RepositoryType");
                if (typeNode != null && "Foundation".equalsIgnoreCase(strType = typeNode.getNodeValue())) {
                    this._foundationReposName = strName;
                }
                String strPath = childNodeMap.getNamedItem("Path").getNodeValue();
                if (childNodeMap.getNamedItem("Engine") != null) {
                    strEngine = childNodeMap.getNamedItem("Engine").getNodeValue();
                }
                if (childNodeMap.getNamedItem("Options") != null) {
                    strOptions = childNodeMap.getNamedItem("Options").getNodeValue();
                }
                String strReposFormat = childNodeMap.getNamedItem("RepositoryFormat").getNodeValue();
                String strAccess = childNodeMap.getNamedItem("Access").getNodeValue();
                String strEffectiveAccess = childNodeMap.getNamedItem("CurrentAccess").getNodeValue();
                String strState = childNodeMap.getNamedItem("PauseState").getNodeValue();
                if (childNodeMap.getNamedItem("MetadataCreated") != null) {
                    String strMetadataCreated = childNodeMap.getNamedItem("MetadataCreated").getNodeValue();
                    metadataCreated = this._mdfactory.getUtil().getDateForDoubleSASDateTimeString(strMetadataCreated);
                }
                if (childNodeMap.getNamedItem("MetadataUpdated") != null) {
                    String strMetadataUpdated = childNodeMap.getNamedItem("MetadataUpdated").getNodeValue();
                    metadataUpdated = this._mdfactory.getUtil().getDateForDoubleSASDateTimeString(strMetadataUpdated);
                }
                OMIServer.RepositoryEntry entry = new OMIServer.RepositoryEntry(this, strFQID, strName, strType, strDesc, strPath, strEngine, strOptions, strAccess, strEffectiveAccess, strReposFormat, strState, metadataCreated, metadataUpdated, null);
                this._repositories.put(strName.toUpperCase(), entry);
                this._id2NameMap.put(strFQID, strName);
            }
        }
    }

    @Override
    public String getHost() throws ServiceException, RemoteException {
        return this._parent == null ? super.getHost() : this._parent.getHost();
    }

    @Override
    public int getPort() throws ServiceException, RemoteException {
        return this._parent == null ? super.getPort() : this._parent.getPort();
    }

    @Override
    public void destroy() throws ServiceException, RemoteException {
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            MetadataServerInterface metadataServerInterface = this._parent;
            synchronized (metadataServerInterface) {
                this._parent.debug(RB.getStringResource("ChildRepository.commit.msg.txt"), "com.sas.services.information.OMIRepository." + this._subNum);
                this._mdstore.updatedMetadataAll();
                if (!(this._parent instanceof OMIChildServer) && !this._mdstore.getStoreName().startsWith("detached")) {
                    this._parent.debug(RB.getStringResource("ChildRepository.flush.msg.txt"), "com.sas.services.information.OMIRepository." + this._subNum);
                    try {
                        ((OMIServer)this._parent).flush();
                    }
                    catch (ServiceException ex) {
                        Serializable cause = (Exception)ex.getRootException();
                        if (cause == null) {
                            cause = ex;
                        }
                        throw new ServiceException((Throwable)cause, RB.getStringResource("ChildRepository.updexcept.ex.txt"));
                    }
                }
                this.close();
            }
        }
        catch (MdException ex) {
            this._parent.debug(RB.getStringResource("ChildRepository.updexcept.ex.txt"), "com.sas.services.information.OMIRepository." + this._subNum, ex);
            throw new ServiceException(ex, RB.getStringResource("ChildRepository.updexcept.ex.txt"));
        }
    }

    @Override
    public void rollback() throws ServiceException, RemoteException {
        this.pulseCheck();
        this._parent.debug(RB.getStringResource("ChildRepository.rollback.msg.txt"), "com.sas.services.information.OMIRepository." + this._subNum);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws RemoteException {
        block8: {
            if (this._isDestroyed) {
                return;
            }
            this._parent.debug("The child repository is closing", "com.sas.services.information.OMIRepository." + this._subNum);
            try {
                if (this._mdstore == null) break block8;
                MetadataServerInterface metadataServerInterface = this._parent;
                synchronized (metadataServerInterface) {
                    this._mdstore.dispose();
                    this._mdstore = null;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this._parent = null;
        this._mdfactory = null;
        try {
            super.destroy();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    @Override
    public RepositoryInterface getRepository(String name) throws ServiceException, RemoteException {
        if (name == null) {
            return null;
        }
        RepositoryInterface result = null;
        OMIServer.RepositoryEntry entry = (OMIServer.RepositoryEntry)this._repositories.get(name.toUpperCase());
        if (entry != null && ((result = entry.repos) == null || result.isDestroyed())) {
            entry.repos = result = new OMIServerChildRepository(this, name);
        }
        return result;
    }

    @Override
    public List getRepositories(boolean getAll) throws ServiceException, RemoteException {
        ArrayList<RepositoryInterface> results = new ArrayList<RepositoryInterface>();
        for (OMIServer.RepositoryEntry entry : this._repositories.values()) {
            RepositoryInterface ri = entry.repos;
            if (ri != null) {
                results.add(ri);
                continue;
            }
            if (!getAll) continue;
            entry.repos = ri = new OMIServerChildRepository(this, entry.name);
            results.add(ri);
        }
        return results;
    }

    @Override
    public MetadataInterface fetch(String repositoryKey) throws ServiceException, RemoteException {
        return this.fetch(repositoryKey, false);
    }

    @Override
    public MetadataInterface fetch(String repositoryKey, boolean bypassCache) throws ServiceException, RemoteException {
        CMetadata c;
        MetadataInterface mi;
        MdStore parentStore = this._mdstore.getOwningStore();
        OMIServer.OMIKey myKey = this.makeKey(repositoryKey);
        String localKey = myKey.getFqid();
        if (myKey.getType() == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.typereq.ex.txt"));
        }
        if (!bypassCache && (mi = (MetadataInterface)this._cache.get(localKey)) != null) {
            CMetadata cm = (CMetadata)mi.getRepositoryEntity();
            mi = this.factoryProcess(cm);
            return mi;
        }
        if (parentStore instanceof MdObjectStore && !bypassCache && (c = this._mdstore.getObject(localKey)) != null) {
            MetadataInterface result = this.factoryProcess(c);
            return result;
        }
        return super.fetch(repositoryKey, bypassCache);
    }

    @Override
    void notifyMetadataConnectionListeners() {
        if (this._parent instanceof OMIServer) {
            ((OMIServer)this._parent).notifyMetadataConnectionListeners();
        }
        super.notifyMetadataConnectionListeners();
    }
}

