/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import java.io.OutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class LoggerStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 640;
    private Level _priority;
    private Logger _logger;
    private StringBuffer _buffer;
    private int _bufferSize = 640;

    public LoggerStream(String context, Level priority) {
        this._logger = LogManager.getLogger((String)context);
        this._priority = priority;
        this._buffer = new StringBuffer(640);
    }

    @Override
    public void close() {
        if (this._logger.isEnabled(this._priority)) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        if (this._logger.isEnabled(this._priority)) {
            this.flush(false);
        }
    }

    @Override
    public void write(byte[] b) {
        if (this._logger.isEnabled(this._priority)) {
            this.write(b, 0, b.length);
        }
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        if (this._logger.isEnabled(this._priority)) {
            for (int i = offset; i < offset + length && i < b.length; ++i) {
                this.write(b[i]);
            }
        }
    }

    @Override
    public void write(int i) {
        if (this._logger.isEnabled(this._priority)) {
            if (i == 13) {
                return;
            }
            if (i == 10) {
                this.flush(true);
                return;
            }
            this._buffer.append((char)i);
            if (this._buffer.length() >= this._bufferSize) {
                this.flush();
            }
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
        if (this._buffer.length() >= this._bufferSize) {
            this.flush();
        }
    }

    private void flush(boolean hard) {
        if (this._logger.isEnabled(this._priority) && (hard || this._buffer.length() > 0)) {
            this._logger.log(this._priority, this._buffer.toString());
            this._buffer.setLength(0);
        }
    }
}

