/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Root;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceInitializationObject;
import com.sas.services.ServiceState;
import com.sas.services.connection.Cluster;
import com.sas.services.deployment.Environment;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.AutoConnectException;
import com.sas.services.information.DAVRepository;
import com.sas.services.information.Factory;
import com.sas.services.information.FactoryAction;
import com.sas.services.information.FactoryType;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInitObject;
import com.sas.services.information.InformationServiceInitializer;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.InformationServiceProxy;
import com.sas.services.information.InformationServiceTimerClient;
import com.sas.services.information.MetadataChangeEvent;
import com.sas.services.information.MetadataChangeListener;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepository;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.PartialFolderResultsException;
import com.sas.services.information.PartialListResultsException;
import com.sas.services.information.PartialResultsException;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryEvent;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import com.sas.services.information.RepositoryProtocol;
import com.sas.services.information.RepositoryUrlMismatchException;
import com.sas.services.information.ServerDef;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.SmartDef;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.FilteredRepository;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.ServerFilter;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.util.ISEntityKey;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.LoginCallbackHandler;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.IOUtil;
import com.sas.services.util.Names;
import com.sas.services.util.URIUtil;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class InformationService
extends AbstractRemoteService
implements InformationServiceInterface {
    public static final List<String> IDENTITY_TYPES = Arrays.asList("User", "UserGroup", "Person", "IdentityGroup", "AuthenticationDomain", "Login");
    private static final String INFOSVC_CONTEXT = "com.sas.services.information.InformationService";
    private static final int LISTENER_INIT_VALUE = 16;
    private static final int TIMER_CLIENT_INIT_VALUE = 64;
    private static final int SMARTDEF_MAP_INIT_VALUE = 128;
    private static final int REPOSDEF_MAP_INIT_VALUE = 16;
    private static final int REPOSMAP_INIT_VALUE = 256;
    private static final int RESULT_ARRAY_INIT_VALUE = 8;
    private static final int URL_BUFFER_INIT = 32;
    private static final String FACTORY_CONFIG_FILENAME = "factory_config.xml";
    private static final int TIMER_VALUE = 300000;
    private static final String TOKEN_SEPARATOR = ":";
    private static final String ENCODING_UTF_8 = "UTF-8";
    private Logger _logger;
    private static InformationService _service = null;
    private Timer _timer;
    private boolean _isIsolated;
    private EventListener _listener;
    private boolean _destroyed;
    private boolean _cacheTypeDefs = true;
    private boolean _cacheExplicitIdentityGroups = true;
    private HashMap<String, String> _repositories;
    private HashMap<String, Object> _factoryTypes;
    private Map<String, SmartDef> _smartDefs;
    private HashMap<String, RepositoryDef> _reposDefs;
    private HashMap<String, ServerDef> _serverDefs;
    private Factory _factory;
    private Map<String, RepositoryInterface> _reposMap;
    private List<InformationServiceTimerClient> _timerClients;
    private Map<String, RepositoryGroup> _reposGroups;
    private Map<String, List> _listeners;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock listenersReadLock = this.rwl.readLock();
    private final Lock listenersWriteLock = this.rwl.writeLock();
    private Map<String, Map<String, TypeDescriptorInterface>> _typeMapMap;
    private Map<String, Map<String, IdentityGroupInterface>> _explicitIdentityGroupsMapMap;

    private InformationService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws RemoteException, ServiceException {
        super(discoveryService);
        if (serviceConfiguration == null) {
            throw new InitializationException();
        }
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)this, sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
        this.configure(serviceConfiguration);
    }

    public static InformationServiceInterface getInstance(Object initObject) throws ServiceException {
        return InformationService.getInstance(initObject, DiscoveryService.defaultInstance());
    }

    public static InformationServiceInterface getInstance(Object initObject, DiscoveryServiceInterface discoveryService) throws ServiceException {
        InformationService.setService(initObject, discoveryService);
        return _service;
    }

    private static final synchronized void setService(Object initObject, DiscoveryServiceInterface discoveryService) throws ServiceException {
        block12: {
            try {
                ServiceConfigurationInterface serviceConfiguration;
                ServiceConfigurationInterface serviceConfigurationInterface = serviceConfiguration = initObject instanceof ServiceConfigurationInterface ? (ServiceConfigurationInterface)initObject : null;
                if (serviceConfiguration == null) {
                    throw new InitializationException(RB.getStringResource("InformationService.specifyConfig.ex.txt"));
                }
                if (_service != null) break block12;
                _service = new InformationService(serviceConfiguration, discoveryService);
                try {
                    _service.bindToDiscoveryService();
                }
                catch (ServiceException e) {
                    if (_service != null) {
                        try {
                            _service.destroy();
                        }
                        catch (ServiceException e2) {
                            throw e;
                        }
                        catch (RemoteException re) {
                            throw e;
                        }
                        finally {
                            _service = null;
                        }
                    }
                    throw new ServiceException((Throwable)((Object)e), RB.getStringResource("InformationService.uhoh.ex.txt"));
                }
            }
            catch (RemoteException e) {
                throw new ServiceException(e, RB.getStringResource("InformationService.uhoh.ex.txt"));
            }
        }
    }

    public void initialize(InformationServiceInitObject init) throws ServiceException {
        if (init == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.nullConfig.ex.txt"));
        }
        this._destroyed = false;
        if (this._timerClients == null) {
            this._timerClients = new CopyOnWriteArrayList<InformationServiceTimerClient>();
            InformationServiceTimer ist = new InformationServiceTimer();
            Environment environment = this.getEnvironment();
            this._timer = environment != null ? environment.createTimer() : new Timer(true);
            this._timer.schedule((TimerTask)ist, 300000L, 300000L);
        }
        String factoryXml = IOUtil.getStringFromResourceUsingEncoding(InformationService.class, FACTORY_CONFIG_FILENAME, "utf-8");
        this._smartDefs = new HashMap<String, SmartDef>(128);
        this._factoryTypes = new HashMap(128);
        this._repositories = new HashMap(8);
        this._reposMap = new ConcurrentHashMap<String, RepositoryInterface>(256);
        this._listener = new EventListener();
        this._typeMapMap = new HashMap<String, Map<String, TypeDescriptorInterface>>();
        this._explicitIdentityGroupsMapMap = new HashMap<String, Map<String, IdentityGroupInterface>>();
        if (factoryXml != null) {
            Document doc = XMLUtil.convertStringToDocument(factoryXml);
            try {
                NodeList nodeList = doc.getChildNodes();
                int nodelistlength = nodeList.getLength();
                for (int i = 0; i < nodelistlength; ++i) {
                    this.parseConfig(nodeList.item(i));
                }
            }
            catch (InitializationException ex) {
                throw new ServiceException(RB.getStringResource("InformationService.badconfig.ex.txt"));
            }
            catch (RemoteException ex) {
                throw new ServiceException(RB.getStringResource("InformationService.badconfig.ex.txt"));
            }
        }
        RepositoryProtocol repositoryProtocol2 = null;
        for (RepositoryProtocol repositoryProtocol2 : init.getRepositoryProtocols()) {
            String protocol = repositoryProtocol2.getProtocol();
            String o = this._repositories.get(protocol);
            if (o != null) continue;
            this._repositories.put(protocol, repositoryProtocol2.getClassName());
        }
        this._reposDefs = new HashMap(16);
        if (init.reposDefs != null) {
            for (RepositoryDef repositoryDef : init.reposDefs.values()) {
                this._reposDefs.put(repositoryDef.getName().toUpperCase(), repositoryDef);
            }
        }
        this._serverDefs = init.serverDefs != null ? new HashMap<String, ServerDef>(init.serverDefs) : new HashMap(16);
        this._reposGroups = init.repositoryGroups != null ? new ConcurrentHashMap<String, RepositoryGroup>(init.repositoryGroups) : new ConcurrentHashMap(1);
        this.processSmartDefs(this._smartDefs.values());
        this._smartDefs.putAll(init.smartDefs);
        this.processSmartDefs(init.smartDefs.values());
        this.processFactoryTypes(init.getFactoryTypes());
        this._factory = Factory.getInstance();
        this._factory.configure(this._factoryTypes);
        this._listeners = new ConcurrentHashMap<String, List>(10);
    }

    private Map getAppLoginConfig() throws ServiceException {
        String loginConfigAppName = null;
        try {
            LocalDiscoveryServiceInterface discoService = DiscoveryService.defaultInstance();
            Class[] authServiceClassArr = new Class[]{AuthenticationServiceInterface.class};
            ServiceTemplate serviceTemplate = new ServiceTemplate(authServiceClassArr);
            AuthenticationServiceInterface authService = (AuthenticationServiceInterface)discoService.findService(serviceTemplate);
            loginConfigAppName = authService.getLoginConfigAppName();
        }
        catch (RemoteException re) {
            InitializationException ie = new InitializationException();
            ie.initCause(re);
            throw ie;
        }
        HashMap<String, String> domainMap = new HashMap<String, String>(8);
        Environment environment = this.getEnvironment();
        List<AppConfigurationEntry> entries = environment.getAppConfigurationEntry(loginConfigAppName);
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                String[] domains;
                AppConfigurationEntry entry = entries.get(i);
                Map map = entry.getOptions();
                map = LoginCallbackHandler.getDelegateOptionMap(map);
                String mapDomain = (String)map.get("domain");
                String aliasDomain = (String)map.get("aliasdomain");
                if (null != aliasDomain && (domains = aliasDomain.split(",")) != null && domains.length > 0) {
                    for (String domain : domains) {
                        domainMap.put(mapDomain, domain);
                    }
                }
                if (domainMap.containsKey(mapDomain)) continue;
                domainMap.put(mapDomain, null);
            }
        }
        return domainMap;
    }

    private void processSmartDefs(Collection defs) throws InitializationException {
        for (SmartDef nextDef : defs) {
            Map defActions = nextDef.getActions();
            Collection actions = defActions.values();
            for (Object o : actions) {
                if (o instanceof SmartDef.ActionDef) {
                    SmartDef.ActionDef actionDef = (SmartDef.ActionDef)o;
                    this.addFactory(actionDef.getProtocol(), actionDef.getType(), actionDef.getAction().getAction(), actionDef.getAction().getFilter());
                    continue;
                }
                List list = (List)o;
                for (SmartDef.ActionDef actionDef : list) {
                    this.addFactory(actionDef.getProtocol(), actionDef.getType(), actionDef.getAction().getAction(), actionDef.getAction().getFilter());
                }
            }
        }
    }

    private void processFactoryTypes(Collection factoryTypes) throws InitializationException {
        String protocol = null;
        String type = null;
        FactoryType factoryType2 = null;
        FactoryAction factoryAction2 = null;
        for (FactoryType factoryType2 : factoryTypes) {
            protocol = factoryType2.getProtocol();
            type = factoryType2.getType();
            for (FactoryAction factoryAction2 : factoryType2.getFactoryActionSet()) {
                this.addFactory(protocol, type, factoryAction2.getAction(), factoryAction2.getFilter());
            }
        }
    }

    private void parseConfig(Node node) throws InitializationException, RemoteException {
        switch (node.getNodeType()) {
            case 10: {
                NamedNodeMap map = ((DocumentType)node).getEntities();
                int maplength = map.getLength();
                for (int i = 0; i < maplength; ++i) {
                    this.parseConfig(map.item(i));
                }
                NodeList nodeList = node.getChildNodes();
                int nodelistlength = nodeList.getLength();
                for (int i = 0; i < nodelistlength; ++i) {
                    Node child = nodeList.item(i);
                    this.parseConfig(child);
                }
                break;
            }
            case 9: 
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int nodelistlength = nodeList.getLength();
                for (int i = 0; i < nodelistlength; ++i) {
                    Node child = nodeList.item(i);
                    this.parseConfig(child);
                }
                break;
            }
            case 1: 
            case 6: {
                String elementName = node.getNodeName();
                if ("InformationService".equalsIgnoreCase(elementName)) {
                    NodeList nodeList = node.getChildNodes();
                    int nodelistlength = nodeList.getLength();
                    for (int i = 0; i < nodelistlength; ++i) {
                        Node child = nodeList.item(i);
                        this.parseConfig(child);
                    }
                } else {
                    if ("repository".equalsIgnoreCase(elementName)) {
                        Element element = (Element)node;
                        String protocol = element.getAttribute("protocol");
                        String className = element.getAttribute("class");
                        this._repositories.put(protocol.toLowerCase(), className);
                    } else if ("Factory".equalsIgnoreCase(elementName)) {
                        this.parseFactory(node);
                        break;
                    }
                    NodeList nodeList = node.getChildNodes();
                    int nodelistlength = nodeList.getLength();
                    for (int i = 0; i < nodelistlength; ++i) {
                        Node child = nodeList.item(i);
                        this.parseConfig(child);
                    }
                }
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private final void parseFactory(Node node) throws RemoteException {
        NodeList nodeList = node.getChildNodes();
        Node child = null;
        String elementName = null;
        int nodelistlength = nodeList.getLength();
        for (int i = 0; i < nodelistlength; ++i) {
            child = nodeList.item(i);
            if (child.getNodeType() != 1) continue;
            elementName = child.getNodeName();
            if ("type".equalsIgnoreCase(elementName)) {
                Element element = (Element)child;
                String protocol = element.getAttribute("protocol");
                String type = element.getAttribute("type");
                String action = element.getAttribute("action");
                String filter = element.getAttribute("filter");
                if (filter.length() == 0) {
                    filter = null;
                }
                this.addFactory(protocol, type, action, filter);
                continue;
            }
            if (!"SmartObject".equalsIgnoreCase(elementName)) continue;
            this.parseAction(child);
        }
    }

    private final void parseAction(Node child) throws RemoteException {
        Element element = (Element)child;
        String smartType = element.getAttribute("smartType");
        String interfaceClass = element.getAttribute("interface");
        SmartDef definition = new SmartDef(smartType, interfaceClass);
        NodeList smartKids = element.getChildNodes();
        int smartkidlength = smartKids.getLength();
        for (int k = 0; k < smartkidlength; ++k) {
            FactoryAction fact = null;
            Node smartChild = smartKids.item(k);
            String smartChildName = smartChild.getNodeName();
            if ("Action".equalsIgnoreCase(smartChildName)) {
                String filter;
                String action;
                String type;
                Element smartAction = (Element)smartChild;
                String protocol = smartAction.getAttribute("protocol");
                if (definition.addAction(protocol, type = smartAction.getAttribute("type"), fact = new FactoryAction(action = smartAction.getAttribute("action"), filter = smartAction.getAttribute("filter")))) continue;
                this.logMessage(Level.DEBUG, Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.actionNotAdded.fmt.txt", (Object)protocol, (Object)type, (Object)definition.getID()));
                continue;
            }
            if (!"filter".equalsIgnoreCase(smartChildName)) continue;
            Element smartFilter = (Element)smartChild;
            String filterClass = smartFilter.getAttribute("class");
            definition.setFilterClass(filterClass);
        }
        this._smartDefs.put(smartType, definition);
    }

    public final void addFactory(String protocol, String type, String action, String filter) {
        String factoryType = type != null ? type.toLowerCase() : "";
        FactoryAction fact = new FactoryAction(action, filter);
        String key = protocol.toLowerCase() + TOKEN_SEPARATOR + factoryType;
        Object o = this._factoryTypes.get(key);
        if (o != null) {
            if (o instanceof List) {
                List factList = (List)o;
                Iterator factIt = factList.iterator();
                while (factIt.hasNext()) {
                    FactoryAction inFact = (FactoryAction)factIt.next();
                    String infilter = inFact.getFilter();
                    if (!infilter.equals(filter)) continue;
                    factIt.remove();
                }
                ((List)o).add(fact);
            }
            if (o instanceof FactoryAction) {
                FactoryAction inFact = (FactoryAction)o;
                String inFilter = inFact.getFilter();
                if (inFilter.equals(filter)) {
                    this._factoryTypes.put(key, fact);
                } else {
                    ArrayList<Object> l = new ArrayList<Object>(8);
                    l.add(o);
                    l.add(fact);
                    this._factoryTypes.put(key, l);
                }
            }
        } else {
            this._factoryTypes.put(key, fact);
        }
        if (action.startsWith("ctor::")) {
            String smartName = action.substring(6);
            key = protocol + TOKEN_SEPARATOR + smartName;
            this._factoryTypes.put(key, type);
        }
    }

    @Override
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        super.configure(serviceConfiguration);
        Object initObject = serviceConfiguration.getInitializationObject();
        InformationServiceInitObject informationServiceInitObject = null;
        try {
            informationServiceInitObject = (InformationServiceInitObject)initObject;
        }
        catch (ClassCastException e) {
            try {
                informationServiceInitObject = (InformationServiceInitObject)((ServiceInitializationObject)initObject).getConfiguration(new InformationServiceInitializer());
            }
            catch (ClassCastException cce) {
                throw new InitializationException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.config.ex.fmt.txt", (Object)initObject));
            }
        }
        this.initialize(informationServiceInitObject);
    }

    @Override
    public void destroy() throws ServiceException, RemoteException {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        short serviceState = this.getServiceState();
        if (!ServiceState.isStateDeactivated(serviceState)) {
            try {
                this.logMessage(Level.DEBUG, RB.getStringResource("InformationService.destroy.txt"));
                this.cleanReposMap();
                if (this._factoryTypes != null) {
                    this._factoryTypes.clear();
                }
                if (this._smartDefs != null) {
                    this._smartDefs.clear();
                }
                if (this._repositories != null) {
                    this._repositories.clear();
                }
                if (this._listeners != null) {
                    this._listeners.clear();
                }
                if (this._reposDefs != null) {
                    this._reposDefs.clear();
                }
                if (this._explicitIdentityGroupsMapMap != null) {
                    this._explicitIdentityGroupsMapMap.clear();
                }
                this._logger = null;
                this.cleanTimers();
                OMIRepository.clearInformationService();
                OMIServerRepository.clearInformationService();
                DAVRepository.clearInformationService();
                Metadata.clearInformationService();
                this._factory.destroy();
            }
            finally {
                super.destroy();
            }
        }
        _service = null;
    }

    private void cleanReposMap() throws RemoteException {
        if (this._reposMap != null) {
            Collection<RepositoryInterface> repos = this._reposMap.values();
            Object[] reposArray = repos.toArray();
            for (int i = 0; i < reposArray.length; ++i) {
                RepositoryInterface r = (RepositoryInterface)reposArray[i];
                this.removeListener(r);
            }
            this._reposMap.clear();
            this._reposMap = null;
        }
    }

    private void removeListener(RepositoryInterface r) throws RemoteException {
        try {
            r.removeListener(this._listener);
            r.close();
        }
        catch (ServiceException ex) {
            this.logMessage(Level.INFO, "", (Throwable)((Object)ex));
        }
    }

    private void cleanTimers() {
        if (this._timer != null) {
            if (this._timerClients != null) {
                this._timerClients.clear();
                this._timerClients = null;
            }
            this._timer.cancel();
            this._timer = null;
        }
    }

    @Override
    public void setOption(int option, Object o) throws IllegalArgumentException, ServiceException, RemoteException {
        switch (option) {
            case 0: {
                int interval = this.object2Int(o);
                Metadata.setTreeRefresh(interval);
                break;
            }
            case 1: {
                int interval = this.object2Int(o);
                Folder.setItemRefresh(interval);
                break;
            }
            case 2: {
                int interval = this.object2Int(o);
                Folder.setFolderRefresh(interval);
                break;
            }
            case 3: {
                if (!(o instanceof Boolean)) {
                    throw new IllegalArgumentException();
                }
                if (((Boolean)o).booleanValue()) {
                    this._cacheTypeDefs = true;
                    break;
                }
                this._cacheTypeDefs = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.invalidOption.ex.fmt.txt", (Object)new Integer(option)));
            }
        }
    }

    private int object2Int(Object o) throws IllegalArgumentException {
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i;
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                int i = Integer.valueOf(s);
                return i;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.integerString.ex.fmt.txt", (Object)s));
            }
        }
        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.integer.ex.fmt.txt", (Object)o.getClass().getName()));
    }

    @Override
    public Object getOption(int option) throws IllegalArgumentException, ServiceException, RemoteException {
        switch (option) {
            case 0: {
                long refresh = Metadata.getTreeRefresh();
                return new Integer((int)refresh);
            }
            case 1: {
                return new Integer((int)Folder.getItemRefresh());
            }
            case 2: {
                return new Integer((int)Folder.getFolderRefresh());
            }
        }
        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.invalidOption.ex.fmt.txt", (Object)new Integer(option)));
    }

    @Override
    public HashMap getFactoryConfig() throws RemoteException {
        return this._factoryTypes;
    }

    @Override
    public String getRepositoryUrl(String name) throws ServiceException, RemoteException {
        RepositoryDef rd = this._reposDefs.get(name.toUpperCase());
        if (rd == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(rd.getProtocol() + "://" + rd.getHost() + ':' + rd.getPort());
        if (rd.getBase() != null) {
            if (rd.getBase().charAt(0) == '/') {
                buffer.append(rd.getBase());
            } else {
                buffer.append('/' + rd.getBase());
            }
        }
        return buffer.toString();
    }

    @Override
    public List findServers(UserContextInterface user) throws ServiceException, RemoteException {
        UserContextInterface localUser = this.getLocalUserContext(user);
        ArrayList<RepositoryDef> result = new ArrayList<RepositoryDef>(8);
        ServerFilter filter = new ServerFilter();
        filter.setServerType(7);
        List list = this.search(localUser, filter);
        for (Object o : list) {
            if (o instanceof com.sas.services.information.metadata.ServerInterface) {
                com.sas.services.information.metadata.ServerInterface server = (com.sas.services.information.metadata.ServerInterface)o;
                String host = server.getHost();
                String port = String.valueOf(server.getTcpPort());
                String domain = "";
                List domains = server.getDomains();
                if (domains.size() > 0) {
                    domain = (String)domains.get(0);
                }
                String protocol = server.getApplicationProtocol();
                RepositoryDef reposDef = new RepositoryDef(host, port, domain, null, protocol);
                result.add(reposDef);
                continue;
            }
            if (!(o instanceof HttpServerInterface)) continue;
        }
        return result;
    }

    @Override
    public MetadataInterface getTrackedObject(UserContextInterface user, int trackingId) throws RemoteException {
        MetadataInterface mi = null;
        return mi;
    }

    @Override
    public MetadataInterface fetchEntityByKey(UserContextInterface user, String key) throws RemoteException, ServiceException {
        return this.fetchEntityByKey(user, key, false);
    }

    @Override
    public MetadataInterface fetchEntityByKey(UserContextInterface user, String key, boolean bypassCache) throws RemoteException, ServiceException {
        String entityUrl;
        MetadataInterface mi = null;
        if (user == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        UserContextInterface localUser = this.getLocalUserContext(user);
        ISEntityKey iseKey = new ISEntityKey(key);
        String protocol = iseKey.getProtocol();
        if ("omi".equals(protocol)) {
            ServerInterface server = user.getAuthServer();
            return server.fetch(key, bypassCache);
        }
        int index = key.indexOf("+");
        if (index < 0) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.badkey.ex.fmt", (Object)key));
        }
        String testUrl = entityUrl = key.substring(index + 1);
        String hostport = null;
        try {
            URI entityURI = new URI(entityUrl);
            String authority = entityURI.getAuthority();
            index = authority.indexOf(";");
            if (index > 0) {
                hostport = URLDecoder.decode(authority.substring(0, index), ENCODING_UTF_8);
                testUrl = entityURI.getScheme() + "://" + hostport + entityURI.getRawPath();
            } else {
                hostport = URLDecoder.decode(authority, ENCODING_UTF_8);
                testUrl = entityUrl;
            }
        }
        catch (URISyntaxException t) {
            testUrl = entityUrl;
        }
        catch (UnsupportedEncodingException t) {
            testUrl = entityUrl;
        }
        ISEntityKey isKey = new ISEntityKey(key);
        String reposName = isKey.getRepository();
        RepositoryInterface repos = this.getRepository(localUser, reposName);
        if (repos != null) {
            try {
                String p;
                URI entityURI = new URI(entityUrl);
                testUrl = entityURI.getScheme() + "://" + repos.getHost() + ':' + repos.getPort();
                String b = repos.getBase();
                if (b.length() > 0) {
                    URI baseURI = new URI(null, null, b, null);
                    b = baseURI.toASCIIString();
                    testUrl = URIUtil.addSegment(testUrl, b);
                }
                if ((p = entityURI.getRawPath()) != null && p.length() > 0) {
                    testUrl = URIUtil.addSegment(testUrl, p);
                }
            }
            catch (URISyntaxException t) {
                testUrl = entityUrl;
            }
        } else {
            repos = this.getRepositoryByURL(localUser, testUrl);
        }
        if (repos == null) {
            repos = this.connectRepositoryByURL(localUser, entityUrl, null);
        }
        if (repos == null) {
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.nosuchrepos.msg.fmt.txt", testUrl);
            return null;
        }
        String reposUrl = repos.getUrl();
        String relpath = null;
        relpath = URIUtil.url1StartsWithUrl2(testUrl, reposUrl);
        if (relpath == null) {
            return null;
        }
        String id = relpath.length() > 0 ? relpath.substring(1) : "";
        mi = repos.fetch(id, bypassCache);
        if (mi == null) {
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.nosuchkey.msg.fmt.txt", id);
        }
        return mi;
    }

    @Override
    public MetadataInterface fetchEntityByUrl(UserContextInterface user, String url, String domain) throws RemoteException, ServiceException {
        return this.fetchEntityByUrl(user, url, domain, false);
    }

    @Override
    public MetadataInterface fetchEntityByUrl(UserContextInterface user, String url, String domain, boolean bypassCache) throws RemoteException, ServiceException {
        RepositoryInterface ri2;
        MetadataInterface mi = null;
        boolean foundRepository = false;
        if (user == null) {
            return null;
        }
        if (url == null) {
            return null;
        }
        UserContextInterface localUser = this.getLocalUserContext(user);
        for (RepositoryInterface ri2 : localUser.getRepositories()) {
            try {
                mi = ri2.fetchByUrl(url, false);
                foundRepository = true;
                if (mi == null) continue;
                return mi;
            }
            catch (RepositoryUrlMismatchException repositoryUrlMismatchException) {
            }
        }
        if (!foundRepository && (ri2 = this.getRepositoryByURL(user, url)) != null) {
            try {
                mi = ri2.fetchByUrl(url, bypassCache);
                foundRepository = true;
            }
            catch (RepositoryUrlMismatchException repositoryUrlMismatchException) {
                // empty catch block
            }
        }
        if (!foundRepository) {
            ri2 = this.connectRepositoryByURL(localUser, url, domain);
            foundRepository = true;
            if (ri2 != null) {
                try {
                    mi = ri2.fetchByUrl(url, false);
                }
                catch (RepositoryUrlMismatchException repositoryUrlMismatchException) {
                    // empty catch block
                }
            }
        }
        return mi;
    }

    private RepositoryInterface getRepositoryByURL(UserContextInterface user, String url) throws ServiceException, RemoteException {
        RepositoryInterface ri = null;
        Iterator it = user.getRepositories().iterator();
        boolean found_repos = false;
        while (it.hasNext()) {
            RepositoryInterface repos = (RepositoryInterface)it.next();
            String reposUrl = repos.getUrl();
            String relpath = URIUtil.url1StartsWithUrl2(url, reposUrl);
            if (relpath == null) continue;
            found_repos = true;
            return repos;
        }
        if (!found_repos) {
            List reposList = this.getReposDefs();
            for (RepositoryDef nextDef : reposList) {
                String reposUrl = nextDef.getUrl();
                String relpath = URIUtil.url1StartsWithUrl2(url, reposUrl);
                if (relpath == null) continue;
                try {
                    RepositoryInterface repos = this.connect(user, nextDef);
                    return repos;
                }
                catch (RemoteException ex) {
                    this.logMessage(Level.WARN, "", ex);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, "", (Throwable)((Object)ex));
                }
            }
        }
        return ri;
    }

    private RepositoryInterface connectRepositoryByURL(UserContextInterface user, String url, String domain) throws RemoteException {
        RepositoryInterface ri = null;
        String host = null;
        String port = null;
        try {
            Object tcpInfo;
            String authority;
            int index;
            URI entityURI = new URI(url);
            String protocol = entityURI.getScheme();
            if ("http".equalsIgnoreCase(protocol)) {
                protocol = "dav";
            }
            if ("sas-oma".equalsIgnoreCase(protocol)) {
                protocol = "omi";
            }
            if ((index = (authority = entityURI.getAuthority()).indexOf(";")) > 0) {
                tcpInfo = authority.substring(0, index);
                int index2 = ((String)tcpInfo).indexOf(TOKEN_SEPARATOR);
                if (index2 > 0) {
                    host = ((String)tcpInfo).substring(0, index2);
                    port = ((String)tcpInfo).substring(index2 + 1);
                } else {
                    host = tcpInfo;
                }
                if (domain == null) {
                    StringTokenizer st = new StringTokenizer(authority, ";");
                    while (st.hasMoreTokens()) {
                        String tokenType;
                        String nextToken = st.nextToken();
                        index = nextToken.indexOf("=");
                        if (index <= -1 || !(tokenType = nextToken.substring(0, index)).toLowerCase().startsWith("domain") || index <= 0) continue;
                        domain = nextToken.substring(index + 1);
                    }
                }
            } else {
                host = entityURI.getHost();
                if (host == null) {
                    throw new ServiceException(RB.getStringResource("InformationService.badkeyhost.ex.txt"));
                }
                port = String.valueOf(entityURI.getPort());
            }
            if (host == null || domain == null) {
                return null;
            }
            try {
                tcpInfo = InetAddress.getByName(host);
            }
            catch (UnknownHostException ex) {
                return null;
            }
            if ("-1".equals(port)) {
                if (url.startsWith("http:")) {
                    port = "80";
                }
                if (url.startsWith("https:")) {
                    port = "443";
                }
                if (url.startsWith("sas-oma")) {
                    port = "8561";
                }
            }
            if ("dav".equals(protocol)) {
                ri = this.doDavConnect(user, entityURI, host, port, domain, protocol);
            } else {
                RepositoryDef reposDef = new RepositoryDef(host, port, domain, null, protocol);
                ri = this.connect(user, reposDef);
            }
        }
        catch (URISyntaxException ex) {
            this.logMessage(Level.WARN, "", ex);
        }
        catch (ServiceException ex) {
            this.logMessage(Level.WARN, "", (Throwable)((Object)ex));
        }
        catch (RemoteException ex) {
            this.logMessage(Level.WARN, "", ex);
        }
        return ri;
    }

    private RepositoryInterface doDavConnect(UserContextInterface user, URI uri, String host, String port, String domain, String protocol) throws ServiceException, RemoteException {
        boolean found_repos = false;
        RepositoryInterface ri = null;
        String path = uri.getPath();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        String base = null;
        int ptr = 0;
        while (!found_repos && ptr >= 0) {
            RepositoryDef reposDef = new RepositoryDef(host, port, domain, base, protocol);
            ri = this.connect(user, reposDef);
            if (ri != null) {
                try {
                    ri.getRootFolders();
                    found_repos = true;
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if ((ptr = path.indexOf(47)) <= 0) continue;
            base = base == null ? path.substring(0, ptr) : base + '/' + path.substring(0, ptr);
            path = path.substring(ptr + 1);
        }
        return ri;
    }

    @Override
    public MetadataInterface newMetadataInFolder(FolderInterface folder, RepositoryInterface repos, String type, String name) throws ServiceException, RemoteException {
        TypeDescriptorInterface tdi;
        String smartClassName = null;
        if (repos == null) {
            throw new ServiceException(RB.getStringResource("InformationService.nononull.ex.txt"));
        }
        if (type == null) {
            throw new ServiceException(RB.getStringResource("InformationService.nulltype.ex.txt"));
        }
        if (IDENTITY_TYPES.contains(type)) {
            Names.validateIdentityName(name, true);
        } else {
            Names.validateOMRObjectName(name, true);
        }
        repos = this.getLocalRepository(repos);
        if (folder != null && folder.hasDuplicate(name, type)) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.dupitem.ex.fmt.txt", (Object)name, (Object)type));
        }
        ServerInterface server = repos.getServer();
        if (server != null && (tdi = server.getTypeDescriptor(type)) != null && (smartClassName = tdi.getClassName()) != null && smartClassName.trim().length() == 0) {
            smartClassName = null;
        }
        if (smartClassName == null) {
            SmartDef.ActionDef actionDef;
            FactoryAction action;
            String url = repos.getUrl();
            String protocol = url.substring(0, url.indexOf(TOKEN_SEPARATOR));
            SmartDef smartDef = this._smartDefs.get(type);
            if (smartDef == null) {
                MetadataInterface mi = this.newMetadata(null, name, repos, type);
                if (folder != null) {
                    folder.addItem(mi);
                }
                return mi;
            }
            Map actions = smartDef.getActions();
            Object o = actions.get(protocol);
            if (o == null) {
                return null;
            }
            if (o instanceof SmartDef.ActionDef) {
                smartClassName = ((SmartDef.ActionDef)o).getAction().getActionClassName();
            } else if (o instanceof List && (action = (actionDef = (SmartDef.ActionDef)((List)o).get(0)).getAction()) != null) {
                smartClassName = action.getActionClassName();
            }
        }
        if (smartClassName == null) {
            MetadataInterface mi = this.newMetadata(null, name, repos, type);
            if (folder != null) {
                folder.addItem(mi);
            }
            return mi;
        }
        Class[] parms = new Class[]{RepositoryInterface.class, String.class, FolderInterface.class};
        Object[] args = new Object[]{repos, name, folder};
        try {
            return (MetadataInterface)this._factory.newInstance(smartClassName, parms, args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException(cnfe, Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.clsntfnd.ex.fmt", (Object)smartClassName));
        }
    }

    @Override
    public MetadataInterface newMetadata913(String reposId, String name, RepositoryInterface repos, String type) throws RemoteException, ServiceException {
        if (repos == null) {
            throw new ServiceException(RB.getStringResource("InformationService.nononull.ex.txt"));
        }
        if (type == null) {
            throw new ServiceException(RB.getStringResource("InformationService.nulltype.ex.txt"));
        }
        String url = repos.getUrl();
        String protocol = url.substring(0, url.indexOf(TOKEN_SEPARATOR));
        String key = protocol + TOKEN_SEPARATOR + type;
        Object typeObject = this._factoryTypes.get(key);
        String reposType = null;
        if (typeObject instanceof String) {
            reposType = (String)typeObject;
        }
        if (reposType == null) {
            return repos.newMetadata(reposId, name, type);
        }
        return repos.newMetadata(reposId, name, reposType);
    }

    @Override
    public MetadataInterface newMetadata(String reposId, String name, RepositoryInterface repos, String type) throws RemoteException, ServiceException {
        TypeDescriptorInterface tdi;
        String smartClassName = null;
        if (repos == null) {
            throw new ServiceException(RB.getStringResource("InformationService.nononull.ex.txt"));
        }
        if (type == null) {
            throw new ServiceException(RB.getStringResource("InformationService.nulltype.ex.txt"));
        }
        if (IDENTITY_TYPES.contains(type)) {
            Names.validateIdentityName(name, true);
        } else {
            Names.validateOMRObjectName(name, true);
        }
        repos = this.getLocalRepository(repos);
        ServerInterface server = repos.getServer();
        if (server != null && (tdi = server.getTypeDescriptor(type)) != null && (smartClassName = tdi.getClassName()) != null && smartClassName.trim().length() == 0) {
            smartClassName = null;
        }
        if (smartClassName == null) {
            SmartDef.ActionDef actionDef;
            FactoryAction action;
            String url = repos.getUrl();
            String protocol = url.substring(0, url.indexOf(TOKEN_SEPARATOR));
            SmartDef smartDef = this._smartDefs.get(type);
            if (smartDef == null) {
                String key = protocol + ':' + type;
                Object typeObject = this._factoryTypes.get(key);
                String reposType = null;
                if (typeObject instanceof String) {
                    reposType = (String)typeObject;
                }
                return reposType == null ? repos.newMetadata(reposId, name, type) : repos.newMetadata(reposId, name, reposType);
            }
            Map actions = smartDef.getActions();
            Object o = actions.get(protocol);
            if (o == null) {
                return null;
            }
            if (o instanceof SmartDef.ActionDef) {
                smartClassName = ((SmartDef.ActionDef)o).getAction().getActionClassName();
            } else if (o instanceof List && (action = (actionDef = (SmartDef.ActionDef)((List)o).get(0)).getAction()) != null) {
                smartClassName = action.getActionClassName();
            }
        }
        if (smartClassName == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.nosmrtcfg.msg.fmt.txt", (Object)type));
        }
        Class[] parms = new Class[]{RepositoryInterface.class, String.class, FolderInterface.class};
        Object[] args = new Object[]{repos, name, null};
        try {
            return (MetadataInterface)this._factory.newInstance(smartClassName, parms, args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException(cnfe, Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.clsntfnd.ex.fmt", (Object)smartClassName));
        }
    }

    @Override
    public MetadataInterface newMetadataByModel(MetadataInterface model, String name) throws RemoteException, ServiceException {
        if (model == null) {
            throw new ServiceException(RB.getStringResource("InformationService.nullmodel.ex.txt"));
        }
        RepositoryInterface repos = model.getRepository();
        return repos.newMetadataByModel(model, name);
    }

    @Override
    public List searchFilterArray(UserContextInterface user, FilterInterface[] filters) throws ServiceException, RemoteException {
        UserContextInterface uci;
        PartialListResultsException plre = null;
        List results = new ArrayList(8);
        UserContextInterface localUser = user;
        if (user instanceof RemoteStub && (uci = this.getLocalUserContext(user)) != null) {
            localUser = uci;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) continue;
            try {
                List temp = this.search(localUser, filters[i]);
                results.addAll(temp);
                continue;
            }
            catch (PartialListResultsException except) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, except.getMessage());
                }
                List list = except.getResults();
                results.addAll(list);
                Throwable[] exceptions = except.getExceptions();
                for (int j = 0; j < exceptions.length; ++j) {
                    plre.addException(exceptions[j]);
                }
            }
        }
        if (plre != null) {
            throw plre;
        }
        results = this.purgeSearchResults(results);
        return results;
    }

    @Override
    public List search(UserContextInterface user, FilterInterface filter) throws ServiceException, RemoteException {
        PartialListResultsException plre = new PartialListResultsException(new ArrayList(8), "");
        UserContextInterface localUser = this.getLocalUserContext(user);
        this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.srchuser.ex.fmt", localUser.getName());
        List result = new ArrayList(8);
        if (filter == null) {
            return result;
        }
        boolean found_a_repos = false;
        for (RepositoryInterface repos : localUser.getRepositories()) {
            if (!this.searchRepos(repos, filter, result, plre)) continue;
            found_a_repos = true;
        }
        if (!found_a_repos) {
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.usernorepos.msg.fmt", localUser.getName());
        }
        if (plre.getExceptions().length > 0) {
            throw plre;
        }
        result = this.purgeSearchResults(result);
        return result;
    }

    @Override
    public List searchProtocols(UserContextInterface user, List protocols, FilterInterface filter) throws ServiceException, RemoteException {
        PartialListResultsException plre = new PartialListResultsException(new ArrayList(8), "");
        boolean did_search = false;
        UserContextInterface localUser = this.getLocalUserContext(user);
        this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.srchuser.ex.fmt", localUser.getName());
        List result = new ArrayList(8);
        for (RepositoryInterface repos : localUser.getRepositories()) {
            int index;
            String url = repos.getUrl();
            String protocol = url.substring(0, index = url.indexOf(TOKEN_SEPARATOR));
            if (!protocols.contains(protocol) || !this.searchRepos(repos, filter, result, plre)) continue;
            did_search = true;
        }
        if (!did_search) {
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.usernorepos.msg.fmt", localUser.getName());
        }
        if (plre.getExceptions().length > 0) {
            throw plre;
        }
        result = this.purgeSearchResults(result);
        return result;
    }

    @Override
    public List searchProtocolsWithFilterArray(UserContextInterface user, List protocols, FilterInterface[] filters) throws ServiceException, RemoteException {
        PartialListResultsException plre = new PartialListResultsException(new ArrayList(8), "");
        List result = new ArrayList(8);
        if (user == null) {
            return result;
        }
        if (protocols == null || protocols.size() == 0) {
            return result;
        }
        if (filters == null || filters.length == 0) {
            return result;
        }
        UserContextInterface localUser = this.getLocalUserContext(user);
        boolean did_search = false;
        for (RepositoryInterface repos : localUser.getRepositories()) {
            int index;
            String url = repos.getUrl();
            String protocol = url.substring(0, index = url.indexOf(TOKEN_SEPARATOR));
            if (!protocols.contains(protocol) || !this.searchReposFilterArray(repos, filters, result, plre)) continue;
            did_search = true;
        }
        if (!did_search) {
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.usernorepos.msg.fmt", localUser.getName());
        }
        if (plre.getExceptions().length > 0) {
            throw plre;
        }
        result = this.purgeSearchResults(result);
        return result;
    }

    private boolean searchRepos(RepositoryInterface ri, FilterInterface filter, List results, PartialListResultsException plre) throws ServiceException, RemoteException {
        boolean did_search = false;
        if (ri == null) {
            return false;
        }
        if (results == null) {
            return false;
        }
        if (filter == null) {
            return false;
        }
        this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.srchrepos.msg.fmt.txt", ri.getUrl());
        try {
            String repository;
            if (ri instanceof OMIRepositoryInterface && (repository = filter.getOMRRepository()) != null && !ri.getBase().equals(repository)) {
                return false;
            }
            List list = ri.search(filter);
            results.addAll(list);
            did_search = true;
        }
        catch (PartialListResultsException partial) {
            if (plre == null) {
                throw partial;
            }
            Throwable[] exceptions = partial.getExceptions();
            for (int i = 0; i < exceptions.length; ++i) {
                plre.addException(exceptions[i]);
            }
            List list = partial.getResults();
            results.addAll(list);
            did_search = true;
        }
        catch (ServiceException svcEx) {
            if (plre == null) {
                throw svcEx;
            }
            plre.addException((Throwable)((Object)svcEx));
            did_search = false;
        }
        return did_search;
    }

    private boolean searchReposFilterArray(RepositoryInterface ri, FilterInterface[] filters, List results, PartialListResultsException plre) throws ServiceException, RemoteException {
        boolean did_search = false;
        for (int i = 0; i < filters.length; ++i) {
            if (!this.searchRepos(ri, filters[i], results, plre)) continue;
            did_search = true;
        }
        return did_search;
    }

    @Override
    public List searchTree(UserContextInterface user, FilterInterface filter) throws ServiceException, RemoteException {
        UserContextInterface uci;
        PartialResultsException plre = null;
        List<FilteredRepository> result = new ArrayList(8);
        UserContextInterface localUser = user;
        if (user instanceof RemoteStub && (uci = this.getLocalUserContext(user)) != null) {
            localUser = uci;
        }
        List repositories = localUser.getRepositories();
        for (RepositoryInterface ri : repositories) {
            FilteredRepository fr = new FilteredRepository(ri);
            boolean hasResults = false;
            try {
                List folders = ri.getRootFolders();
                for (FolderInterface nextFolder : folders) {
                    FilteredFolderInterface ffi = null;
                    try {
                        ffi = ri.searchTreeFromBase(nextFolder, filter);
                    }
                    catch (PartialFolderResultsException pfre) {
                        if (plre == null) {
                            plre = new PartialListResultsException(result, pfre.getMessage());
                        }
                        Throwable[] exceptions = pfre.getExceptions();
                        for (int j = 0; j < exceptions.length; ++j) {
                            plre.addException(exceptions[j]);
                        }
                        ffi = (FilteredFolderInterface)pfre.getResults();
                    }
                    if (ffi == null) continue;
                    fr.addSubfolder(ffi);
                    hasResults = true;
                }
                if (!hasResults) continue;
                result.add(fr);
            }
            catch (ServiceException svcex) {
                if (plre == null) {
                    plre = new PartialListResultsException(result, svcex.getMessage());
                }
                plre.addException((Throwable)((Object)svcex));
            }
        }
        if (plre != null) {
            throw plre;
        }
        result = this.purgeSearchResults(result);
        return result;
    }

    @Override
    public List searchGroupName(UserContextInterface user, String groupName, FilterInterface filter) throws ServiceException, RemoteException {
        RepositoryGroup group = user.getRepositoryGroup(groupName);
        if (group == null && (group = this.getRepositoryGroup(groupName)) == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.nosuchgroup.ex.fmt.txt", (Object)groupName));
        }
        return this.searchGroup(user, group, filter);
    }

    @Override
    public List searchGroup(UserContextInterface user, RepositoryGroup group, FilterInterface filter) throws ServiceException, RemoteException {
        UserContextInterface uci;
        PartialListResultsException plre = null;
        List results = new ArrayList(8);
        List<String> names = group.getGroupNames();
        Iterator<String> it = names.iterator();
        UserContextInterface localUser = user;
        if (user instanceof RemoteStub && (uci = this.getLocalUserContext(user)) != null) {
            localUser = uci;
        }
        while (it.hasNext()) {
            String nextrepos = it.next();
            RepositoryInterface ri = this.getRepository(localUser, nextrepos);
            if (ri == null) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.grpnocnct.ex.fmt.txt", (Object)nextrepos))));
            }
            if (ri == null) continue;
            try {
                List list = ri.search(filter);
                results.addAll(list);
            }
            catch (PartialListResultsException partial) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                Throwable[] exceptions = partial.getExceptions();
                for (int i = 0; i < exceptions.length; ++i) {
                    plre.addException(exceptions[i]);
                }
                List list = partial.getResults();
                results.addAll(list);
            }
            catch (ServiceException svcEx) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)svcEx));
            }
        }
        if (plre != null) {
            throw plre;
        }
        results = this.purgeSearchResults(results);
        return results;
    }

    @Override
    public List searchGroupWithFilterArray(UserContextInterface user, RepositoryGroup group, FilterInterface[] filterArray) throws ServiceException, RemoteException {
        PartialListResultsException ohcrap = null;
        List results = new ArrayList(8);
        for (int i = 0; i < filterArray.length; ++i) {
            FilterInterface nextFilter = filterArray[i];
            List stuff = null;
            try {
                stuff = this.searchGroup(user, group, nextFilter);
            }
            catch (PartialListResultsException plre) {
                stuff = plre.getResults();
                if (ohcrap == null) {
                    ohcrap = plre;
                }
                Throwable[] exceptions = plre.getExceptions();
                for (int j = 0; j < exceptions.length; ++j) {
                    ohcrap.addException(exceptions[j]);
                }
            }
            Iterator it = stuff.iterator();
            while (it.hasNext()) {
                results.add(it.next());
            }
        }
        if (ohcrap != null) {
            throw ohcrap;
        }
        results = this.purgeSearchResults(results);
        return results;
    }

    @Override
    public List searchGroupNameWithFilterArray(UserContextInterface user, String groupName, FilterInterface[] filterArray) throws ServiceException, RemoteException {
        RepositoryGroup group = user.getRepositoryGroup(groupName);
        if (group == null && (group = this.getRepositoryGroup(groupName)) == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.nosuchgroup.ex.fmt.txt", (Object)groupName));
        }
        return this.searchGroupWithFilterArray(user, group, filterArray);
    }

    private List purgeSearchResults(List searchResults) throws RemoteException {
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(searchResults.size());
        ArrayList<String> idList = new ArrayList<String>(searchResults.size());
        for (MetadataInterface mi : searchResults) {
            String id = mi.getReposId();
            if (idList.contains(id)) continue;
            result.add(mi);
            idList.add(id);
        }
        return result;
    }

    @Override
    public List browseSearch(UserContextInterface user, Filter filter) throws ServiceException, RemoteException {
        PartialResultsException plre = null;
        List results = new ArrayList(8);
        Iterator reposIt = user.getRepositories().iterator();
        while (reposIt.hasNext()) {
            try {
                RepositoryInterface ri = (RepositoryInterface)reposIt.next();
                List output = ri.browseSearch(filter);
                results.addAll(output);
            }
            catch (ServiceException ex) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)ex));
            }
        }
        if (plre != null) {
            throw plre;
        }
        results = this.purgeBrowseResults(results);
        return results;
    }

    @Override
    public List browseSearchWithFilterArray(UserContextInterface user, Filter[] filters) throws ServiceException, RemoteException {
        PartialResultsException plre = null;
        List results = new ArrayList(8);
        Iterator reposIt = user.getRepositories().iterator();
        while (reposIt.hasNext()) {
            try {
                RepositoryInterface ri = (RepositoryInterface)reposIt.next();
                for (int i = 0; i < filters.length; ++i) {
                    List output = ri.browseSearch(filters[i]);
                    results.addAll(output);
                }
            }
            catch (ServiceException ex) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)ex));
            }
        }
        if (plre != null) {
            throw plre;
        }
        results = this.purgeBrowseResults(results);
        return results;
    }

    @Override
    public List browseSearchProtocols(UserContextInterface user, List protocols, Filter filter) throws ServiceException, RemoteException {
        PartialResultsException plre = null;
        List results = new ArrayList(8);
        Iterator reposIt = user.getRepositories().iterator();
        while (reposIt.hasNext()) {
            try {
                int index;
                RepositoryInterface ri = (RepositoryInterface)reposIt.next();
                String url = ri.getUrl();
                String protocol = url.substring(0, index = url.indexOf(TOKEN_SEPARATOR));
                if (!protocols.contains(protocol)) continue;
                List output = ri.browseSearch(filter);
                results.addAll(output);
            }
            catch (ServiceException ex) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)ex));
            }
        }
        if (plre != null) {
            throw plre;
        }
        results = this.purgeBrowseResults(results);
        return results;
    }

    @Override
    public List browseSearchProtocolsWithFilterArray(UserContextInterface user, List protocols, Filter[] filters) throws ServiceException, RemoteException {
        PartialResultsException plre = null;
        List results = new ArrayList(8);
        Iterator reposIt = user.getRepositories().iterator();
        while (reposIt.hasNext()) {
            try {
                int index;
                RepositoryInterface ri = (RepositoryInterface)reposIt.next();
                String url = ri.getUrl();
                String protocol = url.substring(0, index = url.indexOf(TOKEN_SEPARATOR));
                if (!protocols.contains(protocol)) continue;
                for (int i = 0; i < filters.length; ++i) {
                    List output = ri.browseSearch(filters[i]);
                    results.addAll(output);
                }
            }
            catch (ServiceException ex) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)ex));
            }
        }
        if (plre != null) {
            throw plre;
        }
        results = this.purgeBrowseResults(results);
        return results;
    }

    @Override
    public List browseSearchGroupName(UserContextInterface user, String groupName, Filter filter) throws ServiceException, RemoteException {
        UserContextInterface uci;
        PartialListResultsException plre = new PartialListResultsException(new ArrayList(8), "");
        List results = new ArrayList(8);
        RepositoryGroup group = this.getRepositoryGroup(groupName);
        if (group == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.nosuchgroup.ex.fmt.txt", (Object)groupName));
        }
        List<String> names = group.getGroupNames();
        Iterator<String> it = names.iterator();
        UserContextInterface localUser = user;
        if (user instanceof RemoteStub && (uci = this.getLocalUserContext(user)) != null) {
            localUser = uci;
        }
        while (it.hasNext()) {
            String nextrepos = it.next();
            RepositoryInterface ri = this.getRepository(localUser, nextrepos);
            if (ri == null && ri == null) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.grpnocnct.ex.fmt.txt", (Object)nextrepos))));
            }
            if (ri == null) continue;
            this.browseSearchRepos(ri, filter, results, plre);
        }
        if (plre.getExceptions().length > 0) {
            throw plre;
        }
        results = this.purgeBrowseResults(results);
        return results;
    }

    @Override
    public List browseSearchGroupNameWithFilterArray(UserContextInterface user, String groupName, Filter[] filters) throws ServiceException, RemoteException {
        UserContextInterface uci;
        PartialListResultsException plre = new PartialListResultsException(new ArrayList(8), "");
        List results = new ArrayList(8);
        RepositoryGroup group = this.getRepositoryGroup(groupName);
        if (group == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.nosuchgroup.ex.fmt.txt", (Object)groupName));
        }
        List<String> names = group.getGroupNames();
        Iterator<String> it = names.iterator();
        UserContextInterface localUser = user;
        if (user instanceof RemoteStub && (uci = this.getLocalUserContext(user)) != null) {
            localUser = uci;
        }
        while (it.hasNext()) {
            String nextrepos = it.next();
            RepositoryInterface ri = this.getRepository(localUser, nextrepos);
            if (ri == null && ri == null) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, "");
                }
                plre.addException((Throwable)((Object)new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.grpnocnct.ex.fmt.txt", (Object)nextrepos))));
            }
            if (ri == null) continue;
            this.browseSearchReposFilterArray(ri, filters, results, plre);
        }
        if (plre.getExceptions().length > 0) {
            throw plre;
        }
        results = this.purgeBrowseResults(results);
        return results;
    }

    private void browseSearchReposFilterArray(RepositoryInterface ri, FilterInterface[] filters, List results, PartialListResultsException plre) throws ServiceException, RemoteException {
        for (int i = 0; i < filters.length; ++i) {
            this.browseSearchRepos(ri, filters[i], results, plre);
        }
    }

    private void browseSearchRepos(RepositoryInterface ri, FilterInterface filter, List results, PartialListResultsException plre) throws ServiceException, RemoteException {
        try {
            List list = ri.browseSearch(filter);
            results.addAll(list);
        }
        catch (PartialListResultsException partial) {
            if (plre == null) {
                throw partial;
            }
            Throwable[] exceptions = partial.getExceptions();
            for (int i = 0; i < exceptions.length; ++i) {
                plre.addException(exceptions[i]);
            }
            List list = partial.getResults();
            results.addAll(list);
        }
        catch (ServiceException svcEx) {
            if (plre == null) {
                throw svcEx;
            }
            plre.addException((Throwable)((Object)svcEx));
        }
    }

    private List purgeBrowseResults(List searchResults) {
        ArrayList<BrowseMetadata> result = new ArrayList<BrowseMetadata>(searchResults.size());
        ArrayList<String> idList = new ArrayList<String>(searchResults.size());
        for (BrowseMetadata bmi : searchResults) {
            String id = bmi.getReposId();
            if (idList.contains(id)) continue;
            result.add(bmi);
            idList.add(id);
        }
        return result;
    }

    @Override
    public void connectAuto(UserContextInterface user) throws ServiceException, RemoteException {
        UserContextInterface uci;
        UserContextInterface localUser = user;
        if (user instanceof RemoteStub && (uci = this.getLocalUserContext(user)) != null) {
            localUser = uci;
        }
        AutoConnectException servExcept = null;
        for (ServerDef sd : this._serverDefs.values()) {
            if (!sd.getAuto()) continue;
            try {
                if (this.connect(localUser, sd) != null) continue;
                servExcept = new AutoConnectException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.autocnctfail.ex.fmt", (Object)sd));
            }
            catch (ServiceException ex) {
                servExcept = new AutoConnectException((Throwable)((Object)ex), ex.getMessage());
            }
        }
        Collection<RepositoryDef> defs = this._reposDefs.values();
        for (RepositoryDef rd : defs) {
            if (!"dav".equalsIgnoreCase(rd.getProtocol()) || !rd.getAuto()) continue;
            try {
                this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.autocnct.msg.fmt", localUser.getName(), rd);
                if (this.connect(localUser, rd) != null) continue;
                servExcept = new AutoConnectException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.autocnctfail.ex.fmt", (Object)rd));
            }
            catch (ServiceException svcex) {
                servExcept = new AutoConnectException((Throwable)((Object)svcex), Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.autocnctfail.ex.fmt", (Object)rd));
            }
        }
        if (servExcept != null) {
            throw servExcept;
        }
    }

    @Override
    public RepositoryInterface connectByName(UserContextInterface user, String name) throws ServiceException, RemoteException {
        try {
            RepositoryInterface ri = user.getRepository(name);
            if (ri != null) {
                return ri;
            }
        }
        catch (ServiceException ri) {
            // empty catch block
        }
        RepositoryDef rd = this._reposDefs.get(name.toUpperCase());
        if (rd == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.noreposdef.ex.fmt", (Object)name));
        }
        return this.connect(user, rd);
    }

    @Override
    public ServerInterface connect(UserContextInterface user, ServerDef serverDef) throws ServiceException, RemoteException {
        return this.connect(user, serverDef, null);
    }

    @Override
    public ServerInterface connect(UserContextInterface user, ServerDef serverDef, Cluster cluster) throws ServiceException, RemoteException {
        UserContextInterface localUser = this.getLocalUserContext(user);
        ServerDef defToUse = serverDef;
        for (ServerDef myDef : this._serverDefs.values()) {
            if (!serverDef.getHost().equalsIgnoreCase(myDef.getHost()) || !serverDef.getPort().equals(myDef.getPort()) || !serverDef.getDomain().equalsIgnoreCase(myDef.getDomain()) || !serverDef.getProtocol().equals(myDef.getProtocol())) continue;
            defToUse = myDef;
        }
        this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.cncnting.msg.fmt", localUser.getName(), serverDef);
        ServerInterface si = this.getUserServer(localUser, defToUse);
        if (si != null) {
            return si;
        }
        String protocol = defToUse.getProtocol();
        String serverClassName = this._repositories.get(protocol);
        if (serverClassName == null) {
            this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.noclsdef.ex.fmt", protocol);
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.noclsdef.ex.fmt", (Object)protocol));
        }
        try {
            return this.makeServer(localUser, serverClassName, defToUse, cluster);
        }
        catch (ClassCastException ex) {
            this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.notserver.ex.fmt.txt", (Object)protocol));
            throw ex;
        }
    }

    @Override
    public RepositoryInterface connect(UserContextInterface user, RepositoryDef reposDef) throws ServiceException, RemoteException {
        String protocol;
        String reposClassName;
        UserContextInterface localUser = this.getLocalUserContext(user);
        this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.cncnting.msg.fmt", localUser.getName(), reposDef);
        RepositoryInterface ri = this.getUserRepos(localUser, reposDef);
        if (ri != null) {
            return ri;
        }
        String domain = reposDef.getDomain();
        List idents = this.getIdents(localUser, domain);
        if (idents.size() == 0) {
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.nocred.ex.fmt", localUser.getName(), reposDef.getDomain());
        }
        if ((reposClassName = this._repositories.get(protocol = reposDef.getProtocol())) == null) {
            this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.noclsdef.ex.fmt", protocol);
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.noclsdef.ex.fmt", (Object)protocol));
        }
        return this.makeRepository(localUser, reposClassName, reposDef, idents);
    }

    private ServerInterface makeServer(UserContextInterface localUser, String serverClassName, ServerDef serverDef, Cluster cluster) throws ServiceException, RemoteException {
        ServerInterface result = null;
        if ("com.sas.services.information.OMIServer".equals(serverClassName)) {
            result = new OMIServer();
        }
        if (result == null) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> reposClass = cl.loadClass(serverClassName);
                Constructor<?> ctor = reposClass.getConstructor(null);
                if (ctor == null) {
                    this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.noctrdef.ex.fmt", serverClassName);
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.noctrdef.ex.fmt", (Object)serverClassName));
                }
                try {
                    result = (ServerInterface)ctor.newInstance(null);
                }
                catch (ClassCastException ex) {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.clsnotserver.ex.fmt.txt", (Object)serverClassName));
                    throw ex;
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServiceException(cnfe, Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.clsntfnd.ex.fmt", (Object)serverClassName));
            }
            catch (NoSuchMethodException nsme) {
                throw new ServiceException(nsme, Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.noctor.ex.fmt", (Object)serverClassName));
            }
            catch (IllegalAccessException e) {
                this.logMessage(Level.ERROR, RB.getStringResource("InformationService.repoexcpt.ex.txt"), e);
                throw new ServiceException(e, RB.getStringResource("InformationService.repoexcpt.ex.txt"));
            }
            catch (InvocationTargetException e) {
                this.logMessage(Level.ERROR, RB.getStringResource("InformationService.repoexcpt.ex.txt"), e);
                throw new ServiceException(e, RB.getStringResource("InformationService.repoexcpt.ex.txt"));
            }
            catch (InstantiationException e) {
                this.logMessage(Level.ERROR, RB.getStringResource("InformationService.repoexcpt.ex.txt"), e);
                throw new ServiceException(e, RB.getStringResource("InformationService.repoexcpt.ex.txt"));
            }
        }
        result.connect(serverDef, localUser, cluster);
        localUser.addServer(result);
        return result;
    }

    private RepositoryInterface makeRepository(UserContextInterface localUser, String reposClassName, RepositoryDef reposDef, List idents) throws ServiceException, RemoteException {
        Object cx = null;
        RepositoryInterface ri = null;
        String protocol = reposDef.getProtocol();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> reposClass = cl.loadClass(reposClassName);
            Class<?>[] rcXfaces = reposClass.getInterfaces();
            for (int i = 0; i < rcXfaces.length; ++i) {
                Class<?> c = rcXfaces[i];
                if (c != ServerInterface.class && c != MetadataServerInterface.class) continue;
                String sdName = reposDef.getHost();
                int index = sdName.indexOf(46);
                if (index > -1) {
                    sdName = sdName.substring(0, index);
                }
                ServerDef sd = new ServerDef(sdName, reposDef.getProtocol(), reposDef.getHost(), reposDef.getPort());
                sd.setDomain(reposDef.getDomain());
                ServerInterface si = this.getUserServer(localUser, sd);
                if (si != null) {
                    ri = si.getRepository(reposDef.getBase());
                    return ri;
                }
                for (ServerDef nextServer : this._serverDefs.values()) {
                    if (!nextServer.getProtocol().equalsIgnoreCase(reposDef.getProtocol()) || !nextServer.getHost().equalsIgnoreCase(reposDef.getHost()) || nextServer.getPort() != reposDef.getPort()) continue;
                    si = this.connect(localUser, nextServer);
                    ri = si.getRepository(reposDef.getBase());
                    ri.setISName(reposDef.getName());
                    return ri;
                }
                si = this.makeServer(localUser, reposClassName, sd, null);
                ri = si.getRepository(reposDef.getBase());
                return ri;
            }
            Constructor<?> ctor = reposClass.getConstructor(null);
            if (ctor == null) {
                this.logFormat(Level.DEBUG, INFOSVC_CONTEXT, RB.getResources(), "InformationService.noctrdef.ex.fmt", reposClassName);
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.noctrdef.ex.fmt", (Object)reposClassName));
            }
            ri = (RepositoryInterface)ctor.newInstance(null);
            ri.setUserContext(localUser);
            this.doDavProcess(protocol, idents);
            boolean result = false;
            result = this.tryConnect(ri, reposDef, idents);
            if (cx != null) {
                cx.close();
            }
            if (result) {
                if (idents.size() > 0) {
                    UserIdentityInterface uii = (UserIdentityInterface)idents.get(0);
                    ri.setDomain(uii.getDomain());
                } else {
                    ri.setDomain(reposDef.getDomain());
                }
                localUser.addRepository(ri);
                String reposName = reposDef.getName();
                if (reposName != null && reposName.length() > 0) {
                    ri.setISName(reposDef.getName());
                }
                ri.addListener(this._listener);
                this._reposMap.put(ri.getUniqueId(), ri);
                return ri;
            }
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.cnctfailed.msg.fmt", reposDef, localUser.getName());
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException(cnfe, Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.clsntfnd.ex.fmt", (Object)reposClassName));
        }
        catch (NoSuchMethodException nsme) {
            throw new ServiceException(nsme, Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.noctor.ex.fmt", (Object)reposClassName));
        }
        catch (IllegalAccessException e) {
            this.logMessage(Level.ERROR, RB.getStringResource("InformationService.repoexcpt.ex.txt"), e);
            throw new ServiceException(e, RB.getStringResource("InformationService.repoexcpt.ex.txt"));
        }
        catch (InvocationTargetException e) {
            this.logMessage(Level.ERROR, RB.getStringResource("InformationService.repoexcpt.ex.txt"), e);
            throw new ServiceException(e, RB.getStringResource("InformationService.repoexcpt.ex.txt"));
        }
        catch (InstantiationException e) {
            this.logMessage(Level.ERROR, RB.getStringResource("InformationService.repoexcpt.ex.txt"), e);
            throw new ServiceException(e, RB.getStringResource("InformationService.repoexcpt.ex.txt"));
        }
    }

    private boolean tryConnect(RepositoryInterface ri, RepositoryDef reposDef, List idents) throws ServiceException, RemoteException {
        boolean result = false;
        if (idents.size() != 0) {
            int identsSize = idents.size();
            for (int i = 0; i < identsSize; ++i) {
                UserIdentityInterface ident = (UserIdentityInterface)idents.get(i);
                String principal = (String)ident.getPrincipal();
                if (principal == null) {
                    principal = (String)ident.getPrincipal();
                }
                String credential = (String)ident.getCredential();
                try {
                    result = ri.connect(principal, credential, reposDef);
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                if (!result || ident == null) continue;
                ident.setAuthenticated(true);
                break;
            }
        } else {
            this.logFormat(Level.INFO, INFOSVC_CONTEXT, RB.getResources(), "InformationService.tryanon.msg.fmt.txt", reposDef.getDomain());
            result = ri.connect(null, null, reposDef);
        }
        return result;
    }

    private void doDavProcess(String protocol, List idents) {
        UserIdentityInterface priIdent;
        String priPrin;
        if ("dav".equalsIgnoreCase(protocol) && idents.size() > 1 && ((priPrin = (String)(priIdent = (UserIdentityInterface)idents.get(0)).getPrincipal()).indexOf(64) == -1 || priPrin.indexOf(92) == -1)) {
            int identsSize = idents.size();
            for (int j = 1; j < identsSize; ++j) {
                UserIdentityInterface dIdent = (UserIdentityInterface)idents.get(j);
                String dPrin = (String)dIdent.getPrincipal();
                if (!dPrin.toLowerCase().startsWith(priPrin.toLowerCase() + "@") && !dPrin.toLowerCase().endsWith("\\" + priPrin.toLowerCase())) continue;
                String principal = dPrin;
                String credential = (String)priIdent.getCredential();
                String domain = priIdent.getDomain();
                idents.clear();
                idents.add(new SimpleUserIdentity(principal, credential, domain));
                break;
            }
        }
    }

    private RepositoryInterface getUserRepos(UserContextInterface localUser, RepositoryDef reposDef) throws ServiceException, RemoteException {
        RepositoryInterface result = null;
        for (RepositoryInterface rep : localUser.getRepositories()) {
            if (!rep.isEqual(reposDef)) continue;
            this.logMessage(Level.DEBUG, RB.getStringResource("InformationService.alrdycnct.msg.txt"));
            result = rep;
            break;
        }
        if (result == null) {
            String host = reposDef.getHost();
            String protocol = reposDef.getProtocol();
            int port = Integer.parseInt(reposDef.getPort());
            for (ServerInterface si : localUser.getServers()) {
                if (!si.getProtocol().equalsIgnoreCase(protocol) || !si.getHost().equalsIgnoreCase(host) || si.getPort() != port) continue;
                result = si.getRepository(reposDef.getBase());
                break;
            }
        }
        return result;
    }

    private ServerInterface getUserServer(UserContextInterface user, ServerDef serverDef) throws ServiceException, RemoteException {
        ServerInterface result = null;
        String defName = serverDef.getName();
        result = user.getServer(defName);
        if (result == null) {
            String protocol = serverDef.getProtocol();
            String host = serverDef.getHost();
            int port = Integer.parseInt(serverDef.getPort());
            for (ServerInterface si : user.getServers()) {
                if (!si.getProtocol().equalsIgnoreCase(protocol) || !si.getHost().equalsIgnoreCase(host) || si.getPort() != port) continue;
                result = si;
                break;
            }
        }
        return result;
    }

    private List getIdents(UserContextInterface localUser, String domain) throws ServiceException, RemoteException {
        if (domain == null) {
            return Collections.EMPTY_LIST;
        }
        if (localUser == null) {
            return Collections.EMPTY_LIST;
        }
        String primaryDomain = null;
        ServerInterface server = localUser.getAuthServer();
        primaryDomain = server.getDomain();
        PrivGetIdentities action = null;
        String rdomain = null;
        List idents = new ArrayList(4);
        Map domainMap = this.getAppLoginConfig();
        rdomain = (String)domainMap.get(domain);
        if (domain.equalsIgnoreCase(primaryDomain)) {
            action = new PrivGetIdentities(localUser, domain);
            try {
                idents = (List)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable t = pae.getCause();
                if (t instanceof RemoteException) {
                    throw (RemoteException)t;
                }
                if (t instanceof SecurityException) {
                    throw (SecurityException)t;
                }
                throw new ServiceException(t, t.getMessage());
            }
            return idents;
        }
        if (rdomain != null) {
            action = new PrivGetIdentities(localUser, rdomain);
            try {
                idents = (List)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                // empty catch block
            }
        }
        if (idents == null || idents.size() == 0) {
            rdomain = domain;
            action = new PrivGetIdentities(localUser, rdomain);
            try {
                idents = (List)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable t = pae.getCause();
                if (t instanceof RemoteException) {
                    throw (RemoteException)t;
                }
                if (t instanceof SecurityException) {
                    throw (SecurityException)t;
                }
                throw new ServiceException(t, "");
            }
        }
        if (idents == null) {
            idents = new ArrayList(0);
        }
        return idents;
    }

    @Override
    public boolean addRepositoryDef(RepositoryDef repositoryDef) throws RemoteException {
        boolean wasAdded = false;
        if (repositoryDef != null && this._reposDefs != null) {
            this._reposDefs.put(repositoryDef.getName().toUpperCase(), repositoryDef);
            wasAdded = true;
        }
        return wasAdded;
    }

    @Override
    public boolean removeRepositoryDef(RepositoryDef repositoryDef) throws RemoteException {
        boolean wasRemoved = false;
        if (repositoryDef != null && this._reposDefs != null) {
            RepositoryDef removedObj = this._reposDefs.remove(repositoryDef.getName().toUpperCase());
            wasRemoved = removedObj != null;
        }
        return wasRemoved;
    }

    @Override
    public void clearRepositoryDefs() {
        if (this._reposDefs != null) {
            this._reposDefs.clear();
        }
    }

    @Override
    public List getReposDefs() throws RemoteException {
        ArrayList<RepositoryDef> result = new ArrayList<RepositoryDef>(this._reposDefs.values());
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                RepositoryDef r1 = (RepositoryDef)o1;
                RepositoryDef r2 = (RepositoryDef)o2;
                int iresult = r1.getName().compareToIgnoreCase(r2.getName());
                if (iresult == 0) {
                    return r1.getName().compareTo(r2.getName());
                }
                return iresult;
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        return result;
    }

    @Override
    public boolean addServerDef(ServerDef serverDef) throws RemoteException {
        boolean wasAdded = false;
        if (serverDef != null && this._serverDefs != null) {
            this._serverDefs.put(serverDef.getName(), serverDef);
            wasAdded = true;
        }
        return wasAdded;
    }

    @Override
    public boolean removeServerDef(ServerDef serverDef) throws RemoteException {
        boolean wasRemoved = false;
        if (serverDef != null && this._serverDefs != null) {
            ServerDef removedObj = this._serverDefs.remove(serverDef.getName());
            wasRemoved = removedObj != null;
        }
        return wasRemoved;
    }

    @Override
    public void clearServerDefs() {
        if (this._serverDefs != null) {
            this._serverDefs.clear();
        }
    }

    @Override
    public List getServerDefs() throws RemoteException {
        ArrayList<ServerDef> result = new ArrayList<ServerDef>(this._serverDefs.values());
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                ServerDef r1 = (ServerDef)o1;
                ServerDef r2 = (ServerDef)o2;
                int iresult = r1.getName().compareToIgnoreCase(r2.getName());
                if (iresult == 0) {
                    return r1.getName().compareTo(r2.getName());
                }
                return iresult;
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        return result;
    }

    @Override
    public List getRepositoryGroups() throws ServiceException, RemoteException {
        return new ArrayList<RepositoryGroup>(this._reposGroups.values());
    }

    @Override
    public RepositoryGroup getRepositoryGroup(String name) throws ServiceException, RemoteException {
        return this._reposGroups.get(name);
    }

    @Override
    public boolean addRepositoryGroup(RepositoryGroup group) throws ServiceException, RemoteException {
        if (group == null) {
            return false;
        }
        if (this._reposGroups.get(group.getName()) != null) {
            return false;
        }
        this._reposGroups.put(group.getName(), group);
        return true;
    }

    @Override
    public boolean removeRepositoryGroup(RepositoryGroup group) throws ServiceException, RemoteException {
        if (group == null) {
            return false;
        }
        if (this._reposGroups.get(group.getName()) == null) {
            return false;
        }
        this._reposGroups.remove(group.getName());
        return true;
    }

    @Override
    public void clearRepositoryGroups() throws ServiceException, RemoteException {
        this._reposGroups.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetadataChangeListener(MetadataChangeListener listener, String url) throws ServiceException, RemoteException {
        int index = url.indexOf("://");
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if ((index = url.indexOf(47, index + 3)) > 0) {
            url = url.substring(0, index);
        }
        this.listenersWriteLock.lock();
        try {
            CopyOnWriteArrayList<MetadataChangeListener> listenerList = this._listeners.get(url);
            if (listenerList == null) {
                listenerList = new CopyOnWriteArrayList<MetadataChangeListener>();
                this._listeners.put(url, listenerList);
            }
            listenerList.add(listener);
        }
        finally {
            this.listenersWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadataChangeListener(MetadataChangeListener listener, String url) throws RemoteException {
        int index = url.indexOf("://");
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if ((index = url.indexOf(47, index + 3)) > 0) {
            url = url.substring(0, index);
        }
        this.listenersWriteLock.lock();
        try {
            List listenerList = this._listeners.get(url);
            if (listenerList == null) {
                return;
            }
            listenerList.remove(listener);
        }
        finally {
            this.listenersWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void metadataChange(MetadataChangeEvent event) throws RemoteException {
        String url = event.getUrl();
        int index = url.indexOf("://");
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if ((index = url.indexOf(47, index + 3)) > 0) {
            url = url.substring(0, index);
        }
        this.listenersReadLock.lock();
        try {
            List listenerList = this._listeners.get(url);
            if (listenerList == null) {
                return;
            }
            for (MetadataChangeListener mcl : listenerList) {
                mcl.metadataChange(event);
            }
        }
        finally {
            this.listenersReadLock.unlock();
        }
    }

    @Override
    public final RemoteServiceInterface getServiceProxy() {
        InformationServiceProxy proxy = null;
        try {
            proxy = new InformationServiceProxy(_service);
        }
        catch (InitializationException e) {
            proxy = null;
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAuthorized(UserContextInterface superUser, IdentityInterface plainUser, MetadataInterface objectToCheck, String permission) throws ServiceException, RemoteException {
        RepositoryInterface reposI = objectToCheck.getRepository();
        if (reposI instanceof OMIRepositoryInterface) {
            OMIRepositoryInterface omiReposI = (OMIRepositoryInterface)reposI;
            String reposName = omiReposI.getISName();
            OMIRepositoryInterface privOmi = (OMIRepositoryInterface)superUser.getRepository(reposName);
            if (privOmi == null) {
                privOmi = (OMIRepositoryInterface)this.connectByName(superUser, reposName);
            }
            if (privOmi == null) {
                throw new ServiceException(RB.getStringResource("OMIRepository.noprivcnxn.ex.txt"));
            }
            List loginList = plainUser.getLogins();
            String subject = null;
            if (loginList != null && loginList.size() > 0) {
                LoginInterface login = (LoginInterface)loginList.get(0);
                subject = login.getUserId();
            }
            if (subject == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.nologinsforuser.ex.fmt.txt", (Object)plainUser.getRepositoryEntity().toString()));
            }
            String credHandle = privOmi.getCredentials(subject);
            boolean result = false;
            try {
                String resource = "OMSOBJ:" + ((Root)objectToCheck.getRepositoryEntity()).getCMetadataType() + '/' + objectToCheck.getReposId();
                result = privOmi.isAuthorized(credHandle, resource, permission);
            }
            finally {
                privOmi.freeCredentials(credHandle);
            }
            return result;
        }
        return false;
    }

    @Override
    public String getReposKey(String entityKey) throws ServiceException, RemoteException {
        int index = entityKey.indexOf("+");
        if (index < 0) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.badkey.ex.fmt", (Object)entityKey));
        }
        String entityUrl = entityKey.substring(index + 1);
        if (entityUrl.startsWith("omi:")) {
            index = entityUrl.lastIndexOf("/");
            if (index < 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.badkey.ex.fmt", (Object)entityKey));
            }
            String result = entityUrl.substring(index + 1);
            return result;
        }
        if (entityUrl.startsWith("ldap:") || entityUrl.startsWith("LDAP:")) {
            entityUrl = entityUrl.substring(7);
            index = entityUrl.indexOf("/");
            entityUrl = entityUrl.substring(index + 1);
            return entityUrl;
        }
        if (entityUrl.startsWith("dav:") || entityUrl.startsWith("DAV:")) {
            entityUrl = entityUrl.substring(6);
            index = entityUrl.indexOf("/");
            entityUrl = entityUrl.substring(index + 1);
            return entityUrl;
        }
        return "";
    }

    @Override
    public void addInformationServiceTimerClient(InformationServiceTimerClient client) throws ServiceException, RemoteException {
        if (this._timerClients == null) {
            return;
        }
        this._timerClients.add(client);
    }

    @Override
    public void removeInformationServiceTimerClient(InformationServiceTimerClient client) throws ServiceException, RemoteException {
        if (this._timerClients == null) {
            return;
        }
        this._timerClients.remove(client);
    }

    @Override
    public void setIsolated() throws RemoteException {
        this._isIsolated = true;
    }

    @Override
    public boolean isIsolated() throws RemoteException {
        return this._isIsolated;
    }

    private final RepositoryInterface getRepository(UserContextInterface user, String reposName) throws ServiceException, RemoteException {
        RepositoryInterface ri = user.getRepository(reposName);
        if (ri == null) {
            try {
                ri = this.connectByName(user, reposName);
            }
            catch (ServiceException ex) {
                ri = null;
            }
        }
        return ri;
    }

    private final RepositoryInterface getLocalRepository(RepositoryInterface repos) {
        if (!(repos instanceof RemoteStub)) {
            return repos;
        }
        RepositoryInterface localRepos = repos;
        try {
            UserContextInterface user = repos.getUserContext();
            user = this.getLocalUserContext(user);
            String name = repos.getISName();
            RepositoryInterface myrepos = user.getRepository(name);
            if (myrepos != null) {
                localRepos = myrepos;
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return localRepos;
    }

    private final UserContextInterface getLocalUserContext(final UserContextInterface remoteUserContext) {
        UserContextInterface userContext = null;
        if (!(remoteUserContext instanceof RemoteStub)) {
            return remoteUserContext;
        }
        try {
            ServiceTemplate serviceTemplate = new ServiceTemplate(new Class[]{UserServiceInterface.class}, null);
            final UserServiceInterface userService = (UserServiceInterface)DiscoveryService.defaultInstance().findService(serviceTemplate);
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return userService.getUser(remoteUserContext, remoteUserContext.getUniqueId());
                }
            };
            try {
                UserContextInterface userContextFromUserService = (UserContextInterface)AccessController.doPrivileged(action);
                if (!(userContextFromUserService instanceof RemoteStub)) {
                    userContext = userContextFromUserService;
                }
            }
            catch (PrivilegedActionException pae) {
                Throwable t = pae.getCause();
                if (t instanceof RemoteException) {
                    throw (RemoteException)t;
                }
            }
        }
        catch (RemoteException e) {
            userContext = null;
        }
        catch (ServiceException e) {
            userContext = null;
        }
        return userContext == null ? remoteUserContext : userContext;
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0) throws RemoteException {
        if (this._logger != null && this._logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0);
            this.logMessage(level, message, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0, Object arg1) throws RemoteException {
        if (this._logger != null && this._logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0, (Object)arg1);
            this.logMessage(level, message, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0, Object arg1, Object arg2) throws RemoteException {
        if (this._logger != null && this._logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0, (Object)arg1, (Object)arg2);
            this.logMessage(level, message, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, Object arg0, Object arg1, Object arg2, Object arg3) throws RemoteException {
        if (this._logger != null && this._logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (Object)arg0, (Object)arg1, (Object)arg2, (Object)arg3);
            this.logMessage(level, message, null);
        }
    }

    public void logMessage(Level level, String message) throws RemoteException {
        if (this._logger != null && this._logger.isEnabled(level)) {
            this.logMessage(level, message, null);
        }
    }

    public void logMessage(Level level, String message, Throwable t) throws RemoteException {
        if (this._logger != null && this._logger.isEnabled(level)) {
            if (t == null) {
                this._logger.log(level, message);
            } else {
                this._logger.log(level, message, t);
            }
        }
    }

    @Override
    public Map getSmartObjectDefinitions() throws RemoteException {
        HashMap<String, SmartDef> map = new HashMap<String, SmartDef>(this._smartDefs);
        return map;
    }

    @Override
    public MetadataInterface getObjectByPath(UserContextInterface user, PathUrl path) throws ServiceException, RemoteException {
        UserContextInterface localUser = this.getLocalUserContext(user);
        ServerInterface server = this.getServerForPath(localUser, path);
        if (server != null) {
            return server.getObjectByPath(path);
        }
        RepositoryInterface ri = user.getRepository(path.getRepository());
        if (ri != null) {
            return ri.getObjectByPath(path);
        }
        return null;
    }

    @Override
    public ServerInterface getServerForPath(UserContextInterface user, PathUrl path) throws ServiceException, RemoteException {
        String servername = path.getRepository();
        ServerInterface server = user.getServer(servername);
        if (server != null) {
            return server;
        }
        List serverList = user.getServers();
        if (serverList.size() == 1) {
            server = (ServerInterface)serverList.get(0);
            List reposList = server.getRepositories(true);
            for (RepositoryInterface repository : reposList) {
                if (!repository.getISName().equals(servername)) continue;
                return server;
            }
        }
        if (serverList.size() > 1) {
            Iterator it = serverList.iterator();
            RepositoryInterface repos = null;
            while (it.hasNext()) {
                server = (ServerInterface)it.next();
                List reposList = server.getRepositories(true);
                for (RepositoryInterface myrepos : reposList) {
                    if (!myrepos.getISName().equals(servername)) continue;
                    if (repos == null) {
                        repos = myrepos;
                        continue;
                    }
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.ambigpath.ex.fmt.txt", (Object)path.toString()));
                }
            }
            if (repos != null) {
                server = repos.getServer();
                if (server != null) {
                    return server;
                }
            } else {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationService.ambigpath.ex.fmt.txt", (Object)path.toString()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTypeMap(String serverUrl, Map typeMap) throws RemoteException {
        if (!this._cacheTypeDefs) {
            return;
        }
        Map<String, Map<String, TypeDescriptorInterface>> map = this._typeMapMap;
        synchronized (map) {
            this._typeMapMap.put(serverUrl, typeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getTypeMap(String serverUrl) throws RemoteException {
        Map<String, Map<String, TypeDescriptorInterface>> map = this._typeMapMap;
        synchronized (map) {
            return this._typeMapMap.get(serverUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void addExplicitIdentityGroupsMap(String serverUrl, Map _explicitIdentityGroupsMap) throws RemoteException {
        if (!this._cacheExplicitIdentityGroups) {
            return;
        }
        Map<String, Map<String, IdentityGroupInterface>> map = this._explicitIdentityGroupsMapMap;
        synchronized (map) {
            this._explicitIdentityGroupsMapMap.put(serverUrl, _explicitIdentityGroupsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Map getExplicitIdentityGroupsMap(String serverUrl) throws RemoteException {
        Map<String, Map<String, IdentityGroupInterface>> map = this._explicitIdentityGroupsMapMap;
        synchronized (map) {
            return this._explicitIdentityGroupsMapMap.get(serverUrl);
        }
    }

    @SASScope
    private class InformationServiceTimer
    extends TimerTask {
        private InformationServiceTimer() {
        }

        @Override
        public void run() {
            if (InformationService.this._timerClients == null) {
                return;
            }
            ArrayList temp = null;
            temp = new ArrayList(InformationService.this._timerClients);
            Iterator it = temp.iterator();
            try {
                while (it.hasNext()) {
                    InformationServiceTimerClient istc = (InformationServiceTimerClient)it.next();
                    istc.runInformationServiceTimer();
                }
            }
            catch (RemoteException t) {
                try {
                    InformationService.this.logMessage(Level.DEBUG, RB.getStringResource("InformationService.timer.ex.txt"));
                }
                catch (RemoteException rex) {
                    System.out.println(RB.getStringResource("InformationService.timer.ex.txt"));
                }
            }
        }
    }

    @SASScope
    private class EventListener
    implements RepositoryListenerInterface {
        private EventListener() {
        }

        @Override
        public void repositoryCallback(RepositoryEvent event) throws RemoteException {
            if (event.getEvent() == 3) {
                RepositoryInterface ri = event.getRepository();
                InformationService.this._reposMap.remove(ri.getUniqueId());
            }
        }
    }

    @SASScope
    private class PrivGetIdentities
    implements PrivilegedExceptionAction {
        private UserContextInterface _user;
        private String _domain;

        PrivGetIdentities(UserContextInterface user, String domain) {
            this._user = user;
            this._domain = domain;
        }

        public Object run() throws Exception {
            List list = null;
            if (this._domain != null) {
                list = this._user.getIdentitiesByDomain(this._domain, false, "");
                if (list == null) {
                    list = new ArrayList(0);
                }
            } else {
                list = this._user.getIdentities();
            }
            return list;
        }
    }
}

