/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.antlr.RecognitionException;
import com.sas.antlr.TokenStreamException;
import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.information.RB;
import com.sas.services.information.rules.ExpressionLexer;
import com.sas.services.information.rules.ExpressionParser;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class FactoryAction
implements Cloneable,
Comparator<FactoryAction>,
ConsumedResourceInterface,
Serializable {
    private static final long serialVersionUID = 1488037376721216715L;
    static final String XML_ELEMENT_FACTORY_NAME = "Type";
    static final String XML_ATTRIBUTE_FACTORY_ACTION = "action";
    static final String XML_ATTRIBUTE_FACTORY_FILTER = "filter";
    static final String XML_ATTRIBUTE_FACTORY_PROTOCOL = "protocol";
    static final String XML_ATTRIBUTE_FACTORY_TYPE = "type";
    static final String XML_ATTRIBUTE_UID = "uid";
    public static final String TYPE_CLASS = "class";
    public static final String TYPE_CONSTRUCTOR = "ctor";
    public static final String TYPE_SERVICE = "service";
    private static final String[][] VALID_TYPES = new String[][]{{"class", RB.getStringResource("FactoryAction.factoryTypeClass.txt")}, {"ctor", RB.getStringResource("FactoryAction.factoryTypeConstructor.txt")}, {"service", RB.getStringResource("FactoryAction.factoryTypeService.txt")}};
    private static final int COL_TYPE = 0;
    private static final String TOKEN_DELIMITER = "::";
    private static final int PRIME_NUMBER = 31;
    private String _filter;
    private String _actionType;
    private String _actionClassName;
    private String _actionMethodName;
    private String _id = GUID.newGUID();

    public FactoryAction() {
        this(TYPE_CLASS, null);
    }

    public FactoryAction(String action, String filter) {
        this._filter = filter;
        this.setAction(action);
    }

    public FactoryAction(String uid, String action, String filter) {
        this(action, filter);
        this.setID(uid);
    }

    public FactoryAction(String actionType, String actionClassName, String actionMethodName, String filter) {
        this(null, actionType, actionClassName, actionMethodName, filter);
    }

    public FactoryAction(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (!XML_ELEMENT_FACTORY_NAME.equalsIgnoreCase(element.getNodeName())) {
            throw new IllegalArgumentException();
        }
        this.setID(element.getAttribute(XML_ATTRIBUTE_UID));
        this.setFilter(element.getAttribute(XML_ATTRIBUTE_FACTORY_FILTER));
        this.setAction(element.getAttribute(XML_ATTRIBUTE_FACTORY_ACTION));
    }

    public FactoryAction(String uid, String actionType, String actionClassName, String actionMethodName, String filter) {
        this.setID(uid);
        this._actionClassName = actionClassName;
        this._actionMethodName = actionMethodName;
        this._actionType = actionType;
        this._filter = filter;
    }

    private void setID(String uid) {
        if (uid != null && uid.length() > 0) {
            this._id = uid;
        }
    }

    public String getID() {
        return this._id;
    }

    public String getAction() {
        StringBuilder actionBuffer = new StringBuilder(this._actionType);
        actionBuffer.append(TOKEN_DELIMITER);
        actionBuffer.append(this._actionClassName);
        if (this._actionMethodName != null && this._actionMethodName.trim().length() > 0) {
            actionBuffer.append(TOKEN_DELIMITER);
            actionBuffer.append(this._actionMethodName);
        }
        return actionBuffer.toString();
    }

    public void setAction(String action) {
        this.tokenizeAction(action);
    }

    public void setAction(String actionType, String actionClassName, String actionMethodName, String actionFilter) throws IllegalArgumentException {
        this.setActionType(actionType);
        this.setActionClassName(actionClassName);
        this.setActionMethodName(actionMethodName);
        this.setFilter(actionFilter);
    }

    public void setFilter(String filter) {
        this._filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String filter, boolean isValidating) throws ServiceException {
        block9: {
            if (filter != null && filter.trim().length() > 0 && isValidating) {
                StringReader input = null;
                Throwable exception = null;
                try {
                    input = new StringReader(filter);
                    new ExpressionParser(new ExpressionLexer(input)).expression();
                }
                catch (RecognitionException ex) {
                    exception = ex;
                }
                catch (TokenStreamException ex) {
                    exception = ex;
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                    if (exception == null) break block9;
                    throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidFilter.ex.fmt.txt", (Object)filter));
                }
            }
        }
        this.setFilter(filter);
    }

    public String getFilter() {
        return this._filter == null ? "" : this._filter;
    }

    @Override
    public int compare(FactoryAction o1, FactoryAction o2) {
        int rv = 0;
        if (null != o1 && null != o2) {
            rv = o1.getFilter().trim().length() == 0 ? 1 : (o2.getFilter().trim().length() == 0 ? -1 : o2.getFilter().compareTo(o1.getFilter()));
        }
        return rv;
    }

    private void tokenizeAction(String action) {
        if (action != null) {
            this._actionType = "";
            this._actionClassName = "";
            this._actionMethodName = "";
            StringTokenizer tokenizer = new StringTokenizer(action, TOKEN_DELIMITER);
            if (tokenizer.hasMoreTokens()) {
                this._actionType = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    this._actionClassName = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        this._actionMethodName = tokenizer.nextToken();
                    }
                }
            }
        }
    }

    public String getActionType() {
        return this._actionType;
    }

    public String getActionClassName() {
        return this._actionClassName;
    }

    public void setActionType(String actionType) throws IllegalArgumentException {
        if (actionType == null || !FactoryAction.isValidType(actionType)) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidType.ex.fmt.txt", (Object)actionType));
        }
        this._actionType = actionType;
        if (!FactoryAction.isMethodEnabled(actionType)) {
            this.setActionMethodName("");
        }
    }

    public void setActionClassName(String actionClassName) {
        if (actionClassName == null || actionClassName.trim().length() == 0) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidClassName.ex.fmt.txt", (Object)actionClassName));
        }
        this._actionClassName = actionClassName;
    }

    public void validate() throws IllegalArgumentException {
        String msg = null;
        if (!FactoryAction.isValidType(this._actionType)) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidType.ex.fmt.txt", (Object)this._actionType);
        } else if (!this.isValidClassName()) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidClassName.ex.fmt.txt", (Object)this._actionClassName);
        } else if (!this.isValidMethodName()) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidMethodName.ex.fmt.txt", (Object)this._actionMethodName);
        } else if (!this.isValidFilter()) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidFilter.ex.fmt.txt", (Object)this._filter);
        }
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private boolean isValidClassName() {
        return this._actionClassName != null && this._actionClassName.trim().length() > 0;
    }

    private boolean isValidMethodName() {
        boolean isValid = true;
        boolean isMethodRequired = FactoryAction.isMethodEnabled(this._actionType);
        if (isMethodRequired) {
            if (this._actionMethodName == null || this._actionMethodName.trim().length() == 0) {
                isValid = false;
            }
        } else if (this._actionMethodName != null && this._actionMethodName.trim().length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean isValidFilter() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setActionMethodName(String actionMethodName) throws IllegalArgumentException {
        boolean isMethodRequired = FactoryAction.isMethodEnabled(this._actionType);
        if (isMethodRequired) {
            if (actionMethodName == null) throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidMethodName.ex.fmt.txt", (Object)""));
            String methodName = actionMethodName.trim();
            if (methodName.length() <= 0) throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.invalidMethodName.ex.fmt.txt", (Object)actionMethodName));
            this._actionMethodName = methodName;
            return;
        } else {
            this._actionMethodName = "";
        }
    }

    public String getActionMethodName() {
        return this._actionMethodName == null ? "" : this._actionMethodName;
    }

    public static boolean isValidType(String type) {
        boolean isValid = false;
        int numValidTypes = VALID_TYPES.length;
        for (int i = 0; i < numValidTypes; ++i) {
            if (!Strings.equal((String)VALID_TYPES[i][0], (String)type, (boolean)false, (boolean)false)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public static boolean isMethodEnabled(String type) {
        return Strings.equal((String)TYPE_CLASS, (String)type, (boolean)false, (boolean)false) || Strings.equal((String)TYPE_SERVICE, (String)type, (boolean)false, (boolean)false);
    }

    @Override
    public boolean equals(Object otherAction) {
        boolean isEqual = false;
        try {
            if (otherAction == this) {
                isEqual = true;
            } else if (otherAction == null) {
                isEqual = false;
            } else {
                FactoryAction otherFactoryAction = (FactoryAction)otherAction;
                if (Strings.equal((String)this.getActionClassName(), (String)otherFactoryAction.getActionClassName(), (boolean)false, (boolean)false) && Strings.equal((String)this.getActionMethodName(), (String)otherFactoryAction.getActionMethodName(), (boolean)false, (boolean)false) && Strings.equal((String)this.getActionType(), (String)otherFactoryAction.getActionType(), (boolean)false, (boolean)false) && Strings.equal((String)this.getFilter(), (String)otherFactoryAction.getFilter(), (boolean)false, (boolean)false)) {
                    isEqual = true;
                }
            }
        }
        catch (ClassCastException e) {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 31;
        if (this._actionClassName != null) {
            hashCode ^= this._actionClassName.hashCode();
        }
        if (this._actionMethodName != null) {
            hashCode ^= this._actionMethodName.hashCode();
        }
        if (this._actionType != null) {
            hashCode ^= this._actionType.hashCode();
        }
        if (this._filter != null) {
            hashCode ^= this._filter.hashCode();
        }
        return hashCode;
    }

    public static String[][] getValidActionTypes() {
        return (String[][])VALID_TYPES.clone();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static Element createXMLElementFactory(Document document, String protocol, String type, FactoryAction factoryAction) throws IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        if (protocol == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (factoryAction == null) {
            throw new IllegalArgumentException();
        }
        Element elementFactory = document.createElement(XML_ELEMENT_FACTORY_NAME);
        elementFactory.setAttribute(XML_ATTRIBUTE_UID, factoryAction.getID());
        elementFactory.setAttribute(XML_ATTRIBUTE_FACTORY_PROTOCOL, protocol);
        elementFactory.setAttribute(XML_ATTRIBUTE_FACTORY_TYPE, type);
        elementFactory.setAttribute(XML_ATTRIBUTE_FACTORY_ACTION, factoryAction.getAction());
        String filter = factoryAction.getFilter();
        if (filter != null) {
            elementFactory.setAttribute(XML_ATTRIBUTE_FACTORY_FILTER, filter);
        }
        return elementFactory;
    }

    boolean hasConflict(FactoryAction other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else if (other != null) {
            String otherClassName = other.getActionClassName();
            String otherMethodName = other.getActionMethodName();
            String otherType = other.getActionType();
            String otherFilter = other.getFilter();
            String thisClassName = this.getActionClassName();
            String thisMethodName = this.getActionMethodName();
            String thisType = this.getActionType();
            String thisFilter = this.getFilter();
            isEqual = !(otherClassName != null && !"".equals(otherClassName) && thisClassName != null && !Strings.equal((String)otherClassName, (String)thisClassName, (boolean)false, (boolean)false) || otherType != null && !"".equals(otherType) && thisType != null && !Strings.equal((String)otherType, (String)thisType, (boolean)false, (boolean)false) || otherFilter != null && !"".equals(otherFilter) && thisFilter != null && !Strings.equal((String)otherFilter, (String)thisFilter, (boolean)false, (boolean)false) || otherMethodName != null && !"".equals(otherMethodName) && thisMethodName != null && !Strings.equal((String)otherMethodName, (String)thisMethodName, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(FactoryAction factoryAction) throws ServiceConfigurationException {
        if (factoryAction != null) {
            String value = factoryAction.getActionClassName();
            if (value != null) {
                this.setActionClassName(value);
            }
            if ((value = factoryAction.getActionMethodName()) != null) {
                this.setActionMethodName(value);
            }
            if ((value = factoryAction.getActionType()) != null) {
                this.setActionType(value);
            }
            if ((value = factoryAction.getFilter()) != null) {
                this.setFilter(value);
            }
        }
    }

    void replace(FactoryAction factoryAction) {
        if (factoryAction != null) {
            this.setActionClassName(factoryAction.getActionClassName());
            this.setActionMethodName(factoryAction.getActionMethodName());
            this.setActionType(factoryAction.getActionType());
            this.setFilter(factoryAction.getFilter());
        }
    }

    @Override
    public String getResourceID() {
        return this._id;
    }

    @Override
    public String getResourceValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._actionType);
        sb.append(TOKEN_DELIMITER);
        sb.append(this._actionClassName);
        if (TYPE_CLASS.equals(this._actionType) || TYPE_SERVICE.equals(this._actionType)) {
            sb.append(TOKEN_DELIMITER);
            sb.append(this._actionMethodName);
        }
        if (this._filter != null && this._filter.length() > 0) {
            sb.append(TOKEN_DELIMITER);
            sb.append(this._filter);
        }
        return sb.toString();
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("FactoryAction.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.factoryAction.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "FactoryAction";
    }

    @Override
    public int getResourceTypeCode() {
        return 0;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    public String toString() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"FactoryAction.toString.fmt.txt", (Object)this._id, (Object)this._actionType, (Object)this._actionClassName, (Object)this._actionMethodName, (Object)this._filter);
    }
}

