/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildRepositoryInterface;
import com.sas.services.information.DAVRepository;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.cache.RepositoryCache;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.dav.DAVEntity;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.webdav.ConnectionInfo;
import java.rmi.RemoteException;
import java.util.List;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVChildRepository
extends DAVRepository
implements ChildRepositoryInterface,
DAVRepositoryInterface {
    private RepositoryCache _parentCache;
    private DAVRepositoryInterface _parent;

    public DAVChildRepository(ConnectionInfo _hostInfo, RepositoryCache parentCache, String name, DAVRepositoryInterface parent) throws RemoteException {
        this(_hostInfo, parentCache, name, parent, DAVChildRepository.class);
    }

    private DAVChildRepository(ConnectionInfo _hostInfo, RepositoryCache parentCache, String name, DAVRepositoryInterface parent, Class theClass) throws RemoteException {
        super(theClass);
        this._parentCache = parentCache;
        this._parent = parent;
        this.setISName(name);
        this._DAVurl = parent.getUrl();
        this._url = parent.getHttpUrl();
        this.hostInfo = _hostInfo;
    }

    @Override
    public void commit() throws ServiceException, RemoteException {
        List itemList = this._cache.getCacheItems();
        for (MetadataInterface mi : itemList) {
            DAVEntity de = (DAVEntity)mi.getRepositoryEntity();
            MetadataInterface pmi = (MetadataInterface)this._parentCache.get(mi.getReposId());
            if (pmi != null) {
                DAVEntity pde = (DAVEntity)pmi.getRepositoryEntity();
                pde.refresh(de);
            } else {
                this._parentCache.put(mi);
            }
            if (this._parent instanceof ChildRepositoryInterface || !de.isUpdatePending()) continue;
            RepositoryData o = null;
            try {
                o = this.fetchRepositoryData(mi.getReposId());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (o == null) {
                this._parent.addEntity(mi);
                continue;
            }
            try {
                if (de.isDeleted()) {
                    this._parent.deleteEntity(mi);
                    continue;
                }
                de.update();
            }
            catch (Exception exception) {}
        }
        this.close();
    }

    @Override
    public void rollback() throws ServiceException, RemoteException {
        this.close();
    }

    @Override
    public void close() throws RemoteException {
        this._cache = null;
        this._isDestroyed = true;
    }

    @Override
    public void addEntity(MetadataInterface input) throws ServiceException, RemoteException {
        if (this._isDestroyed) {
            throw new ServiceException(RB.getStringResource("Repository.isdestroyed.ex.txt"));
        }
        Object o = input.getRepositoryEntity();
        if (!(o instanceof DAVEntityInterface)) {
            return;
        }
        this._cache.put(input);
    }

    public void updateEntity(MetadataInterface input) throws ServiceException, RemoteException {
        if (this._isDestroyed) {
            throw new ServiceException(RB.getStringResource("Repository.isdestroyed.ex.txt"));
        }
        Object o = input.getRepositoryEntity();
        if (!(o instanceof DAVEntity)) {
            return;
        }
    }

    @Override
    public void deleteEntity(MetadataInterface input) throws ServiceException, RemoteException {
        if (this._isDestroyed) {
            throw new ServiceException(RB.getStringResource("Repository.isdestroyed.ex.txt"));
        }
        Object o = input.getRepositoryEntity();
        if (!(o instanceof DAVEntity)) {
            return;
        }
        DAVEntity de = (DAVEntity)o;
        de.setDeleted();
    }
}

