/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.discovery.Passport;
import com.sas.services.discovery.PassportInterface;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.ServiceAttributeMatcher;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.discovery.ServiceTypes;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceTemplate
implements Serializable {
    private static final long serialVersionUID = 15811559635111311L;
    private ServiceTypes _serviceTypes;
    private ServiceAttributeInterface[] _serviceAttributes;
    private PassportInterface _requestPassport;

    public ServiceTemplate() throws InitializationException {
        ServiceTypes serviceTypes = new ServiceTypes();
        this.defineServiceTemplate(serviceTypes, null, false);
    }

    public ServiceTemplate(Class[] serviceTypeClasses) throws InitializationException {
        this(serviceTypeClasses, null);
    }

    public ServiceTemplate(Class[] serviceTypeClasses, ServiceAttributeInterface[] serviceAttributes) throws InitializationException {
        this.defineServiceTemplate(serviceTypeClasses, serviceAttributes, false);
    }

    public final void defineServiceTemplate(Class[] serviceTypeClasses, ServiceAttributeInterface[] serviceAttributes) throws InitializationException {
        this.defineServiceTemplate(serviceTypeClasses, serviceAttributes, true);
    }

    private final void defineServiceTemplate(Class[] serviceTypeClasses, ServiceAttributeInterface[] serviceAttributes, boolean isClearingPassport) throws InitializationException {
        ServiceTypes serviceTypes = new ServiceTypes(serviceTypeClasses);
        this.defineServiceTemplate(serviceTypes, serviceAttributes, isClearingPassport);
    }

    private final void defineServiceTemplate(ServiceTypes serviceTypes, ServiceAttributeInterface[] serviceAttributes, boolean isClearingPassport) {
        this._serviceTypes = serviceTypes;
        this._serviceAttributes = serviceAttributes;
        if (isClearingPassport) {
            this.clearPassport();
        }
    }

    public final ServiceTypes getServiceTypes() {
        return this._serviceTypes;
    }

    public final ServiceAttributeInterface[] getServiceAttributes() {
        int numItems = this._serviceAttributes != null ? this._serviceAttributes.length : 0;
        ServiceAttributeInterface[] serviceAttributes = new ServiceAttributeInterface[numItems];
        if (numItems > 0) {
            System.arraycopy(this._serviceAttributes, 0, serviceAttributes, 0, numItems);
        }
        return serviceAttributes;
    }

    public final boolean isSatisfiedBy(RemoteServiceInterface service) {
        boolean isSatisfied = true;
        try {
            if (this._serviceTypes != null && service != null) {
                if (this._serviceTypes.areSatisfiedBy(service)) {
                    ServiceConfigurationInterface config;
                    ServiceAttributeInterface[] requiredServiceAttributes = this.getServiceAttributes();
                    if (requiredServiceAttributes != null && requiredServiceAttributes.length > 0 && (config = service.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY)) instanceof ServiceDiscoveryConfigurationInterface) {
                        ServiceDiscoveryConfigurationInterface sdci = (ServiceDiscoveryConfigurationInterface)((Object)config);
                        isSatisfied = ServiceAttributeMatcher.matches(requiredServiceAttributes, sdci.getServiceAttributes());
                    }
                } else {
                    isSatisfied = false;
                }
            } else {
                isSatisfied = false;
            }
        }
        catch (RemoteException e) {
            isSatisfied = false;
        }
        return isSatisfied;
    }

    public final boolean isOkToProcess(String discoveryServiceId, boolean stampPassport) {
        boolean containsId = false;
        PassportInterface requestPassport = this.getRequestPassport();
        if (requestPassport != null) {
            containsId = requestPassport.containsId(discoveryServiceId, stampPassport);
        }
        return containsId;
    }

    public final void clearPassport() {
        PassportInterface passport = this.getRequestPassport();
        if (passport != null) {
            passport.clear();
        }
    }

    private final PassportInterface getRequestPassport() {
        if (this._requestPassport == null) {
            this._requestPassport = new Passport();
        }
        return this._requestPassport;
    }

    public final String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        StringBuilder sb = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceTemplate.serviceTemplate.fmt.txt", (Object)lineSeparator, (Object)lineSeparator));
        ServiceTypes serviceTypes = this.getServiceTypes();
        if (serviceTypes != null) {
            sb.append(serviceTypes.toString());
        }
        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceTemplate.attributes.fmt.txt", (Object)lineSeparator, (Object)lineSeparator));
        ServiceAttributeInterface[] serviceAttributes = this.getServiceAttributes();
        if (serviceAttributes != null && serviceAttributes.length > 0) {
            int numAttributes = serviceAttributes.length;
            ServiceAttributeInterface serviceAttribute = null;
            for (int i = 0; i < numAttributes; ++i) {
                serviceAttribute = serviceAttributes[i];
                if (serviceAttribute == null) continue;
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceTemplate.serviceAttribute.fmt.txt", (Object)(i + 1), (Object)serviceAttribute, (Object)lineSeparator));
            }
        } else {
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceTemplate.noOptionalAttributesSpecified.fmt.txt", (Object)lineSeparator));
        }
        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceTemplate.closingBraceNewLineClosingBrace.fmt.txt", (Object)lineSeparator));
        return sb.toString();
    }
}

