/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.discovery.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceDeploymentAttribute
extends MetadataAttribute {
    private static final long serialVersionUID = 3545800983273026098L;

    public ServiceDeploymentAttribute() {
        this(null, null);
    }

    public ServiceDeploymentAttribute(String serviceDeploymentName, String serviceDeploymentId) {
        super(serviceDeploymentId, serviceDeploymentName, "SoftwareComponent", "ABC1234567890");
    }

    public ServiceDeploymentAttribute(SoftwareComponent serviceDeployment) throws IllegalArgumentException {
        this(null, null);
        try {
            if (serviceDeployment == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyNonNullValue.ex.fmt.txt", (Object)"SoftwareComponent"));
            }
            this.setAttributes(serviceDeployment.getFQID(), serviceDeployment.getName(), serviceDeployment.getClassIdentifier());
        }
        catch (RemoteException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    private void setAttributes(String serviceDeploymentId, String serviceDeploymentName, String serviceDeploymentClassIdentifier) throws IllegalArgumentException {
        ServiceDeploymentAttribute.validateClassIdentifier(serviceDeploymentClassIdentifier);
        this.id = serviceDeploymentId;
        this.name = serviceDeploymentName;
        this.classIdentifier = serviceDeploymentClassIdentifier;
    }

    private static void validateClassIdentifier(String classIdentifier) throws IllegalArgumentException {
        if (classIdentifier == null || !"ABC1234567890".equals(classIdentifier)) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyServiceDeployment.ex.fmt.txt", (Object)"SoftwareComponent", (Object)"ABC1234567890"));
        }
    }
}

