/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.discovery.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceComponentAttribute
extends MetadataAttribute {
    private static final long serialVersionUID = 3545800983273026098L;
    public String runtimeId;

    public ServiceComponentAttribute() {
        this(null, null, null);
    }

    public ServiceComponentAttribute(String attributeName, String attributeId) {
        this(attributeName, attributeId, null);
    }

    public ServiceComponentAttribute(String attributeName, String attributeId, String runtimeServiceId) {
        super(attributeId, attributeName, "ServiceComponent", "ABC1212121212");
        this.runtimeId = runtimeServiceId;
    }

    public ServiceComponentAttribute(ServiceComponent serviceComponent) throws IllegalArgumentException {
        this(null, null, null);
        try {
            if (serviceComponent == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyNonNullValue.ex.fmt.txt", (Object)"ServiceComponent"));
            }
            this.setAttributes(serviceComponent.getFQID(), serviceComponent.getName(), serviceComponent.getClassIdentifier());
        }
        catch (RemoteException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    private void setAttributes(String serviceComponentId, String serviceComponentName, String serviceComponentClassIdentifier) throws IllegalArgumentException {
        ServiceComponentAttribute.validateClassIdentifier(serviceComponentClassIdentifier);
        this.id = serviceComponentId;
        this.name = serviceComponentName;
        this.classIdentifier = serviceComponentClassIdentifier;
    }

    private static void validateClassIdentifier(String serviceComponentClassIdentifier) throws IllegalArgumentException {
        if (serviceComponentClassIdentifier == null || !"ABC1212121212".equals(serviceComponentClassIdentifier)) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyServiceComponent.ex.fmt.txt", (Object)"ServiceComponent", (Object)"ABC1212121212"));
        }
    }

    @Override
    public Map<String, String> getFieldNameToValueMap() {
        Map<String, String> map = super.getFieldNameToValueMap();
        map.put("runtimeId", this.runtimeId);
        return map;
    }
}

