/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.entities.GUID;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfiguration;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServicePermission;
import com.sas.services.ServiceState;
import com.sas.services.discovery.AbstractDiscoveryService;
import com.sas.services.discovery.DiscoveryAdminInterface;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.DiscoveryServiceMBean;
import com.sas.services.discovery.FindServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.LookupPolicyInterface;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.ServiceCreationTimeComparator;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.services.discovery.ServicesCache;
import com.sas.services.security.SecurityUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.JMXAgent;
import com.sas.services.util.JMXRegistration;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class DiscoveryService
extends AbstractDiscoveryService
implements LocalDiscoveryServiceInterface {
    private static transient ServiceCreationTimeComparator _serviceCreationTimeComparator = new ServiceCreationTimeComparator();
    private final List<FindServiceInterface> _discoveryDelegates = new ArrayList<FindServiceInterface>(5);
    private final transient List<FindServiceInterface> _serviceFinders = new ArrayList<FindServiceInterface>(5);
    private final ServicesCache _servicesCache = new ServicesCache();
    private static LocalDiscoveryServiceInterface _singletonDiscoveryService = null;
    private transient LookupPolicyInterface _lookupPolicy;
    private static final Object SYNC_OBJECT = new Object();
    private static JMXRegistration _mBeanJMXRegistration;
    private static final transient Logger LOGGER;

    public DiscoveryService() {
    }

    public DiscoveryService(Set<FindServiceInterface> discoveryDelegates) throws IllegalArgumentException {
        this();
        try {
            this.addDiscoveryDelegates(discoveryDelegates);
        }
        catch (ServiceException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    public DiscoveryService(Set<FindServiceInterface> discoveryDelegates, Set<RemoteServiceInterface> services) throws ServiceException {
        this();
        this.addDiscoveryDelegates(discoveryDelegates);
        this.addServices(services);
    }

    private void addServices(Set<RemoteServiceInterface> services) throws ServiceException {
        if (services != null && services.size() > 0) {
            for (RemoteServiceInterface service : services) {
                this.addService(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDiscoveryDelegates(Set<FindServiceInterface> discoveryDelegates) throws ServiceException {
        if (discoveryDelegates != null && discoveryDelegates.size() > 0) {
            List<FindServiceInterface> list = this._discoveryDelegates;
            synchronized (list) {
                try {
                    for (FindServiceInterface serviceFinder : discoveryDelegates) {
                        this.addDiscoveryDelegate(serviceFinder);
                    }
                }
                catch (RemoteException e) {
                    throw new ServiceException(e, RB.getStringResource("DiscoveryService.addDiscoveryDelegates.ex.txt"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LocalDiscoveryServiceInterface defaultInstance() {
        LocalDiscoveryServiceInterface localDiscoveryService = null;
        Object object = SYNC_OBJECT;
        synchronized (object) {
            localDiscoveryService = _singletonDiscoveryService;
            if (_singletonDiscoveryService == null) {
                DiscoveryService discoveryService = new DiscoveryService();
                _singletonDiscoveryService = discoveryService;
                DiscoveryService.registerMBean(discoveryService);
                Serializable ex = null;
                try {
                    _singletonDiscoveryService.configure(new ServiceConfiguration());
                    localDiscoveryService = _singletonDiscoveryService;
                }
                catch (ServiceException e) {
                    ex = e;
                }
                catch (RemoteException e) {
                    ex = e;
                }
                finally {
                    if (ex != null) {
                        _singletonDiscoveryService = null;
                        localDiscoveryService = null;
                    }
                }
            } else {
                try {
                    if (!ServiceState.isStateInitialized(_singletonDiscoveryService.getServiceState())) {
                        _singletonDiscoveryService.configure(new ServiceConfiguration());
                    }
                }
                catch (RemoteException e) {
                    localDiscoveryService = null;
                }
                catch (ServiceException e) {
                    localDiscoveryService = null;
                }
            }
        }
        return localDiscoveryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Services findServices(ServiceTemplate serviceTemplate, int maxNumMatches, Services discoveredServices) throws ServiceException, ServiceNotAvailableException, IllegalStateException, RemoteException {
        String serviceRequestId = GUID.newGUID();
        if (this._lookupPolicy != null) {
            this._lookupPolicy.serviceLookupInitiated(serviceRequestId);
        }
        Services services = null;
        try {
            services = this.findServices(serviceTemplate, maxNumMatches, discoveredServices, serviceRequestId, 0);
        }
        finally {
            if (this._lookupPolicy != null) {
                this._lookupPolicy.serviceLookupTerminated(serviceRequestId);
            }
        }
        return services;
    }

    public final Services findServices(ServiceTemplate serviceTemplate, int maxNumMatches, Services discoveredServices, String serviceRequestId, int attemptNumber) throws ServiceException, ServiceNotAvailableException, RemoteException {
        long startTime = System.currentTimeMillis();
        Services services = discoveredServices != null ? discoveredServices : new Services();
        try {
            boolean isDebugLogEnabled = LOGGER.isDebugEnabled();
            String discoveryServiceId = this.getEntityKey();
            if (!DiscoveryService.isOkToProcessRequest(discoveryServiceId, serviceTemplate)) {
                throw new ServiceNotAvailableException(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.processedServiceTemplate.fmt.txt", (Object)discoveryServiceId, (Object)serviceTemplate.toString()));
            }
            if (isDebugLogEnabled) {
                LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.findingServices.fmt.txt", (Object)maxNumMatches, (Object)serviceTemplate));
            }
            int origNumElements = services.size();
            this.findServicesInCache(serviceTemplate, services, maxNumMatches, origNumElements);
            if (isDebugLogEnabled) {
                LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.timeToProcessRequest.fmt.txt", (Object)(System.currentTimeMillis() - startTime)));
            }
            if (services.size() == 0) {
                throw new ServiceNotAvailableException(serviceTemplate);
            }
        }
        catch (ClassCastException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
        finally {
            int numAttempts = attemptNumber;
            if (this._lookupPolicy != null) {
                while (this.isRetryLookup(services, serviceRequestId)) {
                    ++numAttempts;
                    try {
                        services = this.findServices(serviceTemplate, maxNumMatches, discoveredServices, serviceRequestId, numAttempts);
                        if (this.isRetryLookup(services, serviceRequestId)) continue;
                        break;
                    }
                    catch (ServiceNotAvailableException e) {
                        if (this.isRetryLookup(services, serviceRequestId)) continue;
                        throw e;
                    }
                }
            }
        }
        return services;
    }

    private final int findServicesInCache(ServiceTemplate serviceTemplate, Services services, int maxNumMatches, int origNumElements) {
        int numFinds = 0;
        if (serviceTemplate != null && maxNumMatches - origNumElements > 0) {
            Services cachedServices = this.findInCache(serviceTemplate, services, maxNumMatches);
            numFinds = cachedServices.size() - origNumElements;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.foundServices.fmt.txt", (Object)numFinds, (Object)serviceTemplate));
            }
            if (maxNumMatches > services.size()) {
                this.findServices(serviceTemplate, services, maxNumMatches);
            }
            numFinds = services.size() - origNumElements;
        }
        if (numFinds > 0) {
            this._servicesCache.add(services);
        }
        return numFinds;
    }

    private void findServices(ServiceTemplate serviceTemplate, Services services, int maxNumMatches) {
        this.findServicesUsingDelegates(true, serviceTemplate, services, maxNumMatches);
        if (maxNumMatches > services.size()) {
            this.findServicesUsingDelegates(false, serviceTemplate, services, maxNumMatches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findServicesUsingDelegates(boolean isDelegates, ServiceTemplate serviceTemplate, Services services, int maxNumMatches) {
        List<FindServiceInterface> list;
        FindServiceInterface[] delegates = null;
        if (isDelegates) {
            list = this._discoveryDelegates;
            synchronized (list) {
                delegates = this._discoveryDelegates.toArray(new FindServiceInterface[this._discoveryDelegates.size()]);
            }
        }
        list = this._serviceFinders;
        synchronized (list) {
            delegates = this._serviceFinders.toArray(new FindServiceInterface[this._serviceFinders.size()]);
        }
        int numItems = delegates.length;
        FindServiceInterface findServiceIf = null;
        Services servicesFromDelegate = null;
        boolean isDebugLogEnabled = LOGGER.isDebugEnabled();
        for (int i = 0; i < numItems && maxNumMatches > services.size(); ++i) {
            Serializable ex = null;
            try {
                findServiceIf = delegates[i];
                if (findServiceIf == null) continue;
                if (isDebugLogEnabled) {
                    LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.findingServicesUsingDelegate.fmt.txt", (Object)findServiceIf.getClass().getName()));
                }
                try {
                    servicesFromDelegate = findServiceIf.findServices(serviceTemplate, maxNumMatches, services);
                    services.addAll(servicesFromDelegate);
                }
                catch (ConnectException e) {
                    this.handleStaleDiscoveryService(findServiceIf, isDelegates);
                }
                catch (NoSuchObjectException e) {
                    this.handleStaleDiscoveryService(findServiceIf, isDelegates);
                }
                catch (RemoteException e) {
                    this.handleStaleDiscoveryService(findServiceIf, isDelegates);
                }
                continue;
            }
            catch (ServiceException e) {
                ex = e;
                continue;
            }
            catch (ClassCastException e) {
                ex = e;
                continue;
            }
            finally {
                if (ex != null && isDebugLogEnabled) {
                    LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.exceptionUnableToFindService.ex.fmt.txt", (Object)""), (Throwable)ex);
                }
            }
        }
    }

    private final boolean isRetryLookup(Services discoveredServices, String serviceRequestId) {
        return this._lookupPolicy != null && discoveredServices != null && discoveredServices.size() == 0 && this._lookupPolicy.isOKToRetryLookup(serviceRequestId);
    }

    public String getServiceName() {
        return RB.getStringResource("DiscoveryService.serviceName.txt");
    }

    private final Services findInCache(ServiceTemplate serviceTemplate, Services services, int maxNumMatches) {
        int numServicesToFind = maxNumMatches - services.size();
        this._servicesCache.getServices(serviceTemplate, numServicesToFind, services, true);
        numServicesToFind = maxNumMatches - services.size();
        if (numServicesToFind > 0) {
            this._servicesCache.getServices(serviceTemplate, numServicesToFind, services, false);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<FindServiceInterface> getDiscoverers() {
        HashSet<FindServiceInterface> discoverers = new HashSet<FindServiceInterface>(5);
        List<FindServiceInterface> list = this._discoveryDelegates;
        synchronized (list) {
            discoverers.addAll(this._discoveryDelegates);
        }
        list = this._serviceFinders;
        synchronized (list) {
            discoverers.addAll(this._serviceFinders);
        }
        return discoverers.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addDiscoveryDelegate(FindServiceInterface discoveryDelegate) throws RemoteException {
        if (discoveryDelegate == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.nullFindServiceInterface.ex.txt"));
        }
        if (this.equals(discoveryDelegate) || this.sameEntity(discoveryDelegate)) {
            LOGGER.warn(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.alreadyRegisteredFindServiceInterface.ex.fmt.txt", (Object)this.getEntityKey()));
        } else {
            RemoteServiceInterface service;
            FindServiceInterface discoverySvc = discoveryDelegate;
            RemoteServiceInterface serviceProxy = null;
            if (discoveryDelegate instanceof RemoteServiceInterface && (serviceProxy = (service = (RemoteServiceInterface)((Object)discoveryDelegate)).getServiceProxy()) instanceof FindServiceInterface) {
                discoverySvc = (FindServiceInterface)((Object)serviceProxy);
            }
            boolean wasAdded = false;
            if (discoverySvc instanceof RemoteServiceInterface) {
                RemoteServiceInterface service2 = (RemoteServiceInterface)((Object)discoverySvc);
                List<FindServiceInterface> list = this._discoveryDelegates;
                synchronized (list) {
                    HashSet<RemoteServiceInterface> discoveryDelegates = new HashSet<RemoteServiceInterface>(this._discoveryDelegates.size());
                    for (FindServiceInterface serviceFinder : this._discoveryDelegates) {
                        discoveryDelegates.add((RemoteServiceInterface)((Object)serviceFinder));
                    }
                    if (!ServicesCache.isServiceInCollection(discoveryDelegates, service2) && (wasAdded = this._discoveryDelegates.add(discoverySvc)) && discoverySvc instanceof DiscoveryAdminInterface) {
                        DiscoveryAdminInterface discoveryAdmin = (DiscoveryAdminInterface)((Object)discoverySvc);
                        DiscoveryService.registerServices(discoveryAdmin, this.getRemoteServices());
                        DiscoveryService.registerServices(discoveryAdmin, this.getLocalServices());
                    }
                }
            }
            List<FindServiceInterface> list = this._serviceFinders;
            synchronized (list) {
                boolean isOKToAdd = true;
                for (FindServiceInterface serviceFinder : this._serviceFinders) {
                    if (!this.sameEntity(serviceFinder)) continue;
                    LOGGER.warn(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.alreadyRegisteredFindServiceInterface.ex.fmt.txt", (Object)this.getEntityKey()));
                    isOKToAdd = false;
                    break;
                }
                if (isOKToAdd) {
                    this._serviceFinders.add(discoverySvc);
                }
            }
        }
    }

    private static final void registerServices(DiscoveryAdminInterface discoveryAdmin, Iterator<RemoteServiceInterface> iterator) {
        RemoteServiceInterface service = null;
        ServiceDiscoveryConfigurationInterface serviceDiscoveryConfig = null;
        ServiceConfigurationInterface serviceConfiguration = null;
        while (iterator.hasNext()) {
            try {
                service = iterator.next();
                serviceConfiguration = service.getServiceConfiguration();
                if (serviceConfiguration == null || (serviceDiscoveryConfig = (ServiceDiscoveryConfigurationInterface)((Object)serviceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY))) == null || !serviceDiscoveryConfig.isDelegateRegistrationEnabled()) continue;
                discoveryAdmin.addService(service);
            }
            catch (ServiceException e) {
                LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.registerService.ex.fmt.log", (Object)service), (Throwable)((Object)e));
            }
            catch (RemoteException e) {
                LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.registerService.ex.fmt.log", (Object)service), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeDiscoveryDelegate(FindServiceInterface serviceLocator) {
        List<FindServiceInterface> list = this._discoveryDelegates;
        synchronized (list) {
            String entityKey = null;
            try {
                entityKey = serviceLocator.getEntityKey();
                FindServiceInterface nextServiceLocator = null;
                Iterator<FindServiceInterface> iter = this._discoveryDelegates.iterator();
                while (iter.hasNext()) {
                    nextServiceLocator = iter.next();
                    if (!entityKey.equals(nextServiceLocator.getEntityKey())) continue;
                    iter.remove();
                    this._discoveryDelegates.remove(nextServiceLocator);
                }
            }
            catch (RemoteException e) {
                this._discoveryDelegates.remove(serviceLocator);
            }
        }
    }

    @Override
    public final void addService(RemoteServiceInterface service) throws ServiceException {
        try {
            if (service != null) {
                boolean isDiscoveryDelegate = service instanceof FindServiceInterface;
                if (isDiscoveryDelegate) {
                    this.addDiscoveryDelegate((FindServiceInterface)((Object)service));
                }
                this._servicesCache.add(service);
                if (!isDiscoveryDelegate) {
                    this.registerWithDiscoveryDelegates(service);
                }
            }
        }
        catch (ServiceException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.unableToCacheService.ex.fmt.txt", (Object)service));
            }
            throw e;
        }
        catch (RemoteException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.unableToCacheService.ex.fmt.txt", (Object)service);
            LOGGER.error(msg, (Throwable)e);
            throw new ServiceException(e, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerWithDiscoveryDelegates(RemoteServiceInterface service) {
        block11: {
            try {
                ServiceDiscoveryConfigurationInterface serviceDiscoveryConfig = (ServiceDiscoveryConfigurationInterface)((Object)service.getServiceConfiguration().getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY));
                if (serviceDiscoveryConfig != null && serviceDiscoveryConfig.isDelegateRegistrationEnabled()) {
                    List<FindServiceInterface> list = this._discoveryDelegates;
                    synchronized (list) {
                        Iterator<FindServiceInterface> iterator = this._discoveryDelegates.iterator();
                        FindServiceInterface o = null;
                        while (iterator.hasNext()) {
                            o = iterator.next();
                            if (!(o instanceof DiscoveryAdminInterface)) continue;
                            try {
                                ((DiscoveryAdminInterface)((Object)o)).addService(service);
                            }
                            catch (ServiceException e) {
                                LOGGER.error(e.getMessage(), (Throwable)((Object)e));
                            }
                            catch (RemoteException e) {
                                LOGGER.error(e.getMessage());
                            }
                        }
                        break block11;
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.doNotRegisterServiceWithDelegates.fmt.txt", (Object)service));
                }
            }
            catch (RemoteException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    @Override
    public final void removeService(RemoteServiceInterface service) {
        if (service != null) {
            this._servicesCache.remove(service);
            if (service instanceof FindServiceInterface) {
                this.removeDiscoveryDelegate((FindServiceInterface)((Object)service));
            }
        }
    }

    @Override
    public Iterator<RemoteServiceInterface> getLocalServices() {
        List<RemoteServiceInterface> list = this._servicesCache.getListOfLocalServices();
        Collections.sort(list, _serviceCreationTimeComparator);
        return list.iterator();
    }

    @Override
    public Iterator<RemoteServiceInterface> getRemoteServices() {
        return this._servicesCache.getRemoteServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        String none = Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.none.fmt.txt", (Object)lineSeparator);
        StringBuilder sb = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.toString.fmt.txt", (Object)lineSeparator, (Object)lineSeparator));
        Message messageIterationItem = new Message(RB.getResources(), "IterationItem.fmt.txt");
        Exception ex = null;
        try {
            RemoteServiceInterface service = null;
            Iterator<FindServiceInterface> iterator = this.getDiscoverers();
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.discoveryDelegates.fmt.txt", (Object)lineSeparator));
            int i = 1;
            if (!iterator.hasNext()) {
                sb.append(none);
            } else {
                FindServiceInterface serviceFinder = null;
                while (iterator.hasNext()) {
                    serviceFinder = iterator.next();
                    try {
                        sb.append(messageIterationItem.toString((Object)i++, (Object)(serviceFinder.getClass().getName() + " [" + serviceFinder.getEntityKey() + ']'), (Object)lineSeparator));
                    }
                    catch (ClassCastException e) {
                        sb.append(messageIterationItem.toString((Object)i++, (Object)serviceFinder.getClass().getName(), (Object)lineSeparator));
                    }
                }
            }
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.servicesNonRemoteable.fmt.txt", (Object)lineSeparator));
            i = 1;
            Iterator<RemoteServiceInterface> serviceIter = this.getLocalServices();
            if (!serviceIter.hasNext()) {
                sb.append(none);
            }
            while (serviceIter.hasNext()) {
                service = serviceIter.next();
                sb.append(messageIterationItem.toString((Object)i++, (Object)(service.getClass().getName() + " [" + service.getEntityKey() + ']'), (Object)lineSeparator));
            }
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.servicesRemoteable.fmt.txt", (Object)lineSeparator));
            i = 1;
            serviceIter = this.getRemoteServices();
            if (!serviceIter.hasNext()) {
                sb.append(none);
            }
            while (serviceIter.hasNext()) {
                service = serviceIter.next();
                sb.append(messageIterationItem.toString((Object)i++, (Object)(service.getClass().getName() + " [" + service.getEntityKey() + ']'), (Object)lineSeparator));
            }
        }
        catch (RemoteException e) {
            ex = e;
        }
        catch (ClassCastException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                sb.append(ex.getLocalizedMessage());
            }
            sb.append('}');
        }
        return sb.toString();
    }

    public static final boolean isOkToProcessRequest(String discoveryServiceId, ServiceTemplate serviceTemplate) {
        return serviceTemplate != null && !serviceTemplate.isOkToProcess(discoveryServiceId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(UserContextInterface userContext, boolean isCheckPermission) throws AccessControlException {
        DiscoveryService discoveryService = this;
        synchronized (discoveryService) {
            if (isCheckPermission) {
                SecurityUtil.checkPermission(userContext, new ServicePermission("destroy"));
            }
            boolean isLocalDiscoveryService = this.equals(_singletonDiscoveryService);
            try {
                JMXAgent jmxAgent;
                if (null != _mBeanJMXRegistration && this.equals(_singletonDiscoveryService) && (jmxAgent = JMXAgent.getInstance()) != null) {
                    try {
                        jmxAgent.unregisterMBeanUsingRegistration(_mBeanJMXRegistration);
                        _mBeanJMXRegistration = null;
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.unregisterMBean.ex.fmt.log", (Object)_mBeanJMXRegistration.getRequestedMBeanName()), (Throwable)e);
                    }
                }
            }
            finally {
                this.clearLocalServicesCache();
                this.clearRemoteServicesCache();
                this.clearDiscoveryDelegates();
                try {
                    super.destroy();
                }
                catch (ServiceException e) {
                    this.logDestroyErrorMessage((Exception)((Object)e));
                }
                finally {
                    if (isLocalDiscoveryService) {
                        _singletonDiscoveryService = null;
                    }
                }
            }
        }
    }

    @Override
    public void destroy() {
        this.destroy(null, false);
    }

    public void destroy(UserContextInterface userContext) {
        this.destroy(userContext, true);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)DiscoveryService.defaultInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDiscoveryDelegates() {
        Object[] delegates = null;
        List<FindServiceInterface> list = this._discoveryDelegates;
        synchronized (list) {
            delegates = this._discoveryDelegates.toArray();
            this._discoveryDelegates.clear();
        }
        Object o2 = null;
        RemoteServiceInterface service = null;
        for (Object o2 : delegates) {
            if (!(o2 instanceof RemoteServiceInterface)) continue;
            service = (RemoteServiceInterface)o2;
            try {
                if (ServiceState.isStateDeactivated(service.getServiceState()) || service.equals(this)) continue;
                service.destroy();
            }
            catch (NoSuchObjectException e) {
                Logger logger = LOGGER;
                if (!logger.isDebugEnabled()) continue;
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.destroy.ex.fmt.log", (Object)this.getClass().getName()), (Throwable)e);
            }
            catch (RemoteException e) {
                this.logDestroyErrorMessage(e);
            }
            catch (ServiceException e) {
                this.logDestroyErrorMessage((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRemoteServicesCache() {
        int numServices;
        List<RemoteServiceInterface> services = null;
        ServicesCache servicesCache = this._servicesCache;
        synchronized (servicesCache) {
            services = this._servicesCache.getListOfRemoteServices();
            this._servicesCache.clearRemoteServices();
        }
        int n = numServices = services != null ? services.size() : 0;
        if (numServices > 0) {
            for (RemoteServiceInterface service : services) {
                if (!(service instanceof FindServiceInterface)) continue;
                List<FindServiceInterface> list = this._discoveryDelegates;
                synchronized (list) {
                    this._discoveryDelegates.remove(service);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearLocalServicesCache() {
        List<RemoteServiceInterface> list = null;
        ServicesCache servicesCache = this._servicesCache;
        synchronized (servicesCache) {
            list = this._servicesCache.getListOfLocalServices();
            this._servicesCache.clearLocalServices();
        }
        Collections.sort(list, _serviceCreationTimeComparator);
        FindServiceInterface serviceFinder = null;
        Iterator<RemoteServiceInterface> iterator = list.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                list.clear();
                return;
            }
            RemoteServiceInterface service = iterator.next();
            try {
                if (service instanceof FindServiceInterface) {
                    serviceFinder = (FindServiceInterface)((Object)service);
                    List<FindServiceInterface> list2 = this._discoveryDelegates;
                    synchronized (list2) {
                        this._discoveryDelegates.remove(serviceFinder);
                    }
                }
                try {
                    try {
                        if (!ServiceState.isStateDeactivated(service.getServiceState())) {
                            service.destroy();
                        }
                        service = null;
                    }
                    catch (IllegalStateException e) {
                        service = null;
                    }
                    catch (ServiceException e) {
                        this.logDestroyErrorMessage((Exception)((Object)e));
                        service = null;
                    }
                    catch (RemoteException e) {
                        this.logDestroyErrorMessage(e);
                        service = null;
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    service = null;
                    throw throwable;
                }
            }
            catch (ClassCastException e) {
                continue;
            }
            break;
        }
    }

    @Override
    public final LookupPolicyInterface getLookupPolicy() {
        return this._lookupPolicy;
    }

    @Override
    public final void setLookupPolicy(LookupPolicyInterface lookupPolicy) {
        this._lookupPolicy = lookupPolicy;
    }

    private static final boolean registerMBean(DiscoveryServiceInterface discoveryService) {
        String mBeanObjectName;
        boolean wasRegistered = false;
        JMXAgent jmxAgent = JMXAgent.getInstance();
        if (jmxAgent != null && jmxAgent.isMBeanEnabled(mBeanObjectName = Names.getObjectName("DiscoveryService", discoveryService))) {
            DiscoveryServiceMBean mbean = new DiscoveryServiceMBean();
            mbean.setTargetObject(discoveryService);
            _mBeanJMXRegistration = jmxAgent.registerMBean(mbean, mBeanObjectName);
            wasRegistered = true;
        }
        return wasRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleStaleDiscoveryService(FindServiceInterface serviceLocator, boolean isDelegates) {
        if (isDelegates) {
            List<FindServiceInterface> list = this._discoveryDelegates;
            synchronized (list) {
                if (this._discoveryDelegates.size() > 1) {
                    this._discoveryDelegates.remove(serviceLocator);
                    this._discoveryDelegates.add(serviceLocator);
                }
            }
        }
        List<FindServiceInterface> list = this._serviceFinders;
        synchronized (list) {
            if (this._serviceFinders.size() > 1) {
                this._serviceFinders.remove(serviceLocator);
                this._serviceFinders.add(serviceLocator);
            }
        }
    }

    private final void logDestroyErrorMessage(Exception e) {
        LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.destroy.ex.fmt.log", (Object)this.getClass().getName()), (Throwable)e);
    }

    static {
        LOGGER = LogManager.getLogger(DiscoveryService.class);
    }
}

