/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractExporter;
import com.sas.services.deployment.RB;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
final class SoftwareComponentRemoteExporter
extends AbstractExporter {
    private SoftwareComponent _softwareComponent;

    SoftwareComponentRemoteExporter(SoftwareComponent softwareComponent, File exportDestinationFile, boolean isOKToOverwriteFile) {
        super(exportDestinationFile, isOKToOverwriteFile);
        this.setSoftwareComponent(softwareComponent);
    }

    private void setSoftwareComponent(SoftwareComponent softwareComponent) throws IllegalArgumentException {
        if (softwareComponent == null) {
            throw new IllegalArgumentException(RB.getStringResource("AbstractExporter.specifySoftwareComponent.ex.txt"));
        }
        this._softwareComponent = softwareComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getServiceDeploymentXML() throws ServiceException {
        String xml;
        block16: {
            xml = null;
            MdObjectStore mdObjectStore = null;
            Exception exception = null;
            try {
                mdObjectStore = SoftwareComponentRemoteExporter.newObjectStore(this._softwareComponent);
                xml = this.createExportXMLDocument(mdObjectStore.createXMLforStore());
            }
            catch (IllegalArgumentException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                block17: {
                    if (mdObjectStore != null) {
                        try {
                            mdObjectStore.dispose();
                        }
                        catch (RemoteException e) {
                            Logger logger = LogManager.getLogger(this.getClass());
                            if (logger == null) break block17;
                            logger.error((Object)e);
                        }
                    }
                }
                if (exception == null) break block16;
                throw new ServiceException(exception, RB.getStringResource("SoftwareComponentExporter.getServiceDeploymentXML.ex.txt"));
            }
        }
        return xml;
    }

    private static void changeIdsToAliases(MdObjectStore mdObjectStore) throws ServiceException {
        try {
            if (mdObjectStore == null || mdObjectStore.isDisposed()) {
                throw new ServiceException();
            }
            for (CMetadata cMetadata : new ArrayList(mdObjectStore.getDetailObjectMap().values())) {
                String id = cMetadata.getId();
                mdObjectStore.changeHashKey(id, AbstractExporter.getAliasForID(id));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("SoftwareComponentExporter.aliasIds.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MdObjectStore newObjectStore(SoftwareComponent softwareComponent) throws ServiceException {
        MdObjectStore mdObjectStore = null;
        Throwable exception = null;
        try {
            MdFactory mdFactory = softwareComponent.getObjectStore().getFactory();
            mdObjectStore = mdFactory.createObjectStore(null, SoftwareComponentRemoteExporter.class.getName());
            String xmlQuery = AbstractExporter.getXMLQuery(softwareComponent.getFQID());
            mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)mdObjectStore, AbstractExporter.getRepositoryID(softwareComponent.getRepositoryID()), "SoftwareComponent", AbstractExporter.getMetadataQueryFlags(), xmlQuery);
            SoftwareComponentRemoteExporter.changeIdsToAliases(mdObjectStore);
            return mdObjectStore;
        }
        catch (IllegalStateException e) {
            exception = e;
            return exception;
        }
        catch (RemoteException e) {
            exception = e;
            return exception;
        }
        catch (MdException e) {
            exception = e;
            return exception;
        }
        finally {
            if (exception == null) return mdObjectStore;
            if (mdObjectStore == null) throw new ServiceException(exception, RB.getStringResource("SoftwareComponentExporter.createObjectStore.ex.txt"));
            try {
                try {
                    mdObjectStore.dispose();
                    mdObjectStore = null;
                    throw new ServiceException(exception, RB.getStringResource("SoftwareComponentExporter.createObjectStore.ex.txt"));
                }
                catch (RemoteException e) {
                    Logger logger = LogManager.getLogger(SoftwareComponentRemoteExporter.class);
                    if (logger != null) {
                        logger.error((Object)e);
                    }
                    mdObjectStore = null;
                    throw new ServiceException(exception, RB.getStringResource("SoftwareComponentExporter.createObjectStore.ex.txt"));
                }
            }
            catch (Throwable throwable) {
                mdObjectStore = null;
                throw throwable;
            }
        }
    }

    @Override
    String getSoftwareComponentFQID() throws ServiceException {
        String id = null;
        try {
            id = this._softwareComponent.getFQID();
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("SoftwareComponentExporter.getFQID.ex.txt"));
        }
        return id;
    }
}

