/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.ServiceException;
import com.sas.services.deployment.OperationMonitorInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentImportException;
import com.sas.services.util.IOUtil;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServicePrototypeImporter
extends Thread {
    private static final String DEFAULT_PROTOTYPE_FILE = "sas_service_prototypes.xml";
    private static final int REPOSITORY_ID_LENGTH = 17;
    private String _repositoryId;
    private String _importFileName;
    private OperationMonitorInterface _operationMonitor;
    private MdFactory _mdFactory;

    public ServicePrototypeImporter(MdFactory mdFactory, String repositoryId) {
        this(mdFactory, repositoryId, DEFAULT_PROTOTYPE_FILE, null);
    }

    private ServicePrototypeImporter(MdFactory mdFactory, String repositoryId, String importFileName, OperationMonitorInterface operationMonitor) {
        super(RB.getStringResource("ServicePrototypeImporter.threadName.txt"));
        this.setMdFactory(mdFactory);
        this.setRepositoryId(repositoryId);
        this._operationMonitor = operationMonitor;
        this.setImportFileName(importFileName);
    }

    private void setMdFactory(MdFactory mdFactory) {
        if (mdFactory == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyMetadataFactory.ex.txt"));
        }
        this._mdFactory = mdFactory;
    }

    private void setImportFileName(String importFileName) {
        if (importFileName == null) {
            throw new IllegalArgumentException(RB.getStringResource("ServicePrototypeImporter.mustSpecifyImportFile.ex.txt"));
        }
        this._importFileName = importFileName;
    }

    @Override
    public void run() {
        block2: {
            try {
                ServicePrototypeImporter.importServicePrototypes(this._mdFactory, this._repositoryId, this._importFileName);
            }
            catch (ServiceDeploymentImportException e) {
                if (this._operationMonitor == null) break block2;
                this._operationMonitor.addThrowable((Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importServicePrototypes(MdFactory mdFactory, String repositoryId, String importFileName) throws ServiceDeploymentImportException {
        block11: {
            Object ex = null;
            try {
                if (importFileName != null) {
                    String metadata = IOUtil.getStringFromResourceUsingEncoding(ServicePrototypeImporter.class, importFileName, "utf-8");
                    mdFactory.getOMIUtil().DoRequest("<AddMetadata>" + XMLUtil.stripXMLDeclaration(metadata) + "<ReposId>" + repositoryId + "</ReposId><NS>SAS</NS><Flags>268435456</Flags><Options/></AddMetadata>");
                }
            }
            catch (MdException e) {
                ex = e;
            }
            catch (RemoteException e) {
                ex = e;
            }
            catch (ServiceException e) {
                ex = e;
            }
            finally {
                if (ex == null) break block11;
                String cause = ((Throwable)ex).getLocalizedMessage();
                if (cause == null) {
                    cause = "";
                }
                throw new ServiceDeploymentImportException((Throwable)ex, Message.format((ResourceBundle)RB.getResources(), (String)"ServicePrototypeImporter.importFailed.ex.fmt.txt", (Object)cause));
            }
        }
    }

    private void setRepositoryId(String repositoryId) {
        if (repositoryId == null || repositoryId.length() != 17) {
            throw new IllegalArgumentException(RB.getStringResource("ServicePrototypeImporter.nonNullRepositoryRequired.ex.txt"));
        }
        this._repositoryId = repositoryId;
    }
}

