/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.ServiceException;
import com.sas.services.ServiceFactoryInterface;
import com.sas.services.ServiceProfile;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.CLIOptionsConfig;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.CLIOptionsServiceDeployment;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceConfigUninstaller {
    private ServiceConfigUninstaller() {
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtRuntimeExceptionHandler(true));
        ServiceException exception = null;
        try {
            ServiceConfigUninstaller.uninstallConfig(args);
        }
        catch (ServiceException e) {
            exception = e;
            LogManager.getLogger(ServiceConfigUninstaller.class).error("Unable to uninstall foundation service configuration.", (Throwable)((Object)e));
        }
        System.exit(exception == null ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstallConfig(String[] args) throws ServiceException {
        Logger logger;
        block43: {
            logger = LogManager.getLogger(ServiceConfigUninstaller.class);
            MdStore mdStore = null;
            CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
            Option cliOptionMetaServer = cliOptionsMeta.createOptionMetaServer();
            Option cliOptionMetaPort = cliOptionsMeta.createOptionPort();
            Option cliOptionMetaRepository = cliOptionsMeta.createOptionRepository();
            Option cliOptionIsPrompting = new CLIOptionsConfig().createOptionIsPrompting();
            CLIOptionsServiceDeployment cliDeployment = new CLIOptionsServiceDeployment();
            Option optionDeploymentName = cliDeployment.createOptionDeploymentName();
            optionDeploymentName.setRequired(true);
            Option optionServiceName = cliDeployment.createOptionServiceName();
            optionServiceName.setRequired(true);
            Option optionServiceGroupName = cliDeployment.createOptionServiceGroupName();
            optionServiceGroupName.setRequired(true);
            Option optionApplication = cliDeployment.createOptionServiceApplication();
            Option optionIsRemoveUnusedResources = cliDeployment.createOptionIsRemoveUnusedResources();
            Option cliOptionMetaUser = cliOptionsMeta.createOptionUser();
            Option cliOptionMetaPassword = cliOptionsMeta.createOptionPassword();
            Option cliOptionMetaPasswordOnStdin = cliOptionsMeta.createOptionPasswordOnStdin();
            Option cliOptionSecPackageList = cliOptionsMeta.createOptionSecPackageList();
            Option cliOptionSPN = cliOptionsMeta.createOptionSPN();
            boolean isRemoveUnusedResources = false;
            String serviceDeploymentName = null;
            String serviceGroupName = null;
            String serviceName = null;
            ServiceException exception = null;
            try {
                Options options = new Options();
                options.addOption(cliOptionMetaServer);
                options.addOption(cliOptionMetaPort);
                options.addOption(cliOptionMetaRepository);
                options.addOption(cliOptionIsPrompting);
                options.addOption(optionApplication);
                options.addOption(optionIsRemoveUnusedResources);
                options.addOption(optionDeploymentName);
                options.addOption(optionServiceGroupName);
                options.addOption(optionServiceName);
                OptionGroup optionGroupCx = new OptionGroup();
                optionGroupCx.setRequired(true);
                optionGroupCx.addOption(cliOptionMetaUser);
                optionGroupCx.addOption(cliOptionSecPackageList);
                options.addOptionGroup(optionGroupCx);
                options.addOption(cliOptionMetaPassword);
                options.addOption(cliOptionMetaPasswordOnStdin);
                options.addOption(cliOptionSPN);
                String metaPass = null;
                boolean isValid = false;
                CommandLine cmdLine = null;
                try {
                    cmdLine = new DefaultParser().parse(options, args);
                    String metaHost = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionServer());
                    String metaPort = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPort());
                    String secPackageList = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSecPackageList());
                    String metaSPN = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSPN());
                    String metaUser = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionUser());
                    boolean isPasswordOnStdin = Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPasswordOnStdin()));
                    metaPass = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPassword());
                    serviceName = cmdLine.getOptionValue(optionServiceName.getOpt());
                    serviceGroupName = cmdLine.getOptionValue(optionServiceGroupName.getOpt());
                    serviceDeploymentName = cmdLine.getOptionValue(optionDeploymentName.getOpt());
                    String configName = cmdLine.getOptionValue(optionApplication.getOpt());
                    String isRemoveUnusedResourcesValue = cmdLine.getOptionValue(optionIsRemoveUnusedResources.getOpt());
                    if (isRemoveUnusedResourcesValue != null) {
                        isRemoveUnusedResources = Boolean.parseBoolean(isRemoveUnusedResourcesValue);
                    }
                    boolean bl = isValid = cmdLine.hasOption(cliOptionsMeta.getNameOfOptionServer()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionPort()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionRepository()) && configName != null && serviceDeploymentName != null && serviceGroupName != null && serviceName != null && (metaUser != null && (isPasswordOnStdin || metaPass != null) || secPackageList != null);
                    if (isValid) {
                        ServiceDeployment serviceDeployment;
                        ServiceComponent serviceComponent;
                        HashMap<String, String> metaOptions = new HashMap<String, String>(7);
                        String optionName = cliOptionsMeta.getNameOfOptionServer();
                        metaOptions.put(optionName, metaHost);
                        optionName = cliOptionsMeta.getNameOfOptionPort();
                        metaOptions.put(optionName, metaPort);
                        optionName = cliOptionsMeta.getNameOfOptionRepository();
                        String repositoryName = cmdLine.getOptionValue(optionName);
                        metaOptions.put(optionName, repositoryName);
                        if (secPackageList != null) {
                            optionName = cliOptionsMeta.getNameOfOptionSecPackageList();
                            metaOptions.put(optionName, secPackageList);
                            optionName = cliOptionsMeta.getNameOfOptionSPN();
                            metaOptions.put(optionName, metaSPN);
                        } else {
                            String dashOptionName;
                            optionName = cliOptionsMeta.getNameOfOptionUser();
                            metaOptions.put(optionName, metaUser);
                            if (isPasswordOnStdin && (metaPass = CLIOptionsConfig.getOptionValueFromSystemIn(dashOptionName = '-' + cliOptionsMeta.getNameOfOptionPassword(), Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionIsPrompting.getOpt())) ? Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.fmt.txt", (Object)dashOptionName) : null, null)) == null) {
                                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.ex.fmt.txt", (Object)cliOptionsMeta.getNameOfOptionPassword()));
                            }
                        }
                        if (metaPass != null) {
                            metaOptions.put(cliOptionsMeta.getNameOfOptionPassword(), metaPass);
                        }
                        if ((serviceComponent = (serviceDeployment = new ServiceDeployment(repositoryName, serviceDeploymentName, mdStore = AbstractMetadataSource.createMdStore(false, metaOptions, new Environment()))).getServiceComponent(serviceGroupName, serviceName)) == null) {
                            throw new ServiceException(new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.getService.ex.fmt.txt", (Object)serviceDeploymentName, (Object)serviceGroupName, (Object)serviceName)));
                        }
                        ServiceFactoryInterface serviceFactory = AbstractServiceDeployment.getServiceFactory(serviceComponent.getFactoryClassName());
                        ServiceProfile serviceProfile = serviceFactory.getServiceProfile();
                        List<Property> properties = ServiceDeployment.getServiceConfigProperties(serviceComponent);
                        Property property = null;
                        for (Property nextProperty : properties) {
                            if (!configName.equals(nextProperty.getName())) continue;
                            property = nextProperty;
                            break;
                        }
                        if (property == null) {
                            property = properties.get(0);
                        }
                        AbstractServiceComponentConfig serviceConfig = serviceProfile.createServiceConfigForProperty(property);
                        serviceDeployment.uninstallServiceConfiguration(serviceComponent, serviceConfig, configName, isRemoveUnusedResources);
                        serviceComponent.updateMetadataAll();
                        if (logger.isInfoEnabled()) {
                            logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.uninstalledServiceConfig.fmt.txt", (Object)configName, (Object)serviceName, (Object)serviceComponent.getFQID(), (Object)serviceGroupName, (Object)serviceDeploymentName));
                        }
                    }
                }
                finally {
                    metaPass = null;
                    if (!isValid) {
                        StringBuilder sb = new StringBuilder();
                        String nextOption = "> -";
                        sb.append(ServiceConfigUninstaller.class.getName());
                        sb.append(" -");
                        sb.append(cliOptionMetaServer.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaServer.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaPort.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPort.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaRepository.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaRepository.getArgName());
                        sb.append("> -");
                        sb.append(optionServiceName.getOpt());
                        sb.append(" <");
                        sb.append(optionServiceName.getArgName());
                        sb.append("> -");
                        sb.append(optionApplication.getOpt());
                        sb.append(" [<");
                        sb.append(optionApplication.getArgName());
                        sb.append(">] -");
                        sb.append(optionDeploymentName.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentName.getArgName());
                        sb.append('>');
                        sb.append(optionServiceGroupName.getOpt());
                        sb.append(" <");
                        sb.append(optionServiceGroupName.getArgName());
                        sb.append('>');
                        sb.append(optionServiceName.getOpt());
                        sb.append(" <");
                        sb.append(optionServiceName.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionMetaUser.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaUser.getArgName());
                        sb.append("> [[-");
                        sb.append(cliOptionMetaPassword.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPassword.getArgName());
                        sb.append(">] | [-");
                        sb.append(cliOptionMetaPasswordOnStdin.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPasswordOnStdin.getArgName());
                        sb.append(">]] | [-");
                        sb.append(cliOptionSecPackageList.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSecPackageList.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionSPN.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSPN.getArgName());
                        sb.append(">]]");
                        new HelpFormatter().printHelp(sb.toString(), options);
                    }
                }
            }
            catch (ParseException e) {
                exception = new ServiceException(e);
            }
            catch (MdException e) {
                exception = new ServiceException(e);
            }
            catch (RemoteException e) {
                exception = new ServiceException(e);
            }
            catch (IllegalArgumentException e) {
                exception = new ServiceException(e);
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                cliOptionMetaPassword = null;
                cliOptionMetaUser = null;
                if (mdStore != null) {
                    try {
                        mdStore.getFactory().dispose();
                    }
                    catch (RemoteException e) {
                        logger.error(RB.getStringResource("ServiceConfigurationFactory.disposeFactory.ex.log"), (Throwable)e);
                    }
                }
                if (exception == null) break block43;
                logger.error(RB.getStringResource("ServiceConfigUninstaller.main.ex.txt"), (Throwable)((Object)exception));
                throw exception;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("ServiceConfigInstaller.returningFromMain.log"));
        }
    }
}

