/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.DeployableService;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RMIBinding;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceDiscoveryConfiguration;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.security.AccessController;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class RMIDeployableService
extends DeployableService {
    private static final long serialVersionUID = -7751677386375664758L;
    private Set<RMIBinding> _rmiBindings;
    private RemoteServiceInterface _deployedService;
    private AbstractMetadataSource _metadataSource;

    public RMIDeployableService(String id, ServiceConfigurationInterface serviceConfiguration, String[] dependencies, Set<RMIBinding> rmiBindings, AbstractMetadataSource metadataSource) throws ServiceException {
        super(id, serviceConfiguration, dependencies);
        this.setRMIBindings(rmiBindings);
        this._metadataSource = metadataSource;
    }

    private final void setRMIBindings(Set<RMIBinding> rmiBindings) throws InitializationException {
        if (rmiBindings == null || rmiBindings.size() <= 0) {
            throw new InitializationException(RB.getStringResource("RMIDeployableService.oneOrMoreRMIBindingsRequired.ex.txt"));
        }
        this._rmiBindings = rmiBindings;
    }

    @Override
    public RemoteServiceInterface deploy() throws ServiceException {
        return this.deploy(DiscoveryService.defaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteServiceInterface deploy(DiscoveryServiceInterface discoveryService) throws ServiceException {
        block25: {
            Logger logger = LogManager.getLogger(RMIDeployableService.class);
            String bindName = null;
            Exception exception = null;
            try {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(RB.getStringResource("RMIDeployableService.deployingAnRMIService.txt"));
                }
                if (this._rmiBindings != null) {
                    RMIBinding rmiBinding = null;
                    RMIConfiguration rmiConfiguration = null;
                    Registry registry = null;
                    int numBindings = this._rmiBindings.size();
                    if (numBindings == 1) {
                        rmiBinding = this._rmiBindings.iterator().next();
                        bindName = rmiBinding.getBindName();
                        if (rmiBinding.isNamingLookup()) {
                            rmiConfiguration = rmiBinding.getRMIConfiguration();
                            registry = rmiConfiguration.getRMIRegistry(false);
                            if (registry != null) {
                                Remote remote;
                                if (logger != null && logger.isDebugEnabled()) {
                                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.logMsgLookingUpRemoteObject.fmt.txt", (Object)bindName));
                                }
                                if ((remote = registry.lookup(bindName)) instanceof RemoteServiceInterface) {
                                    if (logger != null && logger.isDebugEnabled()) {
                                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIDeployableService.obtainedRemoteFromRegistry.fmt.txt", (Object)remote, (Object)rmiConfiguration, (Object)bindName));
                                    }
                                    RemoteServiceInterface deployedService = (RemoteServiceInterface)remote;
                                    deployedService.getEntityKey();
                                    if (discoveryService != null) {
                                        discoveryService.addService(deployedService);
                                    }
                                    if (this._metadataSource != null) {
                                        this._metadataSource.addRMIBinding(rmiBinding);
                                    }
                                    this._deployedService = deployedService;
                                }
                            } else if (logger != null) {
                                logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RMIDeployableService.noRegistrySoCanNotLookupService.ex.fmt.txt", (Object)bindName));
                            }
                        } else {
                            this.deploy(rmiBinding, discoveryService);
                        }
                    } else if (numBindings > 0) {
                        for (RMIBinding nextRMIBinding : this._rmiBindings) {
                            if (nextRMIBinding == null) continue;
                            this.deploy(nextRMIBinding, discoveryService);
                        }
                    }
                    break block25;
                }
                throw new ServiceException(RB.getStringResource("RMIDeployableService.oneOrMoreRMIBindingsRequired.ex.txt"));
            }
            catch (NotBoundException e) {
                exception = e;
                return exception;
            }
            catch (AccessException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block25;
                throw new ServiceException(exception, RB.getStringResource("RMIDeployableService.unableToDeployRMIService.ex.txt"));
            }
        }
        return this._deployedService;
    }

    private final void deploy(RMIBinding rmiBinding, DiscoveryServiceInterface discoveryService) throws ServiceException {
        block27: {
            if (rmiBinding == null) {
                throw new ServiceException(RB.getStringResource("RMIDeployableService.rmiBindingMustBeSpecified.ex.txt"));
            }
            Logger logger = LogManager.getLogger(RMIDeployableService.class);
            boolean hasInstantiatedService = false;
            String bindName = "";
            try {
                bindName = rmiBinding.getBindName();
                RMIConfiguration rmiConfiguration = rmiBinding.getRMIConfiguration();
                if (rmiConfiguration == null) {
                    String msg = RB.getStringResource("RMIDeployableService.unableToAscertainRMIRegistryHostPort.ex.txt");
                    if (logger != null) {
                        logger.error(msg);
                    }
                    throw new ServiceException(msg);
                }
                Registry registry = rmiConfiguration.getRMIRegistry(true);
                if (registry == null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RMIDeployableService.getRMIRegistry.ex.fmt.txt", (Object)rmiConfiguration.getUrl());
                    if (logger != null) {
                        logger.error(msg);
                    }
                    throw new ServiceException(msg);
                }
                if (rmiBinding.isNamingLookup() && this._deployedService == null) {
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.logMsgLookingUpRemoteObject.fmt.txt", (Object)bindName));
                    }
                    try {
                        Remote remote = registry.lookup(bindName);
                        if (remote instanceof RemoteServiceInterface) {
                            this._deployedService = (RemoteServiceInterface)remote;
                        }
                        break block27;
                    }
                    catch (NotBoundException e) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.logMsgLookingUpRemoteObject.fmt.txt", (Object)bindName);
                        if (logger != null) {
                            logger.warn(msg);
                        }
                        throw new ServiceException(e, msg);
                    }
                }
                if (this._deployedService == null) {
                    this._deployedService = super.deploy(discoveryService);
                    hasInstantiatedService = true;
                    rmiBinding.setRemoteObject(this._deployedService);
                    ServiceConfigurationInterface config = this._deployedService.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY);
                    if (config != null) {
                        ((ServiceDiscoveryConfiguration)config).addRMIBinding(rmiBinding);
                    }
                    if (this._metadataSource != null) {
                        this._metadataSource.addRMIBinding(rmiBinding);
                    }
                }
                if (this._deployedService == null) {
                    throw new ServiceException(RB.getStringResource("RMIDeployableService.unableToInstantiateService.ex.txt"));
                }
                RemoteServiceInterface remoteService = this._deployedService;
                if (rmiBinding.isRebind()) {
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.logMsgRebindingRemoteObject.fmt.txt", (Object)this._deployedService, (Object)bindName));
                    }
                    registry.rebind(bindName, remoteService);
                } else {
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.logMsgBindingRemoteObject.fmt.txt", (Object)this._deployedService, (Object)bindName));
                    }
                    registry.bind(bindName, remoteService);
                }
            }
            catch (ClassCastException e) {
                throw new ServiceException(e, RB.getStringResource("RMIDeployableService.unableToDeployRMIService.ex.txt"));
            }
            catch (AlreadyBoundException e) {
                if (hasInstantiatedService) {
                    this.destroyService(logger);
                }
                throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.exceptionAlreadyBound.ex.fmt.txt", (Object)this._deployedService, (Object)bindName));
            }
            catch (ServiceException e) {
                if (hasInstantiatedService) {
                    this.destroyService(logger);
                }
                throw e;
            }
            catch (RemoteException e) {
                if (hasInstantiatedService) {
                    this.destroyService(logger);
                }
                throw new ServiceException(e, RB.getStringResource("RMIDeployableService.unableToDeployRMIService.ex.txt"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void destroyService(Logger logger) {
        if (this._deployedService != null) {
            Serializable exception = null;
            try {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIDeployableService.destroyService.ex.fmt.txt", (Object)this._deployedService.getClass().getName()));
                }
                this._deployedService.destroy();
            }
            catch (ServiceException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                this._deployedService = null;
                if (exception != null && logger != null) {
                    logger.error((Object)exception);
                }
            }
        }
    }

    @Override
    public String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        StringBuilder buffer = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"RMIDeployableService.RMIDeployableServiceNewLine.fmt.txt", (Object)super.toString(), (Object)lineSeparator));
        if (this._rmiBindings != null) {
            if (this._rmiBindings.size() > 0) {
                for (RMIBinding rmiBinding : this._rmiBindings) {
                    buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.bindNameNewLine.fmt.txt", (Object)rmiBinding, (Object)lineSeparator));
                }
            } else {
                buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"RMIDeployableService.noBindingsSpecified.fmt.txt", (Object)lineSeparator));
            }
        }
        buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.closingBraceNewLine.fmt.txt", (Object)lineSeparator));
        return buffer.toString();
    }
}

