/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ActivatableWrapper;
import com.sas.services.deployment.DeployInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.security.AccessController;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class RMIBinding
implements DeployInterface,
Serializable {
    private static final long serialVersionUID = 1451216734494895240L;
    private static final Logger LOGGER = LogManager.getLogger(RMIBinding.class);
    public static final String LOCALHOST = "localhost";
    public static final String BINDING_TYPE_BIND = "RMI_BIND";
    public static final String BINDING_TYPE_REBIND = "RMI_REBIND";
    public static final String BINDING_TYPE_LOOKUP = "RMI_LOOKUP";
    public static final short RMI_BINDING_INVALID = -1;
    public static final short RMI_BINDING_BIND = 0;
    public static final short RMI_BINDING_REBIND = 1;
    public static final short RMI_BINDING_LOOKUP = 2;
    private String _bindName;
    private boolean _registerWithRMI;
    private short _bindingType = (short)-1;
    private RMIConfiguration _rmiConfiguration;
    private transient ActivatableWrapper _activatableWrapper;
    private transient Remote _remoteObject;

    public RMIBinding(RMIConfiguration rmiConfiguration, String bindName, short binding) throws ServiceException {
        this.setRMIConfiguration(rmiConfiguration);
        this.setBindName(bindName);
        this.setBinding(binding);
    }

    public static short getBinding(String bindingType) {
        int binding = -1;
        if (bindingType != null) {
            if (BINDING_TYPE_REBIND.equals(bindingType)) {
                binding = 1;
            } else if (BINDING_TYPE_BIND.equals(bindingType)) {
                binding = 0;
            } else if (BINDING_TYPE_LOOKUP.equals(bindingType)) {
                binding = 2;
            }
        }
        return (short)binding;
    }

    public void setBinding(short bindingType) throws ServiceException {
        ServiceException serviceException = null;
        switch (bindingType) {
            case 0: 
            case 1: 
            case 2: {
                this._bindingType = bindingType;
                break;
            }
            default: {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.invalidBindingType.ex.fmt.txt", (Object)bindingType);
                serviceException = new ServiceException(msg);
            }
        }
        if (serviceException != null) {
            throw serviceException;
        }
    }

    public String getBindName() {
        if (this._bindName == null) {
            this._bindName = "";
        }
        return this._bindName;
    }

    public void setBindName(String bindName) {
        this._bindName = bindName;
    }

    public boolean isRegisterWithRMI() {
        return this._registerWithRMI;
    }

    public boolean isRebind() {
        return this._bindingType == 1;
    }

    public boolean isBind() {
        return this._bindingType == 0;
    }

    public boolean isNamingLookup() {
        return this._bindingType == 2;
    }

    public void setRegisterWithRMI(boolean registerWithRMI) {
        this._registerWithRMI = registerWithRMI;
    }

    public RMIConfiguration getRMIConfiguration() {
        if (this._rmiConfiguration == null) {
            this._rmiConfiguration = new RMIConfiguration();
        }
        return this._rmiConfiguration;
    }

    public void setRMIConfiguration(RMIConfiguration rmiConfiguration) {
        this._rmiConfiguration = rmiConfiguration;
    }

    public boolean isActivatable() {
        boolean isActivatable = false;
        if (this._activatableWrapper != null) {
            isActivatable = true;
        }
        return isActivatable;
    }

    public ActivatableWrapper getActivatable() {
        return this._activatableWrapper;
    }

    public void setActivatable(ActivatableWrapper activatableWrapper) {
        this._activatableWrapper = activatableWrapper;
    }

    public Remote getRemoteObject() {
        return this._remoteObject;
    }

    public void setRemoteObject(Remote remoteObject) {
        this._remoteObject = remoteObject;
    }

    public String getUrl() {
        String url = "";
        if (this._rmiConfiguration != null) {
            url = this._rmiConfiguration.getUrl(this._bindName);
        }
        return url;
    }

    /*
     * Exception decompiling
     */
    @Override
    public RemoteServiceInterface deploy() throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean isValidBindingType(String bindingType) {
        return bindingType != null && (BINDING_TYPE_BIND.equals(bindingType) || BINDING_TYPE_REBIND.equals(bindingType) || BINDING_TYPE_LOOKUP.equals(bindingType));
    }

    public String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        StringBuilder buffer = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.RMIBinding.fmt.txt", (Object)lineSeparator, (Object)lineSeparator, (Object)this.getRMIConfiguration(), (Object)lineSeparator));
        String bindName = Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.bindName.fmt.txt", (Object)this.getBindName());
        buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.bindNameNewLine.fmt.txt", (Object)bindName, (Object)lineSeparator));
        if (this._activatableWrapper != null) {
            buffer.append(RB.getStringResource("RMIBinding.activatable.txt"));
            buffer.append(": ");
            try {
                buffer.append(this._activatableWrapper.getMarshalledDataObject().getClass().getName());
                buffer.append(lineSeparator);
            }
            catch (ServiceException e) {
                buffer.append(RB.getStringResource("RMIBinding.None.txt"));
                buffer.append(lineSeparator);
            }
            buffer.append(Message.format((String)RB.getStringResource("RMIBinding.activatableWrapper.fmt.txt"), (Object)this._activatableWrapper));
        } else if (this._remoteObject != null) {
            buffer.append(Message.format((String)"RMIBinding.remoteObject.fmt.txt", (Object)this._remoteObject));
        } else {
            buffer.append(RB.getStringResource("RMIBinding.remoteObjectFromRegistry.fmt.txt"));
            buffer.append(lineSeparator);
        }
        buffer.append('}');
        buffer.append(lineSeparator);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        if (this._bindName != null && this._rmiConfiguration != null) {
            boolean isDebugLogEnabled = LOGGER.isDebugEnabled();
            Serializable exception = null;
            try {
                Registry rmiRegistry = this._rmiConfiguration.getRMIRegistry(false);
                Remote remote = rmiRegistry.lookup(this._bindName);
                if (remote != null) {
                    rmiRegistry.unbind(this._bindName);
                    if (isDebugLogEnabled) {
                        LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.unboundName.fmt.txt", (Object)this._bindName));
                    }
                }
            }
            catch (NotBoundException e) {
                if (isDebugLogEnabled) {
                    LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.unboundName.fmt.txt", (Object)this._bindName), (Throwable)e);
                }
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                if (exception != null) {
                    LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"RMIBinding.unbindFailed.ex.fmt.txt", (Object)this._bindName), (Throwable)exception);
                }
            }
        }
    }
}

