/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.XMLUtil;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRServiceConfigFactory;
import com.sas.services.deployment.RB;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.IOUtil;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;

@SASScope(value="ALL")
@SubjectToChange
public final class OMRMetadataSource
extends AbstractMetadataSource
implements MetadataSourceInterface {
    private static final int METADATA_ID_DOT_INDEX = 8;
    private static final long serialVersionUID = 1388334401615764532L;
    public static final short TEMPLATE_ALL_SERVICES = 0;
    public static final short TEMPLATE_REMOTE_DISCOVERY_SERVICES = 1;
    private static final int REPOSITORY_ID_LENGTH = 17;
    private static final String XMLTEMPLATE_SERVICES = "XMLTemplate_SoftwareComponent_WithUsingComponents.xml";
    private static final String XMLTEMPLATE_REMOTEDISCOVERYSERVICES = "XMLTemplate_SoftwareComponent_RemoteDiscoveryServices.xml";
    private static final int XML_FLAGS = 2948;
    private String _serverHost;
    private String _serverPort;
    private transient String _logonIdentity;
    private transient String _logonIdentityPasswordEncrypted;
    private String _repositoryName;
    private String _repositoryId;
    private transient Environment _environment;
    private transient boolean _isUsingOMI;
    private String _secSPN;
    private String _secPackageList;

    OMRMetadataSource(String omrHost, String omrPort, String omrIdentity, String omrIdentityPassword, String repositoryNameOrID) throws InitializationException {
        this.init(omrHost, omrPort, omrIdentity, omrIdentityPassword, repositoryNameOrID);
    }

    public OMRMetadataSource(String omrHost, String omrPort, String omrIdentity, String omrIdentityPassword, String repositoryName, String softwareComponentName) throws InitializationException {
        this(omrHost, omrPort, omrIdentity, omrIdentityPassword, repositoryName, softwareComponentName, new HashSet<String>(0));
    }

    public OMRMetadataSource(String omrHost, String omrPort, String omrIdentity, String omrIdentityPassword, String repositoryNameOrID, String softwareComponentName, String serviceGroupName) throws InitializationException {
        super(softwareComponentName, serviceGroupName);
        this.init(omrHost, omrPort, omrIdentity, omrIdentityPassword, repositoryNameOrID);
    }

    public OMRMetadataSource(String omrHost, String omrPort, String omrIdentity, String omrIdentityPassword, String repositoryNameOrID, String softwareComponentName, Set<String> serviceGroupNames) throws InitializationException {
        super(softwareComponentName, serviceGroupNames);
        this.init(omrHost, omrPort, omrIdentity, omrIdentityPassword, repositoryNameOrID);
    }

    public OMRMetadataSource(String omrHost, String omrPort, String omrIdentity, String omrIdentityPassword, String repositoryNameOrID, String softwareComponentName, Set<String> serviceGroupNames, Environment environment) throws InitializationException {
        super(softwareComponentName, serviceGroupNames);
        this._environment = environment;
        this.init(omrHost, omrPort, omrIdentity, omrIdentityPassword, repositoryNameOrID);
    }

    public OMRMetadataSource(String repositoryNameOrID, String softwareComponentName, Set<String> serviceGroupNames, String omrHost, String omrPort, String secSPN, String secPackageList, Environment environment) throws ServiceException {
        super(softwareComponentName, serviceGroupNames);
        this._environment = environment;
        this._secSPN = secSPN;
        this._secPackageList = secPackageList;
        this.setHost(omrHost);
        this.setPort(omrPort);
        this.openMetadataServerConnectionUsingSingleSignOn(omrHost, omrPort, repositoryNameOrID, this._secSPN, this._secPackageList, this._environment);
    }

    public OMRMetadataSource(IOMI omi, String repositoryNameOrID, String softwareComponentName, Set<String> serviceGroupNames, Environment environment) throws InitializationException {
        super(softwareComponentName, serviceGroupNames);
        this._environment = environment;
        this.init(omi, repositoryNameOrID);
    }

    private void init(String omrHost, String omrPort, String omrIdentity, String omrIdentityPassword, String repositoryNameOrID) throws InitializationException {
        this.setHost(omrHost);
        this.setPort(omrPort);
        this._logonIdentity = omrIdentity == null ? "" : omrIdentity;
        this._logonIdentityPasswordEncrypted = omrIdentityPassword == null ? "" : omrIdentityPassword;
        try {
            this.openMetadataServerConnection(this._serverHost, this._serverPort, repositoryNameOrID, this._logonIdentity, this._logonIdentityPasswordEncrypted, this._environment);
        }
        catch (InitializationException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw new InitializationException((Throwable)((Object)e), Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.unableToObtainOMRConnection.ex.fmt.txt", (Object)this._serverHost, (Object)this._serverPort));
        }
    }

    private void setHost(String omrHost) throws InitializationException {
        OMRMetadataSource.validateOmrHost(omrHost);
        this._serverHost = omrHost;
    }

    private void setPort(String omrPort) throws InitializationException {
        OMRMetadataSource.validateOmrPort(omrPort);
        this._serverPort = omrPort;
    }

    private void init(IOMI omi, String repositoryNameOrID) throws InitializationException {
        try {
            this.setFactoryConnection(omi);
        }
        catch (InitializationException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw new InitializationException((Throwable)((Object)e), RB.getStringResource("OMRMetadataSource.unableToObtainOMRConnection.ex.txt"));
        }
        this.setRepository(repositoryNameOrID);
    }

    private void setRepository(String repositoryNameOrID) throws InitializationException {
        if (repositoryNameOrID == null || repositoryNameOrID.length() == 0) {
            this.setFoundationRepository();
        } else if (repositoryNameOrID.length() == 17 && repositoryNameOrID.charAt(8) == '.') {
            this._repositoryName = this.getRepositoryName(repositoryNameOrID);
            this._repositoryId = repositoryNameOrID;
        } else {
            this._repositoryId = this.getRepositoryID(repositoryNameOrID);
            this._repositoryName = repositoryNameOrID;
        }
    }

    private void setFoundationRepository() throws InitializationException {
        block7: {
            Throwable exception = null;
            try {
                CMetadata foundation = this.getMdFactory().getOMIUtil().getFoundationRepository();
                this._repositoryId = foundation.getFQID();
                this._repositoryName = foundation.getName();
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (null == exception) break block7;
                throw new InitializationException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.unableToObtainMetadataFromOMR.ex.fmt.txt", (Object)exception.getMessage()));
            }
        }
    }

    public String getRepositoryId() {
        return this._repositoryId;
    }

    private static void validateOmrHost(String omrHost) throws InitializationException {
        if (omrHost == null || omrHost.trim().length() == 0) {
            throw new InitializationException(RB.getStringResource("OMRMetadataSource.mustSpecifyAnOmrHost.ex.txt"));
        }
    }

    private static void validateOmrPort(String omrPort) throws InitializationException {
        if (omrPort == null) {
            throw new InitializationException(RB.getStringResource("MetadataSourceFactory.omrPortMustBeSpecified.ex.txt"));
        }
        try {
            Integer.parseInt(omrPort);
        }
        catch (NumberFormatException e) {
            throw new InitializationException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.mustSpecifyNumberForOmrPort.ex.fmt.txt", (Object)omrPort));
        }
    }

    private static String getTemplate(short templateType) {
        String template = XMLTEMPLATE_SERVICES;
        switch (templateType) {
            case 0: {
                template = XMLTEMPLATE_SERVICES;
                break;
            }
            case 1: {
                template = XMLTEMPLATE_REMOTEDISCOVERYSERVICES;
                break;
            }
        }
        return template;
    }

    String getMetadataToLocateRemoteDiscoveryServices() throws ServiceException {
        return this.getMetadata(OMRMetadataSource.getTemplate((short)1));
    }

    String getMetadataToDeployServices() throws ServiceException {
        return this.getMetadata(OMRMetadataSource.getTemplate((short)0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMetadata(String xmlTemplateFileName) throws ServiceException {
        String metadataXml;
        block12: {
            Logger logger = LogManager.getLogger(OMRMetadataSource.class);
            Logger loggerOMI = LogManager.getLogger((String)"com.sas.services.deployment.omi");
            metadataXml = null;
            Throwable exception = null;
            try {
                MdOMRConnection mdOMRConnection;
                IOMI omi;
                long startTime = System.currentTimeMillis();
                MdFactory mdFactory = this.getMdFactory();
                StringHolder outxmlHolder = new StringHolder();
                String softwareComponentName = this.getSoftwareComponentName();
                String xmlSelect = "<XMLSelect Search=\"*" + OMRMetadataSource.getXMLSelect(softwareComponentName) + "\"/>" + OMRMetadataSource.getXMLTemplateFromFile(xmlTemplateFileName);
                String inXml = "<GetMetadataObjects><ReposId>" + this._repositoryId + "</ReposId><Type>" + "SoftwareComponent" + "</Type><Objects/><ns>SAS</ns><Flags>" + 2948 + "</Flags><Options>" + xmlSelect + "</Options></GetMetadataObjects>";
                String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
                boolean isDebugLogOMIEnabled = loggerOMI.isDebugEnabled();
                if (isDebugLogOMIEnabled) {
                    loggerOMI.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.xmlSelectTemplate.fmt.txt", (Object)lineSeparator, (Object)XMLUtil.formatXML((String)inXml)));
                }
                if ((omi = (mdOMRConnection = mdFactory.getConnection()).getCMRHandle()) == null) {
                    throw new ServiceException(RB.getStringResource("OMRMetadataSource.nullIOMI.ex.txt"));
                }
                int omiReturnCode = omi.DoRequest(inXml, outxmlHolder);
                if (omiReturnCode != 0) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.omiDoRequestFailed.ex.fmt.txt", (Object)omiReturnCode));
                }
                metadataXml = outxmlHolder.value;
                metadataXml = OMRServiceConfigFactory.transformGetMetadataObjects(metadataXml);
                if (isDebugLogOMIEnabled) {
                    loggerOMI.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.queryingOmrTookMsec.fmt.txt", (Object)this._repositoryId, (Object)(System.currentTimeMillis() - startTime), (Object)XMLUtil.formatXML((String)metadataXml)));
                }
            }
            catch (ServiceException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)((Object)e));
                throw e;
            }
            catch (GenericError e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block12;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.unableToObtainMetadataFromOMR.ex.fmt.txt", (Object)"");
                logger.error(msg, exception);
                throw new ServiceException(exception, msg);
            }
        }
        return metadataXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRepositoryID(String repositoryName) throws InitializationException {
        String theRepositoryID;
        block13: {
            theRepositoryID = null;
            Object exception = null;
            try {
                MdFactory mdFactory = this.getMdFactory();
                MdOMIUtil mdOMIUtil = mdFactory.getOMIUtil();
                if (mdOMIUtil == null) {
                    throw new IllegalArgumentException(RB.getStringResource("OMRMetadataSource.nullOMIUtil.ex.txt"));
                }
                for (CMetadata cMetadata : mdOMIUtil.getRepositories()) {
                    if (!Strings.equal((String)repositoryName, (String)cMetadata.getName(), (boolean)false, (boolean)false)) continue;
                    theRepositoryID = cMetadata.getFQID();
                    break;
                }
                if (theRepositoryID == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.invalidRepositoryName.ex.fmt.txt", (Object)repositoryName, (Object)this._serverHost, (Object)this._serverPort));
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (InitializationException e) {
                throw e;
            }
            catch (ServiceException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block13;
                throw new InitializationException((Throwable)exception, Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.repositoryName.ex.fmt.txt", (Object)repositoryName));
            }
        }
        return theRepositoryID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRepositoryName(String repositoryID) throws InitializationException {
        String theRepositoryName;
        block13: {
            theRepositoryName = null;
            Object exception = null;
            try {
                MdFactory mdFactory = this.getMdFactory();
                MdOMIUtil mdOMIUtil = mdFactory.getOMIUtil();
                if (mdOMIUtil == null) {
                    throw new IllegalArgumentException(RB.getStringResource("OMRMetadataSource.nullOMIUtil.ex.txt"));
                }
                for (CMetadata cMetadata : mdOMIUtil.getRepositories()) {
                    if (!Strings.equal((String)repositoryID, (String)cMetadata.getFQID(), (boolean)false, (boolean)false)) continue;
                    theRepositoryName = cMetadata.getName();
                    break;
                }
                if (theRepositoryName == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.invalidRepositoryID.ex.fmt.txt", (Object)repositoryID, (Object)this._serverHost, (Object)this._serverPort));
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (InitializationException e) {
                throw e;
            }
            catch (ServiceException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block13;
                throw new InitializationException((Throwable)exception, Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.getRepositoryName.ex.fmt.txt", (Object)repositoryID));
            }
        }
        return theRepositoryName;
    }

    @Override
    public String getMetadata() throws ServiceException {
        return this.getMetadata(OMRMetadataSource.getTemplate((short)0));
    }

    private static String getXMLSelect(String softwareComponentName) {
        return softwareComponentName == null ? "[@ClassIdentifier='ABC1234567890']" : "[@ClassIdentifier='ABC1234567890' and @Name='" + softwareComponentName + "']";
    }

    private static String getXMLTemplateFromFile(final String fileName) throws ServiceException {
        String xmlString = null;
        try {
            xmlString = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws ServiceException {
                    return IOUtil.getStringFromResourceUsingEncoding(OMRMetadataSource.class, fileName, "utf-8");
                }
            });
            xmlString = com.sas.services.util.XMLUtil.stripXMLDeclaration(xmlString);
        }
        catch (ClassCastException e) {
            throw new ServiceException(e);
        }
        catch (PrivilegedActionException pae) {
            Exception paeException = pae.getException();
            try {
                throw (ServiceException)((Object)paeException);
            }
            catch (ClassCastException cce) {
                throw new ServiceException(paeException);
            }
        }
        if (xmlString == null) {
            xmlString = "";
        }
        return xmlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMetadataServerConnection(String omrHost, String omrPort, String repositoryNameOrID, String omrIdentity, String omrIdentityPasswordEncoded, Environment environment) throws ServiceException {
        Throwable exception = null;
        MdFactory mdFactory = this.getMdFactory();
        try {
            MdOMRConnection mdConnection = mdFactory.getConnection();
            mdConnection.setConnectionResources((ConnectionResources)environment);
            mdConnection.makeOMRConnection(omrHost, omrPort, omrIdentity, omrIdentityPasswordEncoded);
            this.setRepository(repositoryNameOrID);
        }
        catch (MdException e) {
            exception = e;
        }
        catch (RemoteException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                try {
                    mdFactory.dispose();
                }
                catch (RemoteException e) {
                    OMRMetadataSource.handleConnectionCloseException(e);
                }
                this.handleOMRConnectionFailure((Exception)exception, omrHost, omrPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMetadataServerConnectionUsingSingleSignOn(String omrHost, String omrPort, String repositoryNameOrID, String secSPN, String secPackageList, Environment environment) throws ServiceException {
        Throwable exception = null;
        MdOMRConnection mdConnection = null;
        try {
            MdFactory mdFactory = this.getMdFactory();
            mdConnection = mdFactory.getConnection();
            mdConnection.setConnectionResources((ConnectionResources)environment);
            mdConnection.makeOMRConnectionUsingSecurityPackage(omrHost, omrPort, secPackageList, secSPN);
            this.setRepository(repositoryNameOrID);
        }
        catch (MdException e) {
            exception = e;
        }
        catch (RemoteException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                this.handleOMRConnectionFailure((Exception)exception, omrHost, omrPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFactoryConnection(IOMI omi) throws ServiceException {
        RemoteException exception = null;
        try {
            MdFactory mdFactory = this.getMdFactory();
            MdOMRConnection mdConnection = mdFactory.getConnection();
            mdConnection.setConnectionResources((ConnectionResources)this._environment);
            mdConnection.setCMRHandle(omi);
            this._isUsingOMI = true;
        }
        catch (RemoteException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                this.handleOMRConnectionFailure(exception, null, null);
            }
        }
    }

    @Override
    public void destroy() {
        try {
            if (this._isUsingOMI) {
                MdFactory mdFactory = this.getMdFactory();
                MdOMRConnection mdConnection = mdFactory.getConnection();
                mdConnection.setCMRHandle(null);
            }
        }
        catch (RemoteException e) {
            LogManager.getLogger(OMRMetadataSource.class).error(RB.getStringResource("OMRMetadataSource.setCMRHandle.ex.txt"), (Throwable)e);
        }
        finally {
            super.destroy();
        }
    }

    private void handleOMRConnectionFailure(Exception exception, String omrHost, String omrPort) throws ServiceException {
        String msg;
        String string = msg = omrHost != null && omrPort != null ? Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.unableToObtainOMRConnection.ex.fmt.txt", (Object)omrHost, (Object)omrPort) : RB.getStringResource("OMRMetadataSource.unableToObtainOMRConnection.ex.txt");
        if (exception != null) {
            LogManager.getLogger(OMRMetadataSource.class).error(msg, (Throwable)exception);
        }
        throw new ServiceException(exception, msg);
    }

    private static void handleConnectionCloseException(Exception exception) {
        LogManager.getLogger(OMRMetadataSource.class).error(RB.getStringResource("Connection.close.ex.txt"), (Throwable)exception);
    }

    @Override
    protected String getDeployFailureMessage() {
        return RB.getStringResource("ServiceLoader.unableToObtainServicesFromOMRMetadataSource.ex.txt");
    }

    @Override
    public String toString() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"OMRMetadataSource.toString.fmt.txt", (Object)AccessController.doPrivileged(new GetPropertyAction("line.separator")), (Object)super.toString(), (Object)this._serverHost, (Object)this._serverPort, (Object)this._repositoryName);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (this._serverHost != null) {
            hashCode ^= this._serverHost.hashCode();
        }
        if (this._serverPort != null) {
            hashCode ^= this._serverPort.hashCode();
        }
        if (this._repositoryId != null) {
            hashCode ^= this._repositoryId.hashCode();
        } else if (this._repositoryName != null) {
            hashCode ^= this._repositoryName.hashCode();
        }
        if (this._secSPN != null) {
            hashCode ^= this._secSPN.hashCode();
        }
        if (this._secPackageList != null) {
            hashCode ^= this._secPackageList.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other != null) {
            try {
                OMRMetadataSource another = (OMRMetadataSource)other;
                isEqual = Strings.equal((String)this._serverHost, (String)another._serverHost, (boolean)false, (boolean)false) && Strings.equal((String)this._serverPort, (String)another._serverPort, (boolean)false, (boolean)false) && Strings.equal((String)this._repositoryId, (String)another._repositoryId, (boolean)false, (boolean)false) && Strings.equal((String)this._secSPN, (String)another._secSPN, (boolean)false, (boolean)false) && Strings.equal((String)this._secPackageList, (String)another._secPackageList, (boolean)false, (boolean)false) && super.equals(other);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    private MdFactory getMdFactory() throws IllegalStateException {
        MdFactory mdFactory = null;
        RemoteException exception = null;
        try {
            mdFactory = this.getMdObjectStore().getFactory();
        }
        catch (RemoteException e) {
            exception = e;
        }
        if (mdFactory == null) {
            String msg = RB.getStringResource("OMRMetadataSource.noMdFactory.ex.txt");
            LogManager.getLogger(OMRMetadataSource.class).error(msg, (Throwable)exception);
            throw new IllegalStateException(msg);
        }
        return mdFactory;
    }
}

