/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.ThreadPool;
import com.sas.services.connection.ConnectionResources;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Environment
implements ConnectionResources,
Serializable {
    private static final long serialVersionUID = -1780200979728896006L;
    private transient SelectionHub _selectionHub;
    private transient ThreadPool _threadPool;
    private transient List<AppConfigurationEntry> _appConfigurationEntry;

    @SASScope
    public void setSelectionHub(SelectionHub selectionHub) {
        this._selectionHub = selectionHub;
    }

    @SASScope
    public SelectionHub getSelectionHub() {
        return this._selectionHub;
    }

    @SASScope
    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    @SASScope
    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppConfigurationEntry(AppConfigurationEntry[] appConfigurationEntry) {
        Environment environment = this;
        synchronized (environment) {
            if (appConfigurationEntry != null) {
                AppConfigurationEntry[] aceArr = (AppConfigurationEntry[])appConfigurationEntry.clone();
                List<AppConfigurationEntry> aceLst = Arrays.asList(aceArr);
                this._appConfigurationEntry = Collections.unmodifiableList(aceLst);
            } else {
                this._appConfigurationEntry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AppConfigurationEntry> getAppConfigurationEntry(String appConfigurationEntryName) {
        Environment environment = this;
        synchronized (environment) {
            if (this._appConfigurationEntry != null) {
                return this._appConfigurationEntry;
            }
        }
        PrivilegedAction<Configuration> action = new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                Configuration configuration = Configuration.getConfiguration();
                return configuration;
            }
        };
        Configuration configuration = AccessController.doPrivileged(action);
        AppConfigurationEntry[] aceArr = configuration.getAppConfigurationEntry(appConfigurationEntryName);
        List<AppConfigurationEntry> appConfigurationEntry = null;
        if (aceArr != null) {
            List<AppConfigurationEntry> aceLst = Arrays.asList(aceArr);
            appConfigurationEntry = Collections.unmodifiableList(aceLst);
        }
        return appConfigurationEntry;
    }

    @SASScope
    public final Timer createTimer() {
        Timer timer = this.spiCreateTimer();
        if (timer == null) {
            timer = new Timer(true);
        }
        return timer;
    }

    @SASScope
    protected Timer spiCreateTimer() {
        return null;
    }
}

