/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.ServiceFactoryInterface;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.MetadataSourceFactory;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class DeploymentService {
    private SoftwareComponent _softwareComponent;
    private Tree _tree;
    private ServiceComponent _serviceComponent;
    private Properties _properties = new Properties();
    private ServiceFactoryInterface _serviceFactory;
    private final Set<String> _treeNamesSet = new HashSet<String>(5);

    public DeploymentService(SoftwareComponent softwareComponent, Tree tree, ServiceComponent serviceComponent, Properties properties) throws ServiceException {
        try {
            String serviceFactoryClassName = serviceComponent != null ? serviceComponent.getFactoryClassName() : null;
            this._serviceFactory = AbstractServiceDeployment.getServiceFactory(serviceFactoryClassName);
            this._softwareComponent = softwareComponent;
            this._tree = tree;
            this._serviceComponent = serviceComponent;
            this.setProperties(properties);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    public SoftwareComponent getSoftwareComponent() {
        return this._softwareComponent;
    }

    public Tree getTree() {
        return this._tree;
    }

    public ServiceComponent getServiceComponent() {
        return this._serviceComponent;
    }

    public ServiceFactoryInterface getServiceFactory() {
        return this._serviceFactory;
    }

    public boolean isEnabled() throws MdException {
        boolean isEnabled = false;
        try {
            if (this._treeNamesSet.size() == 0) {
                isEnabled = true;
            } else if (this._treeNamesSet.contains(this._tree.getName())) {
                isEnabled = true;
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        return isEnabled;
    }

    private void setProperties(Properties properties) {
        if (properties != null) {
            this._properties.clear();
            this._properties.putAll((Map<?, ?>)properties);
            this._treeNamesSet.clear();
            String treeName = null;
            int maxNumGroups = MetadataSourceFactory.getMaxNumberOfGroups();
            for (int i = 1; i < maxNumGroups && (treeName = this._properties.getProperty(MetadataSourceFactory.getServiceGroupName(i))) != null; ++i) {
                this._treeNamesSet.add(treeName);
            }
        } else {
            this._properties.clear();
        }
    }
}

