/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.RB;
import com.sas.text.Message;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ConsumedResourceAdapter
implements Cloneable,
ConsumedResourceInterface {
    private String _id = GUID.newGUID();
    private String _value;
    private String _localizedType;
    private String _type;
    private int _typeCode;
    private boolean _isRequired;

    public ConsumedResourceAdapter(String id, String value, String type, int typeCode, String localizedType, boolean isRequired) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (localizedType == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (id != null && id.length() > 0) {
            this._id = id;
        }
        this._value = value;
        this._localizedType = localizedType;
        this._type = type;
        this._typeCode = typeCode;
        this._isRequired = isRequired;
    }

    @Override
    public String getResourceID() {
        return this._id;
    }

    @Override
    public String getResourceValue() {
        return this._value;
    }

    @Override
    public String getResourceType() {
        return this._type;
    }

    @Override
    public int getResourceTypeCode() {
        return this._typeCode;
    }

    @Override
    public String getLocalizedResourceType() {
        return this._localizedType;
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.consumedResource.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    public void setResourceValue(String value) {
        this._value = value;
    }

    @Override
    public boolean isRequired() {
        return this._isRequired;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

