/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeployment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class CLIOptionsConfig {
    public String getNameOfOptionIsPrompting() {
        return "isPrompting";
    }

    public Option createOptionIsPrompting() {
        Option option = new Option(this.getNameOfOptionIsPrompting(), true, RB.getStringResource("CLIOptionsConfig.isPrompting.txt"));
        option.setArgName(RB.getStringResource("CLI.booleanOptionArg.txt"));
        return option;
    }

    public static String getOptionValueFromSystemIn(String optionName, String promptMessage, String charsetName) throws ServiceException {
        String metaPass = null;
        BufferedReader reader = null;
        try {
            reader = charsetName == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(System.in, charsetName));
            for (int i = 0; i < 3; ++i) {
                String inData;
                if (promptMessage != null) {
                    System.out.print(promptMessage);
                }
                if ((inData = reader.readLine()) == null) {
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(inData.trim(), " ");
                    String token = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        token = stringTokenizer.nextToken();
                        if (!optionName.equals(token) || (token = stringTokenizer.nextToken()) == null || (token = token.trim()).length() <= 0) continue;
                        metaPass = token;
                        break;
                    }
                    if (metaPass == null) continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogManager.getLogger(ServiceDeployment.class).error(RB.getStringResource("IO.close.ex.txt"), (Throwable)e);
                }
            }
        }
        return metaPass;
    }
}

