/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.RB;
import com.sas.services.ServiceConfigDocument;
import com.sas.services.ServiceException;
import com.sas.services.ServiceFactoryInterface;
import com.sas.services.ServiceProfile;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceAggregateConfig {
    private ServiceFactoryInterface _serviceFactory;
    private final List<ServiceConfigDocument> _serviceConfigDocuments = new ArrayList<ServiceConfigDocument>(5);
    private ServiceComponent _serviceComponent;
    private Boolean _isBaseConfig;
    private ServiceConfigDocument _baseServiceConfigDocument;
    private final Map<Property, AbstractServiceComponentConfig> _propertyToConfigMap = new HashMap<Property, AbstractServiceComponentConfig>(5);
    private Property _propertyConfig;

    public ServiceAggregateConfig(ServiceComponent serviceComponent) throws IllegalArgumentException, ServiceException {
        this.setServiceComponent(serviceComponent);
    }

    public ServiceConfigDocument getBaseServiceConfig() {
        return this._baseServiceConfigDocument;
    }

    public AbstractServiceComponentConfig createAggregateConfig(boolean isIncludingBaseConfig, List<String> appConfigNames) throws ServiceException {
        AbstractServiceComponentConfig aggregatedConfig = null;
        ServiceConfigDocument serviceConfigDocument = null;
        if (isIncludingBaseConfig) {
            serviceConfigDocument = this.getBaseServiceConfig();
            aggregatedConfig = this._serviceFactory.getServiceProfile().createConfig(serviceConfigDocument.getConfigName(), serviceConfigDocument.getDocument());
        }
        if (appConfigNames.size() > 0) {
            AbstractServiceComponentConfig nextConfig = null;
            for (String appConfigName : appConfigNames) {
                serviceConfigDocument = this.getServiceConfigDocument(appConfigName);
                nextConfig = this._serviceFactory.getServiceProfile().createConfig(appConfigName, serviceConfigDocument.getDocument());
                if (aggregatedConfig == null) {
                    aggregatedConfig = nextConfig;
                    continue;
                }
                aggregatedConfig.mergeConfiguration(nextConfig);
            }
        }
        if (aggregatedConfig == null) {
            throw new ServiceException(RB.getStringResource("SAC.noConfigsFound.txt"));
        }
        return aggregatedConfig;
    }

    public List<ServiceConfigDocument> getServiceConfigDocuments(List<String> configNames) throws ServiceException {
        ArrayList<ServiceConfigDocument> list = new ArrayList<ServiceConfigDocument>(configNames.size());
        ServiceConfigDocument serviceConfigDocument = null;
        for (String configName : configNames) {
            serviceConfigDocument = this.getServiceConfigDocument(configName);
            if (serviceConfigDocument == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SAC.getServiceConfigForName.ex.fmt.txt", (Object)configName));
            }
            list.add(serviceConfigDocument);
        }
        return list;
    }

    public ServiceConfigDocument getServiceConfigDocument(String configName) throws ServiceException {
        ServiceConfigDocument serviceConfigDocument = null;
        for (ServiceConfigDocument nextServiceConfigDocument : this._serviceConfigDocuments) {
            if (!configName.equals(nextServiceConfigDocument.getConfigName())) continue;
            serviceConfigDocument = nextServiceConfigDocument;
            break;
        }
        return serviceConfigDocument;
    }

    private void setServiceComponent(ServiceComponent serviceComponent) throws ServiceException, IllegalArgumentException {
        if (serviceComponent == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceComponent.ex.txt"));
        }
        try {
            this.init();
            this._serviceComponent = serviceComponent;
            this.setServiceFactory(serviceComponent.getFactoryClassName());
            List<Property> properties = this.getServiceConfigProperties();
            if (properties.size() > 0) {
                Property property = properties.get(0);
                this._baseServiceConfigDocument = ServiceProfile.getServiceConfigDocument(property);
            }
            ServiceConfigDocument serviceConfigDocument = null;
            AbstractServiceComponentConfig serviceConfig = null;
            ServiceProfile serviceProfile = this._serviceFactory.getServiceProfile();
            for (Property property : properties) {
                serviceConfigDocument = ServiceProfile.getServiceConfigDocument(property);
                serviceConfig = serviceProfile.createServiceConfig(serviceConfigDocument);
                if (serviceConfig == null) continue;
                this._propertyToConfigMap.put(property, serviceConfig);
                this._serviceConfigDocuments.add(serviceConfigDocument);
            }
            this.setServiceConfigProperty(AbstractServiceComponentConfig.getServiceConfigProperty(serviceComponent));
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    public ServiceComponent getServiceComponent() {
        return this._serviceComponent;
    }

    public List<ServiceConfigDocument> getServiceConfigDocuments() {
        return new ArrayList<ServiceConfigDocument>(this._serviceConfigDocuments);
    }

    public Property getServiceConfigProperty() {
        return this._propertyConfig;
    }

    public void setServiceConfigProperty(Property serviceConfigProperty) throws ServiceException {
        this._propertyConfig = serviceConfigProperty;
        this._isBaseConfig = serviceConfigProperty == null ? null : Boolean.valueOf(AbstractServiceComponentConfig.isBaseConfig(serviceConfigProperty));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Property> getServiceConfigProperties() throws ServiceException {
        ArrayList<Property> list;
        block9: {
            list = null;
            Throwable exception = null;
            String serviceComponentName = null;
            try {
                serviceComponentName = this._serviceComponent.getName();
                AssociationList properties = this._serviceComponent.getProperties();
                list = new ArrayList<Property>(properties.size());
                for (Property property : properties) {
                    if (!"INIT_DATA".equals(property.getPropertyName()) || "Application Configuration".equals(property.getPropertyRole())) continue;
                    list.add(property);
                }
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block9;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"SAC.getServiceConfigProperties.ex.fmt.txt", (Object)serviceComponentName));
            }
        }
        if (list == null) {
            list = new ArrayList(0);
        }
        return list;
    }

    public String getConfigUserInterfaceClassName() throws ServiceException {
        return this._serviceFactory.getServiceProfile().getConfigUserInterfaceClassName();
    }

    public void setConfigName(String configName) throws MdException {
        if (configName == null) {
            throw new IllegalArgumentException();
        }
        try {
            this._propertyConfig.setName(configName);
            AbstractServiceComponentConfig serviceConfig = this._propertyToConfigMap.get(this._propertyConfig);
            if (serviceConfig != null) {
                serviceConfig.setConfigName(configName);
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    public String getConfigName() throws MdException {
        String configName = null;
        if (this._propertyConfig != null) {
            try {
                configName = Boolean.TRUE.equals(this._isBaseConfig) ? AbstractServiceComponentConfig.getBaseConfigName() : this._propertyConfig.getName();
            }
            catch (RemoteException e) {
                throw new MdException((Throwable)e);
            }
        }
        return configName;
    }

    public boolean isBaseConfig() {
        return Boolean.TRUE.equals(this._isBaseConfig);
    }

    public AbstractServiceComponentConfig getServiceConfig() {
        return this._propertyToConfigMap.get(this._propertyConfig);
    }

    public AbstractServiceComponentConfig getAggregateServiceConfig() throws ServiceException {
        AbstractServiceComponentConfig aggregateConfig = null;
        try {
            for (AbstractServiceComponentConfig nextConfig : this._propertyToConfigMap.values()) {
                if (aggregateConfig == null) {
                    aggregateConfig = (AbstractServiceComponentConfig)nextConfig.clone();
                    continue;
                }
                aggregateConfig.mergeConfiguration(nextConfig);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new ServiceException(e, RB.getStringResource("SAC.getAggregateConfig.ex.txt"));
        }
        return aggregateConfig;
    }

    public ServiceFactoryInterface getServiceFactory() {
        return this._serviceFactory;
    }

    private void setServiceFactory(String factoryClassName) throws ServiceException {
        if (factoryClassName != null && factoryClassName.length() > 0) {
            this._serviceFactory = AbstractServiceDeployment.getServiceFactory(factoryClassName);
        }
    }

    private void init() {
        this._serviceComponent = null;
        this._propertyConfig = null;
        this._serviceConfigDocuments.clear();
        this._propertyToConfigMap.clear();
    }
}

