/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.entities.EntityKeyInterface;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.InitializationException;
import com.sas.services.RB;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfiguration;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.deployment.DeploymentApplicationMonitor;
import com.sas.services.deployment.Environment;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceDiscoveryConfiguration;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.mgmt.ServiceEvent;
import com.sas.services.mgmt.ServiceNotificationBroadcaster;
import com.sas.services.mgmt.ServiceNotificationBroadcasterInterface;
import com.sas.services.mgmt.ServiceRemoteObserverInterface;
import com.sas.text.Message;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRemoteService
implements RemoteServiceInterface,
ServiceNotificationBroadcasterInterface {
    private ServiceConfigurationInterface _serviceConfiguration;
    private final ServiceState _serviceState = new ServiceState();
    private final EntityKeyInterface _entityKeyIf = new DefaultEntityKeyImpl();
    private transient ServiceNotificationBroadcasterInterface _notificationBroadcaster = new ServiceNotificationBroadcaster();
    private transient RemoteObjectExporterInterface _remoteableExporter;
    private boolean _isExported;
    private final long _creationTime = System.currentTimeMillis();
    private boolean _isHandlingJVMShutdown;
    private transient DiscoveryServiceInterface _discoveryService;
    private boolean _isBoundToDiscoveryService;
    private final Object _syncObject = new Object();

    public AbstractRemoteService() {
        this(DiscoveryService.defaultInstance());
    }

    public AbstractRemoteService(DiscoveryServiceInterface discoveryService) {
        this._discoveryService = discoveryService;
    }

    public DiscoveryServiceInterface getDiscoveryService() {
        return this._discoveryService;
    }

    public void bindToDiscoveryService() throws ServiceException {
        if (this._discoveryService != null) {
            try {
                this._discoveryService.addService(this);
                this._isBoundToDiscoveryService = true;
                Logger logger = LogManager.getLogger(AbstractRemoteService.class);
                if (logger.isDebugEnabled()) {
                    logger.debug(this._discoveryService.toString());
                }
            }
            catch (RemoteException e) {
                throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteService.bind.ex.fmt.txt", this.getClass()));
            }
        }
    }

    public void unbindFromDiscoveryService() throws ServiceException {
        if (this._isBoundToDiscoveryService && this._discoveryService != null) {
            try {
                this._discoveryService.removeService(this);
            }
            catch (RemoteException e) {
                throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteService.unbind.ex.fmt.txt", this.getClass()));
            }
            finally {
                this._isBoundToDiscoveryService = false;
            }
        }
    }

    public void setDiscoveryService(DiscoveryServiceInterface discoveryService) {
        this._discoveryService = discoveryService;
    }

    public void setRemoteableExporter(RemoteObjectExporterInterface remoteableExporter) throws IllegalStateException {
        this.verifyServiceNotDeactivated();
        this._remoteableExporter = remoteableExporter;
    }

    @Override
    public ServiceConfigurationInterface getServiceConfiguration() throws IllegalStateException {
        this.verifyServiceNotDeactivated();
        if (this._serviceConfiguration == null) {
            this._serviceConfiguration = new ServiceConfiguration();
        }
        return this._serviceConfiguration;
    }

    @Override
    public ServiceConfigurationInterface getServiceConfiguration(Object key) throws IllegalStateException {
        this.verifyServiceNotDeactivated();
        ServiceConfigurationInterface serviceConfiguration = this.getServiceConfiguration();
        ServiceConfigurationInterface configuration = null;
        if (key == null) {
            configuration = serviceConfiguration;
        } else if (serviceConfiguration != null) {
            configuration = serviceConfiguration.getServiceConfiguration(key);
        }
        return configuration;
    }

    private void setServiceConfiguration(ServiceConfigurationInterface serviceConfiguration) {
        this._serviceConfiguration = serviceConfiguration;
    }

    @Override
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws InitializationException, RemoteException, ServiceException {
        this.setServiceConfiguration(serviceConfiguration);
        ServiceDiscoveryConfigurationInterface svcDiscoveryConfig = (ServiceDiscoveryConfigurationInterface)((Object)serviceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY));
        if (svcDiscoveryConfig != null) {
            String entityID = this.getEntityKey();
            ServiceComponentAttribute sca = svcDiscoveryConfig.getServiceComponentAttribute();
            if (sca == null) {
                svcDiscoveryConfig.setServiceComponentAttribute(new ServiceComponentAttribute(this.getClass().getName(), null, entityID));
            } else {
                sca.runtimeId = entityID;
            }
            try {
                if (this._remoteableExporter != null && svcDiscoveryConfig.isDelegateRegistrationEnabled()) {
                    this._remoteableExporter.exportObject();
                    this._isExported = true;
                }
            }
            catch (RemoteException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteService.unableToExportService.ex.fmt.txt", (Object)this.getClass().getName(), (Object)"");
                LogManager.getLogger(AbstractRemoteService.class).error(msg, (Throwable)e);
                throw new ServiceException(e, msg);
            }
        }
        if (this._serviceState != null) {
            this._serviceState.setServiceState((short)1);
        }
        DeploymentApplicationMonitor.log(this, DeploymentApplicationMonitor.ACTION_CONFIGURED);
    }

    @Override
    public void reconfigure(ServiceConfigurationInterface serviceConfiguration) throws ServiceException, RemoteException {
        this.setServiceConfiguration(serviceConfiguration);
    }

    public String getEntityKey() throws RemoteException, IllegalStateException {
        return this._entityKeyIf.getEntityKey();
    }

    public void setEntityKey(String entityKey) throws RemoteException, IllegalStateException {
        this._entityKeyIf.setEntityKey(entityKey);
    }

    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException, IllegalStateException {
        this.verifyServiceNotDeactivated();
        return this._entityKeyIf.sameEntity(entity);
    }

    @Override
    public short getServiceState() {
        return this._serviceState == null ? (short)0 : this._serviceState.getServiceState();
    }

    @Override
    public void setServiceState(ServiceState serviceState) throws ServiceException {
        if (serviceState == null) {
            throw new IllegalArgumentException(RB.getStringResource("AbstractRemoteService.specifyServiceState.ex.txt"));
        }
        this._serviceState.setServiceState(serviceState.getServiceState());
    }

    @Override
    public boolean isExported() throws IllegalStateException {
        this.verifyServiceInitialized();
        return this._isExported;
    }

    @Override
    public boolean isAccessibleToRemoteClients() throws IllegalStateException {
        ServiceConfigurationInterface serviceDiscoveryConfig;
        this.verifyServiceInitialized();
        boolean isAccesibleToRemoteClients = false;
        if (this._serviceConfiguration != null && (serviceDiscoveryConfig = this._serviceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY)) != null && serviceDiscoveryConfig instanceof ServiceDiscoveryConfigurationInterface) {
            isAccesibleToRemoteClients = ((ServiceDiscoveryConfigurationInterface)((Object)serviceDiscoveryConfig)).isDelegateRegistrationEnabled();
        }
        return isAccesibleToRemoteClients;
    }

    public void handleJVMShutdown() throws ServiceException {
        this._isHandlingJVMShutdown = true;
        try {
            this.destroy();
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("AbstractRemoteService.handleJVMShutdown.ex.txt"));
        }
    }

    public final boolean isHandlingJVMShutdown() {
        return this._isHandlingJVMShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws RemoteException, ServiceException {
        Object object = this._syncObject;
        synchronized (object) {
            if (this._serviceState != null && !ServiceState.isStateDeactivated(this._serviceState.getServiceState())) {
                if (this._isBoundToDiscoveryService) {
                    try {
                        this.unbindFromDiscoveryService();
                    }
                    catch (ServiceException e) {
                        LogManager.getLogger(AbstractRemoteService.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteService.destroyUnbind.ex.fmt.txt", this.getClass()), (Throwable)((Object)e));
                    }
                }
                try {
                    try {
                        ServiceConfigurationInterface config = this.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY);
                        if (config != null) {
                            ServiceDiscoveryConfiguration sdc = (ServiceDiscoveryConfiguration)config;
                            sdc.destroy();
                        }
                        if (this._remoteableExporter != null && this._remoteableExporter.unexportObject()) {
                            this._isExported = false;
                        }
                    }
                    catch (NoSuchObjectException e) {
                        String cause = e.getLocalizedMessage();
                        if (cause == null) {
                            cause = "";
                        }
                        throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteService.destroy.ex.fmt.txt", (Object)this.getClass().getName(), (Object)cause));
                    }
                    this.removeRegisteredListeners();
                    DeploymentApplicationMonitor.log(this, DeploymentApplicationMonitor.ACTION_TERMINATED);
                }
                finally {
                    this._serviceConfiguration = null;
                    this._serviceState.setServiceState((short)2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void removeRegisteredListeners() {
        if (this._notificationBroadcaster == null) return;
        ServiceEvent serviceEvent = null;
        try {
            serviceEvent = new ServiceEvent("sas.java.service.destroyed", this.getEntityKey(), RB.getStringResource("AbstractRemoteService.serviceDestroyed.txt"), null);
            this._notificationBroadcaster.notifyServiceObservers(serviceEvent);
            return;
        }
        catch (IllegalArgumentException e) {
            LogManager.getLogger(AbstractRemoteService.class).error(RB.getStringResource("AbstractRemoteService.createServiceEvent.ex.log"), (Throwable)e);
            return;
        }
        catch (RemoteException e) {
            LogManager.getLogger(AbstractRemoteService.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteService.fireServiceEvent.ex.fmt.log", serviceEvent), (Throwable)e);
            return;
        }
        finally {
            try {
                this._notificationBroadcaster.removeAllServiceObservers();
            }
            catch (RemoteException e) {
                LogManager.getLogger(AbstractRemoteService.class).error(RB.getStringResource("AbstractRemoteService.removeServiceEventObservers.ex.log"), (Throwable)e);
            }
            finally {
                this._notificationBroadcaster = null;
            }
        }
    }

    @Override
    public final void addServiceObserver(ServiceRemoteObserverInterface serviceObserver) throws RemoteException, IllegalStateException {
        this.verifyServiceInitialized();
        if (this._notificationBroadcaster != null) {
            this._notificationBroadcaster.addServiceObserver(serviceObserver);
        }
    }

    @Override
    public final void removeServiceObserver(ServiceRemoteObserverInterface serviceObserver) throws RemoteException {
        if (this._notificationBroadcaster != null) {
            this._notificationBroadcaster.removeServiceObserver(serviceObserver);
        }
    }

    @Override
    public final void removeAllServiceObservers() throws RemoteException {
        if (this._notificationBroadcaster != null) {
            this._notificationBroadcaster.removeAllServiceObservers();
        }
    }

    @Override
    public final void notifyServiceObservers(ServiceEvent serviceEvent) throws RemoteException, IllegalArgumentException {
        this._notificationBroadcaster.notifyServiceObservers(serviceEvent);
    }

    @Override
    public final long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public RemoteServiceInterface getServiceProxy() throws IllegalStateException {
        this.verifyServiceInitialized();
        return null;
    }

    public String getDetails() {
        return this.toString();
    }

    public String toString() {
        String value = super.toString();
        try {
            value = value + Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteServices.entry.fmt.txt", (Object)this._entityKeyIf.getEntityKey());
        }
        catch (RemoteException e) {
            LogManager.getLogger(AbstractRemoteService.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteService.getEntityKey.ex.fmt.log", (Object)this.getClass().getName()), (Throwable)e);
        }
        return value;
    }

    protected final Environment getEnvironment() {
        this.verifyServiceInitialized();
        return this._serviceConfiguration.getEnvironment();
    }

    private final void verifyServiceNotDeactivated() throws IllegalStateException {
        if (ServiceState.isStateDeactivated(this._serviceState.getServiceState())) {
            Logger logger = LogManager.getLogger(AbstractRemoteService.class);
            if (logger.isDebugEnabled()) {
                String id = null;
                if (null != this._entityKeyIf) {
                    try {
                        id = this._entityKeyIf.getEntityKey();
                    }
                    catch (RemoteException e) {
                        id = "";
                    }
                }
                logger.debug(this.getClass().getName() + "[ID=" + id + "][state=" + this._serviceState.getServiceState() + ']');
            }
            throw new IllegalStateException(RB.getStringResource("AbstractRemoteService.serviceDestroyed.txt"));
        }
    }

    private final void verifyServiceInitialized() throws IllegalStateException {
        short state = this._serviceState.getServiceState();
        if (!ServiceState.isStateInitialized(state)) {
            if (ServiceState.isStateDeactivated(state)) {
                throw new IllegalStateException(RB.getStringResource("AbstractRemoteService.serviceDestroyed.txt"));
            }
            if (ServiceState.isStateUninitialized(state)) {
                throw new IllegalStateException(RB.getStringResource("AbstractRemoteService.serviceUninitialized.txt"));
            }
        }
    }
}

