/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dmv.relationship.ox;

import com.sas.dmv.relationship.ox.Direction;
import com.sas.dmv.relationship.ox.RelationshipAttribute;
import com.sas.dmv.relationship.ox.RelationshipModel;
import com.sas.dmv.relationship.ox.RelationshipModelTracker;
import com.sas.dmv.relationship.ox.RelationshipModels;
import com.sas.dmv.relationship.ox.RelationshipNode;
import com.sas.dmv.relationship.ox.RelationshipObjectFactory;
import com.sas.dmv.relationship.ox.RelationshipType;
import com.sas.dmv.relationship.ox.Resource;
import com.sas.dmv.relationship.ox.ResourceAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RelationshipWorkUnit {
    Logger _logger = LoggerFactory.getLogger(this.getClass());
    RelationshipModels _models = null;
    Map<String, RelationshipModelTracker> _trackedModels = new HashMap<String, RelationshipModelTracker>();
    Map<String, Resource> _resources = new HashMap<String, Resource>();
    RelationshipObjectFactory _factory = null;
    ApplicationContext _context = new ClassPathXmlApplicationContext("/META-INF/dfx-services-config.xml");

    public RelationshipWorkUnit() {
        if (null == this._context) {
            throw new RuntimeException("Unable to get spring context");
        }
        this._factory = (RelationshipObjectFactory)this._context.getBean("relationshipObjectFactory");
        if (null == this._factory) {
            throw new RuntimeException("Unable to initialize factory.");
        }
        this._models = this._factory.createRelationshipModels();
    }

    public RelationshipWorkUnit(RelationshipObjectFactory factory) {
        if (null == this._context) {
            throw new RuntimeException("Unable to get spring context");
        }
        this._factory = null == factory ? (RelationshipObjectFactory)this._context.getBean("relationshipObjectFactory") : factory;
        if (null == this._factory) {
            throw new RuntimeException("Unable to initialize factory.");
        }
        this._models = this._factory.createRelationshipModels();
    }

    public void clear() {
        this._models = this._factory.createRelationshipModels();
        this._resources.clear();
        this._trackedModels.clear();
    }

    public RelationshipObjectFactory getFactory() {
        return this._factory;
    }

    public RelationshipModels getRelationshipModels() {
        return this._models;
    }

    protected RelationshipModelTracker getResourceTracker(Resource res) {
        RelationshipModelTracker returnValue = null;
        String key = this.generateKey(res);
        if (key.length() == 0) {
            return returnValue;
        }
        returnValue = this._trackedModels.get(key);
        if (null == returnValue) {
            returnValue = this.createRelationshipModelTracker(key, res);
            this._trackedModels.put(key, returnValue);
        }
        return returnValue;
    }

    public Resource getResource(String id, String type) {
        Resource returnValue = null;
        String key = this.generateKey(id, type);
        if (key.length() == 0) {
            return returnValue;
        }
        returnValue = this._resources.get(key);
        if (null == returnValue) {
            returnValue = this._factory.createResource("", type, id);
            this._resources.put(key, returnValue);
        }
        return returnValue;
    }

    public boolean updateResource(Resource res, String newId, String newType, String newLabel) {
        boolean returnValue = false;
        if (res != null) {
            RelationshipModelTracker tracker;
            String key;
            String oldKey = this.generateKey(res.getId(), res.getType());
            if (newId != null && newId.length() > 0) {
                res.setId(newId);
            }
            if (newType != null && newType.length() > 0) {
                res.setType(newType);
            }
            if (newLabel != null && newLabel.length() > 0) {
                res.setLabel(newLabel);
            }
            if ((key = this.generateKey(newId, newType)).length() == 0) {
                return returnValue;
            }
            if (!key.equals(oldKey)) {
                this._resources.remove(oldKey);
                this._resources.put(key, res);
            }
            if ((tracker = this._trackedModels.get(oldKey)) != null) {
                this._trackedModels.remove(oldKey);
                this._trackedModels.put(key, tracker);
            }
        }
        return returnValue;
    }

    public List<Resource> getResourcesByType(String type) {
        ArrayList<Resource> returnValue = new ArrayList<Resource>();
        Set<String> keys = this._resources.keySet();
        for (String key : keys) {
            Resource res = this._resources.get(key);
            if (res == null || !res.getType().equals(type)) continue;
            returnValue.add(res);
        }
        return returnValue;
    }

    public List<Resource> getResources() {
        ArrayList<Resource> returnValue = new ArrayList<Resource>();
        Set<String> keys = this._resources.keySet();
        for (String key : keys) {
            Resource res = this._resources.get(key);
            if (res == null || returnValue.contains(res)) continue;
            returnValue.add(res);
        }
        return returnValue;
    }

    public List<RelationshipModelTracker> getRelationshipModelTrackers() {
        ArrayList<RelationshipModelTracker> returnValue = new ArrayList<RelationshipModelTracker>();
        Set<String> keys = this._trackedModels.keySet();
        for (String key : keys) {
            RelationshipModelTracker res = this._trackedModels.get(key);
            if (res == null || returnValue.contains(res)) continue;
            returnValue.add(res);
        }
        return returnValue;
    }

    public RelationshipModelTracker getRelationshipModelTrackerForResource(Resource res) {
        RelationshipModelTracker returnValue = null;
        returnValue = this.getResourceTracker(res);
        return returnValue;
    }

    public RelationshipNode getRelationshipNode(RelationshipModelTracker tracker, Resource res, RelationshipType type) {
        RelationshipNode returnValue = null;
        returnValue = this._factory.getRelationshipNodeFromModel(tracker.getRelationshipModel(), tracker.getRelationshipModel().getResource(), type, res);
        if (null == returnValue) {
            returnValue = this._factory.addRelationshipToModel(tracker.getRelationshipModel(), tracker.getResource(), type, res, Direction.DEPENDENT.intValue());
        }
        return returnValue;
    }

    public boolean addRelationshipAttribute(RelationshipNode node, String key, String value) {
        return this._factory.setRelationshipAttributeValue(node, key, value);
    }

    public boolean addResourceAttribute(Resource res, String key, String value) {
        return this._factory.setResourceAttributeValue(res, key, value);
    }

    private RelationshipModelTracker createRelationshipModelTracker(String key, Resource resource) {
        RelationshipModelTracker returnValue = null;
        RelationshipModel model = this._factory.getRelationshipModelForResource(this._models, resource);
        if (null == model) {
            model = this._factory.addRelationshipModel(this._models, resource);
        }
        model.setResource(resource);
        returnValue = new RelationshipModelTracker(model);
        return returnValue;
    }

    private String generateKey(Resource res) {
        String t = res.getType();
        String i = res.getId();
        return this.generateKey(i, t);
    }

    private String generateKey(String id, String type) {
        if (null == type && null == id) {
            return null;
        }
        if (null == type) {
            type = "";
        }
        if (null == id) {
            id = "";
        }
        return type + id;
    }

    protected RelationshipModelTracker getResourceTracker(String key, RelationshipModel res) {
        RelationshipModelTracker returnValue = null;
        if (key.length() == 0) {
            return returnValue;
        }
        returnValue = this._trackedModels.get(key);
        if (null == returnValue) {
            returnValue = this.createResourceTracker(key, res);
            this._trackedModels.put(key, returnValue);
        }
        return returnValue;
    }

    private RelationshipModelTracker createResourceTracker(String key, RelationshipModel model) {
        RelationshipModelTracker returnValue = null;
        returnValue = new RelationshipModelTracker(model);
        return returnValue;
    }

    public String serializeWorkUnit() {
        return this._factory.marshallRelationshipModelsToString(this._models);
    }

    public String serialzeRelationshipModel(RelationshipModel model) {
        return this._factory.marshallRelationshipModelToString(model);
    }

    public String getRelationshipAttribute(RelationshipNode node, String key) {
        return this._factory.getRelationshipAttributeValue(node, key);
    }

    public String getResourceAttributeValue(Resource res, String key) {
        return this._factory.getResourceAttributeValue(res, key);
    }

    public boolean importModels(RelationshipModels models) {
        boolean returnValue = true;
        if (null != models) {
            List<RelationshipModel> modelList = models.getRelationshipModel();
            if (null != modelList) {
                for (RelationshipModel model : modelList) {
                    Resource modelResource = model.getResource();
                    Resource localResource = this.getResource(modelResource.getId(), modelResource.getType());
                    RelationshipModelTracker tracker = this.getRelationshipModelTrackerForResource(localResource);
                    this.copyResourceAttributes(modelResource, tracker.getResource());
                    if (null == model.getRelationshipNodes()) continue;
                    List<RelationshipNode> modelNodes = model.getRelationshipNodes().getRelationshipNode();
                    for (RelationshipNode node : modelNodes) {
                        this.importNodeToTracker(tracker, node);
                    }
                }
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    private void importNodeToTracker(RelationshipModelTracker tracker, RelationshipNode node) {
        Resource targetRes;
        Resource nodeRes = node.getResource();
        if (null != nodeRes && null != (targetRes = this.getResource(nodeRes.getId(), nodeRes.getType()))) {
            List<RelationshipAttribute> nodeAttrs;
            this.copyResourceAttributes(nodeRes, targetRes);
            RelationshipNode targetNode = this.getRelationshipNode(tracker, targetRes, node.getType());
            if (null != targetNode && null != node.getRelationshipAttributes() && null != (nodeAttrs = node.getRelationshipAttributes().getRelationshipAttribute())) {
                for (RelationshipAttribute nodeAttr : nodeAttrs) {
                    this.addRelationshipAttribute(targetNode, nodeAttr.getName(), nodeAttr.getValue());
                }
            }
        }
    }

    private void copyResourceAttributes(Resource nodeRes, Resource targetRes) {
        List<ResourceAttribute> resAttrs;
        if (null != nodeRes.getAnalysisDate()) {
            targetRes.setAnalysisDate(nodeRes.getAnalysisDate());
        }
        if (null != nodeRes.getLabel()) {
            targetRes.setLabel(nodeRes.getLabel());
        }
        if (null != nodeRes.getResourceId()) {
            targetRes.setResourceId(nodeRes.getResourceId());
        }
        if (null != nodeRes.getResourceAttributes() && null != (resAttrs = nodeRes.getResourceAttributes().getResourceAttribute())) {
            for (ResourceAttribute resAttr : resAttrs) {
                this.addResourceAttribute(targetRes, resAttr.getName(), resAttr.getValue());
            }
        }
    }
}

