/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dmv.relationship.ox;

import com.sas.dmv.relationship.ox.RelationshipModel;
import com.sas.dmv.relationship.ox.RelationshipType;
import com.sas.dmv.relationship.ox.Resource;
import java.util.EnumSet;

public class RelationshipModelTracker {
    Resource _resource = null;
    RelationshipModel _model = null;
    EnumSet<RelationshipType> _relationshipsPopulated = EnumSet.noneOf(RelationshipType.class);
    boolean _modelFetchState = false;

    public RelationshipModelTracker(RelationshipModel model) {
        this._model = model;
        this._resource = model.getResource();
    }

    public Resource getResource() {
        return this._resource;
    }

    public RelationshipModel getRelationshipModel() {
        return this._model;
    }

    public boolean isPopulated() {
        boolean returnValue = true;
        if (!this.hasAllRelationshipsPopulated()) {
            return false;
        }
        return returnValue;
    }

    private boolean hasAllRelationshipsPopulated() {
        return this.hasAll(this._relationshipsPopulated);
    }

    private boolean hasAll(EnumSet<RelationshipType> list) {
        EnumSet<RelationshipType> all = EnumSet.allOf(RelationshipType.class);
        for (RelationshipType type : all) {
            if (list.contains((Object)type)) continue;
            return false;
        }
        return true;
    }

    public boolean inModelFetch() {
        return this._modelFetchState;
    }

    public void setInModelFetch(boolean b) {
        this._modelFetchState = b;
    }

    public boolean hasRelationshipPopulated(RelationshipType type) {
        return this._relationshipsPopulated.contains((Object)type);
    }

    public void setRelationhshipPopulated(RelationshipType type) {
        this._relationshipsPopulated.add(type);
    }

    public String toString() {
        String returnValue = "";
        if (null != this._model) {
            returnValue = returnValue + "MODEL:" + this._model.toString();
            returnValue = returnValue + "_";
        }
        if (null != this._resource) {
            returnValue = returnValue + "RES:" + this._resource.toString();
            returnValue = returnValue + "_";
        }
        if (returnValue.length() == 0) {
            returnValue = super.toString();
        }
        return returnValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationshipModelTracker) {
            RelationshipModelTracker other = (RelationshipModelTracker)obj;
            if (this._model == other._model) {
                return true;
            }
        }
        return false;
    }
}

