/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import com.sas.tkts.logging.AbstractLogger;

public class Timings {
    private String threadStr;
    private String title;
    private short COLLECT_TIMINGS;
    private short COLLECT_SAMPLES;
    private final int MAX_SAMPLES = 21;
    private long duration;
    private long count;
    private int[] samples;
    AbstractLogger logger;
    static final int hasDataThreshold = 1;

    public Timings(String threadID, String title, boolean debug, boolean debugSamples, AbstractLogger l) {
        this.threadStr = threadID;
        this.title = title;
        this.logger = l;
        if (debug) {
            this.COLLECT_TIMINGS = 1;
        }
        if (debugSamples) {
            this.COLLECT_SAMPLES = 1;
            this.samples = new int[21];
        }
    }

    private static double toSeconds(long microseconds) {
        double toSeconds = 1000000.0;
        double out = microseconds;
        return out /= toSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long start, long end) {
        if (this.COLLECT_TIMINGS == 0) {
            return;
        }
        Timings timings = this;
        synchronized (timings) {
            long delta = (end - start) / 1000L;
            this.duration += delta;
            ++this.count;
            if (this.COLLECT_SAMPLES == 0) {
                return;
            }
            if ((delta /= 1000L) < 10L) {
                int n = (int)delta;
                this.samples[n] = this.samples[n] + 1;
            } else {
                int i = 10;
                if ((delta /= 10L) < 10L) {
                    int n = i + (int)delta;
                    this.samples[n] = this.samples[n] + 1;
                } else if ((delta /= 10L) < 10L) {
                    int n = (int)delta;
                    this.samples[n] = this.samples[n] + 1;
                } else {
                    delta /= 10L;
                    int n = i = 20;
                    this.samples[n] = this.samples[n] + 1;
                }
            }
        }
    }

    public long update(long start) {
        long end = System.nanoTime();
        this.update(start, end);
        return end;
    }

    public boolean hasData() {
        return this.count >= 1L;
    }

    public String hasDataString() {
        String out = String.format("count[%d] < threshold[%d]", this.count, 1);
        return out;
    }

    public void log() {
        String[] rangesStr = new String[]{"  0", "  1", "  2", "  3", "  4", "  5", "  6", "  7", " 8", " 9", " 1x", " 2x", " 3x", " 4x", " 5x", " 6x", " 7x", " 8x", " 9x", "1xx", "2xx", "3xx", "4xx", "5xx", "6xx", "7xx", "8xx", "9xx", "1xxx"};
        if (this.COLLECT_TIMINGS == 0) {
            return;
        }
        double dbl = 1000.0;
        double avg = this.duration;
        if (this.count == 0L) {
            String o = String.format("%s %20s No Measurements ", this.threadStr, this.title);
        } else {
            avg /= dbl;
            dbl = this.count;
            double d = Timings.toSeconds(this.duration);
            String o = String.format("%s %20s Count: %12d, Duration(s): %12.2f Avg(ms): %10.2f ", this.threadStr, this.title, this.count, d, avg /= dbl);
            if (this.logger != null) {
                this.logger.info(o);
            }
            String FMT = "milliseconds[%4s] count: %12d";
            if (this.COLLECT_SAMPLES > 0) {
                for (int i = 0; i < 21; ++i) {
                    int c = this.samples[i];
                    if (c <= 0) continue;
                    String v = rangesStr[i];
                    o = String.format("milliseconds[%4s] count: %12d", v, c);
                    if (this.logger == null) continue;
                    this.logger.info(o);
                }
            }
        }
    }

    public void cleanup() {
        this.threadStr = null;
        this.title = null;
        this.samples = null;
    }
}

