/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import com.sas.iom.SASIOMDefs.AnySeqHelper;
import com.sas.iom.SASIOMDefs.DoubleSeqHelper;
import com.sas.iom.SASIOMDefs.FloatSeqHelper;
import com.sas.iom.SASIOMDefs.LongLongSeqHelper;
import com.sas.iom.SASIOMDefs.LongSeqHelper;
import com.sas.iom.SASIOMDefs.OctetSeqHelper;
import com.sas.iom.SASIOMDefs.ShortSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfOctetHelper;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.TimeRepresentation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;

public class ParameterInfoHelper {
    private static Double NULL_NaN = Double.longBitsToDouble(9221120237041090560L);
    private static Double MISSING_UNDERSCORE = Double.longBitsToDouble(-1099511627776L);
    private static Double MISSING_PERIOD = Double.longBitsToDouble(-2199023255552L);
    private static Double MISSING_A = Double.longBitsToDouble(-3298534883328L);
    private static Double MISSING_B = Double.longBitsToDouble(-4398046511104L);
    private static Double MISSING_C = Double.longBitsToDouble(-5497558138880L);
    private static Double MISSING_D = Double.longBitsToDouble(-6597069766656L);
    private static Double MISSING_E = Double.longBitsToDouble(-7696581394432L);
    private static Double MISSING_F = Double.longBitsToDouble(-8796093022208L);
    private static Double MISSING_G = Double.longBitsToDouble(-9895604649984L);
    private static Double MISSING_H = Double.longBitsToDouble(-10995116277760L);
    private static Double MISSING_I = Double.longBitsToDouble(-12094627905536L);
    private static Double MISSING_J = Double.longBitsToDouble(-13194139533312L);
    private static Double MISSING_K = Double.longBitsToDouble(-14293651161088L);
    private static Double MISSING_L = Double.longBitsToDouble(-15393162788864L);
    private static Double MISSING_M = Double.longBitsToDouble(-16492674416640L);
    private static Double MISSING_N = Double.longBitsToDouble(-17592186044416L);
    private static Double MISSING_O = Double.longBitsToDouble(-18691697672192L);
    private static Double MISSING_P = Double.longBitsToDouble(-19791209299968L);
    private static Double MISSING_Q = Double.longBitsToDouble(-20890720927744L);
    private static Double MISSING_R = Double.longBitsToDouble(-21990232555520L);
    private static Double MISSING_S = Double.longBitsToDouble(-23089744183296L);
    private static Double MISSING_T = Double.longBitsToDouble(-24189255811072L);
    private static Double MISSING_U = Double.longBitsToDouble(-25288767438848L);
    private static Double MISSING_V = Double.longBitsToDouble(-26388279066624L);
    private static Double MISSING_W = Double.longBitsToDouble(-27487790694400L);
    private static Double MISSING_X = Double.longBitsToDouble(-28587302322176L);
    private static Double MISSING_Y = Double.longBitsToDouble(-29686813949952L);
    private static Double MISSING_Z = Double.longBitsToDouble(-30786325577728L);
    private static Map<String, Double> missingMap = null;
    private static Map<Long, Double> missingMapUnpack = null;
    private static Map<Long, String> missingDescription = null;
    private static final long NULL_NaN_BITS = 9221120237041090560L;
    private static final int[] LOOKUP_INDICATOR = new int[]{-62, -63, -64, -65, -66, -67, -68, -69, -70, -71, -72, -73, -74, -75, -76, -77, -78, -79, -80, -81, -82, -83, -84, -85, -86, -87, -88, -89};

    private ParameterInfoHelper() {
    }

    public static Double getBitPattern(String key) {
        Double out = null;
        if (missingMap.containsKey(key)) {
            out = missingMap.get(key);
        }
        return out;
    }

    public static boolean populateIOMParameterArrayBasedOnDataType(Any executionParameter, ParameterInfo parameterInfo, int pindx, int[][] lenOrInd, ORB orbHandle, boolean isFakeBatchOperation) throws SQLException {
        boolean isDataAtExecution = false;
        switch (parameterInfo.getSQLType()) {
            case -3: 
            case -2: {
                Any[] inter = ParameterInfoHelper.createAnyArrayFromBytes(parameterInfo, orbHandle, lenOrInd, pindx, isFakeBatchOperation);
                AnySeqHelper.insert((Any)executionParameter, (Any[])inter);
                break;
            }
            case -4: 
            case -1: {
                ParameterInfoHelper.setDataAtExecution(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                isDataAtExecution = true;
                break;
            }
            case 6: 
            case 7: {
                float[] floatValue = ParameterInfoHelper.createFloatArray(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                FloatSeqHelper.insert((Any)executionParameter, (float[])floatValue);
                break;
            }
            case 8: {
                double[] doubleArray = ParameterInfoHelper.createDoubleArray(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                DoubleSeqHelper.insert((Any)executionParameter, (double[])doubleArray);
                break;
            }
            case 4: {
                int[] intArray = ParameterInfoHelper.createIntegerArray(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                LongSeqHelper.insert((Any)executionParameter, (int[])intArray);
                break;
            }
            case -5: {
                long[] longArray = ParameterInfoHelper.createLongArray(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                LongLongSeqHelper.insert((Any)executionParameter, (long[])longArray);
                break;
            }
            case -7: 
            case -6: {
                byte[] bitValue = ParameterInfoHelper.createByteArray(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                OctetSeqHelper.insert((Any)executionParameter, (byte[])bitValue);
                break;
            }
            case 5: {
                short[] shortValue = ParameterInfoHelper.createShortArray(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                ShortSeqHelper.insert((Any)executionParameter, (short[])shortValue);
                break;
            }
            case 1: 
            case 12: {
                String[] stringValue = ParameterInfoHelper.createStringArray(parameterInfo, lenOrInd, pindx, isFakeBatchOperation);
                StringSeqHelper.insert((Any)executionParameter, (String[])stringValue);
                break;
            }
            case 2: 
            case 3: {
                Any[] numericField = ParameterInfoHelper.createNumericFieldArray(parameterInfo, orbHandle, lenOrInd, pindx, isFakeBatchOperation);
                AnySeqHelper.insert((Any)executionParameter, (Any[])numericField);
                break;
            }
            case 91: {
                Any[] dateField = ParameterInfoHelper.createDateArray(parameterInfo, orbHandle, lenOrInd, pindx, isFakeBatchOperation);
                AnySeqHelper.insert((Any)executionParameter, (Any[])dateField);
                break;
            }
            case 92: {
                Any[] timeField = ParameterInfoHelper.createTimeArray(parameterInfo, orbHandle, lenOrInd, pindx, isFakeBatchOperation);
                AnySeqHelper.insert((Any)executionParameter, (Any[])timeField);
                break;
            }
            case 93: {
                Any[] timestampField = ParameterInfoHelper.createTimestampArray(parameterInfo, orbHandle, lenOrInd, pindx, isFakeBatchOperation);
                AnySeqHelper.insert((Any)executionParameter, (Any[])timestampField);
            }
        }
        return isDataAtExecution;
    }

    protected static int[] createIntegerArray(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        int[] results = new int[arraySize];
        if (results.length == 1) {
            ParameterInfoHelper.populateIntegerArray((Number)parameterInfo.getValue(), results, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateIntegerArray((Number)parameterInfo.getValue(dindx), results, lenOrInd, pindx, dindx);
            }
        }
        return results;
    }

    private static void populateIntegerArray(Number value, int[] results, int[][] lenOrInd, int pindx, int dindx) {
        if (value == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            results[dindx] = value.intValue();
        }
    }

    private static double[] createDoubleArray(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        double[] results = new double[arraySize];
        if (results.length == 1) {
            ParameterInfoHelper.populateDoubleArray((Number)parameterInfo.getValue(), results, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateDoubleArray((Number)parameterInfo.getValue(dindx), results, lenOrInd, pindx, dindx);
            }
        }
        return results;
    }

    private static void populateDoubleArray(Number value, double[] results, int[][] lenOrInd, int pindx, int dindx) {
        if (value == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            results[dindx] = value.doubleValue();
        }
    }

    private static float[] createFloatArray(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        float[] results = new float[arraySize];
        if (results.length == 1) {
            ParameterInfoHelper.populateFloatArray((Number)parameterInfo.getValue(), results, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateFloatArray((Number)parameterInfo.getValue(dindx), results, lenOrInd, pindx, dindx);
            }
        }
        return results;
    }

    private static void populateFloatArray(Number value, float[] results, int[][] lenOrInd, int pindx, int dindx) {
        if (value == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            results[dindx] = value.floatValue();
        }
    }

    private static long[] createLongArray(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        long[] results = new long[arraySize];
        if (results.length == 1) {
            ParameterInfoHelper.populateLongArray((Number)parameterInfo.getValue(), results, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateLongArray((Number)parameterInfo.getValue(dindx), results, lenOrInd, pindx, dindx);
            }
        }
        return results;
    }

    private static void populateLongArray(Number value, long[] results, int[][] lenOrInd, int pindx, int dindx) {
        if (value == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            results[dindx] = value.longValue();
        }
    }

    private static short[] createShortArray(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        short[] results = new short[arraySize];
        if (results.length == 1) {
            ParameterInfoHelper.populateShortArray((Number)parameterInfo.getValue(), results, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateShortArray((Number)parameterInfo.getValue(dindx), results, lenOrInd, pindx, dindx);
            }
        }
        return results;
    }

    private static void populateShortArray(Number value, short[] results, int[][] lenOrInd, int pindx, int dindx) {
        if (value == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            results[dindx] = value.shortValue();
        }
    }

    private static byte[] createByteArray(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        byte[] results = new byte[arraySize];
        if (results.length == 1) {
            ParameterInfoHelper.populateByteArray((Byte)parameterInfo.getValue(), results, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateByteArray((Byte)parameterInfo.getValue(dindx), results, lenOrInd, pindx, dindx);
            }
        }
        return results;
    }

    private static void populateByteArray(Byte value, byte[] results, int[][] lenOrInd, int pindx, int dindx) {
        if (value == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            results[dindx] = value;
        }
    }

    private static Any[] createAnyArrayFromBytes(ParameterInfo pi, ORB orbHandle, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(pi, isFakeBatchOperation);
        Any[] results = new Any[arraySize];
        Charset charset = pi.getNativeCharset();
        if (results.length == 1) {
            ParameterInfoHelper.populateAnyArrayFromBytes(orbHandle, pi.getValue(), results, lenOrInd, pindx, 0, charset);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateAnyArrayFromBytes(orbHandle, pi.getValue(dindx), results, lenOrInd, pindx, dindx, charset);
            }
        }
        return results;
    }

    private static void populateAnyArrayFromBytes(ORB orbHandle, Object values, Any[] results, int[][] lenOrInd, int pindx, int dindx, Charset charset) {
        byte[] byteRep = null;
        results[dindx] = orbHandle.create_any();
        if (values == null) {
            lenOrInd[pindx][dindx] = -1;
            byteRep = new byte[]{};
        } else {
            lenOrInd[pindx][dindx] = 1;
            byteRep = values instanceof String ? ((String)values).getBytes(charset) : (byte[])values;
        }
        OctetSeqHelper.insert((Any)results[dindx], (byte[])byteRep);
    }

    private static String[] createStringArray(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        String[] results = new String[arraySize];
        if (results.length == 1) {
            Object inValue = parameterInfo.getValue();
            ParameterInfoHelper.populateStringArray(inValue, results, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                Object inValue = parameterInfo.getValue(dindx);
                ParameterInfoHelper.populateStringArray(inValue, results, lenOrInd, pindx, dindx);
            }
        }
        return results;
    }

    private static void populateStringArray(Object value, String[] results, int[][] lenOrInd, int pindx, int dindx) {
        if (value == null) {
            lenOrInd[pindx][dindx] = -1;
            results[dindx] = "";
        } else {
            lenOrInd[pindx][dindx] = 1;
            Charset charset = CharSetUtil.getToServerCharset();
            results[dindx] = value instanceof byte[] ? new String((byte[])value, charset) : value.toString();
        }
    }

    private static Any[] createNumericFieldArray(ParameterInfo parameterInfo, ORB orbHandle, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        byte[] precision = new byte[arraySize];
        byte[] scale = new byte[arraySize];
        byte[] sign = new byte[arraySize];
        byte[][] value = new byte[arraySize][16];
        Any[] numericField = new Any[4];
        for (int c = 0; c < 4; ++c) {
            numericField[c] = orbHandle.create_any();
        }
        if (arraySize == 1) {
            ParameterInfoHelper.populateNumericFieldArray((BigDecimal)parameterInfo.getValue(), precision, scale, sign, value, lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateNumericFieldArray((BigDecimal)parameterInfo.getValue(dindx), precision, scale, sign, value, lenOrInd, pindx, dindx);
            }
        }
        OctetSeqHelper.insert((Any)numericField[0], (byte[])precision);
        OctetSeqHelper.insert((Any)numericField[1], (byte[])scale);
        OctetSeqHelper.insert((Any)numericField[2], (byte[])sign);
        VariableArray2dOfOctetHelper.insert((Any)numericField[3], (byte[][])value);
        return numericField;
    }

    private static void populateNumericFieldArray(BigDecimal bigDecValue, byte[] precision, byte[] scale, byte[] sign, byte[][] value, int[][] lenOrInd, int pindx, int dindx) {
        if (bigDecValue == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            BigInteger unscaledBigInt = bigDecValue.unscaledValue().abs();
            byte[] byteRep = unscaledBigInt.toByteArray();
            precision[dindx] = (byte)unscaledBigInt.toString().length();
            scale[dindx] = (byte)bigDecValue.scale();
            sign[dindx] = (byte)bigDecValue.signum();
            if (sign[dindx] == -1) {
                sign[dindx] = 0;
            }
            if (byteRep.length > 16) {
                int z = 0;
                int y = byteRep.length - 1;
                while (z < 16) {
                    value[dindx][z] = byteRep[y];
                    ++z;
                    --y;
                }
            } else {
                int z = 0;
                int y = byteRep.length - 1;
                while (y >= 0) {
                    value[dindx][z] = byteRep[y];
                    --y;
                    ++z;
                }
            }
        }
    }

    private static Any[] createDateArray(ParameterInfo parameterInfo, ORB orbHandle, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        Object paramValue = null;
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        Any[] dateField = new Any[3];
        short[] year = new short[arraySize];
        short[] month = new short[arraySize];
        short[] day = new short[arraySize];
        for (int c = 0; c < 3; ++c) {
            dateField[c] = orbHandle.create_any();
        }
        if (arraySize == 1) {
            paramValue = parameterInfo.getValue();
            if (paramValue instanceof TimeRepresentation) {
                ParameterInfoHelper.populateDateArray((TimeRepresentation)paramValue, year, month, day, lenOrInd, pindx, 0);
            } else {
                ParameterInfoHelper.populateDateArray((Date)paramValue, year, month, day, lenOrInd, pindx, 0);
            }
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                paramValue = parameterInfo.getValue(dindx);
                if (paramValue instanceof TimeRepresentation) {
                    ParameterInfoHelper.populateDateArray((TimeRepresentation)paramValue, year, month, day, lenOrInd, pindx, dindx);
                    continue;
                }
                ParameterInfoHelper.populateDateArray((Date)paramValue, year, month, day, lenOrInd, pindx, dindx);
            }
        }
        ShortSeqHelper.insert((Any)dateField[0], (short[])year);
        ShortSeqHelper.insert((Any)dateField[1], (short[])month);
        ShortSeqHelper.insert((Any)dateField[2], (short[])day);
        return dateField;
    }

    private static void populateDateArray(TimeRepresentation dateValue, short[] year, short[] month, short[] day, int[][] lenOrInd, int pindx, int dindx) {
        if (dateValue == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            year[dindx] = (short)dateValue.get_YEAR();
            month[dindx] = (short)dateValue.get_MONTH();
            day[dindx] = (short)dateValue.get_DAY_OF_MONTH();
        }
    }

    private static void populateDateArray(Date dateValue, short[] year, short[] month, short[] day, int[][] lenOrInd, int pindx, int dindx) {
        if (dateValue == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateValue);
            year[dindx] = (short)calendar.get(1);
            month[dindx] = (short)(calendar.get(2) + 1);
            day[dindx] = (short)calendar.get(5);
        }
    }

    private static Any[] createTimeArray(ParameterInfo parameterInfo, ORB orbHandle, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        Object paramValue = null;
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        Any[] timeField = new Any[3];
        short[] hours = new short[arraySize];
        short[] minutes = new short[arraySize];
        short[] seconds = new short[arraySize];
        for (int c = 0; c < 3; ++c) {
            timeField[c] = orbHandle.create_any();
        }
        if (arraySize == 1) {
            paramValue = parameterInfo.getValue();
            if (paramValue instanceof TimeRepresentation) {
                ParameterInfoHelper.populateTimeArray((TimeRepresentation)paramValue, hours, minutes, seconds, lenOrInd, pindx, 0);
            } else {
                ParameterInfoHelper.populateTimeArray((Time)paramValue, hours, minutes, seconds, lenOrInd, pindx, 0);
            }
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                paramValue = parameterInfo.getValue(dindx);
                if (paramValue instanceof TimeRepresentation) {
                    ParameterInfoHelper.populateTimeArray((TimeRepresentation)paramValue, hours, minutes, seconds, lenOrInd, pindx, dindx);
                    continue;
                }
                ParameterInfoHelper.populateTimeArray((Time)paramValue, hours, minutes, seconds, lenOrInd, pindx, dindx);
            }
        }
        ShortSeqHelper.insert((Any)timeField[0], (short[])hours);
        ShortSeqHelper.insert((Any)timeField[1], (short[])minutes);
        ShortSeqHelper.insert((Any)timeField[2], (short[])seconds);
        return timeField;
    }

    private static void populateTimeArray(TimeRepresentation timeValue, short[] hours, short[] minutes, short[] seconds, int[][] lenOrInd, int pindx, int dindx) {
        if (timeValue == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            hours[dindx] = (short)timeValue.get_HOUR_OF_DAY();
            minutes[dindx] = (short)timeValue.get_MINUTES();
            seconds[dindx] = (short)timeValue.get_SECONDS();
        }
    }

    private static void populateTimeArray(Time timeValue, short[] hours, short[] minutes, short[] seconds, int[][] lenOrInd, int pindx, int dindx) {
        if (timeValue == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timeValue.getTime());
            hours[dindx] = (short)calendar.get(11);
            minutes[dindx] = (short)calendar.get(12);
            seconds[dindx] = (short)calendar.get(13);
        }
    }

    private static Any[] createTimestampArray(ParameterInfo parameterInfo, ORB orbHandle, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        Object paramValue = null;
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        short[] year = new short[arraySize];
        short[] month = new short[arraySize];
        short[] day = new short[arraySize];
        short[] hours = new short[arraySize];
        short[] minutes = new short[arraySize];
        short[] seconds = new short[arraySize];
        int[] fraction = new int[arraySize];
        Any[] timestampField = new Any[7];
        for (int c = 0; c < 7; ++c) {
            timestampField[c] = orbHandle.create_any();
        }
        if (arraySize == 1) {
            paramValue = parameterInfo.getValue();
            if (paramValue instanceof TimeRepresentation) {
                ParameterInfoHelper.populateTimestampArray((TimeRepresentation)paramValue, year, month, day, hours, minutes, seconds, fraction, lenOrInd, pindx, 0);
            } else {
                ParameterInfoHelper.populateTimestampArray((Timestamp)paramValue, year, month, day, hours, minutes, seconds, fraction, lenOrInd, pindx, 0);
            }
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                paramValue = parameterInfo.getValue(dindx);
                if (paramValue instanceof TimeRepresentation) {
                    ParameterInfoHelper.populateTimestampArray((TimeRepresentation)paramValue, year, month, day, hours, minutes, seconds, fraction, lenOrInd, pindx, dindx);
                    continue;
                }
                ParameterInfoHelper.populateTimestampArray((Timestamp)paramValue, year, month, day, hours, minutes, seconds, fraction, lenOrInd, pindx, dindx);
            }
        }
        ShortSeqHelper.insert((Any)timestampField[0], (short[])year);
        ShortSeqHelper.insert((Any)timestampField[1], (short[])month);
        ShortSeqHelper.insert((Any)timestampField[2], (short[])day);
        ShortSeqHelper.insert((Any)timestampField[3], (short[])hours);
        ShortSeqHelper.insert((Any)timestampField[4], (short[])minutes);
        ShortSeqHelper.insert((Any)timestampField[5], (short[])seconds);
        LongSeqHelper.insert((Any)timestampField[6], (int[])fraction);
        return timestampField;
    }

    private static void populateTimestampArray(TimeRepresentation timestampValue, short[] year, short[] month, short[] day, short[] hours, short[] minutes, short[] seconds, int[] fraction, int[][] lenOrInd, int pindx, int dindx) {
        if (timestampValue == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            hours[dindx] = (short)timestampValue.get_HOUR_OF_DAY();
            minutes[dindx] = (short)timestampValue.get_MINUTES();
            seconds[dindx] = (short)timestampValue.get_SECONDS();
            year[dindx] = (short)timestampValue.get_YEAR();
            month[dindx] = (short)timestampValue.get_MONTH();
            day[dindx] = (short)timestampValue.get_DAY_OF_MONTH();
            fraction[dindx] = timestampValue.get_NANOSECONDS();
        }
    }

    private static void populateTimestampArray(Timestamp timestampValue, short[] year, short[] month, short[] day, short[] hours, short[] minutes, short[] seconds, int[] fraction, int[][] lenOrInd, int pindx, int dindx) {
        if (timestampValue == null) {
            lenOrInd[pindx][dindx] = -1;
        } else {
            lenOrInd[pindx][dindx] = 1;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timestampValue.getTime());
            hours[dindx] = (short)calendar.get(11);
            minutes[dindx] = (short)calendar.get(12);
            seconds[dindx] = (short)calendar.get(13);
            year[dindx] = (short)calendar.get(1);
            month[dindx] = (short)(calendar.get(2) + 1);
            day[dindx] = (short)calendar.get(5);
            fraction[dindx] = timestampValue.getNanos();
        }
    }

    private static void setDataAtExecution(ParameterInfo parameterInfo, int[][] lenOrInd, int pindx, boolean isFakeBatchOperation) throws SQLException {
        int arraySize = ParameterInfoHelper.getArraySize(parameterInfo, isFakeBatchOperation);
        if (arraySize == 1) {
            ParameterInfoHelper.populateLenOrInd(parameterInfo.getValue(), lenOrInd, pindx, 0);
        } else {
            for (int dindx = 0; dindx < arraySize; ++dindx) {
                ParameterInfoHelper.populateLenOrInd(parameterInfo.getValue(dindx), lenOrInd, pindx, dindx);
            }
        }
    }

    private static void populateLenOrInd(Object obj, int[][] lenOrInd, int pindx, int dindx) {
        lenOrInd[pindx][dindx] = obj != null ? -2 : -1;
    }

    private static byte getBooleanByteValue(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return 1;
        }
        return 0;
    }

    private static int getArraySize(ParameterInfo parameterInfo, boolean isFakeBatch) {
        int arraySize = parameterInfo.getParamSetArraySize();
        if (isFakeBatch || arraySize == 0) {
            arraySize = 1;
        }
        return arraySize;
    }

    public static Object stringToBooleanConstant(String stringValue) {
        Boolean returnObject = stringValue.equals("1") || stringValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
        return returnObject;
    }

    public static Object coerceObject(Object theObject, int sqlType, boolean isMissingMode) {
        Object outObject = null;
        if (theObject instanceof Number) {
            outObject = ParameterInfoHelper.coerceNumber((Number)theObject, sqlType);
        } else if (theObject instanceof String) {
            outObject = ParameterInfoHelper.coerceString((String)theObject, sqlType, isMissingMode);
        } else if (theObject instanceof TimeRepresentation) {
            TimeRepresentation tr = (TimeRepresentation)theObject;
            switch (sqlType) {
                case 91: {
                    outObject = tr.getDateValue();
                    break;
                }
                case 92: {
                    outObject = tr.getTimeValue();
                    break;
                }
                case 93: {
                    outObject = tr.getTimeStampValue();
                    break;
                }
            }
        } else if (theObject instanceof java.util.Date) {
            if (theObject instanceof Date) {
                outObject = ParameterInfoHelper.coerceDate((Date)theObject, sqlType);
            } else if (theObject instanceof Time) {
                outObject = ParameterInfoHelper.coerceTime((Time)theObject, sqlType);
            } else if (theObject instanceof Timestamp) {
                outObject = ParameterInfoHelper.coerceTimestamp((Timestamp)theObject, sqlType);
            } else {
                java.util.Date utilDate = (java.util.Date)theObject;
                long longDate = utilDate.getTime();
                Date tDate = new Date(longDate);
                outObject = ParameterInfoHelper.coerceDate(tDate, sqlType);
            }
        } else if (theObject instanceof Boolean) {
            outObject = ParameterInfoHelper.coerceBoolean((Boolean)theObject, sqlType);
        } else if (theObject.getClass().isArray() && theObject.getClass().getComponentType() == Byte.TYPE) {
            outObject = ParameterInfoHelper.coerceByteArray((byte[])theObject, sqlType);
        } else if (theObject instanceof Calendar) {
            outObject = ParameterInfoHelper.coerceCalendar((Calendar)theObject, sqlType);
        }
        return outObject;
    }

    private static Object coerceBoolean(Boolean booleanValue, int sqlType) {
        Object returnObject = null;
        int bnum = booleanValue != false ? 1 : 0;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                returnObject = booleanValue.toString();
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                if (booleanValue.booleanValue()) {
                    returnObject = Constants.BYTE_ONE;
                    break;
                }
                returnObject = Constants.BYTE_ZERO;
                break;
            }
            case 5: {
                returnObject = new Short((short)bnum);
                break;
            }
            case 4: {
                returnObject = new Integer(bnum);
                break;
            }
            case -5: {
                returnObject = new Long(bnum);
                break;
            }
            case 6: 
            case 7: {
                returnObject = new Float(bnum);
                break;
            }
            case 8: {
                returnObject = new Double(bnum);
                break;
            }
            case 2: 
            case 3: {
                returnObject = new BigDecimal(bnum);
                break;
            }
        }
        return returnObject;
    }

    private static Object coerceString(String stringValue, int sqlType, boolean isMissingMode) {
        Object returnObject = null;
        switch (sqlType) {
            case -7: 
            case -6: {
                returnObject = new Byte(stringValue);
                break;
            }
            case 5: {
                returnObject = new Short(stringValue);
                break;
            }
            case 4: {
                returnObject = new Integer(stringValue);
                break;
            }
            case -5: {
                returnObject = new Long(stringValue);
                break;
            }
            case 6: 
            case 7: {
                returnObject = new Float(stringValue);
                break;
            }
            case 8: {
                if (isMissingMode) {
                    returnObject = ParameterInfoHelper.checkIfMissingValue(stringValue);
                    if (returnObject != null) break;
                    returnObject = new Double(stringValue);
                    break;
                }
                returnObject = new Double(stringValue);
                break;
            }
            case 2: 
            case 3: {
                returnObject = new BigDecimal(stringValue);
                break;
            }
            case 16: {
                returnObject = ParameterInfoHelper.stringToBooleanConstant(stringValue);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                returnObject = stringValue.getBytes();
                break;
            }
            case 91: {
                returnObject = Date.valueOf(stringValue);
                break;
            }
            case 92: {
                returnObject = Time.valueOf(stringValue);
                break;
            }
            case 93: {
                returnObject = Timestamp.valueOf(stringValue);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                returnObject = stringValue;
            }
        }
        return returnObject;
    }

    private static Object coerceString(String stringValue, int sqlType) {
        Object returnObject = null;
        switch (sqlType) {
            case -7: 
            case -6: {
                returnObject = new Byte(stringValue);
                break;
            }
            case 5: {
                returnObject = new Short(stringValue);
                break;
            }
            case 4: {
                returnObject = new Integer(stringValue);
                break;
            }
            case -5: {
                returnObject = new Long(stringValue);
                break;
            }
            case 6: 
            case 7: {
                returnObject = new Float(stringValue);
                break;
            }
            case 8: {
                returnObject = new Double(stringValue);
                break;
            }
            case 2: 
            case 3: {
                returnObject = new BigDecimal(stringValue);
                break;
            }
            case 16: {
                returnObject = ParameterInfoHelper.stringToBooleanConstant(stringValue);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                returnObject = stringValue.getBytes();
                break;
            }
            case 91: {
                returnObject = Date.valueOf(stringValue);
                break;
            }
            case 92: {
                returnObject = Time.valueOf(stringValue);
                break;
            }
            case 93: {
                returnObject = Timestamp.valueOf(stringValue);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                returnObject = stringValue;
            }
        }
        return returnObject;
    }

    private static Object coerceNumber(Number numberValue, int sqlType) {
        Object returnObject = null;
        switch (sqlType) {
            case -7: 
            case -6: {
                returnObject = new Byte(numberValue.byteValue());
                break;
            }
            case 5: {
                returnObject = new Short(numberValue.shortValue());
                break;
            }
            case 4: {
                returnObject = new Integer(numberValue.intValue());
                break;
            }
            case -5: {
                returnObject = new Long(numberValue.longValue());
                break;
            }
            case 6: 
            case 7: {
                returnObject = new Float(numberValue.floatValue());
                break;
            }
            case 8: {
                returnObject = new Double(numberValue.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                if (numberValue instanceof BigDecimal) {
                    returnObject = numberValue;
                    break;
                }
                returnObject = new BigDecimal(numberValue.toString());
                break;
            }
            case 16: {
                int i = numberValue.intValue();
                if (i == 0) {
                    returnObject = Boolean.FALSE;
                    break;
                }
                returnObject = Boolean.TRUE;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (numberValue instanceof BigDecimal) {
                    returnObject = ((BigDecimal)numberValue).toPlainString();
                    break;
                }
                returnObject = numberValue.toString();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                returnObject = numberValue.toString().getBytes();
            }
        }
        return returnObject;
    }

    private static Object coerceByteArray(byte[] byteArrayValue, int sqlType) {
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 2004: {
                return byteArrayValue;
            }
        }
        return null;
    }

    private static Object coerceDate(Date dateValue, int sqlType) {
        Object returnObject = null;
        long time = dateValue.getTime();
        switch (sqlType) {
            case 91: {
                returnObject = dateValue;
                break;
            }
            case 93: {
                returnObject = new Timestamp(time);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                returnObject = dateValue.toString();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                returnObject = dateValue.toString().getBytes();
            }
        }
        return returnObject;
    }

    private static Object coerceTime(Time timeValue, int sqlType) {
        Object returnObject = null;
        long time = timeValue.getTime();
        switch (sqlType) {
            case 92: {
                returnObject = timeValue;
                break;
            }
            case 93: {
                returnObject = new Timestamp(time);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                returnObject = timeValue.toString();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                returnObject = timeValue.toString().getBytes();
            }
        }
        return returnObject;
    }

    private static Object coerceTimestamp(Timestamp timeStampValue, int sqlType) {
        Object returnObject = null;
        long value = timeStampValue.getTime();
        switch (sqlType) {
            case 91: {
                returnObject = new Date(value);
                break;
            }
            case 92: {
                returnObject = new Time(value);
                break;
            }
            case 93: {
                returnObject = timeStampValue;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                returnObject = timeStampValue.toString();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                returnObject = timeStampValue.toString().getBytes();
            }
        }
        return returnObject;
    }

    private static Object coerceCalendar(Calendar calValue, int sqlType) {
        Object returnObject = null;
        long utc = calValue.getTimeInMillis();
        switch (sqlType) {
            case 91: {
                Date sqlDate = new Date(utc);
                returnObject = sqlDate;
                break;
            }
            case 92: {
                returnObject = new Time(utc);
                break;
            }
            case 93: {
                returnObject = new Timestamp(utc);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                returnObject = new Timestamp(utc);
                returnObject = returnObject.toString();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                returnObject = calValue.toString().getBytes();
            }
        }
        return returnObject;
    }

    public static String missingDescription(double d) {
        String out = "";
        long b = Double.doubleToRawLongBits(d);
        if (missingDescription.containsKey(b)) {
            out = missingDescription.get(b);
        }
        return out;
    }

    public static String missingDoubleToString(double d) {
        String out;
        if (Double.isNaN(d)) {
            long pattern = Double.doubleToRawLongBits(d);
            String md = ParameterInfoHelper.missingDescription(d);
            out = String.format("NaN:%s:%08X", md, pattern);
        } else {
            out = Double.toString(d);
        }
        return out;
    }

    public static Double checkIfMissingValue(String value) {
        Double missingValue = ParameterInfoHelper.getBitPattern(value);
        return missingValue;
    }

    public static Double indicatorToMissingValue(long key) {
        Double out = null;
        if (missingMapUnpack.containsKey(key)) {
            out = missingMapUnpack.get(key);
        }
        return out;
    }

    public static long doubleToMissingValueIndicator(double d) {
        long out = 0L;
        long pattern = Double.doubleToRawLongBits(d);
        if (pattern == 9221120237041090560L) {
            return out;
        }
        pattern >>= 40;
        int i = (int)(pattern += 28L);
        if (i < 0 || i >= 28) {
            return out;
        }
        out = LOOKUP_INDICATOR[i];
        return out;
    }

    static {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("NaN_", NULL_NaN);
        map.put("_", MISSING_UNDERSCORE);
        map.put(".", MISSING_PERIOD);
        map.put(".A", MISSING_A);
        map.put(".a", MISSING_A);
        map.put(".B", MISSING_B);
        map.put(".b", MISSING_B);
        map.put(".C", MISSING_C);
        map.put(".c", MISSING_C);
        map.put(".D", MISSING_D);
        map.put(".d", MISSING_D);
        map.put(".E", MISSING_E);
        map.put(".e", MISSING_E);
        map.put(".F", MISSING_F);
        map.put(".f", MISSING_F);
        map.put(".G", MISSING_G);
        map.put(".g", MISSING_G);
        map.put(".H", MISSING_H);
        map.put(".h", MISSING_H);
        map.put(".I", MISSING_I);
        map.put(".i", MISSING_I);
        map.put(".J", MISSING_J);
        map.put(".j", MISSING_J);
        map.put(".K", MISSING_K);
        map.put(".k", MISSING_K);
        map.put(".L", MISSING_L);
        map.put(".l", MISSING_L);
        map.put(".M", MISSING_M);
        map.put(".m", MISSING_M);
        map.put(".N", MISSING_N);
        map.put(".n", MISSING_N);
        map.put(".O", MISSING_O);
        map.put(".o", MISSING_O);
        map.put(".P", MISSING_P);
        map.put(".p", MISSING_P);
        map.put(".Q", MISSING_Q);
        map.put(".q", MISSING_Q);
        map.put(".R", MISSING_R);
        map.put(".r", MISSING_R);
        map.put(".S", MISSING_S);
        map.put(".s", MISSING_S);
        map.put(".T", MISSING_T);
        map.put(".t", MISSING_T);
        map.put(".U", MISSING_U);
        map.put(".u", MISSING_U);
        map.put(".V", MISSING_V);
        map.put(".v", MISSING_V);
        map.put(".W", MISSING_W);
        map.put(".w", MISSING_W);
        map.put(".X", MISSING_X);
        map.put(".x", MISSING_X);
        map.put(".Y", MISSING_Y);
        map.put(".y", MISSING_Y);
        map.put(".Z", MISSING_Z);
        map.put(".z", MISSING_Z);
        missingMap = Collections.unmodifiableMap(map);
        HashMap<Long, Double> mapUnpack = new HashMap<Long, Double>();
        mapUnpack.put(-89L, MISSING_UNDERSCORE);
        mapUnpack.put(-88L, MISSING_PERIOD);
        mapUnpack.put(-87L, MISSING_A);
        mapUnpack.put(-86L, MISSING_B);
        mapUnpack.put(-85L, MISSING_C);
        mapUnpack.put(-84L, MISSING_D);
        mapUnpack.put(-83L, MISSING_E);
        mapUnpack.put(-82L, MISSING_F);
        mapUnpack.put(-81L, MISSING_G);
        mapUnpack.put(-80L, MISSING_H);
        mapUnpack.put(-79L, MISSING_I);
        mapUnpack.put(-78L, MISSING_J);
        mapUnpack.put(-77L, MISSING_K);
        mapUnpack.put(-76L, MISSING_L);
        mapUnpack.put(-75L, MISSING_M);
        mapUnpack.put(-74L, MISSING_N);
        mapUnpack.put(-73L, MISSING_O);
        mapUnpack.put(-72L, MISSING_P);
        mapUnpack.put(-71L, MISSING_Q);
        mapUnpack.put(-70L, MISSING_R);
        mapUnpack.put(-69L, MISSING_S);
        mapUnpack.put(-68L, MISSING_T);
        mapUnpack.put(-67L, MISSING_U);
        mapUnpack.put(-66L, MISSING_V);
        mapUnpack.put(-65L, MISSING_W);
        mapUnpack.put(-64L, MISSING_X);
        mapUnpack.put(-63L, MISSING_Y);
        mapUnpack.put(-62L, MISSING_Z);
        missingMapUnpack = Collections.unmodifiableMap(mapUnpack);
        HashMap<Long, String> mapDesc = new HashMap<Long, String>();
        for (Map.Entry<String, Double> entry : missingMap.entrySet()) {
            String k = entry.getKey();
            Double dObj = entry.getValue();
            long v = Double.doubleToRawLongBits(dObj);
            mapDesc.put(v, k);
        }
        missingDescription = Collections.unmodifiableMap(mapDesc);
    }
}

