/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import com.sas.tkts.FSEnums;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.TimeRepresentation;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DataTypeConversions {
    private static String thisClassName = DataTypeConversions.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    public transient Object srcObj;
    public transient String srcStr;
    public transient String colName;
    public transient String targetClassStr;
    public transient Object tarObj;
    public transient boolean wasNull;
    public transient boolean read;
    public transient int ordinal;
    public transient int tSqlType;
    public transient BigDecimal maxBD;
    public transient BigDecimal minBD;
    public transient byte truncType;
    public transient DataTruncation dt;
    public transient BigDecimal bd;

    public DataTypeConversions(Object inObj, int inOrdinal, String inColName, boolean inRead) {
        this.srcObj = inObj;
        this.ordinal = inOrdinal;
        this.tSqlType = 0;
        this.colName = inColName;
        this.read = inRead;
        this.targetClassStr = null;
        this.srcStr = null;
        this.tarObj = null;
        this.maxBD = null;
        this.minBD = null;
        this.truncType = 0;
        this.dt = null;
        this.bd = null;
    }

    /*
     * Unable to fully structure code
     */
    public static Boolean convertToBoolean(Object srcObj) throws SQLException {
        oValue = false;
        trimVal = null;
        if (srcObj == null) {
            oValue = Boolean.FALSE;
            return oValue;
        }
        if (srcObj instanceof String) {
            value = (String)srcObj;
            trimVal = value.trim();
            if (trimVal.compareToIgnoreCase(Constants.BOOLEAN_TRUE_CONSTANTS[0]) == 0 || trimVal.compareToIgnoreCase(Constants.BOOLEAN_TRUE_CONSTANTS[1]) == 0 || trimVal.compareToIgnoreCase(Constants.BOOLEAN_TRUE_CONSTANTS[2]) == 0 || trimVal.compareToIgnoreCase(Constants.BOOLEAN_TRUE_CONSTANTS[3]) == 0) {
                oValue = Boolean.TRUE;
                return oValue;
            }
            try {
                bd = new BigDecimal(trimVal);
                oValue = bd.equals(BigDecimal.ZERO) != false ? Boolean.FALSE : Boolean.TRUE;
                return oValue;
            }
            catch (Exception e) {
                if (!AbstractLogger.isError) ** GOTO lbl48
                DataTypeConversions.logger.error("convertToBoolean: " + srcObj);
                DataTypeConversions.logger.error(e);
            }
        } else if (srcObj instanceof Number) {
            compare = -1;
            if (srcObj instanceof Byte) {
                value = (Byte)srcObj;
                compare = value.compareTo(Constants.BYTE_ZERO);
            } else if (srcObj instanceof Double) {
                value = (Double)srcObj;
                compare = value.compareTo(0.0);
            } else if (srcObj instanceof Float) {
                value = (Float)srcObj;
                compare = value.compareTo(Constants.FLOAT_ZERO);
            } else if (srcObj instanceof Long) {
                value = (Long)srcObj;
                compare = value.compareTo(Constants.LONG_ZERO);
            } else if (srcObj instanceof Integer) {
                value = (Integer)srcObj;
                compare = value.compareTo(Constants.INTEGER_ZERO);
            } else if (srcObj instanceof Short) {
                value = (Short)srcObj;
                compare = value.compareTo(Constants.SHORT_ZERO);
            }
            oValue = compare != 0 ? Boolean.TRUE : Boolean.FALSE;
            return oValue;
        }
lbl48:
        // 4 sources

        trimStr = srcObj.toString().trim();
        iClass = srcObj.getClass();
        classStr = iClass.getSimpleName();
        DataTypeConversions.badTargetValueTypeException(classStr, "Boolean", trimStr);
        return oValue;
    }

    public static Date convertToDate(Object srcObj) throws SQLException {
        Date oValue;
        block9: {
            oValue = null;
            if (srcObj == null) {
                return oValue;
            }
            if (srcObj instanceof TimeRepresentation) {
                TimeRepresentation tr = (TimeRepresentation)srcObj;
                oValue = tr.getDateValue();
                if (oValue != null) {
                    return oValue;
                }
            } else {
                if (srcObj instanceof Date) {
                    oValue = (Date)srcObj;
                    return oValue;
                }
                if (srcObj instanceof java.util.Date) {
                    Date oDate = (Date)srcObj;
                    long timeMS = oDate.getTime();
                    oValue = new Date(timeMS);
                    return oValue;
                }
                if (srcObj instanceof String) {
                    String oString = (String)srcObj;
                    try {
                        oValue = Date.valueOf(oString);
                        return oValue;
                    }
                    catch (Exception e) {
                        if (!AbstractLogger.isError) break block9;
                        logger.error("convertToDate: " + srcObj);
                        logger.error(e);
                    }
                }
            }
        }
        String trimStr = srcObj.toString().trim();
        Class<?> iClass = srcObj.getClass();
        String classStr = iClass.getSimpleName();
        DataTypeConversions.badTargetValueTypeException(classStr, "Date", trimStr);
        return oValue;
    }

    public static String convertToString(Object srcObj) {
        String oValue = null;
        if (srcObj == null) {
            return oValue;
        }
        if (srcObj instanceof TimeRepresentation) {
            TimeRepresentation tr = (TimeRepresentation)srcObj;
            oValue = tr.toString();
        } else if (srcObj instanceof String) {
            oValue = (String)srcObj;
        } else if (srcObj instanceof Number) {
            Number value = (Number)srcObj;
            oValue = value.toString();
        } else {
            oValue = srcObj.toString();
        }
        return oValue;
    }

    public static Time convertToTime(Object srcObj) throws SQLException {
        Time oValue;
        block6: {
            oValue = null;
            if (srcObj == null) {
                return oValue;
            }
            if (srcObj instanceof TimeRepresentation) {
                TimeRepresentation tr = (TimeRepresentation)srcObj;
                oValue = tr.getTimeValue();
                return oValue;
            }
            if (srcObj instanceof Date) {
                Date oDate = (Date)srcObj;
                oValue = new Time(oDate.getTime());
                return oValue;
            }
            if (srcObj instanceof String) {
                String oString = (String)srcObj;
                try {
                    oValue = Time.valueOf(oString);
                    return oValue;
                }
                catch (Exception e) {
                    if (!AbstractLogger.isError) break block6;
                    logger.error("convertToTime: " + srcObj);
                    logger.error(e);
                }
            }
        }
        String trimStr = srcObj.toString().trim();
        Class<?> iClass = srcObj.getClass();
        String classStr = iClass.getSimpleName();
        DataTypeConversions.badTargetValueTypeException(classStr, "Time", trimStr);
        return oValue;
    }

    public static Timestamp convertToTimestamp(Object srcObj) throws SQLException {
        Timestamp oValue;
        block6: {
            oValue = null;
            if (srcObj == null) {
                return oValue;
            }
            if (srcObj instanceof TimeRepresentation) {
                TimeRepresentation tr = (TimeRepresentation)srcObj;
                oValue = tr.getTimeStampValue();
                return oValue;
            }
            if (srcObj instanceof Date) {
                Date oDate = (Date)srcObj;
                oValue = new Timestamp(oDate.getTime());
                return oValue;
            }
            if (srcObj instanceof String) {
                String oString = (String)srcObj;
                try {
                    oValue = Timestamp.valueOf(oString);
                }
                catch (Exception e) {
                    if (!AbstractLogger.isError) break block6;
                    logger.error("convertToTimestamp: " + srcObj);
                    logger.error(e);
                }
            }
        }
        String trimStr = srcObj.toString().trim();
        Class<?> iClass = srcObj.getClass();
        String classStr = iClass.getSimpleName();
        DataTypeConversions.badTargetValueTypeException(classStr, "Timestamp", trimStr);
        return oValue;
    }

    public void convertNumberToRange() throws SQLException {
        if (this.srcObj == null) {
            this.wasNull = true;
            return;
        }
        if (this.srcObj instanceof Number) {
            Number inNumber = (Number)this.srcObj;
            this.srcStr = inNumber.toString();
        } else if (this.srcObj instanceof String) {
            this.srcStr = (String)this.srcObj;
        } else {
            this.throwConversionError();
            return;
        }
        try {
            this.srcStr = this.srcStr.trim();
            this.bd = new BigDecimal(this.srcStr);
            int bdCmp = this.bd.compareTo(this.maxBD);
            if (bdCmp > 0) {
                this.truncType = 1;
                this.bd = this.maxBD;
            } else {
                bdCmp = this.bd.compareTo(this.minBD);
                if (bdCmp < 0) {
                    this.truncType = (byte)-1;
                    this.bd = this.minBD;
                }
            }
        }
        catch (NumberFormatException nfe) {
            if (AbstractLogger.isError) {
                logger.error("convertNumberToRange: " + this.srcObj);
                logger.error(nfe);
            }
            this.throwConversionError();
        }
    }

    public void throwConversionError() throws SQLException {
        String iClassStr;
        if (this.srcObj == null) {
            this.srcStr = "null";
            iClassStr = "none";
        } else {
            this.srcStr = this.srcObj.toString().trim();
            Class<?> iClass = this.srcObj.getClass();
            iClassStr = iClass.getSimpleName();
        }
        String oClassStr = this.targetClassStr == null ? (this.tarObj == null ? "null" : this.tarObj.getClass().getSimpleName()) : this.targetClassStr;
        DataTypeConversions.badTargetValueTypeException(iClassStr, oClassStr, this.srcStr);
    }

    public static boolean supportsFullRange(int inST, int outST) {
        FSEnums.FsSqlTypes sSqlType = FSEnums.FsSqlTypes.getByValue(inST);
        FSEnums.FsSqlTypes tSqlType = FSEnums.FsSqlTypes.getByValue(outST);
        if (sSqlType.isNumber() && tSqlType.isNumber()) {
            int sBits = sSqlType.getNumberBits();
            int tBits = tSqlType.getNumberBits();
            if (tBits >= sBits) {
                return true;
            }
        }
        return false;
    }

    public DataTruncation getDataTruncation() {
        return this.dt;
    }

    public boolean truncation() {
        return this.truncType != 0;
    }

    public boolean getWasNull() {
        return this.wasNull;
    }

    public byte getByte(boolean parameter) throws SQLException {
        this.maxBD = Constants.BD_MAX_VALUE_OF_BYTE;
        this.minBD = Constants.BD_MIN_VALUE_OF_BYTE;
        this.tSqlType = -6;
        this.targetClassStr = "Byte";
        this.convertNumberToRange();
        byte out = this.bd.byteValue();
        if (this.truncation()) {
            this.tarObj = new Byte(out);
            this.createDataTruncation(parameter, this.read);
        }
        return out;
    }

    public short getShort(boolean parameter) throws SQLException {
        this.maxBD = Constants.BD_MAX_VALUE_OF_SHORT;
        this.minBD = Constants.BD_MIN_VALUE_OF_SHORT;
        this.tSqlType = 5;
        this.targetClassStr = "Short";
        this.convertNumberToRange();
        short out = this.bd.shortValue();
        if (this.truncation()) {
            this.tarObj = new Short(out);
            this.createDataTruncation(parameter, this.read);
        }
        return out;
    }

    public int getInt(boolean parameter) throws SQLException {
        this.maxBD = Constants.BD_MAX_VALUE_OF_INTEGER;
        this.minBD = Constants.BD_MIN_VALUE_OF_INTEGER;
        this.tSqlType = 4;
        this.targetClassStr = "Integer";
        this.convertNumberToRange();
        int out = this.bd.intValue();
        if (this.truncation()) {
            this.tarObj = new Integer(out);
            this.createDataTruncation(parameter, this.read);
        }
        return out;
    }

    public long getLong(boolean parameter) throws SQLException {
        this.maxBD = Constants.BD_MAX_VALUE_OF_LONG;
        this.minBD = Constants.BD_MIN_VALUE_OF_LONG;
        this.tSqlType = -5;
        this.targetClassStr = "Long";
        this.convertNumberToRange();
        long out = this.bd.longValue();
        if (this.truncation()) {
            this.tarObj = new Long(out);
            this.createDataTruncation(parameter, this.read);
        }
        return out;
    }

    public float getFloat(boolean parameter) throws SQLException {
        this.maxBD = Constants.BD_MAX_VALUE_OF_FLOAT;
        this.minBD = Constants.BD_MIN_VALUE_OF_FLOAT;
        this.tSqlType = 6;
        this.targetClassStr = "Float";
        this.convertNumberToRange();
        float out = this.truncType == 0 ? this.bd.floatValue() : (this.truncType == -1 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
        return out;
    }

    public double getDouble(boolean parameter) throws SQLException {
        this.maxBD = Constants.BD_MAX_VALUE_OF_DOUBLE;
        this.minBD = Constants.BD_MIN_VALUE_OF_DOUBLE;
        this.tSqlType = 8;
        this.targetClassStr = "Double";
        this.convertNumberToRange();
        double out = this.truncType == 0 ? this.bd.doubleValue() : (this.truncType == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        return out;
    }

    public static DataTruncation createDataTruncation(Object inObj, Object outObj, String colName, int ordinal, boolean parameter, boolean read) {
        int outDataSize;
        String outDataTypeStr;
        String outStr;
        int inDataSize;
        String inDataTypeStr;
        String inStr;
        DataTruncation dt = null;
        if (inObj == null) {
            inStr = "";
            Object inDataType = null;
            inDataTypeStr = "";
            inDataSize = 0;
        } else {
            inStr = inObj.toString();
            inStr = inStr.trim();
            Class<?> inDataType = inObj.getClass();
            inDataTypeStr = inDataType.getSimpleName();
            inDataSize = UtilityFunctions.getDataTruncationLength(inObj);
        }
        if (outObj == null) {
            outStr = "";
            Object outDataType = null;
            outDataTypeStr = "";
            outDataSize = 0;
        } else {
            outStr = outObj.toString();
            Class<?> outDataType = outObj.getClass();
            outDataTypeStr = outDataType.getSimpleName();
            outDataSize = UtilityFunctions.getDataTruncationLength(outObj);
        }
        if (colName == null || colName.length() == 0) {
            colName = Integer.toString(ordinal);
        }
        String lMsg = LocalizedErrorHandler.getLocalizedError("DataTrucationColumn.fmt", new String[]{colName, inDataTypeStr, outDataTypeStr, inStr, outStr});
        Throwable cause = new Throwable(lMsg);
        cause = cause.fillInStackTrace();
        dt = new DataTruncation(ordinal, parameter, read, inDataSize, outDataSize, cause);
        return dt;
    }

    public DataTruncation createDataTruncation(boolean parameter, boolean read) {
        this.dt = DataTypeConversions.createDataTruncation(this.srcObj, this.tarObj, this.colName, this.ordinal, parameter, read);
        return this.dt;
    }

    public static boolean targetIsNumber(int sqlType) {
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void badTargetSqlTypeException(Object value, int targetSqlType) throws SQLException {
        String sClassStr = "Null";
        if (value != null) {
            sClassStr = value.getClass().getSimpleName();
        }
        String sqlTypeStr = CommonLogger.getSQLTypeString(targetSqlType);
        Object[] parms = new String[]{sClassStr, sqlTypeStr};
        LocalizedErrorHandler.throwLocalizedException("TSField.conversionSqlError.fmt", parms, logger);
    }

    public static void badTargetClassException(Object value, String targetClass) throws SQLException {
        String sClassStr = "Null";
        if (value != null) {
            sClassStr = value.getClass().getSimpleName();
        }
        Object[] parms = new String[]{sClassStr, targetClass};
        LocalizedErrorHandler.throwLocalizedException("TSField.conversionError.fmt", parms, logger);
    }

    public static void badTargetValueTypeException(String sClassName, String tClassName, String vStr) throws SQLException {
        Object[] parms = new String[]{sClassName, tClassName, vStr};
        LocalizedErrorHandler.throwLocalizedException("TSField.conversionErrorVal.fmt", parms, null, logger);
    }

    public String toString() {
        String outStr = "Source: '";
        if (this.srcObj != null) {
            outStr = outStr + this.srcObj;
            outStr = outStr + "' class:" + this.srcObj.getClass().getSimpleName();
        }
        if (this.colName != null) {
            outStr = outStr + " colName:" + this.colName;
        }
        outStr = outStr + "\nTarget: sqlType:" + CommonLogger.getSQLTypeString(this.tSqlType);
        if (this.targetClassStr != null) {
            outStr = outStr + " class:" + this.targetClassStr;
        } else if (this.tarObj != null) {
            outStr = outStr + " class:" + this.tarObj.getClass().getSimpleName();
        }
        outStr = outStr + "\nRange: " + this.minBD + " to " + this.maxBD + " truncType:" + this.truncType;
        return outStr;
    }
}

