/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimestampColumn
extends AbstractColumn {
    private transient Timestamp data;

    public TimestampColumn(Timestamp value) {
        this.data = value;
    }

    @Override
    public String getString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    @Override
    public Timestamp getTimestamp() {
        Timestamp out = null;
        if (this.data != null) {
            out = (Timestamp)this.data.clone();
        }
        return out;
    }

    @Override
    public Time getTime() {
        Time time = null;
        if (this.data != null) {
            long timeMilliseconds = this.data.getTime();
            time = new Time(timeMilliseconds);
        }
        return time;
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        Time time = null;
        if (this.data != null) {
            long timeMilliseconds = this.data.getTime();
            time = new Time(timeMilliseconds);
            UtilityFunctions.applyCalendar(time, calendar);
        }
        return time;
    }

    @Override
    public Date getDate() {
        Date date = null;
        if (this.data != null) {
            long timeMilliseconds = this.data.getTime();
            date = new Date(timeMilliseconds);
        }
        return date;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        Date date = null;
        if (this.data != null) {
            long timeMilliseconds = this.data.getTime();
            date = new Date(timeMilliseconds);
            UtilityFunctions.applyCalendar(date, calendar);
        }
        return date;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        Timestamp newTS = null;
        if (this.data != null) {
            newTS = (Timestamp)this.data.clone();
            UtilityFunctions.applyCalendar(newTS, calendar);
        }
        return newTS;
    }

    @Override
    public Object getObject() {
        Object outObj = this.data;
        if (outObj != null) {
            outObj = this.data.clone();
        }
        return outObj;
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void setNull() {
        this.data = null;
        this.setUpdated(true);
    }

    @Override
    public void setObject(Object value) {
        Timestamp newTS = null;
        if (value != null && (newTS = (Timestamp)ParameterInfoHelper.coerceObject(value, 93, false)) == value) {
            newTS = (Timestamp)newTS.clone();
        }
        this.data = newTS;
        this.setUpdated(true);
    }

    @Override
    public void setTimestamp(Timestamp value) {
        this.data = value == null ? null : (Timestamp)value.clone();
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String outStr = this.data == null ? "Timestamp: NULL isUpdated:" + this.isUpdated() : "Timestamp:" + this.getString() + " isUpdated:" + this.isUpdated();
        return outStr;
    }

    @Override
    public Object getRawData() {
        return this.data;
    }

    @Override
    public final TimestampColumn clone() {
        Timestamp outTimestamp = this.getTimestamp();
        TimestampColumn out = new TimestampColumn(outTimestamp);
        return out;
    }

    @Override
    public int getSQLType() {
        return 93;
    }

    @Override
    public Class getDataTypeClass() {
        return this.data.getClass();
    }

    @Override
    public void cleanup() {
        this.data = null;
    }
}

