/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.Time;
import java.util.Calendar;

public class TimeColumn
extends AbstractColumn {
    private transient Time data;

    public TimeColumn(Time value) {
        this.data = value;
    }

    @Override
    public String getString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    @Override
    public Time getTime() {
        Time out = null;
        if (this.data != null) {
            out = (Time)this.data.clone();
        }
        return out;
    }

    @Override
    public Time getTime(Calendar cal) {
        Time outTime = null;
        if (this.data != null) {
            outTime = (Time)this.data.clone();
            UtilityFunctions.applyCalendar(outTime, cal);
        }
        return outTime;
    }

    @Override
    public Object getObject() {
        Object outObj = this.data;
        if (outObj != null) {
            outObj = this.data.clone();
        }
        return outObj;
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void setNull() {
        this.data = null;
        this.setUpdated(true);
    }

    @Override
    public void setObject(Object value) {
        Time inTime = null;
        if (value != null && (inTime = (Time)ParameterInfoHelper.coerceObject(value, 92, false)) == value) {
            inTime = (Time)inTime.clone();
        }
        this.data = inTime;
        this.setUpdated(true);
    }

    @Override
    public void setTime(Time value) {
        this.data = value == null ? null : (Time)value.clone();
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String outStr = this.data == null ? "Time: NULL isUpdated:" + this.isUpdated() : "Time:" + this.getString() + " isUpdated:" + this.isUpdated();
        return outStr;
    }

    @Override
    public Object getRawData() {
        return this.data;
    }

    @Override
    public final TimeColumn clone() {
        Time outTime = this.getTime();
        TimeColumn out = new TimeColumn(outTime);
        return out;
    }

    @Override
    public int getSQLType() {
        return 92;
    }

    @Override
    public Class getDataTypeClass() {
        return this.data.getClass();
    }

    @Override
    public void cleanup() {
        this.data = null;
    }
}

