/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.NumberColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberColumnLong
extends NumberColumn {
    private long data;

    public NumberColumnLong(long value) {
        Long l = new Long(0L);
        dataClass = l.getClass();
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public final NumberColumnLong clone() {
        NumberColumnLong out = new NumberColumnLong(this.data);
        return out;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.isNull()) {
            return null;
        }
        BigDecimal out = new BigDecimal(this.data);
        return out;
    }

    @Override
    public boolean getBoolean() {
        return this.booleanLong(this.data);
    }

    @Override
    public byte getByte() {
        return this.rangedLongToByte(this.data);
    }

    @Override
    public Class getDataTypeClass() {
        return dataClass;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.data;
    }

    @Override
    public float getFloat() {
        Float f = new Float(this.data);
        return f.floatValue();
    }

    @Override
    public int getInt() {
        return this.rangedLongToInt(this.data);
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public Object getObject() throws SQLException {
        Long outObj = null;
        if (!this.isNull()) {
            outObj = new Long(this.data);
        }
        return outObj;
    }

    @Override
    public Object getRawData() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() {
        return this.rangedLongToShort(this.data);
    }

    @Override
    public int getSQLType() {
        return -5;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.data);
    }

    @Override
    public void setBigDecimal(BigDecimal value) {
        if (value == null) {
            this.data = 0L;
            this.setUpdated(false);
        } else {
            this.data = value.longValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setByte(byte value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setDouble(double value) {
        this.data = this.rangedDoubleToLong(value);
    }

    @Override
    public void setFloat(float value) {
        this.data = this.rangedDoubleToLong(value);
    }

    @Override
    public void setInt(int value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setLong(long value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setNull() {
        this.data = 0L;
        this.setUpdated(false);
    }

    @Override
    public void setObject(Object value) {
        Number inNumber = null;
        if (value == null) {
            this.data = 0L;
            this.setUpdated(false);
        } else {
            int sqlType = UtilityFunctions.getObjectSQLType(value);
            inNumber = (Number)ParameterInfoHelper.coerceObject(value, sqlType, false);
            this.data = inNumber.longValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setShort(short value) {
        this.data = value;
    }

    @Override
    public String toString() {
        String out = this.isNull() ? "NULL" : Long.toString(this.data);
        return out;
    }
}

