/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.NumberColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberColumnInteger
extends NumberColumn {
    private int data;

    public NumberColumnInteger(int value) {
        Integer i = new Integer(0);
        dataClass = i.getClass();
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public final NumberColumnInteger clone() {
        NumberColumnInteger out = new NumberColumnInteger(this.data);
        return out;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.isNull()) {
            return null;
        }
        BigDecimal out = new BigDecimal((long)this.data);
        return out;
    }

    @Override
    public boolean getBoolean() {
        return this.booleanLong(this.data);
    }

    @Override
    public byte getByte() {
        return this.rangedLongToByte(this.data);
    }

    @Override
    public Class getDataTypeClass() {
        return dataClass;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }

    @Override
    public int getInt() {
        return this.data;
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public Object getObject() throws SQLException {
        Integer outObj = null;
        if (!this.isNull()) {
            outObj = new Integer(this.data);
        }
        return outObj;
    }

    @Override
    public Object getRawData() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() {
        return this.rangedLongToShort(this.data);
    }

    @Override
    public int getSQLType() {
        return 4;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Integer.toString(this.data);
    }

    @Override
    public void setBigDecimal(BigDecimal value) {
        if (value == null) {
            this.data = 0;
            this.setUpdated(false);
        } else {
            this.data = value.intValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setByte(byte value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setDouble(double value) {
        this.data = this.rangedDoubleToInt(value);
    }

    @Override
    public void setFloat(float value) {
        this.data = this.rangedDoubleToInt(value);
    }

    @Override
    public void setInt(int value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setLong(long value) {
        this.data = this.rangedLongToInt(value);
    }

    @Override
    public void setNull() {
        this.data = 0;
        this.setUpdated(false);
    }

    @Override
    public void setObject(Object value) {
        Number inNumber = null;
        if (value == null) {
            this.data = 0;
            this.setUpdated(false);
        } else {
            int sqlType = UtilityFunctions.getObjectSQLType(value);
            inNumber = (Number)ParameterInfoHelper.coerceObject(value, sqlType, false);
            this.data = inNumber.intValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setShort(short value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String out = this.isNull() ? "NULL" : Integer.toString(this.data);
        return out;
    }
}

