/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.iom.SASIOMDefs.OctetSeqHelper;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.types.BlobFedSrv;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.LongHolder;

public class LobColumn
extends AbstractColumn
implements Cloneable {
    private static String thisClassName = LobColumn.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient StatementWrapper statementWrapper;
    private transient int columnNumber;
    private transient int rowNumber;
    private transient boolean isBinary;
    private transient byte[] dataBytes;

    public LobColumn() {
    }

    public LobColumn(FSStatement stmtObject, int colNumber, int row, int sqlType) throws SQLException {
        this.statementWrapper = stmtObject.getStatementWrapper();
        this.columnNumber = colNumber;
        this.rowNumber = row;
        this.isBinary = sqlType == -4;
        this.dataBytes = this.getDataFromServer();
        this.setUpdated(true);
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        String value = this.getString();
        BigDecimal bigDecimal = null;
        if (value != null && !value.equals("")) {
            double dNumber = Double.parseDouble(value);
            bigDecimal = BigDecimal.valueOf(dNumber);
        }
        return bigDecimal;
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.dataBytes == null) {
            return null;
        }
        BlobFedSrv out = new BlobFedSrv(this.dataBytes);
        return out;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        byte[] out = this.dataBytes == null ? null : (byte[])this.dataBytes.clone();
        return out;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        ByteArrayInputStream byteArrayIS = null;
        if (this.dataBytes == null) {
            byteArrayIS = new ByteArrayInputStream(new byte[0]);
        } else {
            Charset asciiCS = CharSetUtil.getUS_ASCII_Charset();
            if (asciiCS == null) {
                String ei = "General.UnsupportedCEI.fmt";
                String s = Integer.toString(28);
                LocalizedErrorHandler.throwLocalizedException("General.UnsupportedCEI.fmt", logger, s);
            }
            String asciiStr = new String(this.dataBytes, asciiCS);
            byteArrayIS = new ByteArrayInputStream(asciiStr.getBytes());
        }
        return byteArrayIS;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream byteArrayIS = null;
        byteArrayIS = this.dataBytes != null ? new ByteArrayInputStream(this.dataBytes) : new ByteArrayInputStream(new byte[0]);
        return byteArrayIS;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(null);
    }

    @Override
    public Reader getCharacterStream(String charSet) throws SQLException {
        StringReader stringReader = null;
        String stringData = null;
        if (this.dataBytes != null) {
            stringData = charSet == null ? this.getString() : this.getString(charSet);
            stringReader = new StringReader(stringData);
        } else {
            stringReader = new StringReader("");
        }
        return stringReader;
    }

    @Override
    public Date getDate() throws SQLException {
        return this.getDate(null);
    }

    private SQLException createConvException(String tClass) {
        String ei = "TSField.conversionError.fmt";
        String sClass = this.isBinary ? "Blob" : "Clob";
        Object[] args = new String[]{sClass, tClass};
        String es = LocalizedErrorHandler.getLocalizedError("TSField.conversionError.fmt", args);
        SQLException outSE = new SQLException(es);
        return outSE;
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        SQLException se = this.createConvException("Date");
        throw se;
    }

    @Override
    public double getDouble() throws SQLException {
        SQLException se = this.createConvException("Double");
        throw se;
    }

    @Override
    public float getFloat() throws SQLException {
        SQLException se = this.createConvException("Float");
        throw se;
    }

    @Override
    public int getInt() throws SQLException {
        SQLException se = this.createConvException("Integer");
        throw se;
    }

    @Override
    public long getLong() throws SQLException {
        SQLException se = this.createConvException("Long");
        throw se;
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.dataBytes == null) {
            return this.dataBytes;
        }
        if (this.isBinary) {
            BlobFedSrv outBlobData = new BlobFedSrv(this.dataBytes);
            return outBlobData;
        }
        return this.getString();
    }

    @Override
    public short getShort() throws SQLException {
        SQLException se = this.createConvException("Short");
        throw se;
    }

    @Override
    public String getString() throws SQLException {
        String stringData = null;
        if (this.dataBytes != null) {
            Charset charSet = CharSetUtil.getToServerCharset();
            stringData = new String(this.dataBytes, charSet);
        }
        return stringData;
    }

    @Override
    public Time getTime() throws SQLException {
        SQLException se = this.createConvException("Time");
        throw se;
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        SQLException se = this.createConvException("Time");
        throw se;
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        SQLException se = this.createConvException("Timestamp");
        throw se;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        SQLException se = this.createConvException("Timestamp");
        throw se;
    }

    @Override
    public void setNull() {
        this.dataBytes = null;
        this.setUpdated(true);
    }

    @Override
    public boolean isNull() {
        return this.dataBytes == null;
    }

    @Override
    public void setObject(Object value) {
        if (value != null) {
            byte[] newValue = (byte[])ParameterInfoHelper.coerceObject(value, -4, false);
            if (value == newValue) {
                newValue = (byte[])newValue.clone();
            }
            this.dataBytes = newValue;
        } else {
            this.dataBytes = null;
        }
        this.setUpdated(true);
    }

    @Override
    public void setBytes(byte[] value) {
        this.dataBytes = (byte[])value.clone();
        this.setUpdated(true);
    }

    @Override
    public void setString(String value) throws SQLException {
        this.dataBytes = (byte[])(value != null ? value.getBytes() : null);
        this.setUpdated(true);
    }

    private synchronized byte[] getDataFromServer() throws SQLException {
        String method = "getDataFromServer";
        if (AbstractLogger.isTrace) {
            logger.entry(method);
        }
        byte[] dataFromServer = null;
        AnyHolder value = new AnyHolder();
        LongHolder longLengthHolder = new LongHolder();
        IntHolder status = new IntHolder();
        try {
            block15: {
                if (AbstractLogger.isTrace) {
                    logger.trace("Positioning at row " + this.rowNumber + " Column " + this.columnNumber);
                }
                if (this.statementWrapper.getLobPosition()) {
                    try {
                        this.statementWrapper.Position(this.rowNumber, 0, status);
                    }
                    catch (Exception e1) {
                        this.statementWrapper.setLobPosition(false);
                        if (!AbstractLogger.isTrace) break block15;
                        logger.trace(method + " columnNumber[" + this.columnNumber + "] targetType[TKTS_C_BINARY] Postion failed" + e1.toString());
                    }
                }
            }
            if (AbstractLogger.isTrace) {
                logger.trace(method + " columnNumber[" + this.columnNumber + "] targetType[TKTS_C_BINARY] offset[0] length[0]");
            }
            long offset = 0L;
            this.statementWrapper.GetData2(this.columnNumber, 2, offset, 0, value, longLengthHolder, status);
            if (AbstractLogger.isTrace) {
                logger.trace("getData2() bytes read [" + longLengthHolder.value + "]");
            }
            if (longLengthHolder.value != -1L) {
                if (AbstractLogger.isTrace) {
                    logger.trace(method + " columnNumber[" + this.columnNumber + "] targetType[TKTS_C_BINARY] offset[0] length[" + longLengthHolder.value + "] ");
                }
                int intLength = (int)longLengthHolder.value;
                this.statementWrapper.GetData2(this.columnNumber, 2, offset, intLength, value, longLengthHolder, status);
                if (status.value == -2130708476) {
                    dataFromServer = new byte[]{};
                } else {
                    dataFromServer = OctetSeqHelper.extract((Any)value.value);
                    if (AbstractLogger.isTrace) {
                        String blobStr = this.toString();
                        logger.trace(blobStr);
                    }
                }
            }
        }
        catch (Exception e) {
            LocalizedErrorHandler.handleExceptionsInFunction(method, e, this.statementWrapper, logger);
        }
        if (AbstractLogger.isTrace) {
            logger.exit(method);
        }
        return dataFromServer;
    }

    @Override
    public void setBlob(Blob blob) throws SQLException {
        if (blob == null) {
            this.dataBytes = null;
        } else {
            long blobBytes = this.dataBytes.length;
            if (blobBytes > Integer.MAX_VALUE) {
                SQLException se = BlobFedSrv.invalidLengthSQLException(blobBytes);
                throw se;
            }
            int intBytes = (int)blobBytes;
            byte[] inBytes = blob.getBytes(1L, intBytes);
            this.dataBytes = inBytes;
        }
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String FORMAT = "LOB isUpdated[%s] TotalBytes[%d]";
        if (this.dataBytes == null) {
            String outStr = String.format("LOB isUpdated[%s] TotalBytes[%d]", this.isUpdated(), -1);
            return outStr;
        }
        int lobBytes = this.dataBytes.length;
        int bytesPerRow = UtilityFunctions.getFormatBytesRowSize();
        int bytesToLog = lobBytes < bytesPerRow ? lobBytes : bytesPerRow;
        String outStr = String.format("LOB isUpdated[%s] TotalBytes[%d]", this.isUpdated(), lobBytes);
        outStr = outStr + UtilityFunctions.formatBytesHex(this.dataBytes, 0, bytesToLog);
        if (lobBytes > bytesPerRow) {
            outStr = outStr + " ... ";
            bytesToLog = bytesPerRow;
            outStr = outStr + UtilityFunctions.formatBytesHex(this.dataBytes, lobBytes -= bytesPerRow, bytesPerRow);
        }
        return outStr;
    }

    @Override
    public Object getRawData() {
        return this.dataBytes;
    }

    @Override
    public final LobColumn clone() {
        LobColumn out = new LobColumn();
        out.statementWrapper = this.statementWrapper;
        out.columnNumber = this.columnNumber;
        out.rowNumber = this.rowNumber;
        out.isBinary = this.isBinary;
        out.dataBytes = null;
        return out;
    }

    @Override
    public int getSQLType() {
        if (this.isBinary) {
            return 2004;
        }
        return 2005;
    }

    @Override
    public Class getDataTypeClass() {
        return this.dataBytes.getClass();
    }

    @Override
    public void cleanup() {
        this.statementWrapper = null;
        this.dataBytes = null;
    }
}

