/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.SASTableServer.TKTS_ERROR;
import com.sas.SASTableServer.TKTS_INVALID_HANDLE;
import com.sas.SASTableServer.TKTS_NO_DATA;
import com.sas.SASTableServer.TKTS_STILL_EXECUTING;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHelper;

public class InputStreamExt
extends InputStream {
    private static AbstractLogger m_logger = LoggerFactory.getLogger("com.sas.tkts.TKTSInputStream");
    transient StatementWrapper m_stmt;
    transient int m_col;
    transient long m_tlen;
    transient int data_type;
    transient boolean nomoreData = false;

    public InputStreamExt(StatementWrapper s, int row, int col, long trunclen) throws Exception {
        this(s, row, col, 2);
        if (trunclen > 0L) {
            this.m_tlen = trunclen;
        }
    }

    public InputStreamExt(StatementWrapper s, int row, int col, int stype) throws Exception {
        this.data_type = stype;
        this.m_tlen = 0L;
        this.m_stmt = s;
        try {
            IntHolder bogus = new IntHolder();
            this.m_stmt.FreeStmt(2, bogus);
            this.m_stmt.Position(row, 0, bogus);
        }
        catch (GenericError ge) {
            LocalizedErrorHandler.throwLocalizedException("TKTSInputStream.ctorError.txt", null, (Exception)((Object)ge), this.m_stmt, m_logger);
        }
        this.m_col = col;
    }

    @Override
    public int read() throws IOException {
        AnyHolder valueHolder = new AnyHolder();
        IntHolder flagHolder = new IntHolder();
        try {
            IntHolder bogus = new IntHolder();
            this.m_stmt.GetData(this.m_col, this.data_type, 0, 1, valueHolder, flagHolder, bogus);
            long lind = flagHolder.value;
            if (lind <= 1L) {
                this.nomoreData = true;
            }
        }
        catch (TKTS_ERROR te) {
            throw new IOException(te.getMessage());
        }
        catch (TKTS_STILL_EXECUTING tse) {
            throw new IOException(tse.getMessage());
        }
        catch (TKTS_INVALID_HANDLE tih) {
            throw new IOException(tih.getMessage());
        }
        catch (TKTS_NO_DATA tnd) {
            throw new IOException(tnd.getMessage());
        }
        catch (GenericError ge) {
            throw new IOException(ge.getMessage());
        }
        byte[] bs = OctetSeqHelper.extract((Any)valueHolder.value);
        byte b = bs[0];
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new IOException("Invalid byte array");
        }
        if (b.length == 0) {
            return 0;
        }
        AnyHolder valueHolder = new AnyHolder();
        IntHolder flagHolder = new IntHolder();
        try {
            IntHolder bogus = new IntHolder();
            this.m_stmt.GetData(this.m_col, this.data_type, 0, b.length, valueHolder, flagHolder, bogus);
            long lind = flagHolder.value;
            if (lind <= (long)b.length) {
                this.nomoreData = true;
            }
        }
        catch (TKTS_ERROR te) {
            throw new IOException(te.getMessage());
        }
        catch (TKTS_STILL_EXECUTING tse) {
            throw new IOException(tse.getMessage());
        }
        catch (TKTS_INVALID_HANDLE tih) {
            throw new IOException(tih.getMessage());
        }
        catch (TKTS_NO_DATA tnd) {
            throw new IOException(tnd.getMessage());
        }
        catch (GenericError ge) {
            throw new IOException(ge.getMessage());
        }
        byte[] x = OctetSeqHelper.extract((Any)valueHolder.value);
        System.arraycopy(x, 0, b, 0, b.length);
        return b.length;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.nomoreData) {
            return 0;
        }
        if (b == null) {
            throw new IOException("Invalid byte array");
        }
        if (b.length == 0 || length == 0) {
            return 0;
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IOException();
        }
        AnyHolder valueHolder = new AnyHolder();
        IntHolder flagHolder = new IntHolder();
        try {
            IntHolder bogus = new IntHolder();
            this.m_stmt.GetData(this.m_col, this.data_type, 0, length, valueHolder, flagHolder, bogus);
            long lind = flagHolder.value;
            if (lind <= (long)length) {
                this.nomoreData = true;
            }
        }
        catch (TKTS_ERROR te) {
            throw new IOException(te.getMessage());
        }
        catch (TKTS_STILL_EXECUTING tse) {
            throw new IOException(tse.getMessage());
        }
        catch (TKTS_INVALID_HANDLE tih) {
            throw new IOException(tih.getMessage());
        }
        catch (TKTS_NO_DATA tnd) {
            throw new IOException(tnd.getMessage());
        }
        catch (GenericError ge) {
            throw new IOException(ge.getMessage());
        }
        byte[] x = OctetSeqHelper.extract((Any)valueHolder.value);
        System.arraycopy(x, 0, b, offset, x.length);
        return length > x.length ? x.length : length;
    }
}

