/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class AbstractColumn
implements Cloneable {
    private static final String TRUNC_LOW_STR = "Low";
    private static final String TRUNC_NONE_STR = "None";
    private static final String TRUNC_HIGH_STR = "High";
    private static final String CONV_ERROR = "TSField.conversionError.fmt";
    protected static String thisClassName = AbstractColumn.class.getName();
    protected static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient byte isUpdated;
    private transient byte hasDataTruncation;

    public abstract Object getRawData() throws SQLException;

    public String getTruncString() {
        switch (this.hasDataTruncation) {
            case -1: {
                return TRUNC_LOW_STR;
            }
            case 0: {
                return TRUNC_NONE_STR;
            }
            case 1: {
                return TRUNC_HIGH_STR;
            }
        }
        return "Error";
    }

    public boolean isUpdated() {
        return this.isUpdated == 1;
    }

    public void setUpdated(boolean isUpdated) {
        this.isUpdated = isUpdated ? (byte)1 : 0;
    }

    public boolean getDataTruncation() {
        return this.hasDataTruncation != 0;
    }

    public byte getDataTruncationType() {
        return this.hasDataTruncation;
    }

    public void setDataTruncation(byte newValue) {
        this.hasDataTruncation = newValue;
    }

    public Array getArray() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Array"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setArray(Array value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Array"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public InputStream getAsciiStream() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "InputStream"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setAsciiStream(InputStream value, int length) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "InputStream"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "BigDecimal"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "BigDecimal"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public InputStream getBinaryStream() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "InputStream"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setBinaryStream(InputStream value, int length) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "InputStream"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public Blob getBlob() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Blob"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setBlob(Blob value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Blob"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public boolean getBoolean() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Boolean"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return false;
    }

    public void setBoolean(boolean value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Boolean"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public byte getByte() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Byte"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return 0;
    }

    public void setByte(byte value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Byte"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public byte[] getBytes() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "byte[]"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setBytes(byte[] value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "byte[]"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public Reader getCharacterStream() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "InputStream"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public Reader getCharacterStream(String charSet) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "InputStream"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setCharacterStream(Reader value, int length) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "InputStream"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public Clob getClob() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Blob"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setClob(Clob value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Blob"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public Date getDate() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Date"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public Date getDate(Calendar cal) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Date"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setDate(Date value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Date"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public double getDouble() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Double"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return 0.0;
    }

    public void setDouble(double value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Double"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public float getFloat() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Float"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return 0.0f;
    }

    public void setFloat(float value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Float"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public int getInt() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Integer"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return 0;
    }

    public void setInt(int value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Integer"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public long getLong() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Long"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return 0L;
    }

    public void setLong(long value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Long"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public void setObject(Object value, int scale) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Object"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public Ref getRef() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Ref"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setRef(Ref value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Ref"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public short getShort() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Short"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return 0;
    }

    public void setShort(short value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Short"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public String getString() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "String"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public String getString(String charSet) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "String"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setString(String value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "String"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public Time getTime() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Time"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public Time getTime(Calendar cal) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Time"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setTime(Time value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Time"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public Timestamp getTimestamp() throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Timestamp"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Timestamp"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
        return null;
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        Object[] parms = new String[]{this.getClass().toString(), "Timestamp"};
        LocalizedErrorHandler.throwLocalizedException(CONV_ERROR, parms, logger);
    }

    public abstract Object getObject() throws SQLException;

    public abstract void setObject(Object var1);

    public abstract boolean isNull();

    public abstract void setNull();

    public abstract AbstractColumn clone();

    public abstract int getSQLType();

    public abstract Class getDataTypeClass();

    public String toString() {
        return "Abstract toString";
    }

    public abstract void cleanup();
}

