/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.stats;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.stats.StatisticItem;
import java.util.HashMap;
import java.util.Map;

public class StatisticsBoard {
    public static boolean isStatisticsEnabled = false;
    private static StatisticsBoard statisticsBoard;
    private static byte[] lockItemMap;
    private static Map<String, StatisticItem> STAT_ITEM_MAP;
    private static AbstractLogger statBoardLogger;
    private static AbstractLogger thresholdLogger;
    private static String OVERALL_BEGIN;
    private static String OVERALL_END;
    private static String OVERALL_TOTAL_TIME;
    private static String OVERALL_FORMAT;
    private static String OVERALL_NAME;
    private static String OVERALL_COUNT;
    private static String OVERALL_PERCENT;
    private static String OVERALL_TIME;
    private static String OVERALL_BYTES;
    private static String OVERALL_ROWS;
    private static String OVERALL_AVERAGE;
    private static String OVERALL_OMIT;
    private static String OVERALL_COLUMNS_TOTALS;
    private static String THRESHOLD_FMT;
    private static long NANOSECONDS_TO_SECONDS;
    private static long measurementsThreshold;
    private static long measurementsThresholdSeconds;
    private static final String[] excludeItemList;

    private StatisticsBoard() {
        isStatisticsEnabled = true;
        this.initialize();
        OVERALL_BEGIN = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.begin.txt");
        OVERALL_END = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.end.txt");
        OVERALL_TOTAL_TIME = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.TotalTime.txt");
        OVERALL_FORMAT = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Format.txt");
        OVERALL_NAME = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Name.txt");
        OVERALL_COUNT = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Count.txt");
        OVERALL_PERCENT = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Percent.txt");
        OVERALL_TIME = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Time.txt");
        OVERALL_BYTES = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Bytes.txt");
        OVERALL_ROWS = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Rows.txt");
        OVERALL_AVERAGE = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Average.txt");
        OVERALL_OMIT = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Aggregate.txt");
        OVERALL_COLUMNS_TOTALS = LocalizedMessageHandler.getStatsLocalizedMessage("Overall.Totals.txt");
        THRESHOLD_FMT = LocalizedMessageHandler.getStatsLocalizedMessage("Threshold.Format.txt");
        statBoardLogger = LoggerFactory.getLogger("com.sas.tkts.measurements");
        thresholdLogger = LoggerFactory.getLogger("com.sas.tkts.thresholds");
    }

    private void initialize() {
        STAT_ITEM_MAP = new HashMap<String, StatisticItem>();
    }

    public static void initMeasurementsThreshold() {
        measurementsThresholdSeconds = AbstractLogger.getMeasurementsThreshold();
        measurementsThreshold = measurementsThresholdSeconds == 0L ? Long.MAX_VALUE : measurementsThresholdSeconds * NANOSECONDS_TO_SECONDS;
    }

    public static synchronized StatisticsBoard getInstance() {
        if (statisticsBoard == null) {
            statisticsBoard = new StatisticsBoard();
        }
        return statisticsBoard;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addStatisticsItem(StatisticItem item) {
        boolean result = true;
        if (item == null) return false;
        if (item.getName() == null) return false;
        if (item.getName().equals("")) {
            return false;
        }
        String key = item.getName();
        for (int i = 0; i < excludeItemList.length; ++i) {
            int cmpValue = key.compareTo(excludeItemList[i]);
            if (cmpValue != 0) continue;
            item.setExcludeFromTotals(true);
            break;
        }
        byte[] byArray = lockItemMap;
        synchronized (lockItemMap) {
            if (item != null && STAT_ITEM_MAP.get(key) != null) {
                return false;
            }
            STAT_ITEM_MAP.put(key, item);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeStatisticItem(StatisticItem item) {
        boolean result = false;
        if (item == null) return result;
        if (item.getName().equals("")) return result;
        byte[] byArray = lockItemMap;
        synchronized (lockItemMap) {
            if (STAT_ITEM_MAP.remove(item.getName()) == null) return result;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStatisticItem(String itemName) {
        boolean result = false;
        byte[] byArray = lockItemMap;
        synchronized (lockItemMap) {
            if (STAT_ITEM_MAP.remove(itemName) != null) {
                result = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public StatisticItem getStatisticItem(String itemName) {
        return STAT_ITEM_MAP.get(itemName);
    }

    public synchronized void recordStatistic(String itemName, String description, long timeToRecord) {
        StatisticItem statItem = STAT_ITEM_MAP.get(itemName);
        if (statItem == null) {
            statItem = new StatisticItem(itemName, description, timeToRecord);
            this.addStatisticsItem(statItem);
        }
        statItem.setExecutionTime(timeToRecord);
        statItem.incrementSummative();
    }

    public synchronized void recordStatistic(String itemName, String description, long timeToRecord, AbstractLogger logger) {
        StatisticItem statItem = STAT_ITEM_MAP.get(itemName);
        if (statItem == null) {
            statItem = new StatisticItem(itemName, description, timeToRecord);
            this.addStatisticsItem(statItem);
        }
        statItem.setExecutionTime(timeToRecord);
        statItem.incrementSummative();
        if (statBoardLogger != null && AbstractLogger.isMeasurements) {
            statBoardLogger.logStatistics(this.getStatisticItem(itemName));
        }
    }

    public synchronized void recordStatistic(String itemName, long delta, long rowCount, long bytes, AbstractLogger logger) {
        StatisticItem statItem = STAT_ITEM_MAP.get(itemName);
        if (statItem == null) {
            statItem = new StatisticItem(itemName, delta, rowCount, bytes);
            this.addStatisticsItem(statItem);
        }
        statItem.incrementPackSummative(delta, rowCount, bytes);
        if (statBoardLogger != null) {
            if (AbstractLogger.isMeasurementsDetails) {
                statBoardLogger.logStatistics(statItem);
            }
            if (delta >= measurementsThreshold) {
                long duration = statItem.getExecutionTime() / NANOSECONDS_TO_SECONDS;
                String s = String.format(THRESHOLD_FMT, duration, measurementsThresholdSeconds);
                thresholdLogger.warn(s);
            }
        }
    }

    public synchronized void recordStatistic(String itemName, long timeToRecord) {
        StatisticItem statItem = STAT_ITEM_MAP.get(itemName);
        if (statItem == null) {
            statItem = new StatisticItem(itemName, timeToRecord);
            this.addStatisticsItem(statItem);
        }
        statItem.setExecutionTime(timeToRecord);
        statItem.incrementSummative();
    }

    public synchronized void recordStatistic(String itemName, long timeToRecord, AbstractLogger logger) {
        if (STAT_ITEM_MAP == null) {
            return;
        }
        StatisticItem statItem = STAT_ITEM_MAP.get(itemName);
        if (statItem == null) {
            statItem = new StatisticItem(itemName, timeToRecord);
            this.addStatisticsItem(statItem);
        }
        statItem.setExecutionTime(timeToRecord);
        statItem.incrementSummative();
        if (statBoardLogger != null) {
            if (AbstractLogger.isMeasurementsDetails) {
                statBoardLogger.logStatistics(statItem);
            }
            if (timeToRecord >= measurementsThreshold) {
                long duration = timeToRecord / NANOSECONDS_TO_SECONDS;
                String s = String.format(THRESHOLD_FMT, itemName, duration, measurementsThresholdSeconds);
                thresholdLogger.warn(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logOverallStatistics(AbstractLogger logger) {
        if (statBoardLogger == null || !AbstractLogger.isMeasurements) return;
        long totalTime = 0L;
        long totalCount = 0L;
        long totalBytes = 0L;
        long totalRows = 0L;
        int excludedCount = 0;
        double totalPercent = 0.0;
        double totalAverage = 0.0;
        byte[] byArray = lockItemMap;
        synchronized (lockItemMap) {
            StatisticItem statItem;
            for (Map.Entry<String, StatisticItem> entry : STAT_ITEM_MAP.entrySet()) {
                boolean includeItem;
                statItem = entry.getValue();
                boolean bl = includeItem = !statItem.getExcludeFromTotals();
                if (includeItem) {
                    totalTime += statItem.getSummattive();
                    totalCount += statItem.getCounter();
                    totalBytes += statItem.getTotalBytes();
                    totalRows += statItem.getTotalRows();
                    continue;
                }
                ++excludedCount;
            }
            if (!AbstractLogger.isTraceToNull) {
                statBoardLogger.info(OVERALL_BEGIN);
            }
            double totalDbl = totalTime;
            String formatedItem = String.format(OVERALL_TOTAL_TIME, totalDbl /= 1.0E9);
            if (!AbstractLogger.isTraceToNull) {
                statBoardLogger.info(formatedItem);
            }
            formatedItem = String.format(OVERALL_FORMAT, OVERALL_NAME, OVERALL_COUNT, OVERALL_PERCENT, OVERALL_TIME, OVERALL_AVERAGE, OVERALL_BYTES, OVERALL_ROWS);
            if (!AbstractLogger.isTraceToNull) {
                statBoardLogger.info(formatedItem);
            }
            totalDbl = totalTime;
            for (Map.Entry<String, StatisticItem> entry : STAT_ITEM_MAP.entrySet()) {
                double percent;
                statItem = entry.getValue();
                if (totalDbl > 0.0) {
                    percent = statItem.getSummattive();
                    percent *= 100.0;
                    percent /= totalDbl;
                } else {
                    percent = 0.0;
                }
                statItem.setPercent(percent);
                statBoardLogger.logOverallStatistics(statItem);
            }
            totalDbl = totalTime;
            totalPercent = 0.0;
            totalAverage = 0.0;
            statBoardLogger.logOverallStatisticsTotals(OVERALL_COLUMNS_TOTALS, totalCount, totalPercent, totalDbl, totalAverage, totalBytes, totalRows);
            if (AbstractLogger.isTraceToNull) return;
            statBoardLogger.info(OVERALL_END);
            // ** MonitorExit[var20_9] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatistics() {
        HashMap<String, StatisticItem> new_stat_item_map = new HashMap<String, StatisticItem>();
        byte[] byArray = lockItemMap;
        synchronized (lockItemMap) {
            STAT_ITEM_MAP = new_stat_item_map;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static String getOmit() {
        return OVERALL_OMIT;
    }

    public synchronized long getBytes(String itemName) {
        StatisticItem statItem;
        long out = -1L;
        if (STAT_ITEM_MAP != null && (statItem = STAT_ITEM_MAP.get(itemName)) != null) {
            out = statItem.getTotalBytes();
        }
        return out;
    }

    static {
        lockItemMap = new byte[0];
        NANOSECONDS_TO_SECONDS = 1000000000L;
        excludeItemList = new String[]{"PreparedStatementAPI:ExecuteBatch", "Compress:Inflater", "Compress:Deflater"};
    }
}

