/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.ExceptionsLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSCallableStatement;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSPreparedStatement;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.StatementPoolFullException;
import com.sas.tkts.sql.StatementPoolMonitorTask;
import com.sas.tkts.sql.StatementPoolTimer;
import com.sas.tkts.util.UtilityFunctions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class StatementPoolManager
extends FedSrvJDBC {
    private static String thisClassName = StatementPoolManager.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static String jvmTempDirectory;
    private static String jvmFileSeparator;
    private static final String EI_CCE = "TKTSConnection.closedConnectionError.txt";
    public static final String STATISTIC_FILE_PREFIX = "stmtPooling_";
    public static final String STATISTIC_FILE_SUFIX = ".log";
    public static final String PROP_IS_POOLED_STATEMENT_ENABLED = "IS_POOLED_STATEMENT_ENABLED";
    public static final boolean DEFAULT_IS_POOLED_STATEMENT_ENABLED = false;
    public static final String PROP_MAX_STATEMENT_POOL_SIZE = "MAX_STATEMENT_POOL_SIZE";
    public static final int DEFAULT_MAX_STATEMENT_POOL_SIZE = 100;
    public static final int MAXIMUM_STATEMENT_POOL_SIZE = 1000;
    public static final String PROP_IS_ALLOCATE_OVER_THE_LIMIT = "IS_ALLOCATE_OVER_THE_LIMIT";
    public static final boolean DEFAULT_IS_ALLOCATE_OVER_THE_LIMIT = true;
    public static final String PROP_POOL_MAINTENANCE_INTERVAL = "POOL_MAINTENANCE_INTERVAL";
    public static final int DEFAULT_POOL_MAINTENANCE_INTERVAL = 2;
    public static final String PROP_IDLE_TIMEOUT = "IDLE_TIMEOUT";
    public static final int DEFAULT_IDLE_TIMEOUT = 120;
    public static final String PROP_IS_RECORD_STATISTICS = "IS_RECORD_STATISTICS";
    public static final boolean DEFAULT_IS_RECORD_STATISTICS = false;
    public static final String PROP_STATISTICS_OUTPUT_DIRECTORY = "STATISTICS_OUTPUT_DIRECTORY";
    public static String DEFAULT_STATISTICS_OUTPUT_DIRECTORY;
    protected static final short TYPE_STATEMENT = 0;
    protected static final short TYPE_PREPARED_STATEMENT = 1;
    protected static final short TYPE_CALLABLE_STATEMENT = 2;
    private static StatementPoolTimer poolMaintenanceTimer;
    private transient FSConnection connection;
    private transient HashMap<String, ArrayList<Object>> _POOL_AVAILABLE_STATEMENTS;
    private transient List<Object> _ALL_STATEMENTS_LIST;
    private transient StatementPoolMonitorTask poolMonitorTask;
    private transient long poolMissCounter;
    private transient long poolHitCounter;
    private transient long poolFullHitCounter;
    private transient long poolPurgesCounter;
    private transient int currentPoolSize;
    private transient int totalStatementCount;
    private transient int totalCallableStatementCount;
    private transient int totalPreparedStatementCount;
    private transient boolean isPooledStatementEnabled;
    private transient int maxStatementPoolSize;
    private transient int waitTimeOut;
    private transient boolean isAllocateOveTheLimit;
    private transient boolean isCacheOverTheLimit;
    private transient int poolMaintenanceInterval;
    private transient int idleTimeout;
    private transient boolean isPurgeOnWaitTimeout;
    private transient int purgeThreshold;
    private transient boolean isRecordStats;
    private transient PrintWriter statWriter;
    private transient String statisticsFileName;

    protected StatementPoolManager(FSConnection conn, Properties properties) {
        String method = "StatementPoolManager";
        if (logger == null) {
            logger = LoggerFactory.getLogger(thisClassName);
        }
        if (AbstractLogger.isTrace) {
            logger.entry(method);
        }
        this.connection = conn;
        this.setGlobalStatementPoolingProperties(properties);
        this._ALL_STATEMENTS_LIST = new ArrayList<Object>();
        if (this.isPooledStatementEnabled) {
            int hashEntries = this.maxStatementPoolSize;
            if (hashEntries > 1000) {
                hashEntries = 1000;
            }
            this._POOL_AVAILABLE_STATEMENTS = new HashMap(hashEntries);
            this.poolMonitorTask = poolMaintenanceTimer.createPoolMonitorTask(this);
            if (this.isRecordStats) {
                this.printInitialStatisticsRecords();
            }
        }
    }

    protected synchronized FSStatement getStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String method = "getStatement";
        if (AbstractLogger.isInfo) {
            String ei = "StatementPoolManager.getStatement.fmt";
            this.logInfoMessage(method, "StatementPoolManager.getStatement.fmt", logger, String.valueOf(resultSetType), String.valueOf(resultSetConcurrency));
        }
        FSStatement statement = this.createStatement(resultSetType, resultSetConcurrency);
        statement.isPooled = false;
        this.addToAllStatementsList(statement);
        return statement;
    }

    protected synchronized FSCallableStatement getCallableStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String method = "getCallableStatement";
        if (AbstractLogger.isInfo) {
            String ei = "StatementPoolManager.getCallableStatement.fmt";
            this.logInfoMessage(method, "StatementPoolManager.getCallableStatement.fmt", logger, String.valueOf(resultSetType), String.valueOf(resultSetConcurrency));
        }
        FSCallableStatement statement = null;
        if (!this.isPooledStatementEnabled) {
            statement = this.createCallableStatement(sql, resultSetType, resultSetConcurrency);
            statement.isPooled = false;
            this.addToAllStatementsList(statement);
        } else {
            try {
                statement = (FSCallableStatement)this.getPooledStatement((short)2, sql, resultSetType, resultSetConcurrency);
            }
            catch (StatementPoolFullException e) {
                LocalizedErrorHandler.throwLocalizedException("TKTS.StatementPoolFullException", null, e, logger);
            }
        }
        return statement;
    }

    protected synchronized FSPreparedStatement getPreparedStatement(String sqlStmt, int resultSetType, int resultSetConcurrency) throws SQLException {
        FSPreparedStatement statement = null;
        String method = "getPreparedStatement";
        if (AbstractLogger.isInfo) {
            String ei = "StatementPoolManager.getPreparedStatement.fmt";
            this.logInfoMessage(method, "StatementPoolManager.getPreparedStatement.fmt", logger, sqlStmt, String.valueOf(resultSetType), String.valueOf(resultSetConcurrency));
        }
        if (this.isPooledStatementEnabled) {
            try {
                statement = (FSPreparedStatement)this.getPooledStatement((short)1, sqlStmt, resultSetType, resultSetConcurrency);
            }
            catch (StatementPoolFullException e) {
                LocalizedErrorHandler.throwLocalizedException("TKTSStatementPool.Pool.is.FullError.fmt", (Object[])new String[]{"" + this.maxStatementPoolSize}, e, logger);
            }
        } else {
            statement = this.createPreparedStatement(sqlStmt, resultSetType, resultSetConcurrency);
            statement.isPooled = false;
            this.addToAllStatementsList(statement);
        }
        return statement;
    }

    protected synchronized void returnToPool(FSStatement statement) throws SQLException {
        String method = "returnToPool";
        if (AbstractLogger.isTrace) {
            logger.entry(method, statement.sqlStatementKEY);
        }
        ArrayList<Object> statementList = this._POOL_AVAILABLE_STATEMENTS.get(statement.sqlStatementKEY);
        statement.notInUseSince = System.currentTimeMillis();
        statementList.add(statement);
    }

    protected synchronized void tearDownStatementPoolManager() throws SQLException {
        String method = "tearDownStatementPoolManager";
        if (AbstractLogger.isTrace) {
            logger.entry(method);
        }
        if (this.isRecordStats) {
            this.printFinalStatisticsRecords();
        }
        if (this.isPooledStatementEnabled) {
            this.printStatsRecord("Stopping pool maintenance task.");
            poolMaintenanceTimer.stopPoolMonitorTask(this.poolMonitorTask);
        }
        while (!this._ALL_STATEMENTS_LIST.isEmpty()) {
            FSStatement statement = (FSStatement)this._ALL_STATEMENTS_LIST.remove(0);
            this.printStatsRecord("Closing statement [" + statement.sqlStatementKEY + "]  Usage Count [" + statement.usageCounter + "]");
            statement.tearDownStatement();
            statement.releaseOutgoingResources();
        }
        if (this._POOL_AVAILABLE_STATEMENTS != null && !this._POOL_AVAILABLE_STATEMENTS.isEmpty()) {
            for (ArrayList<Object> statementList : this._POOL_AVAILABLE_STATEMENTS.values()) {
                statementList.clear();
            }
            this._POOL_AVAILABLE_STATEMENTS.clear();
        }
        if (this.isRecordStats) {
            this.closeStatisticsWriter();
        }
        if (AbstractLogger.isTrace) {
            logger.exit(method);
        }
    }

    protected synchronized void removeStatement(Object stmtObject) {
        String method = "removeStatement";
        if (AbstractLogger.isTrace) {
            logger.entry(method, ((FSStatement)stmtObject).sqlStatementKEY);
        }
        if (this._ALL_STATEMENTS_LIST.remove(stmtObject)) {
            if (this.isPooledStatementEnabled && ((FSStatement)stmtObject).isPooled) {
                --this.currentPoolSize;
            }
        } else {
            this.printStatsRecord("STATEMENT NOT FOUND " + ((FSStatement)stmtObject).sqlStatementKEY);
        }
    }

    protected synchronized long getPoolMisses() {
        return this.poolMissCounter;
    }

    protected synchronized long getPoolHits() {
        return this.poolHitCounter;
    }

    protected synchronized long getPoolFullHits() {
        return this.poolFullHitCounter;
    }

    protected synchronized long getPoolPurges() {
        return this.poolPurgesCounter;
    }

    protected synchronized long getCurrentPoolSize() {
        return this.currentPoolSize;
    }

    protected synchronized boolean isPooledStatementEnabled() {
        return this.isPooledStatementEnabled;
    }

    protected synchronized boolean isCacheOverTheLimit() {
        return this.isCacheOverTheLimit;
    }

    protected synchronized boolean isPurgeOnWaitTimeout() {
        return this.isPurgeOnWaitTimeout;
    }

    protected synchronized boolean isAllocateOverTheLimit() {
        return this.isAllocateOveTheLimit;
    }

    protected synchronized int getWaitTimeOut() {
        return this.waitTimeOut;
    }

    protected synchronized int getPoolMaintenanceInterval() {
        return this.poolMaintenanceInterval;
    }

    protected synchronized int getIdleTimeout() {
        return this.idleTimeout;
    }

    protected synchronized int getPurgeThreshold() {
        return this.purgeThreshold;
    }

    protected synchronized int getMaxStatementPoolSize() {
        return this.maxStatementPoolSize;
    }

    protected synchronized String getLogFileName() {
        return this.statisticsFileName;
    }

    protected synchronized boolean isRecordStatistcs() {
        return this.isRecordStats;
    }

    protected synchronized void setMaxStatementPoolSize(int maxStatementPoolSize) {
        if (maxStatementPoolSize > 1000) {
            maxStatementPoolSize = 1000;
        } else if (maxStatementPoolSize <= 0) {
            maxStatementPoolSize = 1;
        }
        this.maxStatementPoolSize = maxStatementPoolSize;
    }

    protected synchronized void setPooledStatementEnabled(boolean isPooledStatementEnabled) {
        this.isPooledStatementEnabled = isPooledStatementEnabled;
    }

    protected synchronized void setWaitTimeOut(int waitTimeOut) {
        this.waitTimeOut = waitTimeOut;
    }

    protected synchronized void setIsAllocateOveTheLimit(boolean isAllocateOveTheLimit) {
        this.isAllocateOveTheLimit = isAllocateOveTheLimit;
    }

    protected synchronized void setCacheOverTheLimit(boolean isCacheOverTheLimit) {
        this.isCacheOverTheLimit = isCacheOverTheLimit;
    }

    protected synchronized void setPoolMaintenanceInterval(int poolMaintenanceInterval) {
        if (poolMaintenanceInterval < 2) {
            poolMaintenanceInterval = 2;
        }
        this.poolMaintenanceInterval = poolMaintenanceInterval;
    }

    protected synchronized void setIdleTimeout(int idleTimeout) {
        if (idleTimeout <= 0) {
            idleTimeout = 1;
        }
        this.idleTimeout = idleTimeout;
    }

    protected synchronized void setPurgeOnWaitTimeout(boolean isPurgeOnWaitTimeout) {
        this.isPurgeOnWaitTimeout = isPurgeOnWaitTimeout;
    }

    protected synchronized void setPurgeThreshold(int purgeThreshold) {
        this.purgeThreshold = purgeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResultSetHoldabilityAfterCommitRollback(int jdbcSideResultSetHoldability) throws SQLException {
        String method = "handleResultSetHoldabilityAfterCommitRollback";
        if (AbstractLogger.isTrace) {
            logger.entry(method);
        }
        if (jdbcSideResultSetHoldability == 2) {
            List<Object> list = this._ALL_STATEMENTS_LIST;
            synchronized (list) {
                if (this._ALL_STATEMENTS_LIST != null) {
                    for (FSStatement fSStatement : this._ALL_STATEMENTS_LIST) {
                        fSStatement.closeGlobalResultSet();
                    }
                }
            }
        }
    }

    protected synchronized void runPoolMaintenanceRoutine() {
        if (this._POOL_AVAILABLE_STATEMENTS != null && !this._POOL_AVAILABLE_STATEMENTS.isEmpty()) {
            for (ArrayList<Object> pooledStatemenstList : this._POOL_AVAILABLE_STATEMENTS.values()) {
                int index = 0;
                while (!pooledStatemenstList.isEmpty() && index < pooledStatemenstList.size()) {
                    FSStatement statement = (FSStatement)pooledStatemenstList.get(index);
                    long idleTime = (System.currentTimeMillis() - statement.notInUseSince) / 1000L;
                    if (idleTime >= (long)this.idleTimeout) {
                        try {
                            ++this.poolPurgesCounter;
                            pooledStatemenstList.remove(index);
                            this.printStatsRecord("Purging statement [" + statement.sqlStatementKEY + "]");
                            statement.tearDownStatement();
                            this.removeStatement(statement);
                        }
                        catch (SQLException e) {
                            ExceptionsLogger.logSql(e);
                        }
                        continue;
                    }
                    ++index;
                }
            }
        }
    }

    public void run() {
        this.runPoolMaintenanceRoutine();
    }

    public static long getPoolMisses(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getPoolMisses();
    }

    public static long getPoolHits(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getPoolHits();
    }

    public static long getPoolFullHits(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getPoolFullHits();
    }

    public static long getPoolPurges(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getPoolPurges();
    }

    public static long getCurrentPoolSize(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getCurrentPoolSize();
    }

    public static boolean isPooledStatementEnabled(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.isPooledStatementEnabled();
    }

    public static boolean isCacheOverTheLimit(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.isCacheOverTheLimit();
    }

    public static boolean isPurgeOnWaitTimeout(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.isPurgeOnWaitTimeout();
    }

    public static boolean isAllocateOverTheLimit(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.isAllocateOverTheLimit();
    }

    public static int getWaitTimeOut(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getWaitTimeOut();
    }

    public static int getPoolMaintenanceInterval(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getPoolMaintenanceInterval();
    }

    public static int getIdleTimeout(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getIdleTimeout();
    }

    public static int getPurgeThreshold(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getPurgeThreshold();
    }

    public static int getMaxStatementPoolSize(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getMaxStatementPoolSize();
    }

    public static String getLogFileName(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.getLogFileName();
    }

    public static boolean getIsRecordStatistics(Connection conn) throws SQLException {
        if (((FSConnection)conn).isClosed()) {
            StatementPoolManager.staticThrowException(EI_CCE, logger);
        }
        return ((FSConnection)conn).statementPoolManager.isRecordStatistcs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object getPooledStatement(short stmtType, String sqlStmt, int resultSetType, int resultSetConcurrency) throws SQLException, StatementPoolFullException {
        String stmtKey = stmtType + "/" + resultSetType + ":" + resultSetConcurrency + ":" + UtilityFunctions.compressString(sqlStmt);
        ArrayList<Object> statementList = this._POOL_AVAILABLE_STATEMENTS.get(stmtKey);
        Object stmtObject = null;
        if (statementList == null) {
            statementList = new ArrayList();
            this._POOL_AVAILABLE_STATEMENTS.put(stmtKey, statementList);
        }
        if (statementList.isEmpty()) {
            if (this.currentPoolSize < this.maxStatementPoolSize) {
                stmtObject = this.allocateStatement(stmtType, stmtKey, sqlStmt, resultSetType, resultSetConcurrency, true);
                ++this.currentPoolSize;
            } else {
                ++this.poolFullHitCounter;
                if (!this.isAllocateOveTheLimit) throw new StatementPoolFullException();
                stmtObject = this.allocateStatement(stmtType, stmtKey, sqlStmt, resultSetType, resultSetConcurrency, this.isCacheOverTheLimit);
            }
        } else {
            ++this.poolHitCounter;
            stmtObject = statementList.remove(0);
        }
        ++((FSStatement)stmtObject).usageCounter;
        return stmtObject;
    }

    private Object allocateStatement(short stmtType, String stmtKey, String sqlStmt, int resultSetType, int resultSetConcurrency, boolean isPooled) throws SQLException {
        FSStatement stmtObject = null;
        switch (stmtType) {
            case 0: {
                stmtObject = this.createStatement(resultSetType, resultSetConcurrency);
                break;
            }
            case 2: {
                stmtObject = this.createCallableStatement(sqlStmt, resultSetType, resultSetConcurrency);
                break;
            }
            case 1: {
                stmtObject = this.createPreparedStatement(sqlStmt, resultSetType, resultSetConcurrency);
                break;
            }
        }
        ++this.poolMissCounter;
        this.addToAllStatementsList(stmtObject);
        stmtObject.isPooled = isPooled;
        stmtObject.notInUseSince = 0L;
        stmtObject.sqlStatementKEY = stmtKey;
        if (this.isRecordStats) {
            this.printStatsRecord("New statement has been allocated [" + sqlStmt + "]");
        }
        return stmtObject;
    }

    private FSStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.totalStatementCount;
        return new FSStatement(this.connection, resultSetType, resultSetConcurrency, 100);
    }

    private FSCallableStatement createCallableStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.totalCallableStatementCount;
        return new FSCallableStatement(this.connection, sql, resultSetType, resultSetConcurrency);
    }

    private FSPreparedStatement createPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.totalPreparedStatementCount;
        return new FSPreparedStatement(this.connection, sql, resultSetType, resultSetConcurrency);
    }

    private synchronized void addToAllStatementsList(Object stmtObject) {
        this._ALL_STATEMENTS_LIST.add(stmtObject);
    }

    private void setGlobalStatementPoolingProperties(Properties properties) {
        String method = "setGlobalStatementPoolingProperties";
        this.isPooledStatementEnabled = UtilityFunctions.evaluateBooleanProperty(properties.getProperty(PROP_IS_POOLED_STATEMENT_ENABLED), false);
        int intValue = UtilityFunctions.evaluateIntegerProperty(properties.getProperty(PROP_MAX_STATEMENT_POOL_SIZE), 100);
        this.setMaxStatementPoolSize(intValue);
        this.isAllocateOveTheLimit = UtilityFunctions.evaluateBooleanProperty(properties.getProperty(PROP_IS_ALLOCATE_OVER_THE_LIMIT), true);
        intValue = UtilityFunctions.evaluateIntegerProperty(properties.getProperty(PROP_POOL_MAINTENANCE_INTERVAL), 2);
        this.setPoolMaintenanceInterval(intValue);
        intValue = UtilityFunctions.evaluateIntegerProperty(properties.getProperty(PROP_IDLE_TIMEOUT), 120);
        this.setIdleTimeout(intValue);
        boolean bl = this.isRecordStats = UtilityFunctions.evaluateBooleanProperty(properties.getProperty(PROP_IS_RECORD_STATISTICS), false) && this.isPooledStatementEnabled;
        if (this.isRecordStats) {
            String statBaseDir = UtilityFunctions.evaluateStringProperty(properties.getProperty(PROP_STATISTICS_OUTPUT_DIRECTORY), DEFAULT_STATISTICS_OUTPUT_DIRECTORY);
            this.statisticsFileName = this.buildStatisticsFileName(statBaseDir);
            this.statWriter = this.openStatisticsWriter(this.statisticsFileName);
        }
        if (AbstractLogger.isInfo) {
            String ei = "StatementPoolManager.setGlobalStatementPoolingProperties.fmt";
            this.logInfoMessage(method, "StatementPoolManager.setGlobalStatementPoolingProperties.fmt", logger, String.valueOf(this.isPooledStatementEnabled), String.valueOf(this.maxStatementPoolSize), String.valueOf(this.isAllocateOveTheLimit), String.valueOf(this.poolMaintenanceInterval), String.valueOf(this.idleTimeout), String.valueOf(this.isRecordStats), this.statisticsFileName);
        }
    }

    private String buildStatisticsFileName(String baseDirectory) {
        Calendar calendar = Calendar.getInstance();
        String fileName = baseDirectory + jvmFileSeparator + STATISTIC_FILE_PREFIX + calendar.get(1) + (calendar.get(2) + 1) + calendar.get(5) + "_" + calendar.get(11) + calendar.get(12) + calendar.get(13) + calendar.get(14) + "_" + this.connection.hashCode() + STATISTIC_FILE_SUFIX;
        return fileName;
    }

    private PrintWriter openStatisticsWriter(String fileName) {
        String method = "openStatisticsWriter";
        if (AbstractLogger.isTrace) {
            logger.entry(method, fileName);
        }
        File statFile = null;
        PrintWriter writer = null;
        try {
            statFile = new File(fileName);
            writer = new PrintWriter(statFile);
            writer.flush();
        }
        catch (FileNotFoundException e) {
            this.isRecordStats = false;
        }
        if (AbstractLogger.isTrace) {
            logger.exit(method);
        }
        return writer;
    }

    private void closeStatWriter() {
        if (this.statWriter != null) {
            this.statWriter.flush();
            this.statWriter.close();
            this.statWriter = null;
        }
    }

    private void closeStatisticsWriter() {
        this.printStatsRecord("Statement Pool Manager stopped.");
        this.closeStatWriter();
    }

    private void printInitialStatisticsRecords() {
        this.printStatsRecord("Initializing Statement Pooling.");
        this.printStatsRecord("Allocate statement over the pool limit is set to [" + this.isAllocateOveTheLimit + "]");
        this.printStatsRecord("Pool maintenance interval is set to [" + this.poolMaintenanceInterval + " seconds]");
        this.printStatsRecord("Maximum pool size is set to [" + this.maxStatementPoolSize + "]");
        this.printStatsRecord("Idle statement timeout is set to [" + this.idleTimeout + " seconds]");
    }

    private void printFinalStatisticsRecords() {
        this.printStatsRecord("Statement pool manager is shutting down.");
        this.printStatsRecord("Total number of pooled and non-pooled statements allocated by pool manager [" + this.totalStatementCount + "]");
        this.printStatsRecord("Total number of pooled and non-pooled callable statements allocated by pool manager [" + this.totalCallableStatementCount + "]");
        this.printStatsRecord("Total number of pooled and non-pooled prepared statements allocated by pool manager [" + this.totalPreparedStatementCount + "]");
        this.printStatsRecord("Current statement pool size [" + this.currentPoolSize + "]");
        this.printStatsRecord("Number of pool misses [" + this.poolMissCounter + "]");
        this.printStatsRecord("Number of pool hits [" + this.poolHitCounter + "]");
        this.printStatsRecord("Number of statements allocated over the pool limit [" + this.poolFullHitCounter + "]");
        this.printStatsRecord("Number of statements purged by the maintenance task [" + this.poolPurgesCounter + "]");
    }

    private void printStatsRecord(String message) {
        if (AbstractLogger.isTrace) {
            logger.trace(message);
        }
        if (this.isRecordStats && this.statWriter != null) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            this.statWriter.println(timestamp + " > " + message);
            this.statWriter.flush();
        }
    }

    protected void finalize() throws Throwable {
        this.closeStatWriter();
        super.finalize();
    }

    static {
        DEFAULT_STATISTICS_OUTPUT_DIRECTORY = jvmTempDirectory;
        poolMaintenanceTimer = StatementPoolTimer.getInstance();
        try {
            jvmTempDirectory = System.getProperty("java.io.tmpdir");
        }
        catch (Exception ex) {
            jvmTempDirectory = null;
        }
        try {
            jvmFileSeparator = System.getProperty("file.separator");
        }
        catch (Exception ex) {
            jvmFileSeparator = null;
        }
        DEFAULT_STATISTICS_OUTPUT_DIRECTORY = jvmTempDirectory;
    }
}

