/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.SASTableServer.TKTS_ERROR;
import com.sas.SASTableServer.TKTS_INVALID_HANDLE;
import com.sas.SASTableServer.TKTS_NO_DATA;
import com.sas.SASTableServer.TKTS_STILL_EXECUTING;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.TrackResource;
import com.sas.tkts.info.ColumnsAttributes;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.iom.AbstractIOMWrapper;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.ExceptionsLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSResultSet;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.TypesHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.ORB;

public class FSStatement
extends FedSrvJDBC
implements Statement,
Wrapper {
    private static String thisClassName = FSStatement.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static String DEBUG_DATE = " Date: ";
    private static String EI_NOT_UPDATE = "TKTSStatement.notAnUpdateError.fmt";
    private static String EI_NOT_QUERY = "TKTSStatement.notAQueryError.fmt";
    protected static boolean trackStatements = false;
    protected static TrackResource myResources;
    protected static boolean debugFlag;
    protected static byte[] P1_NO_PARMETERS;
    private transient int maxFieldSize;
    protected transient boolean isStatementClosed;
    private transient int fetchSizeApi;
    private transient int fetchSizeCurrent;
    private transient boolean hintPoolable;
    protected transient StatementWrapper statementWrapper;
    protected transient boolean isQueryStatement;
    protected transient boolean isAttributeRowNumberOK;
    protected transient int fetchDirection;
    protected transient boolean isEscapeProcessing;
    protected transient ORB orbHandle;
    protected transient SQLWarning globalSQLWarning;
    protected transient FSResultSet globalResultSet;
    protected transient int updateCounter;
    protected transient FSConnection fsConnection;
    protected transient boolean wasExecuted;
    protected transient boolean isPooled;
    protected transient boolean isPackType1;
    protected transient long notInUseSince;
    protected transient long usageCounter;
    protected transient String sqlStatementKEY;
    protected transient String lastSqlStatement;
    protected transient SQLFeatureNotSupportedException nsEx;
    protected transient long applicationLast;
    protected transient long applicationDelayDuration;
    private transient boolean synchResultSetAttribute;
    private transient int cursorType;
    private transient int cursorTypeRequested;
    private transient int resultSetType;
    private transient int resultSetTypeRequested;
    private transient int cursorScrollable;
    private transient int cursorScrollableRequested;
    private transient int cursorSensitivity;
    private transient int cursorSensitivityRequested;
    private transient int cursorConcurrency;
    private transient int cursorConcurrencyRequested;
    private transient int resultSetConcurrency;
    private transient int resultSetConcurrencyRequested;
    private transient int resultSetMaxRows;
    private transient int resultSetMaxRowsRequested;
    private transient int useBookmarks;
    protected transient boolean isUsingBookmarks;
    protected transient int paramset_behavior;
    protected transient boolean isParameterArraySupported;
    protected transient ParameterInfo[] _COLUMN_INFO_ARRAY;
    protected transient int numberOfColumnsToBeBound;
    protected transient int numberOfColumnsInResultSet;
    protected transient List<String> _BATCH_STATEMENT_LIST;
    protected transient int previousBatchSize;
    protected transient int currentBatchSize;
    protected transient int lastBatchIndex;
    protected transient int nullBehavior;
    protected transient int abnormalColumnCount;
    protected transient int[] abnormalColumnIndexes;
    private transient boolean prepared;
    private transient Date preparedDate;
    private transient boolean columnsBound;
    private transient Date columnsBoundDate;
    private transient boolean parametersBound;
    private transient Date parametersBoundDate;
    private transient boolean cursorState;
    private transient Date cursorStateDate;
    protected transient boolean prefetch;
    protected transient OctetSeqHolder paramStatus;
    protected transient IntHolder paramsProcessed;
    protected transient AnySeqHolder outputParams1;
    protected transient OctetSeqHolder outputParams2;
    protected transient LongHolder rowCount;
    protected transient IntHolder statusHolder;
    protected transient VariableArray2dOfLongHolder outLenOrInd1;
    protected transient Any[] inputParam1;
    protected transient int[][] inLenOrInd1;
    protected transient byte[] packedInputBuffer2;
    protected transient byte[] paramOperations2;
    protected transient IntHolder statusIntHolder;
    protected transient LongHolder _rowCount;

    private void setup() {
        this.cursorType = this.fsConnection.cursorType;
        this.cursorTypeRequested = this.fsConnection.cursorType;
        this.resultSetType = 1003;
        this.resultSetTypeRequested = 1003;
        this.resultSetConcurrency = 1007;
        this.resultSetConcurrencyRequested = 1007;
        this.isParameterArraySupported = false;
        this.resultSetMaxRows = Integer.MIN_VALUE;
        this.hintPoolable = false;
        this.fetchDirection = 1000;
        this.fetchSizeApi = Integer.MIN_VALUE;
        this.isEscapeProcessing = true;
        this.updateCounter = -1;
        this.prefetch = false;
        this.paramStatus = new OctetSeqHolder();
        this.paramsProcessed = new IntHolder();
        this.outputParams1 = new AnySeqHolder();
        this.outputParams2 = new OctetSeqHolder();
        this.rowCount = new LongHolder();
        this.statusHolder = new IntHolder();
        this.outLenOrInd1 = new VariableArray2dOfLongHolder();
        this.inputParam1 = new Any[0];
        this.inLenOrInd1 = new int[0][0];
        this.packedInputBuffer2 = new byte[0];
        this.paramOperations2 = new byte[0];
        this.statusIntHolder = new IntHolder();
        this._rowCount = new LongHolder();
        this.previousBatchSize = 1;
        this.currentBatchSize = 0;
        this.synchResultSetAttribute = false;
        this.useBookmarks = Integer.MIN_VALUE;
        this.nsEx = null;
    }

    protected FSStatement(FSConnection connection, int rSetType, int rSetConcurrency, int defaultBatchSize) throws SQLException {
        this.fsConnection = connection;
        this.setup();
        int connDefaultFetchSize = connection.getDefaultFetchSize();
        this.resultSetType = rSetType;
        this.resultSetTypeRequested = rSetType;
        this.resultSetConcurrency = rSetConcurrency;
        this.resultSetConcurrencyRequested = rSetConcurrency;
        this.orbHandle = this.fsConnection.getORBHandle();
        if (this.fsConnection.getParameterSetSizeSupported()) {
            this.isParameterArraySupported = true;
        }
        this.statementWrapper = new StatementWrapper(this);
        boolean scrollable = false;
        if (this.resultSetType == 1004 || this.resultSetType == 1005) {
            scrollable = true;
        }
        this.setResultSetScrollable(scrollable);
        if (this.resultSetConcurrency == 1008) {
            this.setConcurrencyUpdatable();
        } else {
            this.setConcurrencyReadOnly();
        }
        this.initBookmarks();
        if (this.synchResultSetAttribute) {
            this.synchResultSetAttributes();
        }
        this.validateAttributeRowNumber(this.fsConnection);
        int newFetchSize = connDefaultFetchSize == 0 ? 100 : connDefaultFetchSize;
        boolean bl = this.isPackType1 = 1 == connection.getPackType();
        if (connection.getPrefetch()) {
            if (rSetType != 1003 || rSetConcurrency != 1007) {
                String ei = "TKTSPrefetch.InvalidOptions.txt";
                String le = LocalizedErrorHandler.getString("TKTSPrefetch.InvalidOptions.txt");
                SQLWarning w = new SQLWarning(le);
                this.addWarning(w);
            } else {
                this.prefetch = true;
            }
        }
        this.setFetchSize(newFetchSize);
        this.setupParameterSetBehavior();
        if (defaultBatchSize > 0) {
            this.setParameterSetSize(defaultBatchSize);
        }
        this.nullBehavior = connection.getNullBehavior();
        if (this.nullBehavior != -2) {
            this.setAttribute(20301, this.nullBehavior);
        }
        if (AbstractLogger.isTrace) {
            logger.trace("Constructor FSStatement(FSConnection, rSetType, rSetConcurrency)");
        }
        if (trackStatements) {
            String tStr = "STMT_ID:" + this.getMyID() + ":CONN_ID:" + connection.getMyID();
            myResources.track(this, tStr);
        }
    }

    public void addWarning(SQLWarning warning) {
        this.createWarnings(warning);
    }

    @Override
    public synchronized void addBatch(String sqlStmt) throws SQLException {
        String ei;
        String method = "addBatch";
        if (AbstractLogger.isInfo) {
            ei = "FSStatement.addBatch.fmt";
            this.logInfoMessage("addBatch", "FSStatement.addBatch.fmt", logger, sqlStmt);
        }
        this.closedCheck();
        if (sqlStmt == null || sqlStmt.length() == 0) {
            ei = "TKTSStatement.emptyStatement.txt";
            this.throwException("TKTSStatement.emptyStatement.txt", logger);
        }
        if (this._BATCH_STATEMENT_LIST == null) {
            this._BATCH_STATEMENT_LIST = new ArrayList<String>();
        }
        this._BATCH_STATEMENT_LIST.add(sqlStmt);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        String method = "executeBatch";
        if (AbstractLogger.isInfo) {
            String ei = "FSStatement.executeBatch.txt";
            this.logInfoMessage("executeBatch", "FSStatement.executeBatch.txt", logger, new Object[0]);
        }
        this.closedCheck();
        this.clearWarnings();
        if (this._BATCH_STATEMENT_LIST == null || this._BATCH_STATEMENT_LIST.isEmpty()) {
            if (AbstractLogger.isTrace) {
                logger.trace("No Batch Statements to execute");
                logger.exit("executeBatch");
            }
            return new int[0];
        }
        Vector<Integer> rowCountVector = new Vector<Integer>();
        int[] rowCounts = null;
        block4: while (true) {
            try {
                while (!this._BATCH_STATEMENT_LIST.isEmpty()) {
                    String sqlStmt = this._BATCH_STATEMENT_LIST.remove(0);
                    this.prepareSQLStatementForExecution(sqlStmt);
                    if (this.isQueryStatement) {
                        this.throwException(EI_NOT_UPDATE, logger, sqlStmt);
                    }
                    try {
                        this.updateCounter = this.executeSQLStatement();
                        rowCountVector.add(new Integer(this.updateCounter));
                        continue block4;
                    }
                    catch (Exception exception) {
                        LocalizedErrorHandler.handleExceptionsInFunction("executeBatch", exception, this.statementWrapper, logger);
                    }
                }
                break;
            }
            catch (Exception e) {
                rowCounts = UtilityFunctions.extractIntArrayFromIntegerVector(rowCountVector);
                this._BATCH_STATEMENT_LIST.clear();
                String ei = "TKTSStatement.batchUpdateError.fmt";
                String le = this.getLocalizedError("TKTSStatement.batchUpdateError.fmt", e.getMessage());
                BatchUpdateException bue = new BatchUpdateException(le, rowCounts);
                throw bue;
            }
        }
        rowCounts = UtilityFunctions.extractIntArrayFromIntegerVector(rowCountVector);
        if (AbstractLogger.isTrace) {
            for (int j = 0; j < rowCounts.length; ++j) {
                logger.trace("[" + j + "] Inserts row count=[" + rowCounts[j] + "]");
            }
        }
        return rowCounts;
    }

    @Override
    public synchronized boolean execute(String sqlStmt) throws SQLException {
        String method = "execute(sqlStmt)";
        if (AbstractLogger.isInfo) {
            String ei = "FSStatement.execute.fmt";
            this.logInfoMessage("execute(sqlStmt)", "FSStatement.execute.fmt", logger, sqlStmt);
        }
        this.closedCheck();
        this.clearWarnings();
        this.prepareSQLStatementForExecution(sqlStmt);
        if (this.isQueryStatement && this.numberOfColumnsInResultSet == 0) {
            this.throwException(EI_NOT_QUERY, logger, sqlStmt);
        } else if (!this.isQueryStatement && this.numberOfColumnsInResultSet > 0) {
            this.throwException(EI_NOT_UPDATE, logger, sqlStmt);
        }
        this.updateCounter = this.executeSQLStatement();
        if (AbstractLogger.isTrace) {
            logger.exit("execute(sqlStmt)", "IsQuery=[" + this.isQueryStatement + "] UpdateCounter=[" + this.updateCounter + "]");
        }
        return this.isQueryStatement;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String method = "execute(sql, autoGeneratedKeys)";
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        this.genFeatureNotSupportedException("execute(sql, autoGeneratedKeys)");
        throw this.nsEx;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        String method = "execute(sql, columnIndexes[])";
        this.genFeatureNotSupportedException("execute(sql, columnIndexes[])");
        throw this.nsEx;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String method = "execute(sql, String[])";
        this.genFeatureNotSupportedException("execute(sql, String[])");
        throw this.nsEx;
    }

    @Override
    public synchronized ResultSet executeQuery(String sqlStmt) throws SQLException {
        String method = "executeQuery";
        if (AbstractLogger.isInfo) {
            String ei = "FSStatement.executeQuery.fmt";
            this.logInfoMessage("executeQuery", "FSStatement.executeQuery.fmt", logger, sqlStmt);
        }
        this.closedCheck();
        this.clearWarnings();
        this.prepareSQLStatementForExecution(sqlStmt);
        if (!this.isQueryStatement) {
            this.throwException(EI_NOT_QUERY, logger, sqlStmt);
        }
        this.executeSQLStatement();
        return this.globalResultSet;
    }

    @Override
    public synchronized int executeUpdate(String sqlStmt) throws SQLException {
        String method = "executeUpdate";
        if (AbstractLogger.isInfo) {
            String ei = "FSStatement.executeUpdate.fmt";
            this.logInfoMessage("executeUpdate", "FSStatement.executeUpdate.fmt", logger, "FSStatement.executeUpdate.fmt");
        }
        this.closedCheck();
        this.clearWarnings();
        this.prepareSQLStatementForExecution(sqlStmt);
        if (this.isQueryStatement) {
            this.throwException(EI_NOT_UPDATE, logger, sqlStmt);
        }
        this.updateCounter = this.executeSQLStatement();
        return this.updateCounter;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String method = "executeUpdate(sql, int)";
        this.closedCheck();
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        this.genFeatureNotSupportedException("executeUpdate(sql, int)");
        throw this.nsEx;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String method = "executeUpdate(sql, int[])";
        this.closedCheck();
        this.genFeatureNotSupportedException("executeUpdate(sql, int[])");
        throw this.nsEx;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String method = "executeUpdate(sql, String[])";
        this.closedCheck();
        this.genFeatureNotSupportedException("executeUpdate(sql, String[])");
        throw this.nsEx;
    }

    @Override
    public synchronized void close() throws SQLException {
        String method = "close";
        if (AbstractLogger.isInfo) {
            String ei = "FSStatement.close.txt";
            this.logInfoMessage("close", "FSStatement.close.txt", logger, new Object[0]);
        }
        if (!this.isStatementClosed) {
            if (this.isPooled) {
                this.fsConnection.statementPoolManager.returnToPool(this);
            } else {
                this.tearDownStatement();
                this.fsConnection.deleteStatement(this);
            }
        }
        if (!this.isPooled) {
            this.releaseOutgoingResources();
        }
        this.lastSqlStatement = "Closed";
    }

    public void releaseOutgoingResources() {
        if (this._COLUMN_INFO_ARRAY != null) {
            for (int i = 0; i < this._COLUMN_INFO_ARRAY.length; ++i) {
                if (this._COLUMN_INFO_ARRAY[i] == null) continue;
                this._COLUMN_INFO_ARRAY[i].clearParamSetArray();
                this._COLUMN_INFO_ARRAY[i] = null;
            }
        }
        this._COLUMN_INFO_ARRAY = null;
        if (this.statementWrapper != null) {
            this.statementWrapper = null;
        }
        this.deleteGlobalResultSet();
        this.preparedDate = null;
        this.columnsBoundDate = null;
        this.parametersBoundDate = null;
        this.cursorStateDate = null;
        this.prefetch = false;
        this.paramsProcessed = null;
        this.statusHolder = null;
        this.statusIntHolder = null;
        this.rowCount = null;
        this._rowCount = null;
        this.paramStatus = null;
        this.outputParams2 = null;
        this.orbHandle = null;
        this.abnormalColumnIndexes = null;
        this.packedInputBuffer2 = null;
        this.paramOperations2 = null;
        this.outLenOrInd1 = null;
        this.outputParams1 = null;
        this.inLenOrInd1 = null;
        this.inputParam1 = null;
        if (this.fsConnection != null) {
            this.fsConnection = null;
        }
    }

    public int getAttribute(int attributeNumber) throws SQLException {
        int attributeValue = AbstractIOMWrapper.getIntegerAttribute(this.statementWrapper, attributeNumber);
        if (AbstractLogger.isTrace) {
            TypesHelper th = TypesHelper.getGetStmtAttrAsStr(attributeNumber, attributeValue);
            logger.trace("TKTSGetStmtAttr " + th.pair);
        }
        return attributeValue;
    }

    public boolean setAttribute(int attributeNumber, int attributeValue) throws SQLException {
        boolean warning = false;
        if (AbstractLogger.isTrace) {
            TypesHelper th = TypesHelper.getGetStmtAttrAsStr(attributeNumber, attributeValue);
            logger.trace("TKTSSetStmtAttr " + th.pair);
        }
        if (attributeNumber == 27 && attributeValue == 0) {
            warning = true;
            warning = false;
        }
        AbstractIOMWrapper.setIntegerAttribute(this.statementWrapper, attributeNumber, attributeValue, false);
        return warning;
    }

    public void setAttrCursorType(int attributeValue) throws SQLException {
        block2: {
            try {
                this.setAttribute(6, attributeValue);
            }
            catch (SQLException se) {
                if (!AbstractLogger.isError) break block2;
                ExceptionsLogger.logSql(se);
            }
        }
    }

    public void setAttrCursorScrollable(int attributeValue) throws SQLException {
        boolean warning = false;
        this.cursorScrollableRequested = attributeValue;
        try {
            warning = this.setAttribute(-1, attributeValue);
        }
        catch (SQLException se) {
            int newValue = -1;
            try {
                newValue = this.getAttribute(-1);
                if (newValue != this.cursorScrollableRequested) {
                    throw se;
                }
            }
            catch (SQLException gse) {
                throw se;
            }
        }
        if (warning) {
            this.synchResultSetAttribute = true;
            this.cursorScrollable = Integer.MIN_VALUE;
        } else {
            this.cursorScrollable = attributeValue;
        }
    }

    public void setAttrCursorSensitivity(int attributeValue) throws SQLException {
        this.cursorSensitivityRequested = attributeValue;
        boolean warning = this.setAttribute(-2, attributeValue);
        if (warning) {
            this.synchResultSetAttribute = true;
            this.cursorSensitivity = Integer.MIN_VALUE;
        } else {
            this.cursorSensitivity = attributeValue;
        }
    }

    synchronized void tearDownStatement() throws SQLException {
        String method = "tearDownStatement";
        if (AbstractLogger.isTrace) {
            logger.entry("tearDownStatement");
        }
        this.isAttributeRowNumberOK = false;
        this.closeGlobalResultSet();
        if (this.maxFieldSize != 0) {
            this.setMaxFieldSize(0);
        }
        if (this.resultSetMaxRows != 0) {
            this.setMaxRows(0);
        }
        this.resetFetchSize();
        this.freeStatement(Constants.freeStatementOptionsAll, "TKTS_UNBIND,TKTS_RESET_PARAMS,TKTS_UNPREPARE");
        this.isStatementClosed = true;
        try {
            this.statementWrapper.Close();
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("tearDownStatement", exception, this.statementWrapper, logger);
        }
        if (trackStatements) {
            myResources.untrack(this);
        }
        if (AbstractLogger.isTrace) {
            logger.exit("tearDownStatement");
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.closedCheck();
        this.maxFieldSize = (int)AbstractIOMWrapper.getBigIntAttribute(this.statementWrapper, 3);
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.closedCheck();
        if (max < 0) {
            String ei = "TKTSStatement.fieldSizeLowError.txt";
            this.throwException("TKTSStatement.fieldSizeLowError.txt", logger);
        }
        AbstractIOMWrapper.setBigIntAttribute(this.statementWrapper, 3, max);
        this.maxFieldSize = max;
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        this.closedCheck();
        if (this.resultSetMaxRows == Integer.MIN_VALUE) {
            this.resultSetMaxRows = (int)AbstractIOMWrapper.getBigIntAttribute(this.statementWrapper, 1);
        }
        return this.resultSetMaxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        String ei;
        String method = "setMaxRows";
        this.closedCheck();
        if (AbstractLogger.isInfo) {
            ei = "FSStatement.setMaxRows.fmt";
            this.logInfoMessage(method, "FSStatement.setMaxRows.fmt", logger, String.valueOf(max));
        }
        if (max < 0) {
            ei = "TKTSStatement.maxRowSizeLowError.txt";
            this.throwException("TKTSStatement.maxRowSizeLowError.txt", logger);
        }
        AbstractIOMWrapper.setBigIntAttribute(this.statementWrapper, 1, max);
        this.resultSetMaxRows = max;
    }

    @Override
    public int getFetchSize() throws SQLException {
        int outFetchSize = this.fetchSizeApi >= 0 ? this.fetchSizeApi : this.fetchSizeCurrent;
        return outFetchSize;
    }

    @Override
    public synchronized void setFetchSize(int inSize) throws SQLException {
        int rSetMaxRows;
        String ei;
        String method = "setFetchSize";
        this.closedCheck();
        if (AbstractLogger.isInfo) {
            ei = "FSStatement.setFetchSize.fmt";
            this.logInfoMessage("setFetchSize", "FSStatement.setFetchSize.fmt", logger, String.valueOf(inSize));
        }
        if (inSize < 0) {
            ei = "TKTSStatement.fetchSizeLowError.txt";
            this.throwException("TKTSStatement.fetchSizeLowError.txt", logger);
        }
        if ((rSetMaxRows = this.getMaxRows()) > 0 && inSize > rSetMaxRows) {
            String ei2 = "TKTSStatement.fetchSizeHighError.txt";
            this.throwException("TKTSStatement.fetchSizeHighError.txt", logger);
        }
        this.fetchSizeApi = inSize;
        if (inSize == 0) {
            inSize = this.fsConnection.getDefaultFetchSize();
        }
        if (this.fetchSizeCurrent != inSize) {
            boolean warning = this.setAttribute(27, inSize);
            this.fetchSizeCurrent = warning ? this.getAttribute(27) : inSize;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.closedCheck();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.closedCheck();
        if (seconds < 0) {
            String ei = "TKTSStatement.queryTimeoutError.txt";
            this.throwException("TKTSStatement.queryTimeoutError.txt", logger);
        }
    }

    @Override
    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.closedCheck();
        if (enable != this.isEscapeProcessing) {
            int value = 0;
            value = enable ? 0 : 1;
            this.setAttribute(2, value);
        }
    }

    @Override
    public synchronized void cancel() throws SQLException {
        String method = "cancel";
        if (AbstractLogger.isInfo) {
            String ei = "FSStatement.cancel.txt";
            this.logInfoMessage("cancel", "FSStatement.cancel.txt", logger, new Object[0]);
        }
        this.closedCheck();
        try {
            this.statementWrapper.Cancel(new IntHolder());
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("cancel", exception, this.statementWrapper, logger);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.globalSQLWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.globalSQLWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.closedCheck();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.closedCheck();
        return this.globalResultSet;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        block7: {
            String method = "getUpdateCount";
            this.closedCheck();
            if (this.isQueryStatement) {
                this.updateCounter = -1;
            } else {
                try {
                    if (this.updateCounter == -1) {
                        this.updateCounter = (int)this.statementWrapper.RowCount(this.statusIntHolder);
                        if (this.statusIntHolder.value == -2130708479) {
                            this.createWarnings();
                        }
                    }
                }
                catch (Exception ex) {
                    if (!AbstractLogger.isTrace) break block7;
                    logger.trace("Catching Exception for TKTSRowCount issued on statement and return -1");
                    ExceptionsLogger.log(ex);
                }
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("getUpdateCount UpdateCount=[" + this.updateCounter + "]");
        }
        return this.updateCounter;
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        this.closedCheck();
        this.updateCounter = -1;
        return false;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        this.closedCheck();
        return false;
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.closedCheck();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            String ei = "TKTSStatement.fetchDirectionError.txt";
            this.throwException("TKTSStatement.fetchDirectionError.txt", logger);
        } else {
            this.fetchDirection = direction;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.closedCheck();
        return this.fetchDirection;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.closedCheck();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.closedCheck();
        return this.fsConnection.getHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.closedCheck();
        return this.resultSetType;
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        String method = "clearBatch";
        if (AbstractLogger.isInfo) {
            String ei = "FSStatement.clearBatch.txt";
            this.logInfoMessage("clearBatch", "FSStatement.clearBatch.txt", logger, new Object[0]);
        }
        this.closedCheck();
        if (this._BATCH_STATEMENT_LIST != null) {
            this._BATCH_STATEMENT_LIST.clear();
        }
        if (AbstractLogger.isTrace) {
            logger.exit("clearBatch");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.closedCheck();
        return this.fsConnection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String method = "getGeneratedKeys";
        this.closedCheck();
        this.genFeatureNotSupportedException("getGeneratedKeys");
        throw this.nsEx;
    }

    public StatementWrapper getStatementWrapper() {
        return this.statementWrapper;
    }

    public ORB getORBHandle() {
        return this.orbHandle;
    }

    protected boolean isAttributeRowNumberOK() {
        return this.isAttributeRowNumberOK;
    }

    public int getConcurrency() throws SQLException {
        return this.getAttribute(7);
    }

    public int getServerVersion() throws SQLException {
        return this.fsConnection.getServerVersion();
    }

    protected void unBindStatement() throws SQLException {
        this.freeStatement(Constants.freeStatementOptionsUnbindOnly, "TKTS_UNBIND");
    }

    protected void clearAllBinds() throws SQLException {
        this.freeStatement(Constants.freeStatementUnbindAndResetParams, "TKTS_UNBIND,TKTS_RESET_PARAMS");
    }

    protected void closeGlobalResultSet() throws SQLException {
        if (this.globalResultSet != null) {
            this.globalResultSet.close();
        }
    }

    protected void deleteGlobalResultSet() {
        if (this.globalResultSet != null) {
            this.globalResultSet = null;
        }
    }

    protected void createWarnings() {
        SQLWarning warning = LocalizedErrorHandler.createLocalizedWarnnigs(this.statementWrapper);
        this.createWarnings(warning);
    }

    protected void createWarnings(SQLWarning warning) {
        if (warning != null) {
            if (this.globalSQLWarning == null) {
                this.globalSQLWarning = warning;
            } else {
                this.globalSQLWarning.setNextWarning(warning);
            }
            if (AbstractLogger.isWarn) {
                logger.warn(warning.getMessage());
            }
        }
    }

    private synchronized void resetFetchSize() throws SQLException {
        this.setAttribute(27, this.fetchSizeCurrent);
    }

    private synchronized void prepareSQLStatementForExecution(String sqlStmt) throws SQLException {
        String method = "prepareSQLStatementForExecution";
        int columnsInResultSet = 0;
        IntHolder status = new IntHolder();
        if (AbstractLogger.isTrace) {
            logger.trace("prepareSQLStatementForExecution", "Preparing a sql statement for execution: \"" + sqlStmt + "\"");
        }
        if (sqlStmt == null || sqlStmt.length() == 0) {
            String ei = "TKTSStatement.emptyStatement.txt";
            this.throwException("TKTSStatement.emptyStatement.txt", logger);
        }
        this.lastSqlStatement = sqlStmt;
        this.updateCounter = -1;
        this.closeGlobalResultSet();
        this.clearAllBinds();
        this.setParameterSetSize(1);
        try {
            this.statementWrapper.Prepare(sqlStmt, status);
            if (status.value == -2130708479) {
                this.createWarnings();
            }
            if ((columnsInResultSet = this.statementWrapper.NumResultCols(status)) > 0) {
                this.isQueryStatement = true;
                this.createColumnInfoArray(columnsInResultSet);
                if (this.prefetch && this.abnormalColumnCount > 0) {
                    this.prefetch = false;
                }
                if (this.prefetch) {
                    this.setAttribute(20400, 1);
                }
                this.bindColumns();
            } else {
                this.isQueryStatement = false;
                this.numberOfColumnsToBeBound = 0;
                this._COLUMN_INFO_ARRAY = null;
            }
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("prepareSQLStatementForExecution", exception, this.statementWrapper, logger);
        }
        this.numberOfColumnsInResultSet = columnsInResultSet;
    }

    private synchronized int executeSQLStatement() throws SQLException {
        String method = "executeSQLStatement";
        int rowCount = -1;
        try {
            rowCount = this.executeSQLStatement2();
            if (this.isQueryStatement) {
                this.globalResultSet = new FSResultSet(this.statementWrapper, this, this.numberOfColumnsInResultSet, this.isUsingBookmarks);
                this.setCursorOpen(true);
            } else {
                this.statementWrapper.FreeStmt(101, this.statusIntHolder);
                if (this.statusIntHolder.value == -2130708479) {
                    this.createWarnings();
                }
            }
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("executeSQLStatement", exception, this.statementWrapper, logger);
        }
        if (AbstractLogger.isTrace) {
            logger.exit("executeSQLStatement", "IsQuery=[" + this.isQueryStatement + "] UpdateCounter=[" + rowCount + "]");
        }
        return rowCount;
    }

    private synchronized int executeSQLStatement2() throws SQLException, TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, TKTS_STILL_EXECUTING, GenericError {
        String method = "executeSQLStatement2";
        if (AbstractLogger.isTrace) {
            logger.entry("executeSQLStatement2");
        }
        int rowCount = -1;
        this.wasExecuted = true;
        if (true) {
            IntHolder ih = new IntHolder();
            this.statementWrapper.Cancel(ih);
            this.statementWrapper.FreeStmt(0, this.statusIntHolder);
            this.wasExecuted = false;
        }
        LongHolder rowCountHolder = new LongHolder();
        if (this.isPackType1) {
            this.packedInputBuffer2 = P1_NO_PARMETERS;
        }
        this.statementWrapper.Execute2(this.packedInputBuffer2, this.paramOperations2, this.paramsProcessed, this.outputParams2, this.paramStatus, rowCountHolder, this.statusHolder);
        this.wasExecuted = true;
        if (this.statusHolder.value == -2130708479) {
            this.createWarnings();
        }
        if (!this.isQueryStatement) {
            rowCount = (int)rowCountHolder.value;
        }
        return rowCount;
    }

    private void setResultSetScrollable(boolean scrollable) throws SQLException {
        if (scrollable) {
            this.setAttrCursorType(2);
            this.setAttrCursorScrollable(1);
            if (this.resultSetType == 1004) {
                this.setAttrCursorSensitivity(1);
            } else {
                this.setAttrCursorSensitivity(2);
            }
        } else {
            this.setAttrCursorType(0);
            this.setAttrCursorScrollable(0);
        }
    }

    private void setConcurrencyUpdatable() throws SQLException {
        int level = this.fsConnection.getConcurrencyLevel();
        level = level == 2 ? 3 : (level == 4 ? 3 : (level == 8 ? 4 : 2));
        this.cursorConcurrencyRequested = level;
        boolean warning = this.setAttribute(7, level);
        if (warning) {
            this.synchResultSetAttribute = true;
            this.cursorConcurrency = Integer.MIN_VALUE;
        } else {
            this.cursorConcurrency = level;
        }
    }

    private void setConcurrencyReadOnly() throws SQLException {
        this.cursorConcurrencyRequested = 1;
        boolean warning = this.setAttribute(7, 1);
        if (warning) {
            this.synchResultSetAttribute = true;
            this.cursorConcurrency = Integer.MIN_VALUE;
            this.resultSetConcurrency = Integer.MIN_VALUE;
        } else {
            this.cursorConcurrency = 1;
        }
    }

    private void initBookmarks() throws SQLException {
        if (this.useBookmarks == Integer.MIN_VALUE) {
            this.useBookmarks = this.getAttribute(12);
        }
        this.isUsingBookmarks = this.useBookmarks != 0;
    }

    private void freeStatement(int[] options, String debug) throws SQLException {
        String method = "freeStatement";
        String debugStatus = AbstractLogger.isTrace ? "" : null;
        LongSeqHolder status = new LongSeqHolder();
        try {
            this.statementWrapper.FreeStmtArray(options, status);
            if (AbstractLogger.isTrace && options.length != status.value.length) {
                logger.trace(" Error option.length[" + options.length + "] NOT EQUAL status.value.length[" + status.value.length + "]");
            }
            for (int i = 0; i < status.value.length; ++i) {
                if (status.value[i] == -2130708479) {
                    this.createWarnings();
                }
                this.updateStates(options[i], false);
                if (!AbstractLogger.isTrace) continue;
                debugStatus = i < status.value.length - 1 ? debugStatus + status.value[i] + ", " : debugStatus + status.value[i];
            }
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("freeStatement", exception, this.statementWrapper, logger);
        }
        if (AbstractLogger.isTrace) {
            logger.trace("freeStatement Operations[" + debug + "] Status[" + debugStatus + "] ");
        }
    }

    protected void closedCheck() throws SQLException {
        if (this.isStatementClosed) {
            String ei = "TKTSStatement.isClosedError.txt";
            this.throwException("TKTSStatement.isClosedError.txt", logger);
        }
    }

    public void synchResultSetAttributes() throws SQLException {
        String[] args;
        TypesHelper rTH;
        TypesHelper aTH;
        String ei = "TKTSStatement.AttributeWarning.fmt";
        this.cursorType = this.getAttribute(6);
        if (this.cursorType < this.cursorTypeRequested) {
            aTH = TypesHelper.getGetStmtAttrAsStr(6, this.cursorType);
            rTH = TypesHelper.getGetStmtAttrAsStr(6, this.cursorTypeRequested);
            args = new String[]{aTH.key, rTH.value, aTH.value};
            this.createAndLogWarning("TKTSStatement.AttributeWarning.fmt", args, "01S02", logger);
        }
        this.cursorScrollable = this.getAttribute(-1);
        if (this.cursorScrollable < this.cursorScrollableRequested) {
            aTH = TypesHelper.getGetStmtAttrAsStr(-1, this.cursorScrollable);
            rTH = TypesHelper.getGetStmtAttrAsStr(-1, this.cursorScrollableRequested);
            args = new String[]{aTH.key, rTH.value, aTH.value};
            this.createAndLogWarning("TKTSStatement.AttributeWarning.fmt", args, "01S02", logger);
        }
        this.cursorConcurrency = this.getAttribute(7);
        if (this.cursorConcurrency < this.cursorConcurrencyRequested) {
            aTH = TypesHelper.getGetStmtAttrAsStr(7, this.cursorConcurrency);
            rTH = TypesHelper.getGetStmtAttrAsStr(7, this.cursorConcurrencyRequested);
            args = new String[]{aTH.key, rTH.value, aTH.value};
            this.createAndLogWarning("TKTSStatement.AttributeWarning.fmt", args, "01S02", logger);
        }
        this.cursorSensitivity = this.getAttribute(-2);
        if (this.cursorSensitivityRequested != 0 && this.cursorSensitivity != this.cursorSensitivityRequested) {
            aTH = TypesHelper.getGetStmtAttrAsStr(-2, this.cursorSensitivity);
            rTH = TypesHelper.getGetStmtAttrAsStr(-2, this.cursorSensitivityRequested);
            args = new String[]{aTH.key, rTH.value, aTH.value};
            this.createAndLogWarning("TKTSStatement.AttributeWarning.fmt", args, "01S02", logger);
        }
        this.initBookmarks();
    }

    private void validateAttributeRowNumber(FSConnection connection) {
        block10: {
            AnySeqHolder anyArrayHolder = new AnySeqHolder();
            LongSeqHolder status = new LongSeqHolder();
            int attribute = 0;
            int[] indicator = new int[]{-5};
            if (connection.cursorType == 0 && this.resultSetType != 1003 || connection.cursorType == 2) {
                this.isAttributeRowNumberOK = true;
            } else if (this.resultSetType != 1003) {
                if (this.resultSetType == 1005 && this.resultSetConcurrency == 1008) {
                    attribute = 20001;
                } else if (this.resultSetType == 1004) {
                    attribute = 20004;
                }
                int[] infoAttr = new int[]{attribute};
                try {
                    connection.connectionWrapper.GetInformation(infoAttr, indicator, anyArrayHolder, status);
                    int istat = 0;
                    if (status.value.length > 0) {
                        istat = status.value[0];
                    }
                    if (anyArrayHolder.value != null && anyArrayHolder.value.length > 0 && (istat == 0 || istat == -2130708479)) {
                        this.isAttributeRowNumberOK = (anyArrayHolder.value[0].extract_long() & 1) > 0;
                    }
                }
                catch (Exception e) {
                    if (!AbstractLogger.isTrace) break block10;
                    logger.trace("Exception:" + e.getMessage());
                }
            }
        }
    }

    public FSConnection getFSConnection() {
        return this.fsConnection;
    }

    public boolean getThrowException() {
        return this.fsConnection.getThrowException();
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.hintPoolable = poolable;
    }

    @Override
    public boolean isPoolable() {
        return this.hintPoolable;
    }

    @Override
    public boolean isClosed() {
        return this.isStatementClosed;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected void createColumnInfoArray(int columnCount) throws SQLException {
        ColumnsAttributes colAttributes = new ColumnsAttributes(this.statementWrapper, columnCount);
        int attrIndx = 0;
        int endIndx = columnCount;
        if (columnCount == 0) {
            endIndx = colAttributes.getNumberOfColumns();
            columnCount = endIndx - 1;
            attrIndx = 1;
        }
        this._COLUMN_INFO_ARRAY = new ParameterInfo[columnCount];
        this.abnormalColumnCount = 0;
        this.abnormalColumnIndexes = new int[columnCount];
        this.numberOfColumnsToBeBound = 0;
        int y = 0;
        while (attrIndx < endIndx) {
            ParameterInfo ca;
            this._COLUMN_INFO_ARRAY[y] = ca = new ParameterInfo();
            int nCEI = colAttributes.getEncoding(attrIndx);
            ca.setNativeEncoding(nCEI);
            int l = colAttributes.getLength(attrIndx);
            ca.setName(colAttributes.getName(attrIndx));
            ca.setNullableIndicator(colAttributes.getNullable(attrIndx));
            ca.setDecimalDigits(colAttributes.getScale(attrIndx));
            int p = colAttributes.getPrecision(attrIndx);
            ca.setPrecision(p);
            ca.setOrdinal(y + 1);
            int sqlType = colAttributes.getSQLType(attrIndx);
            int nativeCType = colAttributes.getNativeCType(attrIndx);
            if (sqlType == 9) {
                switch (nativeCType) {
                    case 17: {
                        sqlType = 91;
                        break;
                    }
                    case 18: {
                        sqlType = 92;
                        break;
                    }
                    case 19: {
                        sqlType = 93;
                        break;
                    }
                    default: {
                        sqlType = 93;
                    }
                }
            }
            ca.setSQLType(sqlType);
            ca.setDisplaySize(l);
            int cType = UtilityFunctions.mapSQLType2CType(ca, sqlType);
            ca.setNativeCType(nativeCType);
            if (cType == 3 || cType == 3 || cType == 1) {
                ca.setCType(2);
            }
            if (FSStatement.isLongVar(ca.getSQLType())) {
                ca.setBindRequired(false);
                this.abnormalColumnIndexes[this.abnormalColumnCount] = y;
                ++this.abnormalColumnCount;
            } else {
                ca.setBindRequired(true);
                ++this.numberOfColumnsToBeBound;
            }
            if (AbstractLogger.isTrace) {
                nativeCType = ca.getNativeCType();
                logger.trace("Column: Number=[" + ca.getOrdinal() + "] Name=[" + ca.getName() + "] Size=[" + ca.getDisplaySize() + "] CType=[" + CommonLogger.getCTypeString(cType) + ":" + cType + "] nativeCType=[" + CommonLogger.getCTypeString(nativeCType) + ":" + nativeCType + "] SQLType=[" + CommonLogger.getSQLTypeString(sqlType) + ":" + sqlType + "]");
            }
            ++y;
            ++attrIndx;
        }
        if (AbstractLogger.isTrace) {
            logger.trace("Total Columns[" + this._COLUMN_INFO_ARRAY.length + "] ColumnsToBound=[" + this.numberOfColumnsToBeBound + "] AbnormalColumns[" + this.abnormalColumnCount + "] ");
        }
    }

    public synchronized void bindColumns() throws SQLException {
        String method = "bindColumns";
        if (AbstractLogger.isTrace) {
            logger.trace("bindColumns Columns Total:" + this._COLUMN_INFO_ARRAY.length + " ToBeBound:" + this.numberOfColumnsToBeBound);
        }
        if (this.numberOfColumnsToBeBound > 0) {
            LongSeqHolder statusHolder = new LongSeqHolder();
            IntHolder status = new IntHolder();
            int[] columnNumbers = new int[this.numberOfColumnsToBeBound];
            int[] columnCTypes = new int[this.numberOfColumnsToBeBound];
            String[] columnFormats = new String[this.numberOfColumnsToBeBound];
            int[] columnLengths = new int[this.numberOfColumnsToBeBound];
            int[] columnBindDirection = new int[this.numberOfColumnsToBeBound];
            int count = 0;
            for (int i = 0; i < this._COLUMN_INFO_ARRAY.length; ++i) {
                ParameterInfo ci = this._COLUMN_INFO_ARRAY[i];
                if (ci.isBindRequired() && !ci.isBound()) {
                    int cType;
                    ci.setBound(true);
                    ci.setBindRequired(false);
                    columnNumbers[count] = ci.getOrdinal();
                    columnCTypes[count] = cType = this._COLUMN_INFO_ARRAY[i].getCType();
                    int nativeCType = this._COLUMN_INFO_ARRAY[i].getNativeCType();
                    if (nativeCType != cType && nativeCType == 6 && (cType == 19 || cType == 18 || cType == 17)) {
                        columnCTypes[count] = nativeCType;
                    }
                    columnFormats[count] = "TKTS_FMT_DEFAULT";
                    columnLengths[count] = (int)ci.getDisplaySize();
                    columnBindDirection[count] = this.resultSetConcurrency == 1007 ? 13 : 12;
                    ++count;
                    continue;
                }
                if (!AbstractLogger.isTrace) continue;
                logger.trace("Skipping i[" + i + "]");
            }
            try {
                this.statementWrapper.BindCols(columnNumbers, columnCTypes, columnFormats, columnLengths, columnBindDirection, statusHolder, status);
                this.checkForWarnings(status.value);
            }
            catch (Exception e) {
                if (AbstractLogger.isTrace) {
                    logger.trace("Failed to bind columns : " + e.getMessage());
                }
                LocalizedErrorHandler.handleExceptionsInFunction("bindColumns", e, this.statementWrapper, logger);
            }
        }
    }

    public void bindAbnormalColumns(int bindDirection) throws SQLException {
        String method = "bindAbnormalColumns";
        if (AbstractLogger.isTrace) {
            logger.entry("bindAbnormalColumns", "columnCount:" + this.abnormalColumnCount);
        }
        if (this.abnormalColumnCount > 0) {
            int[] columnNumbers = new int[this.abnormalColumnCount];
            int[] columnCTypes = new int[this.abnormalColumnCount];
            String[] columnFormats = new String[this.abnormalColumnCount];
            int[] columnLengths = new int[this.abnormalColumnCount];
            int[] columnBindDirection = new int[this.abnormalColumnCount];
            LongSeqHolder statusHolder = new LongSeqHolder();
            IntHolder status = new IntHolder();
            for (int i = 0; i < this.abnormalColumnCount; ++i) {
                int columnIndex = this.abnormalColumnIndexes[i];
                ParameterInfo ci = this._COLUMN_INFO_ARRAY[columnIndex];
                columnNumbers[i] = ci.getOrdinal();
                columnCTypes[i] = ci.getCType();
                columnFormats[i] = "TKTS_FMT_DEFAULT";
                columnLengths[i] = (int)ci.getDisplaySize();
                columnBindDirection[i] = bindDirection;
            }
            try {
                this.statementWrapper.BindCols(columnNumbers, columnCTypes, columnFormats, columnLengths, columnBindDirection, statusHolder, status);
                this.checkForWarnings(status.value);
            }
            catch (Exception e) {
                if (AbstractLogger.isTrace) {
                    logger.trace("Failed to bind columns : " + e.getMessage());
                }
                LocalizedErrorHandler.handleExceptionsInFunction("bindAbnormalColumns", e, this.statementWrapper, logger);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.exit("bindAbnormalColumns");
        }
    }

    public ParameterInfo[] getColumnInfoArray() {
        ParameterInfo[] COLUMN_INFO_ARRAY_COPY = new ParameterInfo[this._COLUMN_INFO_ARRAY.length];
        for (int i = 0; i < this._COLUMN_INFO_ARRAY.length; ++i) {
            COLUMN_INFO_ARRAY_COPY[i] = this._COLUMN_INFO_ARRAY[i];
        }
        return COLUMN_INFO_ARRAY_COPY;
    }

    public void setColumnsBound(boolean newValue) {
        this.columnsBound = newValue;
        this.columnsBoundDate = new Date();
    }

    public boolean columnsBound() {
        return this.columnsBound;
    }

    public void setParametersBound(boolean newValue) {
        this.parametersBound = newValue;
        this.parametersBoundDate = new Date();
    }

    public boolean parametersBound() {
        return this.parametersBound;
    }

    public void setCursorOpen(boolean newValue) {
        this.cursorState = newValue;
        this.cursorStateDate = new Date();
    }

    public boolean cursorOpen() {
        return this.cursorState;
    }

    public void setPrepared(boolean newValue) {
        this.prepared = newValue;
        this.preparedDate = new Date();
    }

    public boolean prepared() {
        return this.prepared;
    }

    public void updateStates(int option, boolean state) {
        switch (option) {
            case 0: {
                this.setCursorOpen(state);
                break;
            }
            case 3: {
                this.setParametersBound(state);
                break;
            }
            case 100: {
                break;
            }
            case 2: {
                this.setColumnsBound(state);
                break;
            }
            case 101: {
                this.setPrepared(state);
                break;
            }
        }
    }

    public void logStates() {
        if (!AbstractLogger.isTrace) {
            return;
        }
        logger.trace("Statement States");
        logger.trace("  Columns Bound:    " + this.columnsBound + DEBUG_DATE + this.columnsBoundDate);
        logger.trace("  Parameters Bound: " + this.parametersBound + DEBUG_DATE + this.parametersBoundDate);
        logger.trace("  Cursor Open:      " + this.cursorState + DEBUG_DATE + this.cursorStateDate);
        logger.trace("  Prepared:         " + this.prepared + DEBUG_DATE + this.preparedDate);
    }

    protected synchronized void checkForWarnings(int status) {
        if (status == -2130708479) {
            SQLWarning sw = LocalizedErrorHandler.createLocalizedWarnnigs(this.statementWrapper);
            this.createWarnings(sw);
        }
    }

    protected boolean setParameterSetSize(int newSize) {
        boolean success;
        block10: {
            success = true;
            if (newSize == Integer.MIN_VALUE) {
                return success;
            }
            if (this.isParameterArraySupported && this.previousBatchSize != newSize) {
                try {
                    boolean warning = this.setAttribute(22, newSize);
                    this.previousBatchSize = warning ? this.getAttribute(22) : newSize;
                    if (!AbstractLogger.isTrace) break block10;
                    try {
                        int verifySize = this.getAttribute(22);
                        if (verifySize != newSize) {
                            logger.trace("Failed to set Batch size requested:" + newSize + "actual:" + verifySize);
                        }
                    }
                    catch (SQLException se) {
                        if (AbstractLogger.isError) {
                            ExceptionsLogger.logSql(se);
                        }
                    }
                }
                catch (Exception e) {
                    success = false;
                    try {
                        this.setAttribute(22, 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.fsConnection.setParameterSetBehavior(false);
                    this.fsConnection.setParameterSetSizeSupported(false);
                    this.isParameterArraySupported = false;
                }
            }
        }
        return success;
    }

    protected void setupParameterSetBehavior() {
        this.paramset_behavior = -1;
        if (this.fsConnection.getParameterSetBehavior()) {
            try {
                this.paramset_behavior = AbstractIOMWrapper.getIntegerAttribute(this.statementWrapper, 20123);
            }
            catch (Exception e) {
                this.fsConnection.setParameterSetBehavior(false);
            }
        }
    }

    public String toString() {
        String outStr = "Class:" + thisClassName;
        outStr = outStr + " ID:" + this.myID;
        outStr = this.isStatementClosed ? outStr + " Closed" : outStr + " Open";
        if (this.lastSqlStatement != null) {
            outStr = outStr + " SQL:";
            outStr = outStr + this.lastSqlStatement;
        }
        return outStr;
    }

    public String toStringDetails() {
        int xcode = Integer.MIN_VALUE;
        try {
            xcode = AbstractIOMWrapper.getIntegerAttribute(this.statementWrapper, 20309);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String xcodeStr = CommonLogger.getXCodeString(xcode);
        String outStr = "Class: + " + thisClassName;
        outStr = outStr + "\nClosed: " + this.isStatementClosed + " maxFieldSize: " + this.maxFieldSize;
        outStr = outStr + "\nStates: ";
        if (this.prepared) {
            outStr = outStr + "\n  prepared: " + this.preparedDate;
        }
        if (this.columnsBound) {
            outStr = outStr + "\n  columnsBound: " + this.columnsBoundDate;
        }
        if (this.parametersBound) {
            outStr = outStr + "\n  parametersBound: " + this.parametersBoundDate;
        }
        if (this.cursorState) {
            outStr = outStr + "\n  cursorState: " + this.cursorStateDate;
        }
        outStr = outStr + "\nStatement information:";
        outStr = outStr + "\n  SQL:" + this.lastSqlStatement;
        outStr = outStr + "\n  AttributeRowNumberOK:" + this.isAttributeRowNumberOK;
        outStr = outStr + "\n  EscapeProcessing:" + this.isEscapeProcessing;
        outStr = outStr + "\n  QueryStatement:" + this.isQueryStatement;
        outStr = outStr + "\n  UsingBookmarks:" + this.isUsingBookmarks;
        outStr = outStr + "\n  UpdateCounter:" + this.updateCounter;
        outStr = outStr + "\nResultSet Attributes:";
        outStr = outStr + "\n  Concurrency:" + TypesHelper.getResultSetConcurrencyU(this.resultSetConcurrency);
        outStr = outStr + "\n  ConcurrencyRequested:" + TypesHelper.getResultSetConcurrencyU(this.resultSetConcurrencyRequested);
        outStr = outStr + "\n  FetchDirection:" + TypesHelper.getFetchDirectionU(this.fetchDirection);
        outStr = outStr + "\n  FetchSize:" + this.fetchSizeCurrent + ", " + this.fetchSizeApi;
        String tStr = null;
        try {
            tStr = TypesHelper.getResultSetHoldabilityU(this.getResultSetHoldability());
        }
        catch (SQLException sql) {
            tStr = "Unknown";
        }
        outStr = outStr + "\n  Holdability:" + tStr;
        outStr = outStr + "\n  MaxRows:" + this.resultSetMaxRows;
        outStr = outStr + "\n  MaxRowsRequested:" + this.resultSetMaxRowsRequested;
        outStr = outStr + "\n  MaxFieldSize:" + this.maxFieldSize;
        outStr = outStr + "\n  Type:" + TypesHelper.getResultSetTypeU(this.resultSetType);
        outStr = outStr + "\n  TypeRequested:" + TypesHelper.getResultSetTypeU(this.resultSetTypeRequested);
        outStr = outStr + "\n  Poolable:" + this.hintPoolable + " isPoolable:" + this.isPooled;
        outStr = outStr + "\n  PoolKey:" + this.sqlStatementKEY;
        outStr = outStr + "\n  PoolUsageCounter:" + this.usageCounter + " PoolReturnTS:" + this.notInUseSince;
        outStr = outStr + "\nParameter information:";
        outStr = outStr + "\n  ArraySupported:" + this.isParameterArraySupported + " Behavior:" + CommonLogger.paramsetBehavior(this.paramset_behavior);
        outStr = outStr + "\nColumn information:";
        outStr = outStr + "\n  ColumnsToBeBound:" + this.numberOfColumnsToBeBound + " ColumnsInResultSet:" + this.numberOfColumnsInResultSet;
        outStr = outStr + "\n  abnormalColumns:" + this.abnormalColumnCount + " abnormalColumnIndexes:" + this.abnormalColumnIndexes;
        outStr = outStr + "\nBatch information: previousSize" + this.previousBatchSize + " currentSize:" + this.currentBatchSize;
        outStr = outStr + "\nXcode:" + xcodeStr;
        tStr = "\n";
        try {
            tStr = tStr + UtilityFunctions.sqlWarnings(this.getWarnings());
        }
        catch (SQLException sql) {
            tStr = tStr + "Unknown";
        }
        if (tStr != null) {
            outStr = outStr + tStr;
            tStr = null;
        }
        return outStr;
    }

    public boolean isMissingMode() {
        return this.nullBehavior == 1;
    }

    public boolean isANSINullMode() {
        return this.nullBehavior == 0;
    }

    public boolean isDefaultNullMode() {
        return this.nullBehavior == -2;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        String method = "closeOnCompletion";
        this.genFeatureNotSupportedException("closeOnCompletion");
        throw this.nsEx;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        String method = "isCloseOnCompletion";
        this.genFeatureNotSupportedException("isCloseOnCompletion");
        throw this.nsEx;
    }

    protected void genFeatureNotSupportedException(String methodName) {
        this.nsEx = null;
        String lMsg = this.getLocalizedError("General.methodNotImplemented.fmt", methodName);
        this.nsEx = new SQLFeatureNotSupportedException(lMsg, "HY000");
    }

    @Override
    protected SQLWarning createAndLogWarning(String ei, String[] args, String sqlState, AbstractLogger logger) {
        SQLWarning sw = super.createAndLogWarning(ei, args, sqlState, logger);
        this.createWarnings(sw);
        return sw;
    }

    public static void trackingDisplay() {
        myResources.display();
    }

    public static void trackingDisplaySummary() {
        myResources.displaySummary();
    }

    public static long trackingCount() {
        return myResources.count();
    }

    public static void trackingEnabled(boolean newValue, boolean details) {
        trackStatements = newValue;
        myResources.setLogDetails(details);
    }

    public boolean getPrefetch() {
        return this.prefetch;
    }

    public long getRTT() {
        return this.fsConnection.getRTT();
    }

    public String getLastSQL() {
        return this.lastSqlStatement;
    }

    static {
        debugFlag = true;
        myResources = new TrackResource("Statement");
        byte[] b = new byte[]{8, 0, 0, 0, 0, 0, 0, 0};
        P1_NO_PARMETERS = b;
    }
}

