/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.FSEnums;
import com.sas.tkts.TKTSDriver;
import com.sas.tkts.caching.RowSetCache;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.ExceptionsLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSResultSet;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.util.SafeStore;
import com.sas.tkts.util.TimeRepresentation;
import com.sas.tkts.util.UtilityFunctions;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;

public class FSRowSet
extends FSResultSet
implements RowSet,
RowSetInternal {
    private static String thisClassName = FSRowSet.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient Connection connection;
    private transient RowSetMetaData rowSetMetadata;
    private transient Driver sqlDriver;
    private transient String connectionURL;
    private transient String userName;
    private transient SafeStore safeP;
    public transient ParameterInfo[] _PARAMETER_INFO_ARRAY;
    private transient int transactionIsolationLevel = 0;
    private transient boolean isReadOnly;
    private transient boolean isEscapeProcessing = true;
    private transient int maxNumberOfRows;
    private transient int maxFieldSize;
    private transient String sqlSatement;
    private transient int queryTimeOut = 0;
    private transient int fetchSize;
    private transient List<RowSetListener> _LISTENERS_LIST;

    public FSRowSet() throws SQLException {
        String method = "FSRowSet()";
        if (AbstractLogger.isTrace) {
            logger.entry("FSRowSet()");
        }
        this.safeP = new SafeStore("");
        try {
            if (AbstractLogger.isTrace) {
                logger.trace("Loading JDBC Driver for a RowSet object: " + TKTSDriver.DRIVER_NAME);
            }
            Class.forName("com.sas.tkts.TKTSDriver");
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        this._LISTENERS_LIST = new Vector<RowSetListener>();
        this.abstractRowCache = new RowSetCache();
        this.setType(1003);
        this.setConcurrency(1007);
    }

    private int findParameterIndex(String parameterName) throws SQLException {
        int parameterIndex = super.findColumn(parameterName);
        return parameterIndex;
    }

    @Override
    public void execute() throws SQLException {
        String method = "execute";
        if (AbstractLogger.isInfo) {
            LocalizedMessageHandler.logInfoMessage("execute", "FSRowSet.execute.txt", logger);
        }
        this.abstractRowCache = null;
        this.abstractRowCache = new RowSetCache();
        ((RowSetReader)((Object)this.abstractRowCache)).readData(this);
        this.numberColumns = this.abstractRowCache.getColumnCount();
        this.isClosed = false;
    }

    @Override
    public String getCommand() {
        return this.sqlSatement;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Properties properties = new Properties();
        properties.put("userName", this.userName);
        properties.put("password", this.safeP.getValue());
        this.connection = this.sqlDriver.connect(this.connectionURL, properties);
        properties.clear();
        properties = null;
        if (this.transactionIsolationLevel > 0) {
            this.connection.setTransactionIsolation(this.transactionIsolationLevel);
        } else {
            this.transactionIsolationLevel = this.connection.getTransactionIsolation();
        }
        return this.connection;
    }

    public List<RowSetListener> getListeners() {
        return this._LISTENERS_LIST;
    }

    @Override
    public void addRowSetListener(RowSetListener listener) {
        if (listener == null) {
            return;
        }
        this._LISTENERS_LIST.add(listener);
    }

    @Override
    public void removeRowSetListener(RowSetListener listener) {
        if (listener == null || this._LISTENERS_LIST == null) {
            return;
        }
        this._LISTENERS_LIST.remove(listener);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int value) throws SQLException {
        if (value < 0) {
            LocalizedErrorHandler.throwLocalizedException("TKTSStatement.fieldSizeError.txt", logger);
        }
        this.maxFieldSize = value;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxNumberOfRows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        String method = "setFetchSize";
        if (size < 0) {
            LocalizedErrorHandler.throwLocalizedException("TKTSStatement.fetchSizeLowError.txt", logger);
        }
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{String.valueOf(size)};
            LocalizedMessageHandler.logInfoMessage(method, "FSRowSet.setFetchSize.fmt", args, logger);
        }
        this.fetchSize = size;
    }

    @Override
    public void setQueryTimeout(int value) throws SQLException {
        this.queryTimeOut = value;
    }

    @Override
    public int getTransactionIsolation() {
        block3: {
            this.transactionIsolationLevel = 0;
            if (this.connection != null) {
                try {
                    this.transactionIsolationLevel = this.connection.getTransactionIsolation();
                }
                catch (Exception e) {
                    if (!AbstractLogger.isTrace) break block3;
                    ExceptionsLogger.log(e);
                }
            }
        }
        return this.transactionIsolationLevel;
    }

    @Override
    public void setTransactionIsolation(int value) throws SQLException {
        switch (value) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.transactionIsolationLevel = value;
                if (this.connection == null) break;
                this.connection.setTransactionIsolation(value);
                break;
            }
            case 0: {
                LocalizedErrorHandler.throwLocalizedException("TKTSRowSet.txnIsoNoneError.txt", logger);
                break;
            }
            default: {
                LocalizedErrorHandler.throwLocalizedException("TKTSRowSet.invalidIsolationError.txt", logger);
            }
        }
    }

    @Override
    public boolean getEscapeProcessing() throws SQLException {
        return this.isEscapeProcessing;
    }

    @Override
    public void setEscapeProcessing(boolean value) throws SQLException {
        this.isEscapeProcessing = value;
    }

    @Override
    public boolean isReadOnly() {
        try {
            if (this.connection != null) {
                this.isReadOnly = this.connection.isReadOnly();
            }
        }
        catch (SQLException e) {
            if (AbstractLogger.isTrace) {
                logger.trace("isReadOnly: ");
                logger.trace(e);
            }
            this.isReadOnly = false;
        }
        return this.isReadOnly;
    }

    @Override
    public void setConcurrency(int concurrency) throws SQLException {
        String method = "setConcurrency";
        switch (concurrency) {
            case 1008: {
                this.rSetConcurrency = concurrency;
                this.isReadOnly = false;
                break;
            }
            default: {
                this.rSetConcurrency = 1007;
                this.isReadOnly = true;
            }
        }
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{String.valueOf(this.rSetConcurrency)};
            LocalizedMessageHandler.logInfoMessage(method, "FSRowSet.setConcurrency.fmt", args, logger);
        }
    }

    @Override
    public void setType(int value) throws SQLException {
        String method = "setType";
        switch (value) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.rSetType = value;
                break;
            }
            default: {
                this.rSetType = 1003;
            }
        }
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{String.valueOf(this.rSetType)};
            LocalizedMessageHandler.logInfoMessage(method, "FSRowSet.setType.fmt", args, logger);
        }
    }

    @Override
    public String getDataSourceName() {
        return this.connectionURL;
    }

    @Override
    public void setDataSourceName(String value) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
    }

    @Override
    public String getUsername() {
        return this.userName;
    }

    @Override
    public void setUsername(String value) throws SQLException {
        this.userName = value;
    }

    @Override
    public String getPassword() {
        return this.safeP.getValue();
    }

    @Override
    public String getUrl() throws SQLException {
        return this.connectionURL;
    }

    @Override
    public void setUrl(String inURL) throws SQLException {
        Driver driver;
        boolean validDriver;
        if (inURL == null) {
            LocalizedErrorHandler.throwLocalizedException("TKTSConnection.urlError.txt", logger);
        }
        if (validDriver = TKTSDriver.verifyRegisterDriver(driver = DriverManager.getDriver(inURL))) {
            this.sqlDriver = driver;
            this.connectionURL = inURL;
        } else {
            LocalizedErrorHandler.throwLocalizedException("TKTSRowSet.invalidDriverError.txt", logger);
        }
    }

    public void setTypeMap(Map value) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    @Override
    public void setMetaData(RowSetMetaData value) throws SQLException {
        this.rowSetMetadata = value;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowSetMetadata;
    }

    @Override
    public Object[] getParams() throws SQLException {
        return this._PARAMETER_INFO_ARRAY;
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int x = 0; x < this._PARAMETER_INFO_ARRAY.length; ++x) {
            this._PARAMETER_INFO_ARRAY[x].setValue(null);
        }
    }

    @Override
    public void close() throws SQLException {
        boolean releaseCache = true;
        String method = "close";
        if (this.abstractRowCache != null) {
            this.abstractRowCache.close(releaseCache);
        }
        this.isClosed = true;
        if (this.connection != null) {
            this.connection.close();
        }
        if (AbstractLogger.isInfo) {
            LocalizedMessageHandler.logInfoMessage(method, "FSRowSet.close.txt", logger);
        }
    }

    @Override
    public void setArray(int index, Array value) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        this.validateParameterIndex(index);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        String method = "setAsciiStream(parameterIndex, inputStream)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setAsciiStream(parameterIndex, inputStream)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        String method = "setAsciiStream(parameterIndex, inputStream, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setAsciiStream(parameterIndex, inputStream, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream) throws SQLException {
        String method = "setAsciiStream(parameterName, inputStream)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setAsciiStream(parameterName, inputStream)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        String method = "setAsciiStream(parameterName, inputStream, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setAsciiStream(parameterName, inputStream, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        ParameterInfo pi = this._PARAMETER_INFO_ARRAY[parameterIndex - 1];
        FSConnection fsConnection = (FSConnection)this.connection;
        SQLWarning sw = fsConnection == null ? pi.checkBigDecimal(value, FSEnums.BdTransportMode.TARGET, FSEnums.BdRoundingMode.HALF_EVEN, FSEnums.BdWriteTrunc.WARNING) : pi.checkBigDecimal(value, fsConnection.getBdTransportMode(), fsConnection.getBdRoundingMode(), fsConnection.getBdWriteTrunc());
        if (sw != null) {
            this.addWarnings(sw);
        }
        pi.setSQLType(2);
        pi.setValue(value);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(2);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-4);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setDataStreamLength(-1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, int length) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-4);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setDataStreamLength(length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, inputStream, -1);
    }

    @Override
    public void setBlob(int index, Blob value) throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        String method = "setBlob(parameterIndex, inputStream)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setBlob(parameterIndex, inputStream)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        String method = "setBlob(parameterIndex, inputStream, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setBlob(parameterIndex, inputStream, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setBlob(String parameterName, Blob blob) throws SQLException {
        String method = "setBlob(parameterName, blob)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setBlob(parameterName, blob)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        String method = "setBlob(parameterName, inputStream)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setBlob(parameterName, inputStream)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        String method = "setBlob(parameterName, inputStream, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setBlob(parameterName, inputStream, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(5);
        if (value) {
            this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Short(1));
        } else {
            this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Short(0));
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(5);
        if (value) {
            this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Short(1));
        } else {
            this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Short(0));
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-6);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Byte(x));
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-6);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Byte(x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] littleBytes) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-3);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(littleBytes);
    }

    @Override
    public void setBytes(String parameterName, byte[] littleBytes) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-3);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(littleBytes);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String method = "setCharacterStream(parameterIndex, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setCharacterStream(parameterIndex, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String method = "setCharacterStream(parameterIndex, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setCharacterStream(parameterIndex, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        String method = "setCharacterStream(parameterName, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setCharacterStream(parameterName, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        String method = "setCharacterStream(parameterName, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setCharacterStream(parameterName, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        String method = "setCharacterStream(parameterIndex, clob)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setCharacterStream(parameterIndex, clob)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        String method = "setClob(parameterIndex, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setClob(parameterIndex, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String method = "setClob(parameterIndex, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setClob(parameterIndex, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setClob(String parameterName, Clob clob) throws SQLException {
        String method = "setCharacterStream(parameterName, clob)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setCharacterStream(parameterName, clob)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        String method = "setClob(parameterName, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setClob(parameterName, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        String method = "setClob(parameterName, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setClob(parameterName, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setCommand(String sql) throws SQLException {
        String method = "setCommand";
        int parameterCounter = -1;
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{sql};
            LocalizedMessageHandler.logInfoMessage("setCommand", "FSRowSet.setCommand.fmt", args, logger);
        }
        this.sqlSatement = sql;
        this._PARAMETER_INFO_ARRAY = null;
        if (this.sqlSatement != null && (parameterCounter = UtilityFunctions.countParameters(this.sqlSatement)) > 0) {
            this._PARAMETER_INFO_ARRAY = new ParameterInfo[parameterCounter];
            for (int i = 0; i < parameterCounter; ++i) {
                this._PARAMETER_INFO_ARRAY[i] = new ParameterInfo();
                this._PARAMETER_INFO_ARRAY[i].setBindRequired(true);
                this._PARAMETER_INFO_ARRAY[i].setBindDirection(0);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.exit("setCommand", "parameterCounter[" + parameterCounter + "] ");
        }
    }

    @Override
    public void setDate(int parameterIndex, Date dateValue) throws SQLException {
        this.setDate(parameterIndex, dateValue, null);
    }

    @Override
    public void setDate(int parameterIndex, Date dateValue, Calendar calendar) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        TimeRepresentation dateRep = null;
        if (dateValue != null) {
            dateRep = new TimeRepresentation(dateValue, calendar);
        }
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(dateRep);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(91);
    }

    @Override
    public void setDate(String parameterName, Date dateValue) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setDate(parameterIndex, dateValue, null);
    }

    @Override
    public void setDate(String parameterName, Date dateValue, Calendar calendar) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setDate(parameterIndex, dateValue, calendar);
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Double(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(8);
    }

    @Override
    public void setDouble(String parameterName, double value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Double(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(8);
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Float(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(6);
    }

    @Override
    public void setFloat(String parameterName, float value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Float(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(6);
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Integer(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(4);
    }

    @Override
    public void setInt(String parameterName, int value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Integer(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(4);
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Long(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-5);
    }

    @Override
    public void setLong(String parameterName, long value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Long(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(-5);
    }

    @Override
    public void setMaxRows(int value) throws SQLException {
        String method = "setMaxRows";
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{String.valueOf(value)};
            LocalizedMessageHandler.logInfoMessage(method, "FSRowSet.setMaxRows.fmt", args, logger);
        }
        if (value < 0) {
            LocalizedErrorHandler.throwLocalizedException("TKTSRowSet.invalidMaxRowsError.txt", logger);
        }
        this.maxNumberOfRows = value;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String method = "setNCharacterStream(parameterIndex, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNCharacterStream(parameterIndex, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        String method = "setNCharacterStream(parameterIndex, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNCharacterStream(parameterIndex, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        String method = "setNCharacterStream(parameterName, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNCharacterStream(parameterName, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        String method = "setNCharacterStream(parameterName, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNCharacterStream(parameterName, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNClob(int parameterIndex, NClob nclob) throws SQLException {
        String method = "setNClob(parameterIndex, nclob)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNClob(parameterIndex, nclob)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        String method = "setNClob(parameterIndex, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNClob(parameterIndex, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String method = "setNClob(parameterIndex, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNClob(parameterIndex, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNClob(String parameterName, NClob nclob) throws SQLException {
        String method = "setNClob(parameterName, nclob)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNClob(parameterName, nclob)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        String method = "setNClob(parameterName, reader)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNClob(parameterName, reader)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        String method = "setNClob(parameterName, reader, length)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNClob(parameterName, reader, length)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        String method = "setNString(parameterIndex, String)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNString(parameterIndex, String)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        String method = "setNString(parameterName, String)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNString(parameterName, String)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNull(int parameterIndex, int sqltype) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(null);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(sqltype);
    }

    @Override
    public void setNull(String parameterName, int sqltype) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(null);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(sqltype);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        String method = "setNull(parameterIndex, sqlType, typeName)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNull(parameterIndex, sqlType, typeName)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        String method = "setNull(parameterName, sqlType, typeName)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setNull(parameterName, sqlType, typeName)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        int sqlType = UtilityFunctions.getObjectSQLType(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetSqlType, int scaleOrLength) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(targetSqlType);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setDecimalDigits(scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        int sqlType = UtilityFunctions.getObjectSQLType(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(sqlType);
    }

    @Override
    public void setObject(String parameterName, Object value, int targetSqlType) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object value, int targetSqlType, int scaleOrLength) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(targetSqlType);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setDecimalDigits(scaleOrLength);
    }

    @Override
    public void setPassword(String value) throws SQLException {
        this.safeP = new SafeStore(value);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeOut;
    }

    @Override
    public void setReadOnly(boolean value) throws SQLException {
        this.isReadOnly = value;
        if (this.connection != null) {
            this.connection.setReadOnly(value);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        String method = "setRef(parameterIndex, ref)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setRef(parameterIndex, ref)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setRowId(int parameterIndex, RowId rowId) throws SQLException {
        String method = "setRowId(parameterIndex, rowId)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setRowId(parameterIndex, rowId)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setRowId(String parameterName, RowId rowId) throws SQLException {
        String method = "setRowId(parameterName, rowId)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setRowId(parameterName, rowId)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Short(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(5);
    }

    @Override
    public void setShort(String parameterName, short value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(new Short(value));
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(5);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String method = "setSQLXML(parameterIndex, xmlObject)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setSQLXML(parameterIndex, xmlObject)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        String method = "setSQLXML(parameterName, xmlObject)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setSQLXML(parameterName, xmlObject)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(12);
    }

    @Override
    public void setString(String parameterName, String value) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(value);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(12);
    }

    @Override
    public void setTime(int parameterIndex, Time timeValue) throws SQLException {
        this.setTime(parameterIndex, timeValue, null);
    }

    @Override
    public void setTime(int parameterIndex, Time timeValue, Calendar calendar) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        TimeRepresentation timeRep = null;
        if (timeValue != null) {
            timeRep = new TimeRepresentation(timeValue, calendar);
        }
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(timeRep);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(92);
    }

    @Override
    public void setTime(String parameterName, Time timeValue) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setTime(parameterIndex, timeValue, null);
    }

    @Override
    public void setTime(String parameterName, Time timeValue, Calendar calendar) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setTime(parameterIndex, timeValue, calendar);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timeStampValue) throws SQLException {
        this.setTimestamp(parameterIndex, timeStampValue, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timeStampValue, Calendar calendar) throws SQLException {
        this.validateParameterIndex(parameterIndex);
        TimeRepresentation timeStampRep = null;
        if (timeStampValue != null) {
            timeStampRep = new TimeRepresentation(timeStampValue, calendar);
        }
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setValue(timeStampRep);
        this._PARAMETER_INFO_ARRAY[parameterIndex - 1].setSQLType(93);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timeStampValue) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setTimestamp(parameterIndex, timeStampValue, null);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timeStampValue, Calendar calendar) throws SQLException {
        int parameterIndex = this.findParameterIndex(parameterName);
        this.setTimestamp(parameterIndex, timeStampValue, calendar);
    }

    @Override
    public void setURL(int parameterIndex, URL urlObject) throws SQLException {
        String method = "setUrl(parameterIndex, urlObject)";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setUrl(parameterIndex, urlObject)"});
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    public Map getTypeMap() throws SQLException {
        LocalizedErrorHandler.throwLocalizedException("General.methodNotImplemented.fmt", logger);
        return null;
    }

    private void validateParameterIndex(int index) throws SQLException {
        if (index < 1 || index > this._PARAMETER_INFO_ARRAY.length) {
            LocalizedErrorHandler.throwLocalizedException("Generic.InvalidIndex.fmt", new String[]{"" + index}, logger);
        }
    }
}

