/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.logging;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import java.sql.SQLException;

public class ExceptionsLogger {
    private static String thisClassName = ExceptionsLogger.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    static final boolean logToStandardError = false;

    public static void log(Exception ex) {
        if (logger != null) {
            logger.trace("Exception:");
            logger.trace(ex.toString());
            logger.trace("StackTrace:");
            StackTraceElement[] sta = ex.getStackTrace();
            if (sta != null) {
                int elements = sta.length;
                for (int i = 0; i < elements; ++i) {
                    logger.trace(sta[i].toString());
                }
            }
        }
    }

    public static void logLangError(Error le) {
        if (logger != null) {
            logger.trace("java.lang.Exception Error:");
        }
        logger.trace(le.toString());
        logger.trace("StackTrace:");
        logger.trace(le.getStackTrace().toString());
        StackTraceElement[] sta = le.getStackTrace();
        if (sta != null) {
            int elements = sta.length;
            for (int i = 0; i < elements; ++i) {
                logger.trace(sta[i].toString());
            }
        }
    }

    public static void logSql(SQLException sqlEx) {
        logger.error("SQLException:");
        while (sqlEx != null) {
            logger.error("Cause:" + sqlEx.getCause());
            logger.error("ErrorCode:" + sqlEx.getErrorCode());
            logger.error("Message:" + sqlEx.getMessage());
            logger.error("SQLState:" + sqlEx.getSQLState());
            logger.error("StackTrace:");
            StackTraceElement[] sta = sqlEx.getStackTrace();
            if (sta != null) {
                int elements = sta.length;
                for (int i = 0; i < elements; ++i) {
                    logger.error(sta[i].toString());
                }
            }
            logger.error("");
            sqlEx = sqlEx.getNextException();
        }
    }

    public static void logThrowable(Throwable t) {
        logger.error("Message:" + t.getMessage());
        logger.error("Cause:" + t.getCause());
        logger.error("StackTrace:");
        StackTraceElement[] sta = t.getStackTrace();
        if (sta != null) {
            int elements = sta.length;
            for (int i = 0; i < elements; ++i) {
                logger.error(sta[i].toString());
            }
        }
        logger.error("");
    }
}

