/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.iom;

import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.tkts.logging.ExceptionsLogger;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;

public class ServerInformation {
    private static final String VALUE = "value";
    private transient IServerInformation iServerInformation;
    private transient String authServerURI;
    private transient String authServerHostName;
    private transient String authServerPortNumber;
    private transient String productName;
    private transient String productVersion;
    private transient int productVersionNumber;
    private transient String state;

    public ServerInformation(Object corbaObject) {
        this.iServerInformation = IServerInformationHelper.narrow((Object)corbaObject);
        if (this.iServerInformation != null) {
            this.populateServerInformation();
        }
    }

    public String getAuthServerURI() {
        return this.authServerURI;
    }

    public String getAuthServerHostName() {
        return this.authServerHostName;
    }

    public String getAuthServerPortNumber() {
        return this.authServerPortNumber;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getState() {
        return this.state;
    }

    public int getProductVersionNumber() {
        return this.productVersionNumber;
    }

    private void populateServerInformation() {
        AnySeqHolder anySeq = new AnySeqHolder();
        try {
            IFilteredList filteredList = this.iServerInformation.UseCategory("Information", "");
            filteredList.GetAttribute("IOM.ServerState", VALUE, anySeq);
            this.setState(anySeq);
            filteredList.GetAttribute("App.Server.ASURI", VALUE, anySeq);
            this.setAuthServerURI(anySeq);
            filteredList.GetAttribute("App.Server.Version", VALUE, anySeq);
            this.setProductVersion(anySeq);
            filteredList.GetAttribute("App.Server.ProductName", VALUE, anySeq);
            this.setProductName(anySeq);
            filteredList._release();
            this.iServerInformation._release();
        }
        catch (Exception e) {
            ExceptionsLogger.log(e);
        }
    }

    private void setAuthServerURI(AnySeqHolder anySeq) {
        Any[] anyArray = anySeq.value;
        if (anyArray != null && anyArray.length > 0) {
            this.authServerURI = anyArray[0].extract_string();
            if (this.authServerURI != null && !this.authServerURI.equals("")) {
                int pos1 = this.authServerURI.lastIndexOf(58);
                int pos2 = this.authServerURI.indexOf(59);
                String hostName = this.authServerURI.substring(6, pos1);
                String portNumber = this.authServerURI.substring(pos1 + 1, pos2);
                this.setAuthServerHostName(hostName);
                this.setAuthServerPortNumber(portNumber);
            }
        }
    }

    private void setAuthServerHostName(String authServerHostName) {
        this.authServerHostName = authServerHostName;
    }

    private void setAuthServerPortNumber(String authServerPortNumber) {
        this.authServerPortNumber = authServerPortNumber;
    }

    private void setProductName(AnySeqHolder anySeq) {
        Any[] anyArray = anySeq.value;
        this.productName = anyArray[0].extract_string();
    }

    private void setProductVersion(AnySeqHolder anySeq) {
        String version = "";
        Any[] anyArray = anySeq.value;
        this.productVersion = anyArray[0].extract_string();
        byte[] bytes1 = new byte[1];
        byte[] bytes = this.productVersion.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 46) continue;
            bytes1[0] = bytes[i];
            version = version + new String(bytes1);
        }
        try {
            Integer integer = new Integer(version);
            this.productVersionNumber = integer;
        }
        catch (NumberFormatException nfe) {
            ExceptionsLogger.log(nfe);
            this.productVersionNumber = 0;
        }
    }

    private void setState(AnySeqHolder anySeq) {
        Any[] anyArray = anySeq.value;
        this.state = anyArray[0].extract_string();
    }
}

