/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.iom;

import com.sas.SASTableServer.DriverCompletionOptions;
import com.sas.SASTableServer.IConnection;
import com.sas.SASTableServer.IEnvironment;
import com.sas.SASTableServer.IStatement;
import com.sas.SASTableServer.TKTS_ERROR;
import com.sas.SASTableServer.TKTS_INVALID_HANDLE;
import com.sas.SASTableServer.TKTS_NO_DATA;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.tkts.TrackResource;
import com.sas.tkts.iom.AbstractIOMWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;

public class ConnectionWrapper
extends AbstractIOMWrapper {
    private static String thisClassName = ConnectionWrapper.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    protected static boolean trackConnectionWrapper = false;
    protected static TrackResource myResources = new TrackResource("ConnectionWrapper");
    private transient IConnection serverConnection;
    private transient FSConnection fsConnection;

    public ConnectionWrapper(FSConnection conn) throws SQLException {
        String method = "ConnectionWrapper(conn)";
        long entryTime = 0L;
        if (AbstractLogger.isTrace) {
            logger.trace(method, "Wrapping a connection.");
        }
        this.fsConnection = conn;
        IEnvironment iEnvironment = this.fsConnection.getEnvironmentHandle();
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        try {
            this.serverConnection = iEnvironment.CreateConnection(new IntHolder());
        }
        catch (Exception te) {
            LocalizedErrorHandler.handleExceptionsInFunction(method, te, iEnvironment, logger);
        }
        if (trackConnectionWrapper) {
            String tStr = "CW_ID:" + this.getMyID() + ":CONN_ID:" + conn.getMyID();
            myResources.track(this, tStr);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiCreateConnection.txt", delta, logger);
        }
    }

    public FSConnection getFSConnection() {
        return this.fsConnection;
    }

    @Override
    public ORB getORBHandle() {
        return this.fsConnection.getORBHandle();
    }

    @Override
    public void createWarning(SQLWarning warning) {
        this.fsConnection.addWarning(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long Id() {
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            return this.serverConnection.Id();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEnvironment Parent() {
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            return this.serverConnection.Parent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Close() throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.Close();
        }
        if (trackConnectionWrapper) {
            myResources.untrack(this);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiClose.txt", delta, logger);
        }
        this.releaseOutgoingResources();
    }

    public void releaseOutgoingResources() {
        this.serverConnection = null;
        this.fsConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Connect(String serverName, String userName, String authentication, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.Connect(serverName, userName, authentication, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiConnect.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatement CreateStatement(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        IStatement iStatement;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            iStatement = this.serverConnection.CreateStatement(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiCreateStatement.txt", delta, logger);
        }
        return iStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Disconnect(IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.Disconnect(status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiDisconnect.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String DriverConnect(String inConnectionString, DriverCompletionOptions driverCompletion, int bufferLength, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, GenericError {
        String strValue;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            strValue = this.serverConnection.DriverConnect(inConnectionString, driverCompletion, bufferLength, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiDriverConnect.txt", delta, logger);
        }
        return strValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EndTran(int completionType, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.EndTran(completionType, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiEndTran.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void GetAttr(int attr, int indicator, AnyHolder value, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.GetAttr(attr, indicator, value, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiGetConnAttr.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void GetDiagFields(int[] recNumbers, int[] diagIdentifiers, int[] diagIndicators, AnySeqHolder values, VariableArray2dOfLongHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.GetDiagFields(recNumbers, diagIdentifiers, diagIndicators, values, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiGetDiagFields.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void GetDiagRecs(int[] recNumbers, StringSeqHolder sqlstates, LongSeqHolder nativeErrors, StringSeqHolder messageTexts, LongSeqHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, TKTS_NO_DATA, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.GetDiagRecs(recNumbers, sqlstates, nativeErrors, messageTexts, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiGetDiagRecs.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFunctions(int functionId, LongSeqHolder supported, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.GetFunctions(functionId, supported, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiGetFunctions.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetInformation(int[] infoTypes, int[] infoIndicators, AnySeqHolder infoValues, LongSeqHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.GetInformation(infoTypes, infoIndicators, infoValues, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiGetInformation.txt", delta, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SetAttr(int attr, int indicator, Any value, IntHolder status) throws TKTS_ERROR, TKTS_INVALID_HANDLE, GenericError {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        IConnection iConnection = this.serverConnection;
        synchronized (iConnection) {
            this.serverConnection.SetAttr(attr, indicator, value, status);
        }
        if (AbstractLogger.isMeasurements) {
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("ConnectionWrapper.apiSetConnAttr.txt", delta, logger);
        }
    }

    public static void logOverallStatistics() {
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logOverallStatistics(logger);
        }
    }

    public static void trackingDisplay() {
        myResources.display();
    }

    public static void trackingDisplaySummary() {
        myResources.displaySummary();
    }

    public static long trackingCount() {
        return myResources.count();
    }

    public static void trackingEnabled(boolean newValue, boolean details) {
        trackConnectionWrapper = newValue;
        myResources.setLogDetails(details);
    }

    public String toString() {
        String outStr = "CW ID:" + this.myID;
        return outStr;
    }
}

