/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.info;

import com.sas.tkts.FSEnums;
import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.info.PackedParameterSetBuffer;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.BitSet;

public class ParameterInfo
extends FedSrvJDBC {
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_TINYINT = 1;
    public static final int SIZE_OF_SMALLINT = 2;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_INTEGER = 4;
    public static final int SIZE_OF_BIGINT = 8;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_REAL = 8;
    public static final int SIZE_OF_FLOAT = 8;
    public static final int SIZE_OF_DOUBLE = 8;
    public static final int SIZE_OF_DATE = 6;
    public static final int SIZE_OF_TIME = 6;
    public static final int SIZE_OF_TIMESTAMP = 16;
    public static final int SIZE_OF_NUMERIC = 19;
    public static final int SIZE_OF_DECIMAL = 19;
    private static final int CONTROL_BITS_IS_VALID_BYTE = 1;
    private static final int CONTROL_BITS_IS_BOOKMARK = 2;
    private static final int CONTROL_BITS_IS_BIND_REQUIRED = 3;
    private static final int CONTROL_BITS_IS_BOUND = 4;
    private static final int CONTROL_BITS_IS_VALUE_SET = 5;
    private static final int CONTROL_BITS_IS_CONV_EMPTY_STRING = 6;
    private static final int CONTROL_BITS_IS_REAL_DESCRIBE_PARM = 7;
    private static final int CONTROL_BITS_IS_BIG_DECIMAL = 8;
    private static final int CONTROL_BITS_LAST = 8;
    private static String thisClassName = ParameterInfo.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static MathContext MC_DIGITS38_HALF_EVEN = new MathContext(38, RoundingMode.HALF_EVEN);
    private static MathContext[] MC_DIGITS38;
    private static MathContext[] MC_DECIMAL64;
    protected transient BitSet controlBits = new BitSet(8);
    protected transient int ordinal;
    protected transient long displaySize;
    protected transient short sizeOfWChar = (short)2;
    private transient int bufferLength;
    protected transient short decimalDigits;
    protected transient short precisionDigits;
    protected transient String name;
    protected transient Charset nativeCharset;
    protected transient int nativeEncoding;
    protected transient int nullableIndicator;
    protected transient int dataStreamLength;
    protected transient int sqlType;
    protected transient int cType;
    protected transient int nativeCType;
    protected transient int bindDirection;
    protected transient byte classType = (byte)-1;
    protected transient Object value;
    protected transient ParameterSetObjects _PARAMETER_SET_ARRAY;
    protected transient ParameterSetTypes _PARAMETER_SET_TYPE;
    public transient BigDecimalInfo bdInfo;

    protected static String mathContextString(MathContext mc) {
        if (mc == MathContext.DECIMAL32) {
            String out = "DECIMAL32(7,HALF_EVEN)";
            return out;
        }
        if (mc == MathContext.DECIMAL64) {
            String out = "DECIMAL64(16,HALF_EVEN)";
            return out;
        }
        if (mc == MathContext.DECIMAL128) {
            String out = "DECIMAL128(34,HALF_EVEN)";
            return out;
        }
        if (mc == MathContext.UNLIMITED) {
            String out = "UNLIMITED(,HALF_UP)";
            return out;
        }
        if (mc == MC_DIGITS38_HALF_EVEN) {
            String out = "MC_DIGITS38_HALF_EVEN(34,HALF_EVEN)";
            return out;
        }
        RoundingMode rm = mc.getRoundingMode();
        String out = "CUSTOM(" + mc.getPrecision() + "," + (Object)((Object)rm) + ")";
        return out;
    }

    public MathContext getMathContextByDataType(int inCType, FSEnums.BdRoundingMode rMode) {
        MathContext outMC;
        switch (inCType) {
            case 4: 
            case 6: {
                outMC = MC_DECIMAL64[rMode.value];
                break;
            }
            case 5: {
                outMC = MC_DIGITS38[rMode.value];
                break;
            }
            default: {
                outMC = MathContext.UNLIMITED;
            }
        }
        return outMC;
    }

    public ParameterInfo() {
        if (this._PARAMETER_SET_ARRAY == null) {
            this._PARAMETER_SET_ARRAY = new ParameterSetObjects();
        }
        if (this._PARAMETER_SET_TYPE == null) {
            this._PARAMETER_SET_TYPE = new ParameterSetTypes();
        }
        this.setValid(true);
        this.bdInfo = null;
    }

    public boolean isValid() {
        return this.controlBits.get(1);
    }

    public void setValid(boolean newValue) {
        this.controlBits.set(1, newValue);
    }

    public short getSizeOfWChar() {
        return this.sizeOfWChar;
    }

    public void setSizeOfWChar(short sizeOfWChar) {
        this.sizeOfWChar = sizeOfWChar;
    }

    public boolean isBookmark() {
        return this.controlBits.get(2);
    }

    public void setBookmark(boolean newValue) {
        this.controlBits.set(2, newValue);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getPrecision() {
        return this.precisionDigits;
    }

    public void setPrecision(int precisionDigits) {
        this.precisionDigits = (short)precisionDigits;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigit) {
        this.decimalDigits = (short)decimalDigit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String columnName) {
        this.name = columnName;
    }

    public int getNullableIndicator() {
        return this.nullableIndicator;
    }

    public void setNullableIndicator(int nullable) {
        this.nullableIndicator = nullable;
    }

    public int getDataStreamLength() {
        return this.dataStreamLength;
    }

    public void setDataStreamLength(int dataStreamLength) {
        this.dataStreamLength = dataStreamLength;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public void setSQLType(int sqlType) {
        this.sqlType = sqlType;
    }

    public int getCType() {
        return this.cType;
    }

    public void setCType(int cType) {
        this.cType = (short)cType;
    }

    public int getNativeCType() {
        return this.nativeCType;
    }

    public void setNativeCType(int nativeCType) {
        this.nativeCType = nativeCType;
    }

    public void defaultNativeCType() {
        this.nativeCType = this.cType;
    }

    public byte getType() {
        return this.classType;
    }

    public void setType(byte inType) {
        this.classType = inType;
    }

    public int getBindDirection() {
        return this.bindDirection;
    }

    public void setBindDirection(int newValue) {
        this.bindDirection = (byte)newValue;
    }

    public boolean isBindRequired() {
        return this.controlBits.get(3);
    }

    public void setBindRequired(boolean newValue) {
        this.controlBits.set(3, newValue);
    }

    public void setBound(boolean newValue) {
        this.controlBits.set(4, newValue);
    }

    public boolean isBound() {
        return this.controlBits.get(4);
    }

    public boolean isValueSet() {
        return this.controlBits.get(5);
    }

    public void setIsValueSet(boolean newValue) {
        this.controlBits.set(5, newValue);
    }

    public boolean getConvEmpty() {
        return this.controlBits.get(6);
    }

    public void setConvEmpty(boolean newValue) {
        this.controlBits.set(6, newValue);
    }

    public boolean isRealDescribeParm() {
        return this.controlBits.get(7);
    }

    public void setIsRealDescribeParm(boolean newValue) {
        this.controlBits.set(7, newValue);
    }

    public boolean isBigDecimal() {
        return this.controlBits.get(8);
    }

    public void setIsBigDecimal(boolean newValue) {
        this.controlBits.set(8, newValue);
    }

    public long getDisplaySize() {
        return this.displaySize;
    }

    public long getDisplaySizeInCharacters() {
        return this.displaySize / (long)this.sizeOfWChar;
    }

    public void setDisplaySize(long size) {
        if (size < 0L) {
            this.setBindRequired(true);
            this.displaySize = size;
        } else if ((size *= (long)this.sizeOfWChar) > this.displaySize) {
            this.setBindRequired(true);
            this.displaySize = size;
        }
    }

    public void resetDisplaySize() {
        this.displaySize = 0L;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public void setBufferLength(int size) {
        if ((size *= this.sizeOfWChar) > this.bufferLength) {
            this.bufferLength = size;
        }
    }

    public void setNativeEncoding(int inCEI) throws SQLException {
        if (inCEI == 27 || inCEI == 26) {
            this.sizeOfWChar = (short)4;
        }
        this.nativeEncoding = inCEI;
        this.nativeCharset = null;
        if (inCEI != 0) {
            String csName = CharSetUtil.getCharsetNameFromCEI(inCEI);
            if (csName != null) {
                this.nativeCharset = Charset.forName(csName);
            }
            if (this.nativeCharset == null) {
                String ei = "General.UnsupportedCEI.fmt";
                this.throwException("General.UnsupportedCEI.fmt", logger, Integer.toString(inCEI));
            }
        }
    }

    public Charset getNativeCharset() {
        return this.nativeCharset;
    }

    public int getNativeEncoding() {
        return this.nativeEncoding;
    }

    public boolean isLong() {
        return ParameterInfo.isLongVar(this.sqlType);
    }

    public boolean isVarying() {
        return this.isVaryingLength(this.sqlType);
    }

    public void addValueToParameterSet() {
        if (this.bindDirection == 4) {
            return;
        }
        this.setValid(true);
        Object o = this.value;
        if (this.value == null && this.nullableIndicator == 0) {
            o = this.getNullObject();
        }
        if (this.isBigDecimal()) {
            o = this.convertBigDecimal((BigDecimal)o);
        }
        this._PARAMETER_SET_ARRAY.add(o);
        boolean tLong = this.isLong();
        boolean tVarying = this.isVarying();
        Object pType = PackedParameterSetBuffer.getParameterSetType(o, tLong, tVarying);
        this._PARAMETER_SET_TYPE.add(pType);
    }

    public void addValueToPackedData(int psa_index, PackedParameterSetBuffer packedData) {
        this.value = this._PARAMETER_SET_ARRAY.get(psa_index);
        Object pType = this._PARAMETER_SET_TYPE.get(psa_index);
        int pBytes = packedData.packParameterValue(this.ordinal, this.value, pType);
        if (pBytes > 0) {
            this.setBufferLength(pBytes);
        }
    }

    public synchronized void resetValue() {
        this.value = null;
        this.setIsValueSet(false);
        this.clearParamSetArray();
    }

    public synchronized void clearParamSetArray() {
        if (this._PARAMETER_SET_ARRAY != null) {
            this._PARAMETER_SET_ARRAY.clear();
        }
        if (this._PARAMETER_SET_TYPE != null) {
            this._PARAMETER_SET_TYPE.clear();
        }
    }

    public synchronized void removeRows(int rowsToRemove) {
        if (this._PARAMETER_SET_ARRAY != null) {
            this._PARAMETER_SET_ARRAY.deleteRows(rowsToRemove);
        }
        if (this._PARAMETER_SET_TYPE != null) {
            this._PARAMETER_SET_TYPE.deleteRows(rowsToRemove);
        }
    }

    public synchronized void setValue(Object paramValue) {
        this.value = paramValue;
        if (this.bindDirection != 2) {
            switch (this.bindDirection) {
                case 4: {
                    this.bindDirection = 4;
                    this.setBindRequired(true);
                    break;
                }
                case 0: {
                    this.bindDirection = 1;
                    this.setBindRequired(true);
                    break;
                }
            }
        }
    }

    public synchronized Object getValue() throws SQLException {
        if (!this.isValid()) {
            String ei = "ParameterInfo.InvalidParamsError.txt";
            ParameterInfo.staticThrowException("ParameterInfo.InvalidParamsError.txt", logger);
        }
        return this.value;
    }

    public synchronized Object getValue(int index) {
        if (index == -1) {
            return this.value;
        }
        return this._PARAMETER_SET_ARRAY.get(index);
    }

    public synchronized ArrayList<Object> getParamSetArray() {
        return this._PARAMETER_SET_ARRAY;
    }

    public synchronized int getParamSetArraySize() {
        return this._PARAMETER_SET_ARRAY.size();
    }

    public SQLWarning checkBigDecimal(BigDecimal inBD, FSEnums.BdTransportMode transportMode, FSEnums.BdRoundingMode roundingMode, FSEnums.BdWriteTrunc writeTrunc) throws SQLException {
        int bdPrecision;
        SQLWarning sw = null;
        if (this.bdInfo == null) {
            boolean realDescribe = this.isRealDescribeParm();
            if (transportMode == FSEnums.BdTransportMode.TARGET && !realDescribe) {
                transportMode = FSEnums.BdTransportMode.SOURCE;
            }
            this.bdInfo = new BigDecimalInfo(roundingMode, transportMode, writeTrunc, realDescribe);
        } else {
            transportMode = this.bdInfo.bdTransportMode;
        }
        int bdCtype = this.bdInfo.bigDecimalCtype;
        if (FSEnums.BdTransportMode.isFixedDataType(transportMode)) {
            return sw;
        }
        BigDecimal setBD = inBD;
        if (transportMode == FSEnums.BdTransportMode.TARGET) {
            MathContext convMC = this.getMathContextByDataType(this.nativeCType, roundingMode);
            int roundPrecision = convMC.getPrecision();
            if (roundPrecision > 0 && setBD.precision() > roundPrecision) {
                setBD = setBD.round(convMC);
            }
            bdPrecision = setBD.precision();
            switch (this.nativeCType) {
                case 4: 
                case 6: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    double bdDbl = setBD.doubleValue();
                    if (bdDbl != Double.POSITIVE_INFINITY && bdDbl != Double.NEGATIVE_INFINITY) break;
                    if (writeTrunc == FSEnums.BdWriteTrunc.EXCEPTION) {
                        DataTruncation dt = this.createOutOfRange(setBD, 8, 8);
                        throw dt;
                    }
                    if (writeTrunc != FSEnums.BdWriteTrunc.WARNING) break;
                    sw = this.createOutOfRangeWarn(setBD, 8, 8);
                    break;
                }
                case 5: 
                case 8: 
                case 9: {
                    int bdScale = setBD.scale();
                    int bdExponent = bdPrecision - (bdScale + 1);
                    if (bdExponent <= 38) break;
                    if (writeTrunc == FSEnums.BdWriteTrunc.EXCEPTION) {
                        DataTruncation dt = this.createOutOfRange(setBD, 19, 19);
                        throw dt;
                    }
                    if (writeTrunc != FSEnums.BdWriteTrunc.WARNING) break;
                    sw = this.createOutOfRangeWarn(setBD, 19, 19);
                    break;
                }
            }
        } else {
            int bdScale;
            int bdExponent;
            if (bdCtype == 6) {
                bdPrecision = setBD.precision();
                if (bdPrecision > 15) {
                    this.bdInfo.bigDecimalCtype = 5;
                } else {
                    double bdDbl = setBD.doubleValue();
                    if (bdDbl == Double.POSITIVE_INFINITY || bdDbl == Double.NEGATIVE_INFINITY) {
                        this.bdInfo.bigDecimalCtype = 5;
                    } else {
                        return sw;
                    }
                }
            }
            if (bdCtype == 5 && (bdExponent = (bdPrecision = setBD.precision()) - ((bdScale = setBD.scale()) + 1)) <= 38) {
                return sw;
            }
            this.bdInfo.bigDecimalCtype = 1;
        }
        return sw;
    }

    public Object convertBigDecimal(BigDecimal inBD) {
        Object out = null;
        int transportSQLType = this.isRealDescribeParm() ? this.nativeCType : this.bdInfo.bigDecimalCtype;
        BigDecimal setBD = inBD;
        MathContext convMC = this.getMathContextByDataType(transportSQLType, this.bdInfo.bdRoundingMode);
        int roundPrecision = convMC.getPrecision();
        if (roundPrecision > 0 && setBD.precision() > roundPrecision) {
            setBD = setBD.round(convMC);
        }
        switch (transportSQLType) {
            case 4: 
            case 6: {
                double bdDbl = setBD.doubleValue();
                out = new Double(bdDbl);
                this.validateParameterDataType(8);
                break;
            }
            case 5: {
                this.validateParameterDataType(2);
                out = setBD;
                break;
            }
            default: {
                String bdStr = setBD.toString();
                this.validateParameterDataType(12);
                out = bdStr;
                this.adjustDisplaySize(bdStr);
            }
        }
        this.setIsValueSet(true);
        return out;
    }

    public void validateParameterDataType(int sqlType) {
        if (sqlType == 0) {
            sqlType = 1;
        } else if (sqlType == 2005) {
            sqlType = -1;
        } else if (sqlType == 2004) {
            sqlType = -4;
        }
        int oldSqlType = this.getSQLType();
        if (oldSqlType != sqlType) {
            this.setBindRequired(true);
            UtilityFunctions.mapSQLType2CType(this, sqlType);
        }
    }

    public void adjustDisplaySize(String newValue) {
        int newLength = 0;
        if (newValue != null) {
            newLength = newValue.length();
            long oldLength = this.getDisplaySizeInCharacters();
            if (oldLength < (long)newLength) {
                int roundSize = 64;
                int newDisplaySize = newLength / roundSize;
                if (newLength % roundSize != 0) {
                    ++newDisplaySize;
                }
                this.setDisplaySize(newDisplaySize *= roundSize);
            }
        }
    }

    public DataTruncation createOutOfRange(Object valueObj, int dataSize, int transferSize) {
        String valueStr = valueObj.toString();
        String nativeCTypeStr = CommonLogger.getCTypeStringAndNumber(this.nativeCType);
        String ei = "General.NumericOutOfRange.fmt";
        Object[] args = new String[]{valueStr, nativeCTypeStr};
        String lMsg = LocalizedErrorHandler.getLocalizedError("General.NumericOutOfRange.fmt", args);
        Throwable cause = new Throwable(lMsg);
        cause = cause.fillInStackTrace();
        DataTruncation dt = new DataTruncation(this.ordinal, true, false, dataSize, transferSize, cause);
        return dt;
    }

    public SQLWarning createOutOfRangeWarn(Object valueObj, int dataSize, int transferSize) {
        String valueStr = valueObj.toString();
        String nativeCTypeStr = CommonLogger.getCTypeStringAndNumber(this.nativeCType);
        Object[] args = new String[]{valueStr, nativeCTypeStr};
        String ei = "General.NumericOutOfRange.fmt";
        String lMsg = LocalizedErrorHandler.getLocalizedError("General.NumericOutOfRange.fmt", args);
        SQLWarning sqw = new SQLWarning(lMsg, "22003");
        return sqw;
    }

    public void copyFields(ParameterInfo inPI) throws SQLException {
        this.setValue(inPI.getValue());
        this.setCType(inPI.getCType());
        this.setNativeCType(inPI.getNativeCType());
        this.setSQLType(inPI.getSQLType());
        this.setDecimalDigits(inPI.getDecimalDigits());
        this.bdInfo = inPI.bdInfo;
    }

    public ParameterInfo cloneMetaData() throws SQLException {
        ParameterInfo pi = new ParameterInfo();
        pi.name = this.name;
        pi.bindDirection = this.bindDirection;
        pi.nativeEncoding = this.nativeEncoding;
        pi.nativeCharset = this.nativeCharset;
        pi.displaySize = this.displaySize;
        pi.cType = this.cType;
        pi.nativeCType = this.nativeCType;
        pi.sqlType = this.sqlType;
        pi.decimalDigits = this.decimalDigits;
        pi.precisionDigits = this.precisionDigits;
        pi.bdInfo = this.bdInfo;
        pi.dataStreamLength = this.dataStreamLength;
        pi.nullableIndicator = this.nullableIndicator;
        pi.sizeOfWChar = this.sizeOfWChar;
        return pi;
    }

    public String toString() {
        String outStr = this.name == null ? "\nName:? Ordinal:" + this.ordinal : "\nName:'" + this.name + "' Ordinal:" + this.ordinal;
        outStr = outStr + "\nDataTypes SQL:" + CommonLogger.getSQLTypeStringAndNumber(this.getSQLType()) + " C: " + CommonLogger.getCTypeStringAndNumber(this.getCType()) + " NC: " + CommonLogger.getCTypeStringAndNumber(this.getNativeCType());
        outStr = outStr + "\nBind Direction:" + CommonLogger.bindDirection(this.bindDirection);
        if (this.isBindRequired()) {
            outStr = outStr + " Required";
        }
        if (this.isBound()) {
            outStr = outStr + " Bound";
        }
        outStr = this.isValueSet() ? (this.value == null ? outStr + "\nValue is null" : (this.value instanceof byte[] ? outStr + "\nValue Set: byte[]" : outStr + "\nValue Set:" + this.value.toString())) : outStr + "\nValue Not Set:";
        outStr = this.isRealDescribeParm() ? outStr + "\nDescribeParmSupported" : outStr + "\nDescribeParmUnSupported";
        outStr = outStr + "\nDisplaySize:" + this.displaySize + " dataStreamLength:" + this.dataStreamLength;
        outStr = outStr + "\nPrecision:" + this.precisionDigits + " Scale:" + this.decimalDigits;
        outStr = outStr + "\nNative Encoding:" + this.nativeEncoding;
        outStr = outStr + "\nNative Charset:" + this.nativeCharset;
        outStr = this.isValid() ? outStr + "\nisValid:True: nullableIndicator:" + this.nullableIndicator : outStr + "\nisValid:False: nullableIndicator:" + this.nullableIndicator;
        if (this.isLong()) {
            outStr = outStr + "\nisLong";
        }
        if (this.isBigDecimal()) {
            outStr = outStr + "\nisBigDecimal";
        }
        if (this.bdInfo != null) {
            outStr = outStr + this.bdInfo.toString();
        }
        outStr = outStr + "\n";
        return outStr;
    }

    public void log() {
    }

    protected Object getNullObject() {
        Object out = null;
        switch (this.sqlType) {
            case 2003: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case -5: {
                out = Constants.LONG_ZERO;
                break;
            }
            case -2: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case -7: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case 2004: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case 16: {
                out = Boolean.FALSE;
                break;
            }
            case 1: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case 2005: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case 70: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case 91: {
                out = Constants.DATE_ZERO;
                break;
            }
            case 3: {
                out = Constants.BD_ZERO;
                break;
            }
            case 2001: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case 8: {
                out = Constants.DOUBLE_ZERO;
                break;
            }
            case 6: {
                out = Constants.FLOAT_ZERO;
                break;
            }
            case 4: {
                out = Constants.INTEGER_ZERO;
                break;
            }
            case -4: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case -1: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case -15: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case 2011: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case 0: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case 2: {
                out = Constants.BD_ZERO;
                break;
            }
            case -9: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case 1111: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case 7: {
                out = Constants.FLOAT_ZERO;
                break;
            }
            case 2006: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case -8: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case 5: {
                out = Constants.SHORT_ZERO;
                break;
            }
            case 92: {
                out = Constants.DATE_ZERO;
                break;
            }
            case 93: {
                out = Constants.DATE_ZERO;
                break;
            }
            case -6: {
                out = Constants.BYTE_ZERO;
                break;
            }
            case -3: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case 12: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case -10: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            case -16: {
                out = Constants.ARRAY_EMPTY;
                break;
            }
            default: {
                out = Constants.BYTE_ZERO;
            }
        }
        return out;
    }

    static {
        FSEnums.BdRoundingMode[] roundingModes = FSEnums.BdRoundingMode.values();
        int numberModes = roundingModes.length;
        MC_DIGITS38 = new MathContext[numberModes];
        MC_DECIMAL64 = new MathContext[numberModes];
        for (int iRM = 0; iRM < numberModes; ++iRM) {
            FSEnums.BdRoundingMode bdRM = roundingModes[iRM];
            RoundingMode mathRM = bdRM.getMathRoundingMode();
            ParameterInfo.MC_DIGITS38[iRM] = new MathContext(38, mathRM);
            ParameterInfo.MC_DECIMAL64[iRM] = new MathContext(16, mathRM);
        }
        boolean bl = false;
    }

    public class ParameterSetObjects
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        public void deleteRows(int rows) {
            this.removeRange(0, rows);
        }
    }

    public class ParameterSetTypes
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        public void deleteRows(int rows) {
            this.removeRange(0, rows);
        }
    }

    private class BigDecimalInfo {
        public transient int bigDecimalCtype = 6;
        public transient FSEnums.BdRoundingMode bdRoundingMode;
        public transient FSEnums.BdTransportMode bdTransportMode;
        public transient FSEnums.BdWriteTrunc bdWriteTrunc;
        public transient boolean describeParm;

        public BigDecimalInfo(FSEnums.BdRoundingMode rm, FSEnums.BdTransportMode tm, FSEnums.BdWriteTrunc wt, boolean dp) {
            this.bdRoundingMode = rm;
            this.bdTransportMode = tm;
            this.bdWriteTrunc = wt;
            this.describeParm = dp;
        }

        public String toString() {
            String outStr = "\nBigDecimal Information:";
            outStr = outStr + "\n  CType:" + CommonLogger.getCTypeStringAndNumber(ParameterInfo.this.bdInfo.bigDecimalCtype);
            outStr = outStr + "\n  RoundingMode:" + ParameterInfo.this.bdInfo.bdRoundingMode.toString();
            outStr = outStr + "\n  TransportMode:" + ParameterInfo.this.bdInfo.bdTransportMode.toString();
            outStr = outStr + "\n  WriteTruncation:" + ParameterInfo.this.bdInfo.bdWriteTrunc.toString();
            if (this.describeParm) {
                outStr = outStr + "\n  Supports Describe Parameters";
            }
            return outStr;
        }
    }
}

