/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.tkts.FSEnums;
import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.caching.Row;
import com.sas.tkts.info.ColumnsAttributes;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.types.NumberColumnInteger;
import com.sas.tkts.types.StringColumn;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.IntHolder;

public class MetaDataRowCache
extends AbstractRowCache {
    private static String thisClassName = MetaDataRowCache.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static final int[] CATALOG_INDEX_MAP = new int[]{0, -1, -1, -1, -1, 1, -1, -1};
    private static final int[] PROCEDURES_INDEX_MAP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 9, 10, 11};
    private static final int[] SCHEMA_INDEX_MAP = new int[]{1, 0, -1, -1, -1, -1, -1, -1};
    private static final int[] TABLETYPES_INDEX_MAP = new int[]{-1, -1, -1, 0, -1, -1, -1, -1};
    private static final String BASE_TYPE = "BASE_TYPE";
    private static final String CLASS_NAME = "CLASS_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String REMARKS = "REMARKS";
    private static final String TYPE_CAT = "TYPE_CAT";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TYPE_SCHEM = "TYPE_SCHEM";
    private static final String SPECIFIC_NAME = "SPECIFIC_NAME";
    private static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String FETCHS_AND_ROWS = "Number Fetchs=[%d] Rows=[%d]";
    private transient boolean isRebindRequired;
    private transient Constants.mdTypes metaDataType;
    private static final transient int MAX_MD_INDEX = 30;
    private static transient int[] DEFAULT_INDEX_MAP = new int[30];

    protected static String debugFetchsRows(int fetches, int rows) {
        String out = String.format(FETCHS_AND_ROWS, fetches, rows);
        return out;
    }

    protected void initFields(Constants.mdTypes mdType, StatementWrapper inStmtWrapper) {
        this.isRebindRequired = true;
        this.isMetadataCache = true;
        this.statementWrapper = inStmtWrapper;
        this.metaDataType = mdType;
    }

    public MetaDataRowCache(Constants.mdTypes mdType) throws SQLException {
        this.initFields(mdType, null);
        this.setCursorPosition(-1, 0);
        switch (mdType) {
            case CLIENTINFOPROPERTIES: {
                this.dummyClientInfoProperties();
                break;
            }
            case FUNCTIONCOLUMNS: {
                this.dummyFunctionColumns();
                break;
            }
            case FUNCTIONS: {
                this.dummyFunctions();
                break;
            }
            case UDT: {
                this.dummyUserDefinedType();
                break;
            }
            case UDT_ATTRIBUTES_TYPE: {
                this.dummyUdtAttribute();
                break;
            }
            case SCHEMAS: {
                this.createSchemas();
                break;
            }
            case SUPERTABLE_TYPE: {
                this.dummySuperTables();
                break;
            }
            case SUPERTYPE_TYPE: {
                this.dummySuperTypes();
                break;
            }
            default: {
                logger.error("MetaDataRowCache unexpected mdType:" + this.getMetaDataTypeToString(mdType));
            }
        }
    }

    public MetaDataRowCache(Constants.mdTypes mdType, StatementWrapper stmtWrapper) throws SQLException {
        String method = "MetaDataRowCache()";
        if (AbstractLogger.isTrace) {
            logger.trace(method, "New(mdType[" + this.getMetaDataTypeToString(mdType) + "] stmtWrapper:" + stmtWrapper + ");");
        }
        this.initFields(mdType, stmtWrapper);
        this.determinePackType();
        switch (this.metaDataType) {
            case BESTROWIDENTIFIER: {
                this.rsBestRowIdentifier();
                break;
            }
            case CATALOGS: {
                this.rsCatalog();
                break;
            }
            case COLUMNPRIVILEGES: {
                this.rsColumnPrivileges();
                break;
            }
            case COLUMNS: {
                this.rsColumns();
                break;
            }
            case CROSSREFERENCE: {
                this.rsCrossReference();
                break;
            }
            case EXPORTEDKEYS: {
                this.rsExportedKeys();
                break;
            }
            case IMPORTEDKEYS: {
                this.rsImportedKeys();
                break;
            }
            case INDEX_INFO: {
                this.rsIndexInfo();
                break;
            }
            case PRIMARYKEYS: {
                this.rsPrimaryKeys();
                break;
            }
            case PROCEDURES: {
                this.rsProcedures();
                break;
            }
            case PROC_COLUMNS: {
                this.rsProcedureColumns();
                break;
            }
            case SCHEMAS: {
                this.rsSchemas();
                break;
            }
            case TABLES: {
                this.rsTables();
                break;
            }
            case TABLEPRIVILEGES: {
                this.rsTablesPrivileges();
                break;
            }
            case TABLETYPES: {
                this.rsTableTypes();
                break;
            }
            case TYPEINFO: {
                this.rsTypeInfo();
                break;
            }
            case VERSIONCOLUMNS: {
                this.rsVersionColumns();
                break;
            }
            case NOSPECIALBINDING: {
                System.err.println("FIX ME NOSPECIALBINDING:");
                break;
            }
        }
        this.setCursorPosition(-1, 0);
        if (stmtWrapper != null) {
            boolean stmtPrefetch = stmtWrapper.getPrefetch();
            this.setPrefetch(stmtPrefetch);
        } else {
            System.out.println("MetaDataRowCache stmtWrapper is null ");
        }
    }

    private String getMetaDataTypeToString(Constants.mdTypes mdt) {
        String outString = null;
        switch (mdt) {
            case CATALOGS: {
                outString = "CATALOGS";
                break;
            }
            case COLUMNS: {
                outString = "COLUMNS";
                break;
            }
            case NOSPECIALBINDING: {
                outString = "";
                break;
            }
            case PROC_COLUMNS: {
                outString = "PROC_COLUMNS";
                break;
            }
            case SCHEMAS: {
                outString = "SCHEMAS";
                break;
            }
            case SUPERTABLE_TYPE: {
                outString = "SUPERTABLE_TYPE";
                break;
            }
            case SUPERTYPE_TYPE: {
                outString = "SUPERTYPE_TYPE";
                break;
            }
            case TABLES: {
                outString = "TABLES";
                break;
            }
            case TABLETYPES: {
                outString = "TABLETYPES";
                break;
            }
            case TYPEINFO: {
                outString = "TYPEINFO";
                break;
            }
            case UDT: {
                outString = "UDT";
                break;
            }
            case UDT_ATTRIBUTES_TYPE: {
                outString = "UDT_ATTRIBUTES_TYPE";
                break;
            }
            default: {
                outString = "????";
            }
        }
        outString = outString + "(" + (Object)((Object)mdt) + ")";
        return outString;
    }

    protected int getNativeEncoding() {
        int nativeEncoding = CharSetUtil.getToServerEncoding();
        return nativeEncoding;
    }

    @Override
    protected void bindColumns() throws SQLException {
        String method = "bindColumns()";
        IntHolder status = new IntHolder();
        LongSeqHolder statusHolder = new LongSeqHolder();
        int arraySize = this.getBoundColumns();
        int[] columnWidths = new int[arraySize];
        int[] columnCTypes = new int[arraySize];
        String[] columnFormats = new String[arraySize];
        int[] bindTypes = new int[arraySize];
        int[] columnNumbers = new int[arraySize];
        block12: for (int i = 0; i < arraySize; ++i) {
            columnFormats[i] = "TKTS_FMT_DEFAULT";
            bindTypes[i] = 13;
            columnWidths[i] = (int)this._COLUMN_INFO_ARRAY[i].getDisplaySize();
            columnNumbers[i] = this._COLUMN_INFO_ARRAY[i].getOrdinal();
            switch (this._COLUMN_INFO_ARRAY[i].getSQLType()) {
                case 1: 
                case 12: {
                    columnCTypes[i] = 3;
                    continue block12;
                }
                case 4: {
                    columnCTypes[i] = 10;
                    continue block12;
                }
                case 5: {
                    columnCTypes[i] = 12;
                    continue block12;
                }
                case -6: {
                    columnCTypes[i] = 14;
                    continue block12;
                }
                case -5: {
                    columnCTypes[i] = 8;
                    continue block12;
                }
                case 91: {
                    columnCTypes[i] = 17;
                    continue block12;
                }
                case 92: {
                    columnCTypes[i] = 18;
                    continue block12;
                }
                case 93: {
                    columnCTypes[i] = 19;
                    continue block12;
                }
                default: {
                    columnCTypes[i] = 6;
                }
            }
        }
        if (this.isRebindRequired) {
            try {
                this.statementWrapper.BindCols(columnNumbers, columnCTypes, columnFormats, columnWidths, bindTypes, statusHolder, status);
                this.checkForWarnings(status.value);
                this.isRebindRequired = false;
            }
            catch (Exception exception) {
                LocalizedErrorHandler.handleExceptionsInFunction(thisClassName + "." + "bindColumns()", exception, this.statementWrapper, logger);
            }
        }
    }

    protected void setupColumns(int tktsColumns, int jdbcColumns) throws SQLException {
        int i;
        int allocateSize;
        String method = "setupColumns()";
        ColumnsAttributes colAttributes = null;
        this._COLUMN_INFO_ARRAY = null;
        if (this.statementWrapper != null) {
            try {
                colAttributes = new ColumnsAttributes(this.statementWrapper, tktsColumns);
            }
            catch (SQLException se) {
                if (AbstractLogger.isTrace) {
                    logger.trace("setupColumns" + se);
                }
                LocalizedErrorHandler.handleExceptionsInFunction(thisClassName + "." + "setupColumns()", se, this.statementWrapper, logger);
            }
        }
        if ((allocateSize = jdbcColumns) < tktsColumns) {
            allocateSize = tktsColumns;
        }
        ParameterInfo[] columns = new ParameterInfo[allocateSize];
        int numberColumns = tktsColumns;
        int numberColAttributes = colAttributes.getNumberOfColumns();
        if (numberColumns > numberColAttributes) {
            numberColumns = numberColAttributes;
        }
        for (i = 0; i < numberColumns; ++i) {
            ParameterInfo ci;
            columns[i] = ci = new ParameterInfo();
            ci.setOrdinal(i + 1);
            ci.setBindDirection(13);
            int encoding = colAttributes.getEncoding(i);
            if (this.packType == 1) {
                encoding = 20;
            }
            long columnSizeChar = colAttributes.getLength(i);
            ci.setNativeEncoding(encoding);
            ci.resetDisplaySize();
            ci.setDisplaySize(columnSizeChar);
            ci.setDecimalDigits(colAttributes.getScale(i));
            ci.setName(colAttributes.getName(i));
            int inSqlType = colAttributes.getSQLType(i);
            switch (inSqlType) {
                case -10: {
                    inSqlType = -1;
                    break;
                }
                case -9: {
                    inSqlType = 12;
                    break;
                }
                case -8: {
                    inSqlType = 1;
                    break;
                }
            }
            ci.setSQLType(inSqlType);
            FSEnums.FsSqlTypes mySQLType = FSEnums.FsSqlTypes.getByValue(inSqlType);
            int cType = mySQLType == null ? 0 : mySQLType.getCType();
            ci.setCType(cType);
            cType = colAttributes.getNativeCType(i);
            ci.setNativeCType(cType);
        }
        this._COLUMN_INFO_ARRAY = columns;
        this.setBoundColumns(tktsColumns);
        if (AbstractLogger.isTrace) {
            for (i = 0; i < tktsColumns; ++i) {
                ParameterInfo pi = this._COLUMN_INFO_ARRAY[i];
                int sqlType = pi.getSQLType();
                int cType = pi.getCType();
                String name = pi.getName();
                logger.trace("COL[" + i + "] name[" + name + "] sqlType[" + CommonLogger.getSQLTypeString(sqlType) + "] cType[" + CommonLogger.getCTypeStringAndNumber(cType) + "] [" + CommonLogger.getCTypeStringAndNumber(cType) + "]");
            }
        }
        this.bindColumns();
    }

    protected void correctColumns(int tktsColumns, int jdbcColumns, int[] indexMap) throws SQLException {
        ParameterInfo[] tColumns = new ParameterInfo[jdbcColumns];
        ParameterInfo[] sColumns = this._COLUMN_INFO_ARRAY;
        for (int si = 0; si < tktsColumns; ++si) {
            int ti = indexMap[si];
            if (ti == -1) continue;
            ParameterInfo ci = sColumns[si];
            if (ci == null) {
                ci = new ParameterInfo();
            }
            tColumns[ti] = ci;
            ci.setOrdinal(ti + 1);
        }
        this._COLUMN_INFO_ARRAY = tColumns;
    }

    public void close() throws SQLException {
        String method = "close()";
        try {
            this._ROWS_DATA_CACHE.clear();
            if (this.statementWrapper != null) {
                this.statementWrapper.Close();
            }
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction(thisClassName + "." + "close()", exception, this.statementWrapper, logger);
        }
    }

    private void dummyUserDefinedType() throws SQLException {
        int encoding = this.getNativeEncoding();
        String[] NAMES = new String[]{TYPE_CAT, TYPE_SCHEM, TYPE_NAME, CLASS_NAME, DATA_TYPE, REMARKS, BASE_TYPE};
        int numberColumns = 7;
        ParameterInfo[] columns = new ParameterInfo[numberColumns];
        for (int i = 0; i < numberColumns; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setNativeEncoding(encoding);
            columns[i].setSQLType(12);
            columns[i].setNativeCType(12);
            columns[i].setDisplaySize(256L);
            columns[i].setName(NAMES[i]);
            columns[i].setOrdinal(i + 1);
        }
        columns[4].setSQLType(4);
        columns[4].setNativeCType(4);
        columns[4].resetDisplaySize();
        columns[4].setDisplaySize(11L);
        columns[6].setSQLType(5);
        columns[6].setNativeCType(5);
        columns[6].resetDisplaySize();
        columns[6].setDisplaySize(6L);
        this._COLUMN_INFO_ARRAY = columns;
    }

    private void dummySuperTables() throws SQLException {
        int encoding = this.getNativeEncoding();
        int numberColumns = 4;
        ParameterInfo[] columns = new ParameterInfo[numberColumns];
        String[] NAMES = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        for (int i = 0; i < numberColumns; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setNativeEncoding(encoding);
            columns[i].setSQLType(12);
            columns[i].setNativeCType(12);
            columns[i].resetDisplaySize();
            columns[i].setDisplaySize(256L);
            columns[i].setName(NAMES[i]);
            columns[i].setOrdinal(i + 1);
        }
        this._COLUMN_INFO_ARRAY = columns;
    }

    private void dummySuperTypes() throws SQLException {
        int encoding = this.getNativeEncoding();
        String[] NAMES = new String[]{TYPE_CAT, TYPE_SCHEM, TYPE_NAME, "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        int numberColumns = 6;
        ParameterInfo[] columns = new ParameterInfo[numberColumns];
        for (int i = 0; i < numberColumns; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setNativeEncoding(encoding);
            columns[i].setDisplaySize(256L);
            columns[i].setName(NAMES[i]);
            columns[i].setSQLType(12);
            columns[i].setNativeCType(12);
            columns[i].setOrdinal(i + 1);
        }
        this._COLUMN_INFO_ARRAY = columns;
    }

    private void dummyClientInfoProperties() throws SQLException {
        int encoding = this.getNativeEncoding();
        int numberColumns = 4;
        ParameterInfo[] columns = new ParameterInfo[numberColumns];
        String[] NAMES = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        this._COLUMN_INFO_ARRAY = columns;
        for (int i = 0; i < numberColumns; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setNativeEncoding(encoding);
            columns[i].setSQLType(12);
            columns[i].setNativeCType(12);
            columns[i].setDisplaySize(256L);
            columns[i].setName(NAMES[i]);
            columns[i].setOrdinal(i + 1);
            if (i != 1) continue;
            columns[1].setSQLType(4);
            columns[1].setNativeCType(4);
            columns[i].setDisplaySize(11L);
        }
        this._COLUMN_INFO_ARRAY = columns;
        DriverPropertyInfo[] DPI = UtilityFunctions.getDriverPropertyInfo();
        DriverPropertyInfo dpi = DPI[0];
        this._ROWS_DATA_CACHE = new ArrayList();
        Row newRow = new Row(23);
        StringColumn sc = new StringColumn(dpi.name);
        newRow.setColumnData(0, sc);
        NumberColumnInteger ic = new NumberColumnInteger(50);
        newRow.setColumnData(1, ic);
        sc = new StringColumn(dpi.value);
        newRow.setColumnData(2, sc);
        sc = new StringColumn(dpi.description);
        newRow.setColumnData(3, sc);
        this._ROWS_DATA_CACHE.add(newRow);
        this.rowCount = 1;
        this.afterLast = false;
    }

    private void dummyFunctionColumns() throws SQLException {
        int encoding = this.getNativeEncoding();
        int numberColumns = 17;
        ParameterInfo[] columns = new ParameterInfo[numberColumns];
        String[] NAMES = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", DATA_TYPE, TYPE_NAME, "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", REMARKS, "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", SPECIFIC_NAME};
        for (int i = 0; i < numberColumns; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setNativeEncoding(encoding);
            columns[i].setSQLType(12);
            columns[i].setNativeCType(12);
            columns[i].setDisplaySize(256L);
            columns[i].setName(NAMES[i]);
            columns[i].setOrdinal(i + 1);
        }
        columns[4].setSQLType(5);
        columns[4].setNativeCType(5);
        columns[4].resetDisplaySize();
        columns[4].setDisplaySize(6L);
        columns[5].setSQLType(4);
        columns[5].setNativeCType(4);
        columns[5].resetDisplaySize();
        columns[5].setDisplaySize(11L);
        columns[5].setOrdinal(6);
        columns[6].setSQLType(12);
        columns[6].setNativeCType(12);
        columns[6].setOrdinal(7);
        columns[7].setSQLType(4);
        columns[7].setNativeCType(4);
        columns[7].resetDisplaySize();
        columns[7].setDisplaySize(11L);
        columns[7].setOrdinal(8);
        columns[8].setSQLType(4);
        columns[8].setNativeCType(4);
        columns[8].resetDisplaySize();
        columns[8].setDisplaySize(11L);
        columns[8].setOrdinal(9);
        columns[9].setSQLType(5);
        columns[9].setNativeCType(5);
        columns[9].resetDisplaySize();
        columns[9].setDisplaySize(6L);
        columns[9].setOrdinal(10);
        columns[10].setSQLType(5);
        columns[10].setNativeCType(5);
        columns[10].resetDisplaySize();
        columns[10].setDisplaySize(6L);
        columns[10].setOrdinal(11);
        columns[11].setSQLType(5);
        columns[11].setNativeCType(5);
        columns[11].resetDisplaySize();
        columns[11].setDisplaySize(6L);
        columns[11].setOrdinal(12);
        columns[12].setSQLType(12);
        columns[12].setNativeCType(12);
        columns[12].setOrdinal(13);
        columns[13].setSQLType(4);
        columns[13].setNativeCType(4);
        columns[13].resetDisplaySize();
        columns[13].setDisplaySize(11L);
        columns[13].setOrdinal(14);
        columns[14].setSQLType(4);
        columns[14].setNativeCType(4);
        columns[14].resetDisplaySize();
        columns[14].setDisplaySize(11L);
        columns[14].setOrdinal(15);
        columns[15].setSQLType(12);
        columns[15].setNativeCType(12);
        columns[15].setOrdinal(16);
        columns[16].setSQLType(12);
        columns[16].setNativeCType(12);
        columns[16].setOrdinal(17);
        this._COLUMN_INFO_ARRAY = columns;
    }

    private void dummyFunctions() throws SQLException {
        int encoding = this.getNativeEncoding();
        int numberColumns = 6;
        ParameterInfo[] columns = new ParameterInfo[numberColumns];
        String[] NAMES = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", REMARKS, "FUNCTION_TYPE", SPECIFIC_NAME};
        this._COLUMN_INFO_ARRAY = columns;
        for (int i = 0; i < numberColumns; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setNativeEncoding(encoding);
            columns[i].setSQLType(12);
            columns[i].setNativeCType(12);
            columns[i].setDisplaySize(256L);
            columns[i].setName(NAMES[i]);
            columns[i].setOrdinal(i + 1);
            if (i != 4) continue;
            columns[4].setSQLType(5);
            columns[4].setNativeCType(5);
            columns[4].setDisplaySize(6L);
        }
        this._COLUMN_INFO_ARRAY = columns;
    }

    private void dummyUdtAttribute() {
        ParameterInfo[] columns = new ParameterInfo[21];
        for (int i = 0; i < 21; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setDisplaySize(256L);
        }
        columns[0].setName(TYPE_CAT);
        columns[0].setSQLType(12);
        columns[0].setNativeCType(12);
        columns[0].setOrdinal(1);
        columns[1].setName(TYPE_SCHEM);
        columns[1].setSQLType(12);
        columns[1].setNativeCType(12);
        columns[1].setOrdinal(2);
        columns[2].setName(TYPE_NAME);
        columns[2].setSQLType(12);
        columns[2].setNativeCType(12);
        columns[2].setOrdinal(3);
        columns[3].setName("ATTR_NAME");
        columns[3].setSQLType(12);
        columns[3].setNativeCType(12);
        columns[3].setOrdinal(4);
        columns[4].setName(DATA_TYPE);
        columns[4].setSQLType(4);
        columns[4].setNativeCType(4);
        columns[4].resetDisplaySize();
        columns[4].setDisplaySize(11L);
        columns[4].setOrdinal(5);
        columns[5].setName("ATTR_TYPE_NAME");
        columns[5].setSQLType(12);
        columns[5].setNativeCType(12);
        columns[5].setOrdinal(6);
        columns[6].setName("ATTR_SIZE");
        columns[6].setSQLType(4);
        columns[6].setNativeCType(4);
        columns[6].resetDisplaySize();
        columns[6].setDisplaySize(11L);
        columns[6].setOrdinal(7);
        columns[7].setName("DECIMAL_DIGITS");
        columns[7].setSQLType(4);
        columns[7].setNativeCType(4);
        columns[7].resetDisplaySize();
        columns[7].setDisplaySize(11L);
        columns[7].setOrdinal(8);
        columns[8].setName("NUM_PREC_RADIX");
        columns[8].setSQLType(4);
        columns[8].setNativeCType(4);
        columns[8].resetDisplaySize();
        columns[8].setDisplaySize(11L);
        columns[8].setOrdinal(9);
        columns[9].setName("NULLABLE");
        columns[9].setSQLType(4);
        columns[9].setNativeCType(4);
        columns[9].resetDisplaySize();
        columns[9].setDisplaySize(11L);
        columns[9].setOrdinal(10);
        columns[10].setName(REMARKS);
        columns[10].setSQLType(4);
        columns[10].setNativeCType(4);
        columns[10].resetDisplaySize();
        columns[10].setDisplaySize(11L);
        columns[10].setOrdinal(11);
        columns[11].setName("ATTR_DEF");
        columns[11].setSQLType(12);
        columns[11].setNativeCType(12);
        columns[11].setOrdinal(12);
        columns[12].setName(SQL_DATA_TYPE);
        columns[12].setSQLType(4);
        columns[12].setNativeCType(4);
        columns[12].resetDisplaySize();
        columns[12].setDisplaySize(11L);
        columns[12].setOrdinal(13);
        columns[13].setName(SQL_DATETIME_SUB);
        columns[13].setSQLType(4);
        columns[13].setNativeCType(4);
        columns[13].resetDisplaySize();
        columns[13].setDisplaySize(11L);
        columns[13].setOrdinal(14);
        columns[14].setName("CHAR_OCTET_LENGTH");
        columns[14].setSQLType(4);
        columns[14].setNativeCType(4);
        columns[14].resetDisplaySize();
        columns[14].setDisplaySize(11L);
        columns[14].setOrdinal(15);
        columns[15].setName("ORDINAL_POSITION");
        columns[15].setSQLType(4);
        columns[15].setNativeCType(4);
        columns[15].resetDisplaySize();
        columns[15].setDisplaySize(11L);
        columns[15].setOrdinal(16);
        columns[16].setName("IS_NULLABLE");
        columns[16].setSQLType(12);
        columns[16].setNativeCType(12);
        columns[16].setOrdinal(17);
        columns[17].setName("SCOPE_CATALOG");
        columns[17].setSQLType(12);
        columns[17].setNativeCType(12);
        columns[17].setOrdinal(18);
        columns[18].setName("SCOPE_SCHEMA");
        columns[18].setSQLType(12);
        columns[18].setNativeCType(12);
        columns[18].setOrdinal(19);
        columns[19].setName("SCOPE_TABLE");
        columns[19].setSQLType(12);
        columns[19].setNativeCType(12);
        columns[19].setOrdinal(20);
        columns[20].setName("SOURCE_DATA_TYPE");
        columns[20].setSQLType(5);
        columns[20].setNativeCType(5);
        columns[20].resetDisplaySize();
        columns[20].setDisplaySize(6L);
        columns[20].setOrdinal(21);
        this._COLUMN_INFO_ARRAY = columns;
    }

    private void nullifyCatalogName() throws IndexOutOfBoundsException, SQLException {
        String method = "nullifyCatalogName()";
        if (AbstractLogger.isTrace) {
            logger.entry("nullifyCatalogName()", "Nullify catalog name.");
        }
        int numberOfFetches = 0;
        int numberOfRows = 0;
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            ++numberOfFetches;
            Iterator it = this._ROWS_DATA_CACHE.iterator();
            while (it.hasNext()) {
                ++numberOfRows;
                Row oneRow = (Row)it.next();
                AbstractColumn catalogColumn = oneRow.getColumnData(1);
                catalogColumn.setString(null);
                _TEMP_ROWS_DATA_CACHE.add(oneRow);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("nullifyCatalogName()", MetaDataRowCache.debugFetchsRows(numberOfFetches, numberOfRows));
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
    }

    @Override
    protected boolean fetch(int fetchOffset, String[] bookmarks, int fetchOrientation) throws SQLException {
        String method = "fetch(fetchOffset,bookmarks,fetchOrientation)";
        if (AbstractLogger.isTrace) {
            logger.entry("fetch(fetchOffset,bookmarks,fetchOrientation)", "Calling fetch.");
        }
        if (this.isAllSchemaRowsFetched || this.statementWrapper == null) {
            this.afterLast = true;
            return false;
        }
        boolean isDataLoaded = false;
        isDataLoaded = this.prefetch ? this.commonPrefetch(fetchOffset, bookmarks, fetchOrientation, false) : this.commonFetch(fetchOffset, bookmarks, fetchOrientation, false);
        return isDataLoaded;
    }

    private void rsBestRowIdentifier() throws SQLException {
        this.setupColumns(8, 8);
    }

    private void rsCatalog() throws IndexOutOfBoundsException, SQLException {
        String method = "rsCatalog";
        this.setupColumns(8, 2);
        int numberOfFetches = 0;
        int numberOfRows = 0;
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            ++numberOfFetches;
            Iterator it = this._ROWS_DATA_CACHE.iterator();
            while (it.hasNext()) {
                ++numberOfRows;
                Row oldRow = (Row)it.next();
                Row newRow = new Row(2);
                oldRow.copyData(newRow, 0, 0, 1);
                oldRow.copyData(newRow, 5, 1, 1);
                _TEMP_ROWS_DATA_CACHE.add(newRow);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("rsCatalog", MetaDataRowCache.debugFetchsRows(numberOfFetches, numberOfRows));
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
        this.correctColumns(8, 2, CATALOG_INDEX_MAP);
        if (AbstractLogger.isTrace) {
            logger.exit("rsCatalog");
        }
    }

    private void rsColumnPrivileges() throws SQLException {
        this.setupColumns(8, 8);
    }

    private void rsColumns() throws IndexOutOfBoundsException, SQLException {
        String method = "rsColumns";
        if (AbstractLogger.isTrace) {
            logger.entry("rsColumns");
        }
        this.setupColumns(18, 23);
        int numberOfFetches = 0;
        int numberOfRows = 0;
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            ++numberOfFetches;
            Iterator it = this._ROWS_DATA_CACHE.iterator();
            while (it.hasNext()) {
                ++numberOfRows;
                Row oldRow = (Row)it.next();
                Row newRow = new Row(23);
                oldRow.copyData(newRow, 18);
                String nullString = null;
                StringColumn sc = new StringColumn(nullString);
                newRow.setColumnData(18, sc);
                sc = new StringColumn(nullString);
                newRow.setColumnData(19, sc);
                sc = new StringColumn(nullString);
                newRow.setColumnData(20, sc);
                sc = new StringColumn(nullString);
                newRow.setColumnData(21, sc);
                sc = new StringColumn("");
                newRow.setColumnData(22, sc);
                _TEMP_ROWS_DATA_CACHE.add(newRow);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("rsColumns", MetaDataRowCache.debugFetchsRows(numberOfFetches, numberOfRows));
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
        this._COLUMN_INFO_ARRAY[13].setName(SQL_DATA_TYPE);
        this._COLUMN_INFO_ARRAY[14].setName(SQL_DATETIME_SUB);
        for (int x = 18; x < 23; ++x) {
            ParameterInfo pi;
            this._COLUMN_INFO_ARRAY[x] = pi = this._COLUMN_INFO_ARRAY[0].cloneMetaData();
        }
        this._COLUMN_INFO_ARRAY[18].setName("SCOPE_CATLOG");
        this._COLUMN_INFO_ARRAY[19].setName("SCOPE_SCHEMA");
        this._COLUMN_INFO_ARRAY[20].setName("SCOPE_TABLE");
        this._COLUMN_INFO_ARRAY[21].setName("SOURCE_DATA_TYPE");
        this._COLUMN_INFO_ARRAY[21].setSQLType(5);
        this._COLUMN_INFO_ARRAY[21].setNativeCType(5);
        this._COLUMN_INFO_ARRAY[21].resetDisplaySize();
        this._COLUMN_INFO_ARRAY[21].setDisplaySize(6L);
        this._COLUMN_INFO_ARRAY[22].setName("IS_AUTOINCREMENT");
        this._COLUMN_INFO_ARRAY[22].setConvEmpty(true);
        if (AbstractLogger.isTrace) {
            logger.exit("rsColumns");
        }
    }

    private void rsCrossReference() throws SQLException {
        this.setupColumns(14, 14);
    }

    private void rsExportedKeys() throws SQLException {
        this.setupColumns(14, 14);
    }

    private void rsImportedKeys() throws SQLException {
        this.setupColumns(14, 14);
    }

    private void rsIndexInfo() throws SQLException {
        this.setupColumns(31, 31);
    }

    private void rsPrimaryKeys() throws SQLException {
        this.setupColumns(6, 6);
    }

    public Constants.mdTypes getMetaDataType() {
        return this.metaDataType;
    }

    private void createSchemas() throws SQLException {
        int encoding = this.getNativeEncoding();
        int numberColumns = 2;
        ParameterInfo[] columns = new ParameterInfo[numberColumns];
        String[] NAMES = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
        this._COLUMN_INFO_ARRAY = columns;
        for (int i = 0; i < numberColumns; ++i) {
            columns[i] = new ParameterInfo();
            columns[i].setNativeEncoding(encoding);
            columns[i].setSQLType(12);
            columns[i].setNativeCType(12);
            columns[i].setDisplaySize(256L);
            columns[i].setName(NAMES[i]);
            columns[i].setOrdinal(i + 1);
        }
        this._COLUMN_INFO_ARRAY = columns;
    }

    private void rsProcedures() throws IndexOutOfBoundsException, SQLException {
        String method = "rsProcedures()";
        if (AbstractLogger.isTrace) {
            logger.entry("rsProcedures()", "Correct Procedures output columns.");
        }
        int inTktsCols = 11;
        this.setupColumns(inTktsCols, 12);
        int numberColumns = this.getColumnCount();
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            for (Row oldRow : this._ROWS_DATA_CACHE) {
                AbstractColumn tColumn;
                int ti;
                int si;
                int cc;
                Row newRow = new Row(numberColumns);
                oldRow.copyData(newRow, 8);
                if (numberColumns == 12) {
                    cc = 3;
                    si = 8;
                    ti = 9;
                } else {
                    cc = 0;
                    ti = 0;
                    si = 0;
                }
                while (cc > 0) {
                    tColumn = oldRow.getColumnData(si);
                    if (tColumn == null) {
                        tColumn = new StringColumn(null);
                    }
                    newRow.setColumnData(ti, tColumn);
                    --cc;
                    ++si;
                    ++ti;
                }
                tColumn = new StringColumn(null);
                newRow.setColumnData(8, tColumn);
                _TEMP_ROWS_DATA_CACHE.add(newRow);
            }
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
        this.correctColumns(11, 12, PROCEDURES_INDEX_MAP);
        ParameterInfo pi = this._COLUMN_INFO_ARRAY[9];
        if (pi.getName() == null || pi.getName().length() == 0) {
            numberColumns = 9;
            this.setBoundColumns(8);
        } else {
            numberColumns = 12;
            this.setBoundColumns(12);
        }
        this._COLUMN_INFO_ARRAY[3].setName("");
        this._COLUMN_INFO_ARRAY[4].setName("");
        this._COLUMN_INFO_ARRAY[5].setName("");
        this._COLUMN_INFO_ARRAY[8] = pi = this._COLUMN_INFO_ARRAY[0].cloneMetaData();
        pi.setOrdinal(9);
        pi.setBindRequired(false);
        pi.setName(SPECIFIC_NAME);
        this._COLUMN_INFO_ARRAY[8] = pi = this._COLUMN_INFO_ARRAY[0].cloneMetaData();
        pi.setOrdinal(9);
        pi.setBindRequired(false);
        pi.setName(SPECIFIC_NAME);
        this._COLUMN_INFO_ARRAY[9] = pi = this._COLUMN_INFO_ARRAY[0].cloneMetaData();
        pi.setOrdinal(10);
        pi.setBindRequired(false);
        pi.setName("NATIVE_CAT");
        this._COLUMN_INFO_ARRAY[10] = pi = this._COLUMN_INFO_ARRAY[0].cloneMetaData();
        pi.setOrdinal(11);
        pi.setBindRequired(false);
        pi.setName("SECURITY");
        this._COLUMN_INFO_ARRAY[11] = pi = this._COLUMN_INFO_ARRAY[0].cloneMetaData();
        pi.setOrdinal(12);
        pi.setBindRequired(false);
        pi.setName("SERVICE");
    }

    private void rsProcedureColumns() throws IndexOutOfBoundsException, SQLException {
        String method = "rsProcedureColumns()";
        if (AbstractLogger.isTrace) {
            logger.entry("rsProcedureColumns()", "Correct Procedures output columns.");
        }
        this.setupColumns(19, 20);
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            for (Row oldRow : this._ROWS_DATA_CACHE) {
                Row newRow = new Row(20);
                oldRow.copyData(newRow, 19);
                newRow.setColumnData(19, null);
                _TEMP_ROWS_DATA_CACHE.add(newRow);
            }
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
        this._COLUMN_INFO_ARRAY[7].setName("PRECISION");
        this._COLUMN_INFO_ARRAY[8].setName("LENGTH");
        this._COLUMN_INFO_ARRAY[9].setName("SCALE");
        this._COLUMN_INFO_ARRAY[10].setName("RADIX");
        this._COLUMN_INFO_ARRAY[14].setName(SQL_DATA_TYPE);
        this._COLUMN_INFO_ARRAY[15].setName(SQL_DATETIME_SUB);
        ParameterInfo pi = this._COLUMN_INFO_ARRAY[7].cloneMetaData();
        pi.setName(SPECIFIC_NAME);
        pi.setOrdinal(20);
        this._COLUMN_INFO_ARRAY[19] = pi;
    }

    private void rsSchemas() throws IndexOutOfBoundsException, SQLException {
        String method = "rsSchemas";
        if (AbstractLogger.isTrace) {
            logger.entry("rsSchemas");
        }
        this.setupColumns(8, 2);
        int numberOfFetches = 0;
        int numberOfRows = 0;
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            ++numberOfFetches;
            Iterator it = this._ROWS_DATA_CACHE.iterator();
            while (it.hasNext()) {
                ++numberOfRows;
                Row oldRow = (Row)it.next();
                Row newRow = new Row(2);
                oldRow.copyData(newRow, 0, 1, 1);
                oldRow.copyData(newRow, 1, 0, 1);
                _TEMP_ROWS_DATA_CACHE.add(newRow);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("rsSchemas", MetaDataRowCache.debugFetchsRows(numberOfFetches, numberOfRows));
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        this.correctColumns(8, 8, SCHEMA_INDEX_MAP);
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
        if (AbstractLogger.isTrace) {
            logger.exit("rsSchemas");
        }
    }

    private void rsTables() throws IndexOutOfBoundsException, SQLException {
        ParameterInfo pi;
        String method = "rsTables()";
        if (AbstractLogger.isTrace) {
            logger.entry("rsTables()", "Correct table columns.");
        }
        this.setupColumns(8, 13);
        int numberOfFetches = 0;
        int numberOfRows = 0;
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            ++numberOfFetches;
            Iterator it = this._ROWS_DATA_CACHE.iterator();
            while (it.hasNext()) {
                ++numberOfRows;
                Row oldRow = (Row)it.next();
                Row newRow = new Row(13);
                oldRow.copyData(newRow, 5);
                oldRow.copyData(newRow, 5, 10, 1);
                newRow.setColumnData(5, null);
                oldRow.copyData(newRow, 6, 11, 1);
                newRow.setColumnData(6, null);
                oldRow.copyData(newRow, 7, 12, 1);
                newRow.setColumnData(7, null);
                _TEMP_ROWS_DATA_CACHE.add(newRow);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("rsTables()", MetaDataRowCache.debugFetchsRows(numberOfFetches, numberOfRows));
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
        this.correctColumns(8, 13, DEFAULT_INDEX_MAP);
        if (this._COLUMN_INFO_ARRAY[5].getCType() != 0) {
            pi = this._COLUMN_INFO_ARRAY[5];
            pi.setOrdinal(11);
            pi.setName("NATIVE_CAT");
            this._COLUMN_INFO_ARRAY[10] = pi;
        }
        if (this._COLUMN_INFO_ARRAY[6].getCType() != 0) {
            pi = this._COLUMN_INFO_ARRAY[6];
            pi.setOrdinal(12);
            pi.setName("SECURITY");
            this._COLUMN_INFO_ARRAY[11] = pi;
        }
        if (this._COLUMN_INFO_ARRAY[7].getCType() != 0) {
            pi = this._COLUMN_INFO_ARRAY[7];
            pi.setOrdinal(13);
            pi.setName("SERVICE");
            this._COLUMN_INFO_ARRAY[12] = pi;
        }
        pi = this._COLUMN_INFO_ARRAY[1].cloneMetaData();
        pi.setOrdinal(6);
        pi.setName(TYPE_CAT);
        this._COLUMN_INFO_ARRAY[5] = pi;
        pi = this._COLUMN_INFO_ARRAY[1].cloneMetaData();
        pi.setOrdinal(7);
        pi.setName(TYPE_SCHEM);
        this._COLUMN_INFO_ARRAY[6] = pi;
        pi = this._COLUMN_INFO_ARRAY[1].cloneMetaData();
        pi.setOrdinal(8);
        pi.setName(TYPE_NAME);
        this._COLUMN_INFO_ARRAY[7] = pi;
        pi = this._COLUMN_INFO_ARRAY[1].cloneMetaData();
        pi.setOrdinal(9);
        pi.setName("SELF_REFERENCING_COL_NAME");
        this._COLUMN_INFO_ARRAY[8] = pi;
        pi = this._COLUMN_INFO_ARRAY[1].cloneMetaData();
        pi.setOrdinal(10);
        pi.setName("REF_GENERATION");
        this._COLUMN_INFO_ARRAY[9] = pi;
    }

    private void rsTablesPrivileges() throws SQLException {
        this.setupColumns(7, 7);
    }

    private void rsTableTypes() throws IndexOutOfBoundsException, SQLException {
        String method = "rsTableTypes()";
        if (AbstractLogger.isTrace) {
            logger.entry("rsTableTypes()", "Correct getTableTypes columns.");
        }
        this.setupColumns(8, 1);
        int numberOfFetches = 0;
        int numberOfRows = 0;
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        while (this.fetch(0, null, 1)) {
            ++numberOfFetches;
            Iterator it = this._ROWS_DATA_CACHE.iterator();
            while (it.hasNext()) {
                ++numberOfRows;
                Row oldRow = (Row)it.next();
                Row newRow = new Row(1);
                oldRow.copyData(newRow, 3, 0, 1);
                _TEMP_ROWS_DATA_CACHE.add(newRow);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("rsTableTypes()", MetaDataRowCache.debugFetchsRows(numberOfFetches, numberOfRows));
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (this.rowCount > 0) {
            this.afterLast = false;
        }
        this.correctColumns(8, 1, TABLETYPES_INDEX_MAP);
    }

    private void rsTypeInfo() throws SQLException {
        this.setupColumns(19, 19);
        this._COLUMN_INFO_ARRAY[2].setName("PRECISION");
        this._COLUMN_INFO_ARRAY[11].setName("AUTO_INCREMENT");
        this._COLUMN_INFO_ARRAY[15].setName(SQL_DATA_TYPE);
        this._COLUMN_INFO_ARRAY[16].setName(SQL_DATETIME_SUB);
    }

    private void rsVersionColumns() throws SQLException {
        this.setupColumns(8, 8);
    }

    static {
        for (int i = 0; i < 30; ++i) {
            MetaDataRowCache.DEFAULT_INDEX_MAP[i] = i;
        }
    }
}

