/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts;

import com.sas.net.crypto.SealedString;
import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.ResourceUsage;
import com.sas.tkts.SystemPropertiesInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.ConcreteLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSDatabaseMetaData;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.sql.StatementPoolManager;
import com.sas.tkts.stats.StatisticsBoard;
import com.sas.tkts.util.SafeStore;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class TKTSDriver
extends FedSrvJDBC
implements Driver {
    private static String thisClassName;
    private static AbstractLogger logger;
    private static AbstractLogger initLogger;
    private static ResourceBundle resourceBundle;
    private static boolean PRELOAD_CLASSES;
    private static SafeStore safeSetup;
    public static String DRIVER_NAME;
    private transient Properties _DRIVER_PROPERTIES;
    private transient DriverPropertyInfo[] _DRIVER_PROPERTY_INFO;
    private transient int C_INDEX;
    private transient int P_INDEX;
    private transient int U_INDEX;
    private static transient Hashtable<String, Driver> wrapperDrivers;
    public static transient boolean classesLoaded;
    public static transient SystemPropertiesInfo systemPropertyDebugInit;
    public static transient SystemPropertiesInfo systemPropertyLoggingLevel;
    public static transient SystemPropertiesInfo systemPropertyLoggingFlush;
    public static transient SystemPropertiesInfo systemPropertyMeasurementsLevel;
    public static transient SystemPropertiesInfo systemPropertyMeasurementsUnits;
    public static transient SystemPropertiesInfo systemPropertyMeasurementsThreshold;
    public static transient SystemPropertiesInfo systemPropertyMeasurementsAppend;
    public static transient SystemPropertiesInfo systemPropertyPrefetchSummary;
    public static transient SystemPropertiesInfo systemPropertyPrefetchDebug;
    public static transient SystemPropertiesInfo systemPropertyPrefetchTrace;
    private static transient Hashtable<Long, FSConnection> openConnections;
    private static transient Lock openConnlock;

    public static boolean prefetchSummaryEnabled() {
        return TKTSDriver.systemPropertyPrefetchSummary.boolValue;
    }

    public static boolean prefetchDebugEnabled() {
        return TKTSDriver.systemPropertyPrefetchDebug.boolValue;
    }

    public static boolean prefetchTraceEnabled() {
        return TKTSDriver.systemPropertyPrefetchTrace.boolValue;
    }

    private static String getSystemProperty(String key) {
        String out;
        try {
            out = System.getProperty(key);
        }
        catch (Exception ex) {
            System.err.println("System.getProperty(" + key + ")");
            System.err.println(ex);
            out = null;
        }
        return out;
    }

    protected static synchronized void loadAllClasses() {
        if (classesLoaded) {
            return;
        }
        try {
            Class.forName("com.sas.tkts.sql.LocalizedErrorHandler");
            Class.forName("com.sas.tkts.sql.LocalizedMessageHandler");
            Class.forName("com.sas.tkts.FedSrvJDBC");
            Class.forName("com.sas.tkts.FSEnums");
            Class.forName("com.sas.tkts.ResourceUsage");
            Class.forName("com.sas.tkts.TrackResource");
            Class.forName("com.sas.tkts.caching.AbstractRowCache");
            Class.forName("com.sas.tkts.caching.MetaDataRowCache");
            Class.forName("com.sas.tkts.caching.PrefetchControl");
            Class.forName("com.sas.tkts.caching.PrefetchData");
            Class.forName("com.sas.tkts.caching.Row");
            Class.forName("com.sas.tkts.caching.RowCache");
            Class.forName("com.sas.tkts.caching.RowSetCache");
            Class.forName("com.sas.tkts.caching.UnpackInfo");
            Class.forName("com.sas.tkts.info.ColumnsAttributes");
            Class.forName("com.sas.tkts.info.PackedParameterSetBuffer");
            Class.forName("com.sas.tkts.info.PackedParameterSetBufferPT0");
            Class.forName("com.sas.tkts.info.PackedParameterSetBufferPT1");
            Class.forName("com.sas.tkts.info.ParameterInfo");
            Class.forName("com.sas.tkts.info.ServerDataTypeInfo");
            Class.forName("com.sas.tkts.iom.AbstractIOMWrapper");
            Class.forName("com.sas.tkts.iom.ConnectionWrapper");
            Class.forName("com.sas.tkts.iom.ServerInformation");
            Class.forName("com.sas.tkts.iom.StatementWrapper");
            Class.forName("com.sas.tkts.logging.AbstractLogger");
            Class.forName("com.sas.tkts.logging.CommonLogger");
            Class.forName("com.sas.tkts.logging.ConcreteLogger");
            Class.forName("com.sas.tkts.logging.ExceptionsLogger");
            Class.forName("com.sas.tkts.logging.LoggerFactory");
            Class.forName("com.sas.tkts.sql.BaseDataSource");
            Class.forName("com.sas.tkts.sql.ConnectionPoolManager");
            Class.forName("com.sas.tkts.sql.Constants");
            Class.forName("com.sas.tkts.sql.FSCallableStatement");
            Class.forName("com.sas.tkts.sql.FSConnection");
            Class.forName("com.sas.tkts.sql.FSConnectionPoolDataSource");
            Class.forName("com.sas.tkts.sql.FSDatabaseMetaData");
            Class.forName("com.sas.tkts.sql.FSException");
            Class.forName("com.sas.tkts.sql.FSParameterMetaData");
            Class.forName("com.sas.tkts.sql.FSPooledConnection");
            Class.forName("com.sas.tkts.sql.FSPreparedStatement");
            Class.forName("com.sas.tkts.sql.FSResultSet");
            Class.forName("com.sas.tkts.sql.FSResultSetMetaData");
            Class.forName("com.sas.tkts.sql.FSRowSet");
            Class.forName("com.sas.tkts.sql.FSRowSetMetaData");
            Class.forName("com.sas.tkts.sql.FSStatement");
            Class.forName("com.sas.tkts.sql.StatementPoolFullException");
            Class.forName("com.sas.tkts.sql.StatementPoolManager");
            Class.forName("com.sas.tkts.sql.StatementPoolManagerFactory");
            Class.forName("com.sas.tkts.sql.StatementPoolMonitorTask");
            Class.forName("com.sas.tkts.types.AbstractColumn");
            Class.forName("com.sas.tkts.types.BlobFedSrv");
            Class.forName("com.sas.tkts.types.BlobImpl");
            Class.forName("com.sas.tkts.types.BlobOutputStream");
            Class.forName("com.sas.tkts.types.ByteArrayColumn");
            Class.forName("com.sas.tkts.types.ColumnFactory");
            Class.forName("com.sas.tkts.types.DateColumn");
            Class.forName("com.sas.tkts.types.InputStreamExt");
            Class.forName("com.sas.tkts.types.LobColumn");
            Class.forName("com.sas.tkts.types.NumberColumn");
            Class.forName("com.sas.tkts.types.NumberColumnBigDecimal");
            Class.forName("com.sas.tkts.types.NumberColumnByte");
            Class.forName("com.sas.tkts.types.NumberColumnDouble");
            Class.forName("com.sas.tkts.types.NumberColumnFloat");
            Class.forName("com.sas.tkts.types.NumberColumnInteger");
            Class.forName("com.sas.tkts.types.NumberColumnLong");
            Class.forName("com.sas.tkts.types.NumberColumnShort");
            Class.forName("com.sas.tkts.types.StreamColumn");
            Class.forName("com.sas.tkts.types.StringColumn");
            Class.forName("com.sas.tkts.types.TimeColumn");
            Class.forName("com.sas.tkts.types.TimestampColumn");
            Class.forName("com.sas.tkts.util.ByteArrayConverter");
            Class.forName("com.sas.tkts.util.ByteExtractor");
            Class.forName("com.sas.tkts.util.CharSetUtil");
            Class.forName("com.sas.tkts.util.Counts");
            Class.forName("com.sas.tkts.util.DataTypeConversions");
            Class.forName("com.sas.tkts.util.Hits");
            Class.forName("com.sas.tkts.util.ParameterInfoHelper");
            Class.forName("com.sas.tkts.util.Reuse");
            Class.forName("com.sas.tkts.util.SafeStore");
            Class.forName("com.sas.tkts.util.TimeRepresentation");
            Class.forName("com.sas.tkts.util.Timings");
            Class.forName("com.sas.tkts.util.TypesHelper");
            Class.forName("com.sas.tkts.util.UtilityFunctions");
            Class.forName("com.sas.tkts.util.VendorSpecificErrorCode");
            safeSetup = new SafeStore(DRIVER_NAME);
        }
        catch (ClassNotFoundException cex) {
            System.err.println(cex);
            logger.error(cex);
        }
        classesLoaded = true;
    }

    private void sanityProperties(Properties inP) throws SQLException {
        if (inP == null) {
            return;
        }
        if (inP.size() > 3 * this._DRIVER_PROPERTY_INFO.length) {
            String cwe = "TKTSDriver.excessiveProperties.error.msg";
            String[] args = new String[]{};
            this.throwException("TKTSDriver.excessiveProperties.error.msg", args, logger);
        }
    }

    public TKTSDriver() throws SQLException {
        this.createDriverProperties();
    }

    @Override
    public Connection connect(String userURL, Properties inProperties) throws SQLException {
        String value;
        String method = "connect(userURL,inProperties)";
        FSConnection conn = null;
        Properties userProperties = null;
        Properties urlProperties = null;
        if (!this.acceptsURL(userURL)) {
            if (AbstractLogger.isTrace) {
                logger.trace("connect(userURL,inProperties)", "Exit no match");
            }
            return conn;
        }
        int minLen = "jdbc:sastkts://".length() + 3;
        if (userURL == null || userURL.length() < minLen) {
            String ei = "TKTSConnection.urlError.txt";
            LocalizedErrorHandler.throwLocalizedException("TKTSConnection.urlError.txt", logger);
        }
        if (AbstractLogger.isInfo) {
            value = UtilityFunctions.safeToLog(userURL, "URL:");
            logger.info("connect(userURL,inProperties)", value);
            value = UtilityFunctions.logProperties(inProperties);
            logger.info("connect(userURL,inProperties)", value);
        }
        if (inProperties == null) {
            userProperties = new Properties();
        } else {
            this.sanityProperties(inProperties);
            userProperties = (Properties)inProperties.clone();
        }
        value = userProperties.getProperty("user");
        if (value != null) {
            userProperties.remove("user");
            userProperties.put("userName", value);
        }
        urlProperties = UtilityFunctions.urlToProperties(userURL);
        value = UtilityFunctions.getHostName(userURL);
        if (value != null) {
            urlProperties.put("server", value);
        }
        if ((value = UtilityFunctions.getPortNumber(userURL)) != null) {
            urlProperties.put("port", value);
        }
        LinkedList<SQLWarning> propWarnings = new LinkedList<SQLWarning>();
        Properties conProps = this.updateDriverProperties(userProperties, urlProperties, propWarnings);
        conn = new FSConnection(userURL, conProps);
        while (!propWarnings.isEmpty()) {
            SQLWarning sqlWarning = (SQLWarning)propWarnings.remove(0);
            conn.addWarning(sqlWarning);
        }
        openConnlock.lock();
        openConnections.put(conn.getMyID(), conn);
        openConnlock.unlock();
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        boolean isAccepted = false;
        if (url.startsWith("jdbc:sastkts://")) {
            isAccepted = url.regionMatches(0, "jdbc:sastkts://", 0, "jdbc:sastkts://".length());
        }
        return isAccepted;
    }

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        String method = "getPropertyInfo";
        String ei = "TKTSDriver.getPropertyInfo.fmt";
        DriverPropertyInfo[] driverPropInfo = new DriverPropertyInfo[this._DRIVER_PROPERTY_INFO.length];
        if (AbstractLogger.isInfo) {
            String[] args = new String[]{url, String.valueOf(info)};
            LocalizedMessageHandler.logInfoMessage("getPropertyInfo", "TKTSDriver.getPropertyInfo.fmt", args, logger);
        }
        this.sanityProperties(info);
        for (int i = 0; i < driverPropInfo.length; ++i) {
            driverPropInfo[i] = new DriverPropertyInfo(this._DRIVER_PROPERTY_INFO[i].name, this._DRIVER_PROPERTY_INFO[i].value);
            driverPropInfo[i].choices = this._DRIVER_PROPERTY_INFO[i].choices;
            driverPropInfo[i].description = this._DRIVER_PROPERTY_INFO[i].description;
            driverPropInfo[i].required = this._DRIVER_PROPERTY_INFO[i].required;
        }
        if (info == null) {
            return driverPropInfo;
        }
        Enumeration<Object> e = info.keys();
        block1: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)info.get(key);
            for (int i = 0; i < driverPropInfo.length; ++i) {
                if (driverPropInfo[i].name.compareToIgnoreCase(key) != 0) continue;
                driverPropInfo[i].value = value;
                continue block1;
            }
        }
        return driverPropInfo;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private void createDriverProperties() {
        String defaultApplName = String.format("FEDSRV_JDBC_V%sR%s", 4, 4);
        int pn = 0;
        String defaultValue = null;
        this._DRIVER_PROPERTY_INFO = new DriverPropertyInfo[28];
        pn = 0;
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("APPLICATION_NAME", defaultApplName);
        String ei = "TKTSDriver.applicationname.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("compress", "none");
        ei = "TKTSDriver.compress.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[3];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "best";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "fast";
        this._DRIVER_PROPERTY_INFO[pn].choices[2] = "none";
        this.C_INDEX = ++pn;
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("constring", "");
        ei = "TKTSDriver.constring.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[3];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "TKTS_CUR_USE_TKTS";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "TKTS_CUR_USE_DRIVER";
        this._DRIVER_PROPERTY_INFO[pn].choices[2] = "TKTS_CUR_USE_IF_NEEDED";
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("cursorType", "TKTS_CUR_USE_DRIVER");
        ei = "TKTSDriver.cursorType.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[3];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "TKTS_CUR_USE_TKTS";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "TKTS_CUR_USE_DRIVER";
        this._DRIVER_PROPERTY_INFO[pn].choices[2] = "TKTS_CUR_USE_IF_NEEDED";
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("debugAll", "YES");
        ei = "TKTS.driverPropertyInfo.PROP_IS_DEBUG_ALL.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "YES";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "NO";
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("debugUnit", "s");
        ei = "TKTS.driverPropertyInfo.PROP_UNIT.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[4];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "ms";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "min";
        this._DRIVER_PROPERTY_INFO[pn].choices[2] = "ns";
        this._DRIVER_PROPERTY_INFO[pn].choices[3] = "s";
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("defaultFetchSize", String.valueOf(100));
        ei = "TKTSDriver.defaultFetchSize.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("flush", "YES");
        ei = "TKTS.driverPropertyInfo.PROP_FLUSH.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "YES";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "NO";
        ++pn;
        defaultValue = TKTSDriver.getSystemProperty("IDLE_TIMEOUT");
        if (defaultValue == null || defaultValue.compareToIgnoreCase("") == 0) {
            defaultValue = String.valueOf(120);
        }
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("IDLE_TIMEOUT", defaultValue);
        ei = "TKTS.driverPropertyInfo.PROP_IDLE_TIMEOUT.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        ++pn;
        defaultValue = TKTSDriver.getSystemProperty("IS_ALLOCATE_OVER_THE_LIMIT");
        if (defaultValue == null || defaultValue.compareToIgnoreCase("") == 0) {
            defaultValue = String.valueOf(true);
        }
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("IS_ALLOCATE_OVER_THE_LIMIT", defaultValue);
        ei = "TKTS.driverPropertyInfo.PROP_IS_ALLOCATE_OVER_THE_LIMIT.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        ++pn;
        defaultValue = TKTSDriver.getSystemProperty("IS_POOLED_STATEMENT_ENABLED");
        if (defaultValue == null || defaultValue.compareToIgnoreCase("") == 0) {
            defaultValue = String.valueOf(false);
        }
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("IS_POOLED_STATEMENT_ENABLED", defaultValue);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "false";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "true";
        ei = "TKTS.driverPropertyInfo.PROP_IS_POOLED_STATEMENT_ENABLED.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        ++pn;
        defaultValue = TKTSDriver.getSystemProperty("IS_RECORD_STATISTICS");
        if (defaultValue == null || defaultValue.compareToIgnoreCase("") == 0) {
            defaultValue = String.valueOf(false);
        }
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("IS_RECORD_STATISTICS", defaultValue);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "false";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "true";
        ei = "TKTS.driverPropertyInfo.PROP_IS_DISPLAY_STATISTICS.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("logLevel", "OFF");
        ei = "TKTS.driverPropertyInfo.PROP_CONN_LOGGING.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[8];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "ALL";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "DEBUG";
        this._DRIVER_PROPERTY_INFO[pn].choices[2] = "ERROR";
        this._DRIVER_PROPERTY_INFO[pn].choices[3] = "FATAL";
        this._DRIVER_PROPERTY_INFO[pn].choices[4] = "INFO";
        this._DRIVER_PROPERTY_INFO[pn].choices[5] = "OFF";
        this._DRIVER_PROPERTY_INFO[pn].choices[6] = "TRACE";
        this._DRIVER_PROPERTY_INFO[pn].choices[7] = "WARN";
        ++pn;
        defaultValue = TKTSDriver.getSystemProperty("MAX_STATEMENT_POOL_SIZE");
        if (defaultValue == null || defaultValue.compareToIgnoreCase("") == 0) {
            defaultValue = String.valueOf(100);
        }
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("MAX_STATEMENT_POOL_SIZE", defaultValue);
        ei = "TKTS.driverPropertyInfo.PROP_MAX_STATEMENT_POOL_SIZE.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("NULL_BEHAVIOR", "default");
        ei = "TKTS.driverPropertyInfo.PROP_NULL_BEHAVIOR.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[3];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "ansi";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "missing";
        this._DRIVER_PROPERTY_INFO[pn].choices[2] = "default";
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("pack", "0");
        ei = "TKTSDriver.pack.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "0";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "1";
        this.P_INDEX = ++pn;
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("password", "");
        ei = "TKTSDriver.password.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        ++pn;
        defaultValue = TKTSDriver.getSystemProperty("POOL_MAINTENANCE_INTERVAL");
        if (defaultValue == null || defaultValue.compareToIgnoreCase("") == 0) {
            defaultValue = String.valueOf(2);
        }
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("POOL_MAINTENANCE_INTERVAL", defaultValue);
        ei = "TKTS.driverPropertyInfo.PROP_POOL_MAINTENANCE_INTERVAL.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("port", "");
        ei = "TKTSDriver.port.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("prefetch", "on");
        ei = "TKTS.driverPropertyInfo.PROP_PREFETCH.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "on";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "off";
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("proxylist", "");
        ei = "TKTS.driverPropertyInfo.PROP_PROXYLIST.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("SCHEMA_SCOPE", "all");
        ei = "TKTS.driverPropertyInfo.PROP_SCHEMA_SCOPE.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "all";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "default";
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("secpackagelist", "");
        ei = "TKTS.driverPropertyInfo.PROP_SECPACKAGELIST.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("server", "");
        ei = "TKTSDriver.server.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("sspi", "");
        ei = "TKTS.driverPropertyInfo.PROP_SSPI.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[pn].choices = new String[2];
        this._DRIVER_PROPERTY_INFO[pn].choices[0] = "on";
        this._DRIVER_PROPERTY_INFO[pn].choices[1] = "off";
        ++pn;
        defaultValue = TKTSDriver.getSystemProperty("STATISTICS_OUTPUT_DIRECTORY");
        if (defaultValue == null || defaultValue.compareToIgnoreCase("") == 0) {
            defaultValue = String.valueOf(StatementPoolManager.DEFAULT_STATISTICS_OUTPUT_DIRECTORY);
        }
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("STATISTICS_OUTPUT_DIRECTORY", defaultValue);
        ei = "TKTS.driverPropertyInfo.PROP_STATISTICS_OUTPUT_DIRECTORY.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTY_INFO[++pn] = new DriverPropertyInfo("user", "");
        ei = "TKTSDriver.user.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this.U_INDEX = ++pn;
        this._DRIVER_PROPERTY_INFO[pn] = new DriverPropertyInfo("userName", "");
        ei = "TKTSDriver.username.desc.txt";
        this._DRIVER_PROPERTY_INFO[pn].description = resourceBundle.getString(ei);
        this._DRIVER_PROPERTIES = new Properties();
        int max_required_properties = this._DRIVER_PROPERTY_INFO.length;
        for (int i = 0; i < max_required_properties; ++i) {
            this._DRIVER_PROPERTIES.put(this._DRIVER_PROPERTY_INFO[i].name, this._DRIVER_PROPERTY_INFO[i].value);
        }
        if (AbstractLogger.isTrace) {
            logger.trace("DriverProperties:'" + this._DRIVER_PROPERTIES + "' ");
        }
    }

    private void addValuesToProperties(String[] k, String[] v, Properties p) {
        for (int i = 0; i < k.length; ++i) {
            String key = k[i];
            String value = v[i];
            if (value == null) continue;
            p.put(key, value);
        }
    }

    private void addPropWarning(String key, List<SQLWarning> propWarnings, String method) {
        String ei = "TKTSDriver.invalidPropertyError.fmt";
        Object[] args = new String[]{key};
        String warningStr = LocalizedErrorHandler.getLocalizedError("TKTSDriver.invalidPropertyError.fmt", args);
        SQLWarning sqlWarning = new SQLWarning(warningStr, "01S00");
        propWarnings.add(sqlWarning);
        if (AbstractLogger.isWarn) {
            logger.warn(method, warningStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties updateDriverProperties(Properties info, Properties urlProps, List<SQLWarning> propWarnings) throws SQLException {
        SealedString sc = null;
        SealedString sp = null;
        SealedString su = null;
        boolean otp = false;
        String method = "updateDriverProperties(info,propWarnings)";
        Properties conProps = new Properties();
        if (this._DRIVER_PROPERTY_INFO == null) {
            return conProps;
        }
        Object object = this._DRIVER_PROPERTY_INFO;
        synchronized (this._DRIVER_PROPERTY_INFO) {
            String value;
            String key;
            String[] keys = new String[this._DRIVER_PROPERTY_INFO.length];
            String[] values = new String[this._DRIVER_PROPERTY_INFO.length];
            for (int i = 0; i < this._DRIVER_PROPERTY_INFO.length; ++i) {
                key = this._DRIVER_PROPERTY_INFO[i].name;
                value = this._DRIVER_PROPERTY_INFO[i].value;
                keys[i] = key;
                if (value == null || value.length() <= 0) continue;
                values[i] = value;
            }
            // ** MonitorExit[var14_10 /* !! */ ] (shouldn't be in output)
            if (info == null && urlProps == null) {
                this.addValuesToProperties(keys, values, conProps);
                return conProps;
            }
            object = this._DRIVER_PROPERTIES;
            synchronized (object) {
                int i;
                int propLength = this._DRIVER_PROPERTY_INFO.length;
                boolean found = false;
                Enumeration<Object> a = urlProps.keys();
                while (a.hasMoreElements()) {
                    key = (String)a.nextElement();
                    if (key.equalsIgnoreCase("sconstr") || key.equalsIgnoreCase("spassword") || key.equalsIgnoreCase("suser")) continue;
                    value = (String)urlProps.get(key);
                    for (i = 0; i < propLength; ++i) {
                        if (!key.equalsIgnoreCase(this._DRIVER_PROPERTY_INFO[i].name)) continue;
                        values[i] = value;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.addPropWarning(key, propWarnings, "updateDriverProperties(info,propWarnings)");
                    }
                    found = false;
                }
                a = info.keys();
                while (a.hasMoreElements()) {
                    key = (String)a.nextElement();
                    if (key.equalsIgnoreCase("sconstr")) {
                        sc = (SealedString)info.remove(key);
                        continue;
                    }
                    if (key.equalsIgnoreCase("spassword")) {
                        sp = (SealedString)info.remove(key);
                        continue;
                    }
                    if (key.equalsIgnoreCase("suser")) {
                        su = (SealedString)info.remove(key);
                        continue;
                    }
                    value = (String)info.get(key);
                    for (i = 0; i < propLength; ++i) {
                        if (!key.equalsIgnoreCase(this._DRIVER_PROPERTY_INFO[i].name)) continue;
                        values[i] = value;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.addPropWarning(key, propWarnings, "updateDriverProperties(info,propWarnings)");
                    }
                    found = false;
                }
            }
            if (sc == null) {
                value = values[this.C_INDEX];
                values[this.C_INDEX] = null;
                if (value != null) {
                    sc = new SealedString(value);
                    value = null;
                }
            }
            if (sp == null) {
                value = values[this.P_INDEX];
                values[this.P_INDEX] = null;
                if (value != null) {
                    sp = new SealedString(value);
                    value = null;
                }
            }
            if (su == null) {
                value = values[this.U_INDEX];
                values[this.U_INDEX] = null;
                if (value != null) {
                    otp = FSConnection.isOtpUser(value);
                    su = new SealedString(value);
                    value = null;
                }
            }
            this.addValuesToProperties(keys, values, conProps);
            if (sc != null) {
                conProps.put("sconstr", sc);
            }
            if (sp != null) {
                conProps.put("spassword", sp);
            }
            if (su != null) {
                conProps.put("suser", su);
            }
            if (otp) {
                conProps.put("OTP", "true");
            }
            return conProps;
        }
    }

    public static boolean registerDriver(String inUrl, Driver inDriver) {
        boolean outRegistered = false;
        Driver tDriver = wrapperDrivers.get(inUrl);
        if (tDriver == null) {
            outRegistered = true;
            wrapperDrivers.put(inUrl, inDriver);
        }
        return outRegistered;
    }

    public static boolean verifyRegisterDriver(Driver inDriver) {
        boolean validDriver = false;
        if (inDriver != null) {
            Enumeration<Driver> e = wrapperDrivers.elements();
            while (e.hasMoreElements()) {
                Driver tDriver = e.nextElement();
                if (tDriver != inDriver) continue;
                validDriver = true;
                break;
            }
        }
        return validDriver;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        String method = "getParentLogger";
        SQLFeatureNotSupportedException ex = null;
        String lMsg = null;
        Object[] args = new String[]{"getParentLogger"};
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", args);
        ex = new SQLFeatureNotSupportedException(lMsg);
        throw ex;
    }

    public void closingConn(FSConnection inConn) {
        openConnlock.lock();
        openConnections.remove(inConn.getMyID());
        openConnlock.unlock();
    }

    public ResourceUsage getResourceUsage() {
        ResourceUsage out = new ResourceUsage();
        openConnlock.lock();
        Enumeration<FSConnection> connEnumeration = openConnections.elements();
        while (connEnumeration.hasMoreElements()) {
            FSDatabaseMetaData dbmd;
            FSConnection tConn;
            block7: {
                boolean open;
                block6: {
                    tConn = connEnumeration.nextElement();
                    ++out.connTotal;
                    open = false;
                    dbmd = null;
                    try {
                        open = tConn.isClosed();
                    }
                    catch (SQLException se) {
                        if (!AbstractLogger.isWarn) break block6;
                        logger.warn("getResourceUsage", se.toString());
                        logger.warn(se);
                    }
                }
                if (!open) continue;
                ++out.connOpen;
                out.connWarnings += tConn.getNumberOfWarnings();
                try {
                    dbmd = (FSDatabaseMetaData)tConn.getMetaData();
                }
                catch (SQLException se) {
                    if (!AbstractLogger.isWarn) break block7;
                    logger.warn("getResourceUsage", se.toString());
                    logger.warn(se);
                }
            }
            if (dbmd != null) {
                out.connResultSet += dbmd.resultSetCount();
            }
            out.stmtTotal = (int)((long)out.stmtTotal + tConn.getNumberStatements());
        }
        openConnlock.unlock();
        return out;
    }

    static {
        PRELOAD_CLASSES = true;
        String method = "initialization";
        DRIVER_NAME = thisClassName = TKTSDriver.class.getName();
        try {
            String ei;
            resourceBundle = ResourceBundle.getBundle("com.sas.tkts.Resources");
            systemPropertyDebugInit = new SystemPropertiesInfo("dfsJDBCDebugInit", "false");
            systemPropertyDebugInit.verifyBoolean();
            if (TKTSDriver.systemPropertyDebugInit.valid && TKTSDriver.systemPropertyDebugInit.boolValue) {
                AbstractLogger.setDebugInitialization(TKTSDriver.systemPropertyDebugInit.strValue);
            }
            systemPropertyLoggingLevel = new SystemPropertiesInfo("dfsJDBCLogLevel", "off");
            TKTSDriver.systemPropertyLoggingLevel.valid = AbstractLogger.setLevel(TKTSDriver.systemPropertyLoggingLevel.strValue);
            systemPropertyLoggingFlush = new SystemPropertiesInfo("dfsJDBCLogFlush", "false");
            systemPropertyLoggingFlush.verifyBoolean();
            AbstractLogger.setFlush(TKTSDriver.systemPropertyLoggingFlush.strValue);
            systemPropertyMeasurementsLevel = new SystemPropertiesInfo("dfsJDBCMeasurements", "off");
            TKTSDriver.systemPropertyMeasurementsLevel.valid = AbstractLogger.setMeasurements(TKTSDriver.systemPropertyMeasurementsLevel.strValue);
            if (AbstractLogger.isMeasurements) {
                LocalizedMessageHandler.setLogStatisticsOnConnectionClose(true);
            }
            systemPropertyMeasurementsUnits = new SystemPropertiesInfo("dfsJDBCMeasurementsUnits", "s");
            TKTSDriver.systemPropertyMeasurementsUnits.valid = AbstractLogger.setMeasurementsUnit(TKTSDriver.systemPropertyMeasurementsUnits.strValue);
            AbstractLogger.setMeasurementsUnit(TKTSDriver.systemPropertyMeasurementsUnits.strValue);
            systemPropertyMeasurementsThreshold = new SystemPropertiesInfo("dfsJDBCMeasurementsThreshold", "0");
            systemPropertyMeasurementsThreshold.verifyThreshold();
            AbstractLogger.setMeasurementsThreshold(TKTSDriver.systemPropertyMeasurementsThreshold.intValue);
            StatisticsBoard.initMeasurementsThreshold();
            systemPropertyMeasurementsAppend = new SystemPropertiesInfo("dfsJDBCMeasurementsAppend", "false");
            systemPropertyMeasurementsAppend.verifyBoolean();
            AbstractLogger.setMeasurementsAppend(TKTSDriver.systemPropertyMeasurementsAppend.strValue);
            ConcreteLogger.initializeLogger();
            if (logger == null) {
                logger = LoggerFactory.getLogger(thisClassName);
            }
            if (initLogger == null) {
                initLogger = LoggerFactory.getLogger("com.sas.tkts.init");
            }
            systemPropertyPrefetchSummary = new SystemPropertiesInfo("dfsJDBCPrefetchSummary", "false");
            systemPropertyPrefetchSummary.verifyBoolean();
            systemPropertyPrefetchDebug = new SystemPropertiesInfo("dfsJDBCPrefetchDebug", "false");
            systemPropertyPrefetchDebug.verifyBoolean();
            systemPropertyPrefetchTrace = new SystemPropertiesInfo("dfsJDBCPrefetchTrace", "false");
            systemPropertyPrefetchTrace.verifyBoolean();
            systemPropertyDebugInit.log(initLogger, "initialization");
            systemPropertyLoggingLevel.log(initLogger, "initialization");
            systemPropertyLoggingFlush.log(initLogger, "initialization");
            systemPropertyMeasurementsLevel.log(initLogger, "initialization");
            systemPropertyMeasurementsUnits.log(initLogger, "initialization");
            systemPropertyMeasurementsThreshold.log(initLogger, "initialization");
            systemPropertyMeasurementsAppend.log(initLogger, "initialization");
            systemPropertyPrefetchSummary.log(initLogger, "initialization");
            systemPropertyPrefetchDebug.log(initLogger, "initialization");
            systemPropertyPrefetchTrace.log(initLogger, "initialization");
            if (AbstractLogger.isInfo) {
                String[] args = new String[]{thisClassName, TKTSDriver.systemPropertyLoggingLevel.strValue, AbstractLogger.getFlushType(), "Deprecated", AbstractLogger.getMeasurementsUnitString()};
                ei = "TKTSDriver.register.fmt";
                LocalizedMessageHandler.logInfoMessage("initialization", ei, args, logger);
            }
            try {
                Driver driver = (Driver)Class.forName(thisClassName).newInstance();
                DriverManager.registerDriver(driver);
                wrapperDrivers = new Hashtable();
                TKTSDriver.registerDriver("jdbc:sastkts://", driver);
            }
            catch (Exception e) {
                if (AbstractLogger.isFatal) {
                    LocalizedMessageHandler.logFatalMessage("initialization", e, logger);
                }
                System.err.println(e.getMessage());
            }
            catch (ClassFormatError cfe) {
                if (AbstractLogger.isFatal) {
                    LocalizedMessageHandler.logFatalMessage("initialization", cfe, logger);
                }
                System.err.println(cfe.getMessage());
            }
            openConnections = new Hashtable();
            openConnlock = new ReentrantLock();
            if (PRELOAD_CLASSES) {
                TKTSDriver.loadAllClasses();
            }
            if (AbstractLogger.isInfo) {
                ei = "TKTSDriver.registerComplete.txt";
                LocalizedMessageHandler.logInfoMessage("initialization", ei, logger);
            }
        }
        catch (ExceptionInInitializerError e) {
            String s = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
            System.err.println(s);
            System.err.println(e);
            Throwable c = e.getCause();
            System.err.println(c);
            System.err.println(s);
        }
        catch (Exception e) {
            String s = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
            System.err.println(s);
            System.err.println(e);
            System.err.println(s);
        }
    }
}

