/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.tools.ToolboxFactory;
import org.apache.velocity.tools.config.ConfigurationCleaner;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.view.JeeConfig;
import org.apache.velocity.tools.view.JeeContextConfig;
import org.apache.velocity.tools.view.JeeFilterConfig;
import org.apache.velocity.tools.view.JeeServletConfig;
import org.apache.velocity.tools.view.ServletUtils;
import org.apache.velocity.tools.view.ViewToolContext;
import org.apache.velocity.tools.view.ViewToolManager;
import org.apache.velocity.util.ExtProperties;
import org.apache.velocity.util.SimplePool;

public class VelocityView
extends ViewToolManager {
    public static final String CONTENT_TYPE_KEY = "default.contentType";
    public static final String OUTPUT_ENCODING_KEY = "output.encoding";
    public static final String SERVLET_CONTEXT_KEY = ServletContext.class.getName();
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    public static final String TOOLS_KEY = "org.apache.velocity.tools";
    public static final String USER_TOOLS_PATH = "/WEB-INF/tools.xml";
    public static final String DEFAULT_PROPERTIES_PATH = "/org/apache/velocity/tools/view/velocity.properties";
    public static final String PROPERTIES_KEY = "org.apache.velocity.properties";
    public static final String USER_PROPERTIES_PATH = "/WEB-INF/velocity.properties";
    public static final String LOAD_DEFAULTS_KEY = "org.apache.velocity.tools.loadDefaults";
    public static final String CLEAN_CONFIGURATION_KEY = "org.apache.velocity.tools.cleanConfiguration";
    public static final String USER_OVERWRITE_KEY = "org.apache.velocity.tools.userCanOverwriteTools";
    private static SimplePool writerPool = new SimplePool(40);
    private String defaultContentType = "text/html";

    public VelocityView(ServletConfig config) {
        this(new JeeServletConfig(config));
    }

    public VelocityView(FilterConfig config) {
        this(new JeeFilterConfig(config));
    }

    public VelocityView(ServletContext context) {
        this(new JeeContextConfig(context));
    }

    public VelocityView(JeeConfig config) {
        super(config.getServletContext(), false, false);
        this.init(config);
    }

    public void setVelocityEngine(VelocityEngine engine) {
        if (engine == null) {
            throw new NullPointerException("VelocityEngine cannot be null");
        }
        super.setVelocityEngine(engine);
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(String type) {
        if (!this.defaultContentType.equals(type)) {
            this.defaultContentType = type;
            this.getLog().debug("Default Content-Type was changed to {}", (Object)type);
        }
    }

    protected String getProperty(String key, String alternate) {
        String prop = (String)this.velocity.getProperty(key);
        if (prop == null || prop.length() == 0) {
            return alternate;
        }
        return prop;
    }

    protected void init(JeeConfig config) {
        String allowOverwrite;
        if (this.velocity == null) {
            this.setVelocityEngine(new VelocityEngine());
        }
        if ((allowOverwrite = config.findInitParameter(USER_OVERWRITE_KEY)) != null && allowOverwrite.equalsIgnoreCase("false")) {
            this.setUserCanOverwriteTools(false);
        }
        this.init(config, this.velocity);
        this.configure(config, this.factory);
        this.setEncoding(config);
    }

    protected void init(JeeConfig config, final VelocityEngine velocity) {
        velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.servletContext);
        this.configure(config, velocity);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        velocity.init();
                        return null;
                    }
                });
            } else {
                velocity.init();
            }
        }
        catch (Exception e) {
            String msg = "Could not initialize VelocityEngine";
            this.getLog().error(msg, (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(msg + ": " + e, e);
        }
    }

    protected void configure(JeeConfig config, VelocityEngine velocity) {
        Properties appProperties;
        String servletPropsPath;
        Properties defaultProperties = this.getProperties(DEFAULT_PROPERTIES_PATH, true);
        velocity.setProperties(defaultProperties);
        String appPropsPath = this.servletContext.getInitParameter(PROPERTIES_KEY);
        if (appPropsPath != null) {
            Properties appProperties2 = this.getProperties(appPropsPath, true);
            this.getLog().debug("Configuring Velocity with properties at: {}", (Object)appPropsPath);
            velocity.setProperties(appProperties2);
        }
        if (!((servletPropsPath = config.getInitParameter(PROPERTIES_KEY)) == null || appPropsPath != null && appPropsPath.equals(servletPropsPath))) {
            boolean isInWebInf = servletPropsPath.startsWith("/WEB-INF") || servletPropsPath.startsWith("WEB-INF");
            Properties servletProperties = this.getProperties(servletPropsPath, true);
            this.getLog().debug("Configuring Velocity with properties at: {}", (Object)servletPropsPath);
            velocity.setProperties(servletProperties);
        }
        if (appPropsPath == null && servletPropsPath == null && (appProperties = this.getProperties(USER_PROPERTIES_PATH, false)) != null) {
            this.getLog().debug("Configuring Velocity with properties at: {}", (Object)appPropsPath);
            velocity.setProperties(appProperties);
        }
        this.initLog();
    }

    protected void configure(JeeConfig config, ToolboxFactory factory) {
        String cleanConfig;
        FactoryConfiguration injected;
        FactoryConfiguration standardLocationConfiguration;
        String servletToolsPath;
        FactoryConfiguration factoryConfig = new FactoryConfiguration("VelocityView.configure(config,factory)");
        String loadDefaults = config.findInitParameter(LOAD_DEFAULTS_KEY);
        if (loadDefaults == null || "false".equalsIgnoreCase(loadDefaults)) {
            this.getLog().debug("Default tools not loaded.");
        } else {
            this.getLog().trace("Loading default tools configuration...");
            factoryConfig.addConfiguration(this.getDefaultToolsConfiguration());
        }
        String appToolsPath = this.servletContext.getInitParameter(TOOLS_KEY);
        if (appToolsPath != null) {
            FactoryConfiguration appToolsConfig = this.getConfiguration(appToolsPath, true);
            factoryConfig.addConfiguration(appToolsConfig);
            this.getLog().debug("Loaded configuration from: {}", (Object)appToolsPath);
        }
        if ((servletToolsPath = config.getInitParameter(TOOLS_KEY)) != null) {
            FactoryConfiguration servletToolsConfig = this.getConfiguration(servletToolsPath, true);
            factoryConfig.addConfiguration(servletToolsConfig);
            this.getLog().debug("Loaded configuration from: {}", (Object)servletToolsPath);
        }
        if (appToolsPath == null && servletToolsPath == null && (standardLocationConfiguration = this.getConfiguration(USER_TOOLS_PATH, false)) != null) {
            factoryConfig.addConfiguration(standardLocationConfiguration);
            this.getLog().debug("Loaded configuration from: {}", (Object)USER_TOOLS_PATH);
        }
        if ((injected = ServletUtils.getConfiguration(this.servletContext)) != null) {
            factoryConfig.addConfiguration(injected);
            this.getLog().debug("Added configuration instance in servletContext attributes as '{}'", (Object)TOOLS_KEY);
        }
        if ("true".equals(cleanConfig = config.findInitParameter(CLEAN_CONFIGURATION_KEY))) {
            ConfigurationCleaner cleaner = new ConfigurationCleaner();
            cleaner.setLog(this.getLog());
            cleaner.clean(factoryConfig);
        }
        this.getLog().debug("Configuring factory with: {}", (Object)factoryConfig);
        this.configure(factoryConfig);
    }

    protected FactoryConfiguration getDefaultToolsConfiguration() {
        return ConfigurationUtils.getDefaultTools();
    }

    private boolean setConfig(FactoryConfiguration factory, String path, boolean require) {
        if (path == null) {
            return false;
        }
        FactoryConfiguration config = this.getConfiguration(path, require);
        if (config == null) {
            return false;
        }
        this.getLog().debug("Loaded configuration from: {}", (Object)path);
        factory.addConfiguration(config);
        return true;
    }

    protected InputStream getInputStream(String path, boolean required) {
        InputStream inputStream = ServletUtils.getInputStream(path, this.servletContext);
        if (inputStream == null) {
            String msg = "Did not find resource at: " + path;
            if (required) {
                this.getLog().error(msg);
                throw new ResourceNotFoundException(msg);
            }
            this.getLog().debug(msg);
            return null;
        }
        return inputStream;
    }

    protected Properties getProperties(String path) {
        return this.getProperties(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String path, boolean required) {
        InputStream inputStream;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Searching for properties at {} ", (Object)path);
        }
        if ((inputStream = ServletUtils.getInputStream(path, this.servletContext)) == null) {
            String msg = "Did not find resource at: " + path;
            if (required) {
                this.getLog().error(msg);
                throw new ResourceNotFoundException(msg);
            }
            this.getLog().debug(msg);
            return null;
        }
        Properties properties = new Properties();
        try {
            ExtProperties extProps = new ExtProperties();
            extProps.load(inputStream);
            properties.putAll((Map<?, ?>)extProps);
        }
        catch (IOException ioe) {
            String msg = "Failed to load properties at: " + path;
            this.getLog().error(msg, (Throwable)ioe);
            if (required) {
                throw new RuntimeException(msg, ioe);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                this.getLog().error("Failed to close input stream for {}", (Object)path, (Object)ioe);
            }
        }
        return properties;
    }

    protected FactoryConfiguration getConfiguration(String path) {
        return this.getConfiguration(path, false);
    }

    protected FactoryConfiguration getConfiguration(String path, boolean required) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Searching for configuration at: {}", (Object)path);
        }
        FactoryConfiguration config = null;
        try {
            config = ServletUtils.getConfiguration(path, this.servletContext);
            if (config == null) {
                String msg = "Did not find resource at: " + path;
                if (required) {
                    this.getLog().error(msg);
                    throw new ResourceNotFoundException(msg);
                }
                this.getLog().debug(msg);
            }
        }
        catch (ResourceNotFoundException rnfe) {
            throw rnfe;
        }
        catch (RuntimeException re) {
            this.getLog().error(re.getMessage(), (Throwable)re);
            throw re;
        }
        return config;
    }

    protected void setEncoding(JeeConfig config) {
        this.defaultContentType = this.getProperty(CONTENT_TYPE_KEY, DEFAULT_CONTENT_TYPE);
        String encoding = this.getProperty(OUTPUT_ENCODING_KEY, DEFAULT_OUTPUT_ENCODING);
        if (!DEFAULT_OUTPUT_ENCODING.equalsIgnoreCase(encoding)) {
            int index = this.defaultContentType.lastIndexOf("charset");
            if (index < 0) {
                this.defaultContentType = this.defaultContentType + "; charset=" + encoding;
            } else {
                this.getLog().info("Charset was already specified in the Content-Type property.  Output encoding property will be ignored.");
            }
        }
        this.getLog().debug("Default Content-Type is: {}", (Object)this.defaultContentType);
    }

    public Context render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ViewToolContext context = this.createContext(request, response);
        Template template = this.getTemplate(request);
        this.merge(template, (Context)context, response.getWriter());
        return context;
    }

    public Context render(HttpServletRequest request, Writer out) throws IOException {
        ViewToolContext context = this.createContext(request, null);
        Template template = this.getTemplate(request);
        this.merge(template, (Context)context, out);
        return context;
    }

    @Override
    public ViewToolContext createContext(HttpServletRequest request, HttpServletResponse response) {
        ViewToolContext ctx = new ViewToolContext(this.velocity, request, response, this.servletContext);
        this.prepareContext(ctx, request);
        return ctx;
    }

    public Template getTemplate(HttpServletRequest request) {
        String path = ServletUtils.getPath(request);
        return this.getTemplate(path);
    }

    public Template getTemplate(String name) {
        return this.getTemplate(name, null);
    }

    public Template getTemplate(String name, String encoding) {
        try {
            if (encoding == null) {
                return this.velocity.getTemplate(name);
            }
            return this.velocity.getTemplate(name, encoding);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Template template, Context context, Writer writer) throws IOException {
        VelocityWriter vw = null;
        try {
            vw = (VelocityWriter)writerPool.get();
            if (vw == null) {
                vw = new VelocityWriter(writer, 4096, true);
            } else {
                vw.recycle(writer);
            }
            this.performMerge(template, context, (Writer)vw);
            vw.flush();
        }
        finally {
            if (vw != null) {
                try {
                    vw.recycle(null);
                    writerPool.put((Object)vw);
                }
                catch (Exception e) {
                    this.getLog().error("Trouble releasing VelocityWriter: ", (Throwable)e);
                }
            }
        }
    }

    protected void performMerge(Template template, Context context, Writer writer) throws IOException {
        template.merge(context, writer);
    }
}

