/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.pdx.FieldType;

public class PdxField
implements DataSerializable,
Comparable<PdxField> {
    private static final long serialVersionUID = -1095459461236458274L;
    private String fieldName;
    private int fieldIndex;
    private int varLenFieldSeqId;
    private FieldType type;
    private int relativeOffset;
    private int vlfOffsetIndex;
    private boolean identityField;
    private boolean deleted;
    private static final byte IDENTITY_BIT = 1;
    private static final byte DELETED_BIT = 2;

    public PdxField() {
    }

    public PdxField(String fieldName, int index, int varId, FieldType type, boolean identityField) {
        this.fieldName = fieldName;
        this.fieldIndex = index;
        this.varLenFieldSeqId = varId;
        this.type = type;
        this.identityField = identityField;
    }

    protected PdxField(PdxField other) {
        this.fieldName = other.fieldName;
        this.fieldIndex = other.fieldIndex;
        this.varLenFieldSeqId = other.varLenFieldSeqId;
        this.type = other.type;
        this.identityField = other.identityField;
        this.deleted = other.deleted;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public int getVarLenFieldSeqId() {
        return this.varLenFieldSeqId;
    }

    public boolean isVariableLengthType() {
        return !this.type.isFixedWidth();
    }

    public FieldType getFieldType() {
        return this.type;
    }

    public int getRelativeOffset() {
        return this.relativeOffset;
    }

    public void setRelativeOffset(int relativeOffset) {
        this.relativeOffset = relativeOffset;
    }

    public int getVlfOffsetIndex() {
        return this.vlfOffsetIndex;
    }

    public void setVlfOffsetIndex(int vlfOffsetIndex) {
        this.vlfOffsetIndex = vlfOffsetIndex;
    }

    public void setIdentityField(boolean identityField) {
        this.identityField = identityField;
    }

    public boolean isIdentityField() {
        return this.identityField;
    }

    public void setDeleted(boolean v) {
        this.deleted = v;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fieldName = DataSerializer.readString(in);
        this.fieldIndex = in.readInt();
        this.varLenFieldSeqId = in.readInt();
        this.type = DataSerializer.readEnum(FieldType.class, in);
        this.relativeOffset = in.readInt();
        this.vlfOffsetIndex = in.readInt();
        byte bits = in.readByte();
        this.identityField = (bits & 1) != 0;
        this.deleted = (bits & 2) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        KnownVersion sourceVersion;
        DataSerializer.writeString(this.fieldName, out);
        out.writeInt(this.fieldIndex);
        out.writeInt(this.varLenFieldSeqId);
        DataSerializer.writeEnum(this.type, out);
        out.writeInt(this.relativeOffset);
        out.writeInt(this.vlfOffsetIndex);
        byte bits = 0;
        if (this.identityField) {
            bits = (byte)(bits | 1);
        }
        if ((sourceVersion = StaticSerialization.getVersionForDataStream((DataOutput)out)).isNotOlderThan((Version)KnownVersion.GFE_81) && this.deleted) {
            bits = (byte)(bits | 2);
        }
        out.writeByte(bits);
    }

    public int hashCode() {
        int hash = 1;
        if (this.fieldName != null) {
            hash = hash * 31 + this.fieldName.hashCode();
        }
        if (this.type != null) {
            hash = hash * 31 + this.type.hashCode();
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PdxField)) {
            return false;
        }
        PdxField otherVFT = (PdxField)other;
        if (otherVFT.fieldName == null) {
            return false;
        }
        return otherVFT.fieldName.equals(this.fieldName) && this.isDeleted() == otherVFT.isDeleted() && this.type.equals((Object)otherVFT.type);
    }

    public String toString() {
        return this.fieldName + ":" + String.valueOf((Object)this.type) + (this.isDeleted() ? ":DELETED" : "") + (this.isIdentityField() ? ":identity" : "") + ":" + this.fieldIndex + (String)(this.varLenFieldSeqId > 0 ? ":" + this.varLenFieldSeqId : "") + ":idx0(relativeOffset)=" + this.relativeOffset + ":idx1(vlfOffsetIndex)=" + this.vlfOffsetIndex;
    }

    public String getTypeIdString() {
        return this.getFieldType().toString();
    }

    @Override
    public int compareTo(PdxField o) {
        return this.getFieldName().compareTo(o.getFieldName());
    }

    public void toStream(PrintStream printStream) {
        printStream.print("    ");
        printStream.print((Object)this.getFieldType());
        printStream.print(' ');
        printStream.print(this.getFieldName());
        printStream.print(';');
        if (this.isIdentityField()) {
            printStream.print(" // identity");
        }
        if (this.isDeleted()) {
            printStream.print(" // DELETED");
        }
        printStream.println();
    }
}

