/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.Externalizable;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import org.apache.geode.CancelException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.RegionService;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.PdxSerializerObject;
import org.apache.geode.internal.util.concurrent.CopyOnWriteWeakHashMap;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.FieldType;
import org.apache.geode.pdx.NonPortableClassException;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.PdxWriter;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.pdx.internal.InternalPdxReader;
import org.apache.geode.pdx.internal.PdxField;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.unsafe.internal.sun.misc.Unsafe;
import org.apache.logging.log4j.Logger;

public class AutoSerializableManager {
    private static final Logger logger;
    private static final String INIT_CLASSES_PARAM = "classes";
    private static final String INIT_CHECK_PORTABILITY_PARAM = "check-portability";
    private static final String OPT_IDENTITY = "identity";
    private static final String OPT_EXCLUDE = "exclude";
    private final Map<Class<?>, AutoClassInfo> classMap = new CopyOnWriteWeakHashMap();
    private final List<String[]> identityPatterns = new CopyOnWriteArrayList<String[]>();
    private final List<String[]> excludePatterns = new CopyOnWriteArrayList<String[]>();
    public static final String NO_HARDCODED_EXCLUDES_PARAM = "gemfire.auto.serialization.no.hardcoded.excludes";
    private boolean noHardcodedExcludes = Boolean.getBoolean("gemfire.auto.serialization.no.hardcoded.excludes");
    private final Set<Pattern> classPatterns = new LinkedHashSet<Pattern>();
    private final Set<Pattern> hardcodedExclusions = new HashSet<Pattern>(){
        {
            this.add(Pattern.compile("org\\.apache\\.geode\\..*"));
            this.add(Pattern.compile("com\\.gemstone\\..*"));
            this.add(Pattern.compile("java\\..*"));
            this.add(Pattern.compile("javax\\..*"));
        }
    };
    private final Set<String> cachedExcludedClasses = new CopyOnWriteHashSet<String>();
    private final Set<String> cachedIncludedClasses = new CopyOnWriteHashSet<String>();
    private final Set<String> loggedNoAutoSerializeMsg = new CopyOnWriteHashSet<String>();
    private final ReflectionBasedAutoSerializer owner;
    private boolean checkPortability;
    @Immutable
    private static final Unsafe unsafe;
    private static final boolean USE_CONSTRUCTOR;
    private RegionService cache;

    public ReflectionBasedAutoSerializer getOwner() {
        return this.owner;
    }

    public static AutoSerializableManager create(ReflectionBasedAutoSerializer owner, boolean checkPortability, String ... patterns) {
        AutoSerializableManager result = new AutoSerializableManager(owner);
        result.reconfigure(checkPortability, patterns);
        return result;
    }

    private AutoSerializableManager(ReflectionBasedAutoSerializer owner) {
        this.owner = owner;
    }

    public Map<Class<?>, AutoClassInfo> getClassMap() {
        return this.classMap;
    }

    public void setCheckPortability(boolean b) {
        this.checkPortability = b;
    }

    public boolean getCheckPortability() {
        return this.checkPortability;
    }

    public void resetCachedTypes() {
        this.classMap.clear();
    }

    public void resetCaches() {
        this.identityPatterns.clear();
        this.excludePatterns.clear();
        this.resetCachedTypes();
    }

    public void resetAll() {
        this.resetCaches();
        this.checkPortability = false;
        this.classPatterns.clear();
        this.cachedIncludedClasses.clear();
        this.cachedExcludedClasses.clear();
        this.loggedNoAutoSerializeMsg.clear();
        this.noHardcodedExcludes = Boolean.getBoolean(NO_HARDCODED_EXCLUDES_PARAM);
    }

    private boolean isRelevant(Class<?> clazz) {
        String className = clazz.getName();
        if (this.cachedIncludedClasses.contains(className)) {
            return true;
        }
        if (this.cachedExcludedClasses.contains(className)) {
            return false;
        }
        boolean result = this.getOwner().isClassAutoSerialized(clazz);
        if (result) {
            this.cachedIncludedClasses.add(className);
        } else {
            this.cachedExcludedClasses.add(className);
        }
        return result;
    }

    public boolean isExcluded(String className) {
        if (!this.noHardcodedExcludes) {
            for (Pattern p : this.hardcodedExclusions) {
                if (!p.matcher(className).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean defaultIsClassAutoSerialized(Class<?> clazz) {
        if (clazz.isEnum()) {
            return false;
        }
        String className = clazz.getName();
        if (this.isExcluded(className) && !PdxSerializerObject.class.isAssignableFrom(clazz)) {
            return false;
        }
        for (Pattern p : this.classPatterns) {
            if (!p.matcher(className).matches()) continue;
            return this.hasValidConstructor(clazz, p) && !this.needsStandardSerialization(clazz, p);
        }
        return false;
    }

    private boolean hasValidConstructor(Class<?> clazz, Pattern matchedPattern) {
        if (unsafe != null && !USE_CONSTRUCTOR) {
            return true;
        }
        try {
            clazz.getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException nex) {
            String className = clazz.getName();
            if (!this.loggedNoAutoSerializeMsg.contains(className)) {
                this.loggedNoAutoSerializeMsg.add(className);
                logger.warn("Class {} matched with '{}' cannot be auto-serialized due to missing public no-arg constructor. Will attempt using Java serialization.", (Object)className, (Object)matchedPattern.pattern());
            }
            return false;
        }
    }

    private boolean needsStandardSerialization(Class<?> clazz, Pattern matchedPattern) {
        if (Serializable.class.isAssignableFrom(clazz)) {
            if (Externalizable.class.isAssignableFrom(clazz)) {
                String className = clazz.getName();
                if (!this.loggedNoAutoSerializeMsg.contains(className)) {
                    this.loggedNoAutoSerializeMsg.add(className);
                    logger.warn("Class {} matched with '{}' cannot be auto-serialized because it is Externalizable. Java serialization will be used instead of auto-serialization.", (Object)className, (Object)matchedPattern.pattern());
                }
                return true;
            }
            if (AutoSerializableManager.getPrivateMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE)) {
                String className = clazz.getName();
                if (!this.loggedNoAutoSerializeMsg.contains(className)) {
                    this.loggedNoAutoSerializeMsg.add(className);
                    logger.warn("Class {} matched with '{}' cannot be auto-serialized because it has a writeObject(ObjectOutputStream) method. Java serialization will be used instead of auto-serialization.", (Object)className, (Object)matchedPattern.pattern());
                }
                return true;
            }
            if (AutoSerializableManager.getInheritableMethod(clazz, "writeReplace", null, Object.class)) {
                String className = clazz.getName();
                if (!this.loggedNoAutoSerializeMsg.contains(className)) {
                    this.loggedNoAutoSerializeMsg.add(className);
                    logger.warn("Class {} matched with '{}' cannot be auto-serialized because it has a writeReplace() method. Java serialization will be used instead of auto-serialization.", (Object)className, (Object)matchedPattern.pattern());
                }
                return true;
            }
        }
        return false;
    }

    private static boolean getPrivateMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        try {
            Method meth = cl.getDeclaredMethod(name, argTypes);
            int mods = meth.getModifiers();
            return meth.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private static boolean getInheritableMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        Class defCl;
        Method meth = null;
        for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                meth = defCl.getDeclaredMethod(name, argTypes);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (meth == null || meth.getReturnType() != returnType) {
            return false;
        }
        int mods = meth.getModifiers();
        if ((mods & 0x408) != 0) {
            return false;
        }
        if ((mods & 5) != 0) {
            return true;
        }
        if ((mods & 2) != 0) {
            return cl == defCl;
        }
        return AutoSerializableManager.packageEquals(cl, defCl);
    }

    private static boolean packageEquals(Class cl1, Class cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && AutoSerializableManager.getPackageName(cl1).equals(AutoSerializableManager.getPackageName(cl2));
    }

    private static String getPackageName(Class cl) {
        String s = cl.getName();
        int i = s.lastIndexOf(91);
        if (i >= 0) {
            s = s.substring(i + 2);
        }
        return (i = s.lastIndexOf(46)) >= 0 ? s.substring(0, i) : "";
    }

    public List<PdxFieldWrapper> getFields(Class<?> clazz) {
        return this.getClassInfo(clazz).getFields();
    }

    public AutoClassInfo getExistingClassInfo(Class<?> clazz) {
        return this.classMap.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoClassInfo getClassInfo(Class<?> clazz) {
        Class<?> tmpClass = clazz;
        AutoClassInfo classInfo = this.getExistingClassInfo(tmpClass);
        if (classInfo == null) {
            Map<Class<?>, AutoClassInfo> map = this.classMap;
            synchronized (map) {
                classInfo = this.classMap.get(tmpClass);
                if (classInfo != null) {
                    return classInfo;
                }
                ArrayList<PdxFieldWrapper> fieldList = new ArrayList<PdxFieldWrapper>();
                ArrayList<PdxFieldWrapper> variableLenFields = new ArrayList<PdxFieldWrapper>();
                while (tmpClass != Object.class) {
                    Field[] fields;
                    for (Field f : fields = tmpClass.getDeclaredFields()) {
                        if (!this.getOwner().isFieldIncluded(f, clazz)) continue;
                        f.setAccessible(true);
                        FieldType ft = this.getOwner().getFieldType(f, clazz);
                        PdxFieldWrapper fw = PdxFieldWrapper.create(this, f, ft, this.getOwner().getFieldName(f, clazz), this.getOwner().transformFieldValue(f, clazz), this.getOwner().isIdentityField(f, clazz));
                        if (ft.isFixedWidth()) {
                            fieldList.add(fw);
                            continue;
                        }
                        variableLenFields.add(fw);
                    }
                    tmpClass = tmpClass.getSuperclass();
                }
                fieldList.addAll(variableLenFields);
                classInfo = new AutoClassInfo(clazz, fieldList);
                logger.info("Auto serializer generating type for {} for fields: {}", clazz, (Object)classInfo.toFormattedString());
                this.classMap.put(clazz, classInfo);
            }
        }
        return classInfo;
    }

    public boolean defaultIsIdentityField(Field f, Class<?> clazz) {
        return this.fieldMatches(f, clazz.getName(), this.identityPatterns);
    }

    public boolean defaultIsFieldIncluded(Field f, Class<?> clazz) {
        return !Modifier.isTransient(f.getModifiers()) && !Modifier.isStatic(f.getModifiers()) && !this.fieldMatches(f, clazz.getName(), this.excludePatterns);
    }

    public FieldType defaultGetFieldType(Field f, Class<?> clazz) {
        return FieldType.get(f.getType());
    }

    public List<PdxFieldWrapper> getFields(Object obj) {
        return this.getFields(obj.getClass());
    }

    public boolean writeData(PdxWriter writer, Object obj) {
        if (this.isRelevant(obj.getClass())) {
            this.writeData(writer, obj, this.getClassInfo(obj.getClass()));
            return true;
        }
        return false;
    }

    private static void handleException(Exception ex, boolean serialization, String fieldName, Object obj) {
        if (ex instanceof CancelException) {
            throw (CancelException)ex;
        }
        if (ex instanceof NonPortableClassException) {
            throw (NonPortableClassException)ex;
        }
        throw new PdxSerializationException((serialization ? "Serialization" : "Deserialization") + " error on field " + fieldName + " for class " + obj.getClass().getName(), ex);
    }

    public void writeData(PdxWriter writer, Object obj, AutoClassInfo autoClassInfo) {
        PdxWriterImpl w = (PdxWriterImpl)writer;
        boolean optimizeFieldWrites = false;
        if (autoClassInfo.getSerializedType() != null && w.initUnreadData() == null) {
            optimizeFieldWrites = true;
        }
        for (PdxFieldWrapper f : autoClassInfo.getFields()) {
            if (f.transform()) {
                try {
                    Object newValue = this.getOwner().writeTransform(f.getField(), obj.getClass(), f.getObject(obj));
                    f.serializeValue(w, newValue, optimizeFieldWrites);
                }
                catch (Exception ex) {
                    f.handleException(true, obj, ex);
                }
            } else {
                f.serialize(w, obj, optimizeFieldWrites);
            }
            if (!f.isIdentityField() || !w.definingNewPdxType()) continue;
            try {
                w.markIdentityField(f.getName());
            }
            catch (Exception ex) {
                AutoSerializableManager.handleException(ex, true, f.getName(), obj);
            }
        }
        if (autoClassInfo.getSerializedType() == null) {
            autoClassInfo.setSerializedType(w.getAutoPdxType());
        }
    }

    public Object readData(PdxReader reader, Class<?> clazz) {
        Object result = null;
        if (this.isRelevant(clazz)) {
            AutoClassInfo ci = this.getClassInfo(clazz);
            result = ci.newInstance(clazz);
            InternalPdxReader ri = (InternalPdxReader)reader;
            PdxType pt = ri.getPdxType();
            if (ci.matchesPdxType(pt)) {
                pt.setAutoInfo(ci);
                ri.orderedDeserialize(result, ci);
            } else {
                for (PdxFieldWrapper f : ci.getFields()) {
                    f.deserialize(ri, result);
                }
            }
        }
        return result;
    }

    public void addIdentityPattern(String classPattern, String fieldPattern) {
        this.identityPatterns.add(new String[]{classPattern, fieldPattern});
    }

    public List<String[]> getIdentityPatterns() {
        return this.identityPatterns;
    }

    public void addExcludePattern(String classPattern, String fieldPattern) {
        this.excludePatterns.add(new String[]{classPattern, fieldPattern});
    }

    public List<String[]> getExcludePatterns() {
        return this.excludePatterns;
    }

    private boolean fieldMatches(Field field, String className, List<String[]> matches) {
        String fieldName = field.getName();
        for (String[] e : matches) {
            if (!className.matches(e[0]) || !fieldName.matches(e[1])) continue;
            return true;
        }
        return false;
    }

    public void init(Properties props) {
        this.resetAll();
        if (props != null) {
            Enumeration<?> it = props.propertyNames();
            while (it.hasMoreElements()) {
                Object o = it.nextElement();
                if (o instanceof String) {
                    String propValue;
                    String key = (String)o;
                    if (INIT_CLASSES_PARAM.equals(key)) {
                        propValue = props.getProperty(INIT_CLASSES_PARAM);
                        if (propValue == null) continue;
                        this.processInitParams(propValue);
                        continue;
                    }
                    if (INIT_CHECK_PORTABILITY_PARAM.equals(key)) {
                        propValue = props.getProperty(INIT_CHECK_PORTABILITY_PARAM);
                        if (propValue == null) continue;
                        this.setCheckPortability(Boolean.parseBoolean(propValue));
                        continue;
                    }
                    if (NO_HARDCODED_EXCLUDES_PARAM.equals(key)) {
                        if (props.getProperty(NO_HARDCODED_EXCLUDES_PARAM) == null) continue;
                        this.noHardcodedExcludes = true;
                        continue;
                    }
                    throw new IllegalArgumentException("ReflectionBasedAutoSerializer: unknown init property \"" + key + "\"");
                }
                throw new IllegalArgumentException("ReflectionBasedAutoSerializer: unknown non-String init property \"" + String.valueOf(o) + "\"");
            }
        }
    }

    public Properties getConfig() {
        String[] s;
        Properties props = new Properties();
        if (this.classPatterns.isEmpty()) {
            return props;
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Pattern p : this.classPatterns) {
            tmp.add(p.pattern());
        }
        Iterator<Object> i = tmp.iterator();
        while (i.hasNext()) {
            s = (String[])i.next();
            sb.append((String)s);
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        if (this.getIdentityPatterns().size() > 0) {
            sb.append(", ");
            i = this.getIdentityPatterns().iterator();
            while (i.hasNext()) {
                s = (String[])i.next();
                sb.append(s[0]).append("#identity=").append(s[1]);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        if (this.getExcludePatterns().size() > 0) {
            sb.append(", ");
            i = this.getExcludePatterns().iterator();
            while (i.hasNext()) {
                s = (String[])i.next();
                sb.append(s[0]).append("#exclude=").append(s[1]);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        props.put(INIT_CLASSES_PARAM, sb.toString());
        if (this.getCheckPortability()) {
            props.put(INIT_CHECK_PORTABILITY_PARAM, "true");
        }
        return props;
    }

    public void reconfigure(boolean b, String ... patterns) {
        this.resetAll();
        this.setCheckPortability(b);
        for (String c : patterns) {
            this.processInitParams(c);
        }
    }

    private void processInitParams(String value) {
        for (String s : value.split("[, ]+")) {
            if (s.length() <= 0) continue;
            String[] split = s.split("#");
            for (int i = 1; i < split.length; ++i) {
                String identityPattern = null;
                String excludePattern = null;
                String[] paramVals = split[i].split("=");
                if (paramVals.length != 2) {
                    throw new IllegalArgumentException("Unable to correctly process auto serialization init value: " + value);
                }
                if (OPT_IDENTITY.equalsIgnoreCase(paramVals[0])) {
                    identityPattern = paramVals[1];
                } else if (OPT_EXCLUDE.equalsIgnoreCase(paramVals[0])) {
                    excludePattern = paramVals[1];
                } else {
                    throw new IllegalArgumentException("Unable to correctly process auto serialization init value: " + value);
                }
                if (identityPattern != null) {
                    this.addIdentityPattern(split[0], identityPattern);
                }
                if (excludePattern == null) continue;
                this.addExcludePattern(split[0], excludePattern);
            }
            this.classPatterns.add(Pattern.compile(split[0]));
        }
    }

    public RegionService getRegionService() {
        return this.cache;
    }

    public void setRegionService(RegionService rs) {
        this.cache = rs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checkPortability ? 1231 : 1237);
        result = 31 * result + this.classPatterns.hashCode();
        result = 31 * result + this.excludePatterns.hashCode();
        result = 31 * result + this.identityPatterns.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoSerializableManager other = (AutoSerializableManager)obj;
        if (this.checkPortability != other.checkPortability) {
            return false;
        }
        if (!this.classPatterns.equals(other.classPatterns)) {
            return false;
        }
        if (!this.excludePatterns.equals(other.excludePatterns)) {
            return false;
        }
        return this.identityPatterns.equals(other.identityPatterns);
    }

    static {
        Unsafe tmp;
        block5: {
            logger = LogService.getLogger();
            tmp = null;
            if (!Boolean.getBoolean("gemfire.AutoSerializer.SAFE")) {
                try {
                    tmp = new Unsafe();
                }
                catch (RuntimeException ex) {
                    if (Boolean.getBoolean("gemfire.AutoSerializer.UNSAFE")) {
                        throw ex;
                    }
                }
                catch (Error ex) {
                    if (!Boolean.getBoolean("gemfire.AutoSerializer.UNSAFE")) break block5;
                    throw ex;
                }
            }
        }
        unsafe = tmp;
        USE_CONSTRUCTOR = !Boolean.getBoolean("gemfire.autopdx.ignoreConstructor");
    }

    public static class AutoClassInfo {
        private final WeakReference<Class<?>> clazzRef;
        private final List<PdxFieldWrapper> fields;
        private final Set<Integer> matchingPdxIds = new CopyOnWriteArraySet<Integer>();
        private final Set<Integer> mismatchingPdxIds = new CopyOnWriteArraySet<Integer>();
        private PdxType serializedType = null;

        public AutoClassInfo(Class<?> clazz, List<PdxFieldWrapper> fields) {
            this.clazzRef = new WeakReference(clazz);
            this.fields = fields;
        }

        public String toFormattedString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (PdxFieldWrapper o : this.fields) {
                if (first) {
                    first = false;
                    sb.append('\n');
                }
                sb.append("    ").append(o).append('\n');
            }
            return sb.toString();
        }

        public Object newInstance(Class<?> clazz) {
            Object result;
            try {
                result = unsafe != null && !USE_CONSTRUCTOR ? unsafe.allocateInstance(clazz) : clazz.newInstance();
            }
            catch (Exception ex) {
                throw new PdxSerializationException(String.format("Could not create an instance of a class %s", clazz.getName()), ex);
            }
            return result;
        }

        public void setSerializedType(PdxType v) {
            this.serializedType = v;
        }

        public PdxType getSerializedType() {
            return this.serializedType;
        }

        public Class<?> getInfoClass() {
            return (Class)this.clazzRef.get();
        }

        public List<PdxFieldWrapper> getFields() {
            return this.fields;
        }

        public boolean matchesPdxType(PdxType t) {
            Integer pdxTypeId = t.getTypeId();
            if (this.matchingPdxIds.contains(pdxTypeId)) {
                return true;
            }
            if (this.mismatchingPdxIds.contains(pdxTypeId)) {
                return false;
            }
            if (this.checkForMatch(t)) {
                this.matchingPdxIds.add(pdxTypeId);
                return true;
            }
            this.mismatchingPdxIds.add(pdxTypeId);
            return false;
        }

        private boolean checkForMatch(PdxType t) {
            if (this.fields.size() != t.getUndeletedFieldCount()) {
                return false;
            }
            Iterator<PdxField> pdxIt = t.getFields().iterator();
            for (PdxFieldWrapper f : this.fields) {
                PdxField pdxF = pdxIt.next();
                if (pdxF.isDeleted()) {
                    return false;
                }
                if (!f.getName().equals(pdxF.getFieldName())) {
                    return false;
                }
                if (FieldType.get(f.getField().getType()).equals((Object)pdxF.getFieldType())) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "AutoClassInfo [fields=" + String.valueOf(this.fields) + "]";
        }
    }

    public static abstract class PdxFieldWrapper {
        private final FieldWrapper field;
        private final String fieldName;
        private final boolean transformValue;
        private final AutoSerializableManager owner;
        private final boolean isIdentityField;

        protected PdxFieldWrapper(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            FieldWrapper tmp = unsafe != null ? new UnsafeFieldWrapper(f) : new FieldWrapper(f);
            this.field = tmp;
            this.fieldName = name;
            this.transformValue = transformValue;
            this.owner = owner;
            this.isIdentityField = isIdentityField;
        }

        public static PdxFieldWrapper create(AutoSerializableManager owner, Field f, FieldType ft, String name, boolean transformValue, boolean isIdentityField) {
            switch (ft) {
                case INT: {
                    return new IntField(owner, f, name, transformValue, isIdentityField);
                }
                case BYTE: {
                    return new ByteField(owner, f, name, transformValue, isIdentityField);
                }
                case LONG: {
                    return new LongField(owner, f, name, transformValue, isIdentityField);
                }
                case BOOLEAN: {
                    return new BooleanField(owner, f, name, transformValue, isIdentityField);
                }
                case CHAR: {
                    return new CharField(owner, f, name, transformValue, isIdentityField);
                }
                case SHORT: {
                    return new ShortField(owner, f, name, transformValue, isIdentityField);
                }
                case DOUBLE: {
                    return new DoubleField(owner, f, name, transformValue, isIdentityField);
                }
                case FLOAT: {
                    return new FloatField(owner, f, name, transformValue, isIdentityField);
                }
                case STRING: {
                    return new StringField(owner, f, name, transformValue, isIdentityField);
                }
                case DATE: {
                    return new DateField(owner, f, name, transformValue, isIdentityField);
                }
                case BYTE_ARRAY: {
                    return new ByteArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case STRING_ARRAY: {
                    return new StringArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case ARRAY_OF_BYTE_ARRAYS: {
                    return new ByteArrayArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case BOOLEAN_ARRAY: {
                    return new BooleanArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case CHAR_ARRAY: {
                    return new CharArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case SHORT_ARRAY: {
                    return new ShortArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case INT_ARRAY: {
                    return new IntArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case LONG_ARRAY: {
                    return new LongArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case FLOAT_ARRAY: {
                    return new FloatArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case DOUBLE_ARRAY: {
                    return new DoubleArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case OBJECT_ARRAY: {
                    return new ObjectArrayField(owner, f, name, transformValue, isIdentityField);
                }
                case OBJECT: {
                    return new ObjectField(owner, f, name, transformValue, isIdentityField);
                }
            }
            throw new IllegalStateException("unhandled field type " + String.valueOf((Object)ft));
        }

        public boolean getCheckPortability() {
            return this.owner.getCheckPortability();
        }

        public Field getField() {
            return this.field.getField();
        }

        public String getName() {
            return this.fieldName;
        }

        public boolean transform() {
            return this.transformValue;
        }

        public abstract void serialize(PdxWriterImpl var1, Object var2, boolean var3);

        public abstract void serializeValue(PdxWriterImpl var1, Object var2, boolean var3);

        public abstract void deserialize(InternalPdxReader var1, Object var2);

        public abstract void orderedDeserialize(InternalPdxReader var1, Object var2);

        protected Object readTransformIf(Object o, Object serializedValue) throws IllegalArgumentException, IllegalAccessException {
            if (!this.transform()) {
                return serializedValue;
            }
            return this.readTransform(o, serializedValue);
        }

        protected Object readTransform(Object o, Object serializedValue) throws IllegalArgumentException, IllegalAccessException {
            return this.owner.getOwner().readTransform(this.getField(), o.getClass(), serializedValue);
        }

        protected void handleException(boolean serialization, Object obj, Exception ex) {
            AutoSerializableManager.handleException(ex, serialization, this.getName(), obj);
        }

        protected int getInt(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getInt(o);
        }

        protected void setInt(Object o, int v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setInt(o, v);
        }

        protected boolean getBoolean(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getBoolean(o);
        }

        protected void setBoolean(Object o, boolean v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setBoolean(o, v);
        }

        protected byte getByte(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getByte(o);
        }

        protected void setByte(Object o, byte v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setByte(o, v);
        }

        protected short getShort(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getShort(o);
        }

        protected void setShort(Object o, short v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setShort(o, v);
        }

        protected char getChar(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getChar(o);
        }

        protected void setChar(Object o, char v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setChar(o, v);
        }

        protected long getLong(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getLong(o);
        }

        protected void setLong(Object o, long v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setLong(o, v);
        }

        protected float getFloat(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getFloat(o);
        }

        protected void setFloat(Object o, float v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setFloat(o, v);
        }

        protected double getDouble(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getDouble(o);
        }

        protected void setDouble(Object o, double v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setDouble(o, v);
        }

        protected Object getObject(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getObject(o);
        }

        protected void setObject(Object o, Object v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setObject(o, v);
        }

        public boolean isIdentityField() {
            return this.isIdentityField;
        }

        public String toString() {
            return this.fieldName + ": " + String.valueOf(this.field);
        }
    }

    public static class ObjectArrayField
    extends PdxFieldWrapper {
        public ObjectArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeObjectArray((Object[])newValue, this.getCheckPortability());
            } else {
                writer.writeObjectArray(this.getName(), (Object[])newValue, this.getCheckPortability());
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readObjectArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readObjectArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class ByteArrayArrayField
    extends PdxFieldWrapper {
        public ByteArrayArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeArrayOfByteArrays((byte[][])newValue);
            } else {
                writer.writeArrayOfByteArrays(this.getName(), (byte[][])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readArrayOfByteArrays(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readArrayOfByteArrays()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class StringArrayField
    extends PdxFieldWrapper {
        public StringArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeStringArray((String[])newValue);
            } else {
                writer.writeStringArray(this.getName(), (String[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readStringArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readStringArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class DoubleArrayField
    extends PdxFieldWrapper {
        public DoubleArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeDoubleArray((double[])newValue);
            } else {
                writer.writeDoubleArray(this.getName(), (double[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readDoubleArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readDoubleArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class FloatArrayField
    extends PdxFieldWrapper {
        public FloatArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeFloatArray((float[])newValue);
            } else {
                writer.writeFloatArray(this.getName(), (float[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readFloatArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readFloatArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class LongArrayField
    extends PdxFieldWrapper {
        public LongArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeLongArray((long[])newValue);
            } else {
                writer.writeLongArray(this.getName(), (long[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readLongArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readLongArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class IntArrayField
    extends PdxFieldWrapper {
        public IntArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeIntArray((int[])newValue);
            } else {
                writer.writeIntArray(this.getName(), (int[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readIntArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readIntArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class CharArrayField
    extends PdxFieldWrapper {
        public CharArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeCharArray((char[])newValue);
            } else {
                writer.writeCharArray(this.getName(), (char[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readCharArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readCharArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class ShortArrayField
    extends PdxFieldWrapper {
        public ShortArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeShortArray((short[])newValue);
            } else {
                writer.writeShortArray(this.getName(), (short[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readShortArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readShortArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class BooleanArrayField
    extends PdxFieldWrapper {
        public BooleanArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeBooleanArray((boolean[])newValue);
            } else {
                writer.writeBooleanArray(this.getName(), (boolean[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readBooleanArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readBooleanArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class ByteArrayField
    extends PdxFieldWrapper {
        public ByteArrayField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeByteArray((byte[])newValue);
            } else {
                writer.writeByteArray(this.getName(), (byte[])newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readByteArray(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readByteArray()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class DateField
    extends PdxFieldWrapper {
        public DateField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeDate((Date)newValue);
            } else {
                writer.writeDate(this.getName(), (Date)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readDate(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readDate()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class StringField
    extends PdxFieldWrapper {
        public StringField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeString((String)newValue);
            } else {
                writer.writeString(this.getName(), (String)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readString(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readString()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class ObjectField
    extends PdxFieldWrapper {
        public ObjectField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                this.serializeValue(writer, this.getObject(obj), optimizeWrite);
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeObject(newValue, this.getCheckPortability());
            } else {
                writer.writeObject(this.getName(), newValue, this.getCheckPortability());
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    this.setObject(obj, this.readTransformIf(obj, reader.readObject(pf)));
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                this.setObject(obj, this.readTransformIf(obj, reader.readObject()));
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class DoubleField
    extends PdxFieldWrapper {
        public DoubleField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeDouble(this.getDouble(obj));
                } else {
                    writer.writeDouble(this.getName(), this.getDouble(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeDouble((Double)newValue);
            } else {
                writer.writeDouble(this.getName(), (Double)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, reader.readDouble(pf)));
                    } else {
                        this.setDouble(obj, reader.readDouble(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, reader.readDouble()));
                } else {
                    this.setDouble(obj, reader.readDouble());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class FloatField
    extends PdxFieldWrapper {
        public FloatField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeFloat(this.getFloat(obj));
                } else {
                    writer.writeFloat(this.getName(), this.getFloat(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeFloat(((Float)newValue).floatValue());
            } else {
                writer.writeFloat(this.getName(), ((Float)newValue).floatValue());
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, Float.valueOf(reader.readFloat(pf))));
                    } else {
                        this.setFloat(obj, reader.readFloat(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, Float.valueOf(reader.readFloat())));
                } else {
                    this.setFloat(obj, reader.readFloat());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class ShortField
    extends PdxFieldWrapper {
        public ShortField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeShort(this.getShort(obj));
                } else {
                    writer.writeShort(this.getName(), this.getShort(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeShort((Short)newValue);
            } else {
                writer.writeShort(this.getName(), (Short)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, reader.readShort(pf)));
                    } else {
                        this.setShort(obj, reader.readShort(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, reader.readShort()));
                } else {
                    this.setShort(obj, reader.readShort());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class CharField
    extends PdxFieldWrapper {
        public CharField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeChar(this.getChar(obj));
                } else {
                    writer.writeChar(this.getName(), this.getChar(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeChar(((Character)newValue).charValue());
            } else {
                writer.writeChar(this.getName(), ((Character)newValue).charValue());
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, Character.valueOf(reader.readChar(pf))));
                    } else {
                        this.setChar(obj, reader.readChar(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, Character.valueOf(reader.readChar())));
                } else {
                    this.setChar(obj, reader.readChar());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class BooleanField
    extends PdxFieldWrapper {
        public BooleanField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeBoolean(this.getBoolean(obj));
                } else {
                    writer.writeBoolean(this.getName(), this.getBoolean(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeBoolean((Boolean)newValue);
            } else {
                writer.writeBoolean(this.getName(), (Boolean)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, reader.readBoolean(pf)));
                    } else {
                        this.setBoolean(obj, reader.readBoolean(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, reader.readBoolean()));
                } else {
                    this.setBoolean(obj, reader.readBoolean());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class LongField
    extends PdxFieldWrapper {
        public LongField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeLong(this.getLong(obj));
                } else {
                    writer.writeLong(this.getName(), this.getLong(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeLong((Long)newValue);
            } else {
                writer.writeLong(this.getName(), (Long)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, reader.readLong(pf)));
                    } else {
                        this.setLong(obj, reader.readLong(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, reader.readLong()));
                } else {
                    this.setLong(obj, reader.readLong());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class ByteField
    extends PdxFieldWrapper {
        public ByteField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeByte(this.getByte(obj));
                } else {
                    writer.writeByte(this.getName(), this.getByte(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeByte((Byte)newValue);
            } else {
                writer.writeByte(this.getName(), (Byte)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, reader.readByte(pf)));
                    } else {
                        this.setByte(obj, reader.readByte(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, reader.readByte()));
                } else {
                    this.setByte(obj, reader.readByte());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    public static class IntField
    extends PdxFieldWrapper {
        public IntField(AutoSerializableManager owner, Field f, String name, boolean transformValue, boolean isIdentityField) {
            super(owner, f, name, transformValue, isIdentityField);
        }

        @Override
        public void serialize(PdxWriterImpl writer, Object obj, boolean optimizeWrite) {
            try {
                if (optimizeWrite) {
                    writer.writeInt(this.getInt(obj));
                } else {
                    writer.writeInt(this.getName(), this.getInt(obj));
                }
            }
            catch (Exception ex) {
                this.handleException(true, obj, ex);
            }
        }

        @Override
        public void serializeValue(PdxWriterImpl writer, Object newValue, boolean optimizeWrite) {
            if (optimizeWrite) {
                writer.writeInt((Integer)newValue);
            } else {
                writer.writeInt(this.getName(), (Integer)newValue);
            }
        }

        @Override
        public void deserialize(InternalPdxReader reader, Object obj) {
            PdxField pf = reader.getPdxField(this.getName());
            if (pf != null) {
                try {
                    if (this.transform()) {
                        this.setObject(obj, this.readTransform(obj, reader.readInt(pf)));
                    } else {
                        this.setInt(obj, reader.readInt(pf));
                    }
                }
                catch (Exception ex) {
                    this.handleException(false, obj, ex);
                }
            }
        }

        @Override
        public void orderedDeserialize(InternalPdxReader reader, Object obj) {
            try {
                if (this.transform()) {
                    this.setObject(obj, this.readTransform(obj, reader.readInt()));
                } else {
                    this.setInt(obj, reader.readInt());
                }
            }
            catch (Exception ex) {
                this.handleException(false, obj, ex);
            }
        }
    }

    private static class UnsafeFieldWrapper
    extends FieldWrapper {
        private final long offset;

        public UnsafeFieldWrapper(Field f) {
            super(f);
            this.offset = unsafe.objectFieldOffset(f);
        }

        @Override
        public int getInt(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getInt(o, this.offset);
        }

        @Override
        public void setInt(Object o, int v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putInt(o, this.offset, v);
        }

        @Override
        public boolean getBoolean(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getBoolean(o, this.offset);
        }

        @Override
        public void setBoolean(Object o, boolean v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putBoolean(o, this.offset, v);
        }

        @Override
        public byte getByte(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getByte(o, this.offset);
        }

        @Override
        public void setByte(Object o, byte v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putByte(o, this.offset, v);
        }

        @Override
        public short getShort(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getShort(o, this.offset);
        }

        @Override
        public void setShort(Object o, short v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putShort(o, this.offset, v);
        }

        @Override
        public char getChar(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getChar(o, this.offset);
        }

        @Override
        public void setChar(Object o, char v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putChar(o, this.offset, v);
        }

        @Override
        public long getLong(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getLong(o, this.offset);
        }

        @Override
        public void setLong(Object o, long v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putLong(o, this.offset, v);
        }

        @Override
        public float getFloat(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getFloat(o, this.offset);
        }

        @Override
        public void setFloat(Object o, float v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putFloat(o, this.offset, v);
        }

        @Override
        public double getDouble(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getDouble(o, this.offset);
        }

        @Override
        public void setDouble(Object o, double v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putDouble(o, this.offset, v);
        }

        @Override
        public Object getObject(Object o) throws IllegalArgumentException, IllegalAccessException {
            return unsafe.getObject(o, this.offset);
        }

        @Override
        public void setObject(Object o, Object v) throws IllegalArgumentException, IllegalAccessException {
            unsafe.putObject(o, this.offset, v);
        }
    }

    private static class FieldWrapper {
        private final Field field;

        public FieldWrapper(Field f) {
            this.field = f;
        }

        public Field getField() {
            return this.field;
        }

        public int getInt(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getInt(o);
        }

        public void setInt(Object o, int v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setInt(o, v);
        }

        public boolean getBoolean(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getBoolean(o);
        }

        public void setBoolean(Object o, boolean v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setBoolean(o, v);
        }

        public byte getByte(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getByte(o);
        }

        public void setByte(Object o, byte v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setByte(o, v);
        }

        public short getShort(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getShort(o);
        }

        public void setShort(Object o, short v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setShort(o, v);
        }

        public char getChar(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getChar(o);
        }

        public void setChar(Object o, char v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setChar(o, v);
        }

        public long getLong(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getLong(o);
        }

        public void setLong(Object o, long v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setLong(o, v);
        }

        public float getFloat(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getFloat(o);
        }

        public void setFloat(Object o, float v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setFloat(o, v);
        }

        public double getDouble(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getDouble(o);
        }

        public void setDouble(Object o, double v) throws IllegalArgumentException, IllegalAccessException {
            this.field.setDouble(o, v);
        }

        public Object getObject(Object o) throws IllegalArgumentException, IllegalAccessException {
            return this.field.get(o);
        }

        public void setObject(Object o, Object v) throws IllegalArgumentException, IllegalAccessException {
            this.field.set(o, v);
        }

        public String toString() {
            return this.field.toString();
        }
    }
}

