/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.metrics.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Collection;
import java.util.HashSet;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.metrics.internal.CloseableMeterBinder;
import org.apache.logging.log4j.Logger;

public class CompoundMeterBinder
implements CloseableMeterBinder {
    private final Logger logger;
    private final Collection<MeterBinder> meterBinders = new HashSet<MeterBinder>();

    public CompoundMeterBinder(Collection<MeterBinder> binders) {
        this(LogService.getLogger(), binders);
    }

    @VisibleForTesting
    CompoundMeterBinder(Logger logger, Collection<MeterBinder> binders) {
        this.logger = logger;
        this.meterBinders.addAll(binders);
    }

    public void bindTo(MeterRegistry registry) {
        this.meterBinders.forEach(binder -> this.bind(registry, (MeterBinder)binder));
    }

    @Override
    public void close() {
        this.meterBinders.stream().filter(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).forEach(this::close);
    }

    private void bind(MeterRegistry registry, MeterBinder binder) {
        try {
            binder.bindTo(registry);
        }
        catch (Exception thrown) {
            this.logger.warn("Exception while binding meter binder " + String.valueOf(binder), (Throwable)thrown);
        }
    }

    private void close(AutoCloseable binder) {
        try {
            binder.close();
        }
        catch (Exception thrown) {
            this.logger.warn("Exception while closing meter binder " + String.valueOf(binder), (Throwable)thrown);
        }
    }
}

