/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.security;

import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.internal.security.AccessControlMXBean;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;

public class MBeanServerWrapper
implements MBeanServerForwarder {
    private MBeanServer mbs;
    private final SecurityService securityService;
    @Immutable
    private static final QueryExp notAccessControlMBean = Query.not(Query.isInstanceOf(Query.value(AccessControlMXBean.class.getName())));

    public MBeanServerWrapper(SecurityService securityService) {
        this.securityService = securityService;
    }

    private void checkDomain(ObjectName name) {
        if ("GemFire".equals(name.getDomain())) {
            throw new SecurityException("Access Denied");
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.checkDomain(name);
        return this.mbs.registerMBean(object, name);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkDomain(name);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbs.getObjectInstance(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        if (query != null) {
            return this.mbs.queryMBeans(name, Query.and(query, notAccessControlMBean));
        }
        return this.mbs.queryMBeans(name, notAccessControlMBean);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        if (query != null) {
            return this.mbs.queryNames(name, Query.and(query, notAccessControlMBean));
        }
        return this.mbs.queryNames(name, notAccessControlMBean);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.mbs.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        return this.mbs.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, InstanceNotFoundException, ReflectionException {
        Object result;
        ResourcePermission ctx = this.getOperationContext(name, attribute, false);
        this.securityService.authorize(ctx);
        try {
            result = this.mbs.getAttribute(name, attribute);
        }
        catch (AttributeNotFoundException nex) {
            return null;
        }
        return result;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList results;
        this.checkAuthorization(name, attributes);
        try {
            results = this.mbs.getAttributes(name, attributes);
        }
        catch (Exception e) {
            throw new GemFireSecurityException("error getting values of attributes :" + Arrays.toString(attributes) + " from " + String.valueOf(name), e);
        }
        return results;
    }

    void checkAuthorization(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        HashSet<ResourcePermission> contextSet = new HashSet<ResourcePermission>();
        for (String attribute : attributes) {
            ResourcePermission ctx = this.getOperationContext(name, attribute, false);
            if (ctx == null || !contextSet.add(ctx)) continue;
            this.securityService.authorize(ctx);
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ResourcePermission ctx = this.getOperationContext(name, attribute.getName(), false);
        this.securityService.authorize(ctx);
        this.mbs.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkAuthorization(name, (String[])attributes.parallelStream().map(attribute -> ((Attribute)attribute).getName()).toArray());
        try {
            this.mbs.setAttributes(name, attributes);
        }
        catch (Exception e) {
            throw new GemFireSecurityException("error setting attributes :" + String.valueOf(attributes) + " of " + String.valueOf(name), e);
        }
        return attributes;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        ResourcePermission ctx = this.getOperationContext(name, operationName, true);
        this.securityService.authorize(ctx);
        return this.mbs.invoke(name, operationName, params, signature);
    }

    private ResourcePermission getOperationContext(ObjectName objectName, String featureName, boolean isOp) throws InstanceNotFoundException, ReflectionException {
        MBeanInfo beanInfo;
        try {
            beanInfo = this.mbs.getMBeanInfo(objectName);
        }
        catch (IntrospectionException e) {
            throw new GemFireSecurityException("error getting beanInfo of " + String.valueOf(objectName), e);
        }
        ResourcePermission result = null;
        result = this.getOperationContext(beanInfo.getDescriptor(), result);
        MBeanFeatureInfo[] featureInfos = isOp ? beanInfo.getOperations() : beanInfo.getAttributes();
        for (MBeanFeatureInfo info : featureInfos) {
            if (!info.getName().equals(featureName)) continue;
            result = this.getOperationContext(info.getDescriptor(), result);
            break;
        }
        return result;
    }

    private ResourcePermission getOperationContext(Descriptor descriptor, ResourcePermission defaultValue) {
        String resource = (String)descriptor.getFieldValue("resource");
        String operationCode = (String)descriptor.getFieldValue("operation");
        String targetCode = (String)descriptor.getFieldValue("target");
        if (resource != null && operationCode != null) {
            if (StringUtils.isBlank((CharSequence)targetCode)) {
                return new ResourcePermission(ResourcePermission.Resource.valueOf(resource), ResourcePermission.Operation.valueOf(operationCode));
            }
            return new ResourcePermission(ResourcePermission.Resource.valueOf(resource), ResourcePermission.Operation.valueOf(operationCode), ResourcePermission.Target.valueOf(targetCode).getName());
        }
        return defaultValue;
    }

    @Override
    public String getDefaultDomain() {
        return this.mbs.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.mbs.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbs.getMBeanInfo(name);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbs.isInstanceOf(name, className);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, params, signature);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        return this.mbs.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.mbs.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        return this.mbs.deserialize(className, loaderName, data);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbs.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbs.getClassLoader(loaderName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.mbs.getClassLoaderRepository();
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    @Override
    public void setMBeanServer(MBeanServer mbs) {
        this.mbs = mbs;
    }
}

